package org.gcube.soa3.connector.common.security.impl;

import it.eng.rdlab.soa3.connector.utils.SecurityManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.common.security.Credentials;

/**
 * 
 * TLS X509 {@link Credentials}
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class X509TLSCredentials implements Credentials 
{

	private Log log;
	private final String X509TLS = "X509TLS";
	private String 	certFile,
					keyFile,
					trustDir;
					//trustExt;
	
	public X509TLSCredentials ()
	{
		this (null,null,null,null);
	}
	
	public X509TLSCredentials(String certFile, String keyFile, String trustDir, String trustExt) 
	{
		this.log = LogFactory.getLog(this.getClass());
		if (certFile != null)
		{
			SecurityManager.getInstance().setCertFile(certFile);
			this.certFile = certFile;
		}
		else this.certFile = SecurityManager.DEFAULT_CERT_FILE;
		
		if (keyFile != null)
		{
			SecurityManager.getInstance().setKeyFile(keyFile);
			this.keyFile = keyFile;
		}
		else this.keyFile = SecurityManager.DEFAULT_KEY_FILE;
		
		if (trustDir != null)
		{
			SecurityManager.getInstance().setTrustDir(trustDir);
			this.trustDir = trustDir;
		}
		else this.trustDir = SecurityManager.DEFAULT_TRUST_DIR;
		
		if (trustExt != null)
		{
			SecurityManager.getInstance().setTrustExt(trustExt);
			//this.trustExt = trustExt;
		}
		//else this.trustExt = SecurityManager.DEFAULT_TRUST_FILE_EXTENSION;
		
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void prepareCredentials() 
	{
		log.debug("Loading certificates");
		try 
		{
			SecurityManager.getInstance().loadCertificate();
			log.debug("Certificates loaded");
		} catch (Exception e) {
			log.error("Unable to load security certificates", e);
		}
	}

	/**
	 * Returns "X509TLS"
	 */
	@Override
	public String getAuthenticationType() 
	{

		return X509TLS;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getAuthenticationString() 
	{
		return new StringBuilder("Certificate ").append(this.certFile).append(" Key ").append(this.keyFile).append(" Trust Dir ").append(this.trustDir).toString();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getHeaderString() 
	{
		return null;
	}

}
