package org.gcube.security.soa3.connector.integration;

import java.rmi.Remote;

import org.apache.axis.client.Stub;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.soa3.connector.common.security.CredentialManager;
import org.gcube.soa3.connector.common.security.Credentials;
import org.globus.axis.gsi.GSIConstants;
import org.ietf.jgss.GSSCredential;

public class SOA3IntegrationCredentialInserter implements GCUBESecurityManager {

	private CredentialManager soa3CredentialManager;
	private GCUBELog log;
	
	public SOA3IntegrationCredentialInserter(CredentialManager soa3CredentialManager) 
	{
		this.log = new GCUBELog(this);
		this.soa3CredentialManager = soa3CredentialManager;
	}
	
	@Override
	public boolean isSecurityEnabled() {
		return true;
	}

	@Override
	public void useCredentials(GSSCredential credentials) throws Exception {
		// TODO Auto-generated method stub

	}

	@Override
	public void useCredentials(SecurityCredentials credentials)
			throws Exception {
		// TODO Auto-generated method stub

	}

	@Override
	public void useCredentials(Thread thread,
			SecurityCredentials... credentials) throws Exception {
		// TODO Auto-generated method stub

	}

	@Override
	public SecurityCredentials getCredentials() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setSecurity(Remote s, AuthMode e, DelegationMode d) throws Exception {
		
		log.debug("Adding https credentials");
		Stub stub = (Stub) s;
		stub._setProperty(GSIConstants.GSI_CREDENTIALS, SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
		log.debug("https credentials added");
		log.debug("Setting security credentials");
		Credentials credentials = this.soa3CredentialManager.getCredentials();
		
		if (credentials != null)
		{
			log.debug("Credential type "+credentials.getAuthenticationType());
			StubMessageManager messageManager = new StubMessageManager(stub);
			messageManager.setCredentials(credentials);
			log.debug("Credentials set");
		}
		else log.debug("No credentials set");

		
		
	}

	@Override
	public void setAuthMethod(AuthMethod m) {
		// TODO Auto-generated method stub

	}

}
