/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.ws.rs.core.MediaType;
import javax.xml.rpc.handler.MessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBESecurityController;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.cache.SOA3EhcacheWrapper;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.gcube.security.soa3.connector.engine.RestManager;
import org.gcube.security.soa3.connector.integration.utils.Utils;
import org.w3c.dom.Element;

public class SOA3SecurityController
implements GCUBESecurityController {
    private GCUBELog log = new GCUBELog((Object)this);
    private static final String SES = "SES";
    private static final String DN = "DN";
    private final String AUTHORIZATION_HEADER = "Authorization";
    private String serviceName;
    private String soa3Endpoint;
    private boolean credentialPropagationPolicy;

    public void init(GCUBEServiceContext serviceContext) {
        this.serviceName = serviceContext.getName();
        this.log.debug((Object)("Initializing security manager for service " + this.serviceName));
        this.soa3Endpoint = ConfigurationManager.getInstance().getServerUrl(this.serviceName);
        this.credentialPropagationPolicy = ConfigurationManager.getInstance().getCredentialPropagationPolicy(this.serviceName);
    }

    public boolean checkAccess(Map<String, Object> parameters) {
        this.log.debug((Object)"Checking access");
        if (!ConfigurationManager.getInstance().isSecurityEnabled(this.serviceName)) {
            this.log.debug((Object)"Security disabled");
            return true;
        }
        this.log.debug((Object)"Security enabled");
        return this.applySecurityPolicies(parameters);
    }

    private boolean applySecurityPolicies(Map<String, Object> parameters) {
        this.log.debug((Object)"Checking the acces rights");
        Map headers = (Map)parameters.get("HEADERS");
        String securityHeader = (String)headers.get("BinarySecurityToken");
        MessageContext messageContext = (MessageContext)parameters.get("MESSAGE_CONTEXT");
        String response = null;
        String type = null;
        if (securityHeader != null) {
            try {
                String[] secHeaderElements = securityHeader.split(" ");
                type = secHeaderElements[0];
                String value = secHeaderElements[1];
                this.log.debug((Object)("Type = " + type));
                this.log.debug((Object)("id = " + value));
                response = this.getAuthenticationString(type, value);
            }
            catch (Exception e) {
                this.log.error((Object)"Invalid auth header");
                type = DN;
                response = this.getDn(messageContext);
            }
        } else {
            type = DN;
            response = this.getDn(messageContext);
        }
        this.log.debug((Object)("Response = " + response));
        if (response != null && this.credentialPropagationPolicy) {
            try {
                this.log.debug((Object)"Generating security header");
                Element element = Utils.generateBinaryTokenElement(SES, response);
                this.log.debug((Object)"Security Header generated");
                messageContext.setProperty("SECURITY_TOKEN", (Object)element);
            }
            catch (Exception e) {
                this.log.debug((Object)"Unable to generate the security header", (Throwable)e);
            }
        }
        return response != null;
    }

    private String getDn(MessageContext messageContext) {
        this.log.debug((Object)"No security header found");
        this.log.debug((Object)"Looking at the Distinguished Name");
        String response = null;
        Subject subject = (Subject)messageContext.getProperty("callerSubject");
        if (subject == null) {
            this.log.error((Object)"No Distinguished name found");
        } else {
            this.log.debug((Object)("External subject " + subject));
            Set<Principal> principals = subject.getPrincipals();
            if (principals == null || principals.isEmpty()) {
                this.log.error((Object)"Unable to find subject identity");
            } else {
                this.log.debug((Object)"Identities found, looking for the DNs");
                Iterator<Principal> principalIterator = principals.iterator();
                while (principalIterator.hasNext() && response == null) {
                    String dn = principalIterator.next().getName();
                    this.log.debug((Object)("Distinguished name " + dn));
                    response = this.getAuthenticationString(DN, dn);
                    this.log.debug((Object)("Response = " + response));
                }
            }
        }
        return response;
    }

    private String getAuthenticationString(String type, String value) {
        this.log.debug((Object)"Asking the cache...");
        String cacheString = type + value;
        this.log.debug((Object)("Cache string " + cacheString));
        String response = SOA3EhcacheWrapper.getInstance().get(cacheString);
        if (response == null) {
            this.log.debug((Object)"Response null, asking to SOA3");
            response = this.askSoa3(type, value);
            if (response != null) {
                this.log.debug((Object)"Response found populating the cache");
                SOA3EhcacheWrapper.getInstance().put(cacheString, response);
                this.log.debug((Object)"Cache populated");
            }
        } else {
            this.log.debug((Object)"Response found in the cache");
        }
        this.log.debug((Object)("Response = " + response));
        return response;
    }

    private String askSoa3(String type, String value) {
        this.log.debug((Object)"Sending authentication message to SOA3");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", type + " " + value);
        String response = RestManager.getInstance(this.soa3Endpoint).sendMessage("access", headers, null, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE);
        this.log.debug((Object)("Authentication response = " + response));
        return response;
    }
}

