package org.gcube.security.soa3.connector.integration.client.context;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManager.AuthMethod;
import org.gcube.common.core.security.context.impl.DefaultGHNClientSecurityContext;
import org.gcube.common.core.security.impl.GCUBECredentialAdder;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;

public class SOA3ClientSecurityContext extends DefaultGHNClientSecurityContext {

	private ServiceSecurityDescriptor secDesc;
	private GCUBEDefaultSecurityConfiguration configuration;
	private GCUBELog log;
	
	public SOA3ClientSecurityContext ()
	{
		super ();
		this.log = new GCUBELog(this);
		this.log.debug("Init soa3 client security context");
		this.configuration = new GCUBEDefaultSecurityConfiguration();
		this.configuration.setOutEnabled(true);
		this.configuration.setOutOverride(true);
		
		secDesc = new ServiceSecurityDescriptor();
		List<AuthMethod> authMethods = new ArrayList<AuthMethod> ();
		authMethods.add(AuthMethod.GSI_TRANS);
		try {
			secDesc.setAuthMethods(authMethods);
		} catch (SecurityDescriptorException e) {
			log.error("Unable complete the security descriptor",e);
		}
		
	}
	
	@Override
	public GCUBEDefaultSecurityConfiguration getDefaultServiceSecurityConfiguration() {

		return configuration;
	}

	@Override
	public ServiceSecurityDescriptor getDefaultIncomingMessagesSecurityDescriptor() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ServiceSecurityDescriptor getDefaultOutgoingMessagesSecurityDescriptor() {
		return secDesc;
	}


	@Override
	public GCUBESecurityManager getDefaultSecurityManager() throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public GCUBECredentialAdder getCredentialsAdder() {
		// TODO Auto-generated method stub
		return null;
	}

}
