package org.gcube.security.soa3.connector.integration.server.context;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.GCUBESecurityManager.AuthMethod;
import org.gcube.common.core.security.context.impl.DefaultGHNServerSecurityContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;


/**
 * 
 * A context that manages all the security related operations
 * 
 * @author Ciro Formisano
 *
 */
public class SOA3ServerSecurityContext extends DefaultGHNServerSecurityContext
{
	private GCUBELog log;
	private GCUBEDefaultSecurityConfiguration configuration;
	private ServiceSecurityDescriptor secDesc;
	
	public SOA3ServerSecurityContext() 
	{
		super ();
		this.log = new GCUBELog(this);
		this.log.debug("Init soa3 client security context");
		this.configuration = new GCUBEDefaultSecurityConfiguration();
		this.configuration.setOutEnabled(true);
		this.configuration.setOutOverride(false);
		this.configuration.setDefaultCredentialPropagationSet(false);
		this.configuration.setPropagateCallerCredentials(ConfigurationManager.getInstance().getCredentialPropagationPolicy(null));
		this.configuration.setPropagateCallerCredentialsOverride(false);
	
		secDesc = new ServiceSecurityDescriptor();
		List<AuthMethod> authMethods = new ArrayList<AuthMethod> ();
		authMethods.add(AuthMethod.GSI_TRANS);
		try {
			secDesc.setAuthMethods(authMethods);
		} catch (SecurityDescriptorException e) {
			log.error("Unable complete the security descriptor",e);
		}
	}
	

	 
	 
		@Override
		public GCUBEDefaultSecurityConfiguration getDefaultServiceSecurityConfiguration ()
		{
			return this.configuration;
		}
		
		/* (non-Javadoc)
		 * @see org.gcube.common.core.security.context.impl.SecurityContext#getDefaultIncomingMessagesSecurityDescriptor()
		 */
		@Override
		public ServiceSecurityDescriptor getDefaultIncomingMessagesSecurityDescriptor ()
		{
			return this.secDesc;
		}
		
		/* (non-Javadoc)
		 * @see org.gcube.common.core.security.context.impl.SecurityContext#getDefaultOutgoingMessagesSecurityDescriptor()
		 */
		@Override
		public ServiceSecurityDescriptor getDefaultOutgoingMessagesSecurityDescriptor ()
		{
			return this.secDesc;
		}

}
