package org.gcube.security.soa3.connector.integration.utils;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPException;

import org.apache.axis.message.SOAPHeaderElement;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.gcube.soa3.connector.common.security.messages.impl.SoapMessageManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Utils 
{
	public static final String SERVICE_PROPERTIES = "serviceSecurityProperties.props";
	public static final String SECURITY_TOKEN = "SECURITY_TOKEN";
	public static final String 	BINARY_SECURITY_TOKEN_LABEL = "BinarySecurityToken",
								BINARY_SECURITY_TOKEN_PREFIX = "wsse",
								WSSE_NAMESPACE = "http://schemas.xmlsoap.org/ws/2002/04/secext",
								VALUE_TYPE_LABEL = "ValueType",
								ENCODING_TYPE_LABEL = "EncodingType",
								BASE64 = "wsse:Base64Binary",
								ID_LABEL = "Id",
								SECURITY_TOKEN_ATTR = "SecurityToken";
	
	public static void setServiceProperties (GCUBEServiceContext ctxt,String serviceName)
	{
		
		GCUBELog log = new GCUBELog(Utils.class);
		
		Properties properties = null;
		log.debug("Service name "+serviceName);

		try
		{
			File servicePropertiesFile = ctxt.getFile(SERVICE_PROPERTIES, false);
			log.debug("Service Property file = "+servicePropertiesFile);
			
			if (servicePropertiesFile != null && servicePropertiesFile.exists())
			{
				properties = new Properties();
				properties.load(new FileReader(servicePropertiesFile));
			
			}
			
		} catch (Exception e)
		{
			log.debug("Unable to load local property file");
		}
				
		if (properties != null) ConfigurationManager.getInstance().setServiceProperties(serviceName, properties);
		
	}
	
	public static Element generateBinaryTokenElement (String type,String binaryTokenValue) throws Exception
	{
		GCUBELog log = new GCUBELog(Utils.class);
		log.debug("Generating token SOAP element");
		log.debug("Type = "+type);
		log.debug("Value = "+binaryTokenValue);
		DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		Document tokenDocument = builder.newDocument();
		Element tokenElement = tokenDocument.createElementNS(SoapMessageManager.WSSE_NAMESPACE, SoapMessageManager.BINARY_SECURITY_TOKEN_PREFIX+":"+SoapMessageManager.BINARY_SECURITY_TOKEN_LABEL);
		tokenElement.setAttribute(SoapMessageManager.VALUE_TYPE_LABEL, type);
		tokenElement.setAttribute(SoapMessageManager.ENCODING_TYPE_LABEL,SoapMessageManager.BASE64 );
		tokenElement.setAttribute(SoapMessageManager.ID_LABEL, SECURITY_TOKEN);
		tokenElement.setTextContent(binaryTokenValue);
		log.debug("Header completed");
		return tokenElement;

	}
	
	public static SOAPHeaderElement generateSoapHeaderBinaryTokenElement (String type,String binaryTokenValue) throws SOAPException
	{
		GCUBELog log = new GCUBELog(Utils.class);
		log.debug("Generating token SOAP element");
		log.debug("Type = "+type);
		log.debug("Value = "+binaryTokenValue);
		SOAPHeaderElement headerElement = new SOAPHeaderElement(new QName(WSSE_NAMESPACE,BINARY_SECURITY_TOKEN_PREFIX+":"+BINARY_SECURITY_TOKEN_LABEL));
		headerElement.addAttribute (WSSE_NAMESPACE,VALUE_TYPE_LABEL,type);
		headerElement.addAttribute (WSSE_NAMESPACE,ENCODING_TYPE_LABEL,BASE64);
		headerElement.addAttribute (WSSE_NAMESPACE,ID_LABEL,SECURITY_TOKEN_ATTR);
		headerElement.setValue(binaryTokenValue);
		log.debug("Header completed");
		return headerElement;

	}
	

}
