/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.engine;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.ws.security.WSSecurityException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.wssec.WSConstants;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityRequestEngine;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityTokenWSSecurityRequestEngine
extends WSSecurityRequestEngine {
    private GCUBELog log = new GCUBELog((Object)this);
    private static SecurityTokenWSSecurityRequestEngine engine;

    public static synchronized SecurityTokenWSSecurityRequestEngine getEngine() {
        if (engine == null) {
            engine = new SecurityTokenWSSecurityRequestEngine();
        }
        return engine;
    }

    private SecurityTokenWSSecurityRequestEngine() {
    }

    public void processSecurityHeader(Element securityHeader, MessageContext msgCtx, String actor, SOAPHeaderElement messageIdHeader, boolean request) throws Exception {
        boolean route;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing WS-Security header for '" + actor + "' actor. request (so process timestamp) " + request));
        }
        Element timestampElem = null;
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        String ns = null;
        String ln = null;
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            ns = elem.getNamespaceURI();
            ln = elem.getLocalName();
            this.log.debug((Object)("Local Name = " + ln));
            if ("http://www.w3.org/2000/09/xmldsig#".equalsIgnoreCase(ns) && "Signature".equalsIgnoreCase(ln)) {
                this.log.debug((Object)"Found signature element");
                if (this.handleSignatureElement((Element)elem, msgCtx, request)) continue;
                throw new WSSecurityException(6);
            }
            if ("http://www.w3.org/2001/04/xmlenc#".equalsIgnoreCase(ns)) {
                this.log.debug((Object)"Found encryption element");
                this.handleEncryptionElement((Element)elem, msgCtx);
                continue;
            }
            if ("UsernameToken".equalsIgnoreCase(ln)) {
                this.log.debug((Object)"Found user name token");
                this.handleUsernameElement((Element)elem, msgCtx);
                continue;
            }
            if ("BinarySecurityToken".equalsIgnoreCase(ln) && "http://schemas.xmlsoap.org/ws/2002/04/secext".equalsIgnoreCase(ns)) {
                this.log.debug((Object)"Found Security header");
                this.handleSecTokenElement((Element)elem, msgCtx);
                continue;
            }
            if (WSConstants.WSU_NS.equalsIgnoreCase(ns) && "Timestamp".equalsIgnoreCase(ln)) {
                this.log.debug((Object)"Found timestamp element");
                timestampElem = (Element)elem;
                SecurityTokenWSSecurityRequestEngine.normalize((Node)timestampElem);
                continue;
            }
            if (elem.getNodeType() != 1) continue;
            this.log.debug((Object)(elem.getLocalName() + " " + elem.getNamespaceURI()));
        }
        if (request) {
            this.log.debug((Object)"Secure message, timestamp might be required");
            if (this.constantSet(msgCtx.getProperty("org.globus.security.secMsg.msg.type"), Constants.SIGNATURE) || this.constantSet(msgCtx.getProperty("org.globus.security.secMsg.msg.type"), Constants.ENCRYPTION)) {
                this.processTimestampHeader(timestampElem, msgCtx, messageIdHeader);
            }
        }
        boolean bl = route = "".equals(actor) && Boolean.TRUE.equals(msgCtx.getProperty("org.globus.ogsa.router"));
        if (!route) {
            securityHeader.getParentNode().removeChild(securityHeader);
            this.log.debug((Object)"Security Header removed");
        } else {
            this.log.debug((Object)"Header not removed");
        }
    }

    private boolean constantSet(Object msgVal, Object propValue) {
        return msgVal != null && msgVal.equals(propValue);
    }

    private void handleSecTokenElement(Element secTokenElement, MessageContext context) throws Exception {
        if (secTokenElement != null) {
            this.log.debug((Object)"Inserting security token...");
            context.setProperty("SECURITY_TOKEN", (Object)secTokenElement);
            this.log.debug((Object)"Security token inserted");
        } else {
            this.log.error((Object)"Security token element null");
        }
    }
}

