/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.group.bean;

import it.eng.rdlab.um.beans.GenericModel;
import it.eng.rdlab.um.beans.GenericModelWrapper;
import it.eng.rdlab.um.group.beans.GroupModel;
import it.eng.rdlab.um.ldap.LdapAbstractModelWrapper;
import it.eng.rdlab.um.ldap.validators.LdapGroupValidator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapGroupModelWrapper
extends LdapAbstractModelWrapper {
    private Log log = LogFactory.getLog(this.getClass());
    private List<String> membersList;

    public LdapGroupModelWrapper(GroupModel groupModel) {
        super((GenericModel)groupModel);
        this.initModel(groupModel);
    }

    private void initModel(GroupModel groupModel) {
        this.log.debug((Object)"Loading uid");
        if (groupModel.getGroupName() != null && groupModel.getGroupName().length() > 0) {
            this.attributeMap.put("cn", groupModel.getGroupName());
        }
        if (groupModel.getDescription() != null && groupModel.getDescription().length() > 0) {
            this.attributeMap.put("description", groupModel.getDescription());
        }
        this.log.debug((Object)"Loading dn");
        this.dn = groupModel.getGroupId();
        this.membersList = (List)new GenericModelWrapper((GenericModel)groupModel).getObjectParameter("member");
    }

    @Override
    public boolean validateData() {
        return LdapGroupValidator.validate(this.dn, this.objectClasses, this.attributeMap, this.membersList);
    }
}

