/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.javaapi.impl.engine;

import it.eng.rdlab.soa3.connector.utils.SecurityManager;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.AuthZRequestBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.configuration.ConfigurationManagerBuilder;
import it.eng.rdlab.soa3.pm.connector.javaapi.engine.PolicyDecisionEngine;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.utils.AttributeLoader;
import it.eng.rdlab.soa3.pm.connector.javaapi.impl.utils.Utils;
import java.util.List;
import java.util.Map;
import org.glite.authz.common.model.Action;
import org.glite.authz.common.model.Attribute;
import org.glite.authz.common.model.Request;
import org.glite.authz.common.model.Resource;
import org.glite.authz.common.model.Response;
import org.glite.authz.common.model.Result;
import org.glite.authz.common.model.Subject;
import org.glite.authz.pep.client.PEPClient;
import org.glite.authz.pep.client.config.PEPClientConfiguration;
import org.glite.authz.pep.profile.GridCEAuthorizationProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyDecisionEngineImpl
implements PolicyDecisionEngine {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PEPClient client;
    private final String SUBJECT_CATEGORY = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    private final String DATA_TYPE = "http://www.w3.org/2001/XMLSchema#string";
    private boolean indeterminateDecision;

    public PolicyDecisionEngineImpl() throws Exception {
        PEPClientConfiguration pepConfiguration = new PEPClientConfiguration();
        String endpoint = ConfigurationManagerBuilder.getConfigurationManager().getAuthQueryEndpoint();
        this.indeterminateDecision = ConfigurationManagerBuilder.getConfigurationManager().getIndeterminateDecision();
        this.logger.debug("Authorization query endpoint " + endpoint);
        pepConfiguration.addPEPDaemonEndpoint(endpoint);
        pepConfiguration.setTrustMaterial(SecurityManager.getInstance().getKeyStore());
        pepConfiguration.setKeyMaterial(SecurityManager.getInstance().getKeyStore(), "changeit");
        this.client = new PEPClient(pepConfiguration);
        this.logger.debug("Configuration completed");
    }

    public boolean getDecision(AuthZRequestBean bean) {
        boolean decision = false;
        GridCEAuthorizationProfile profile = GridCEAuthorizationProfile.getInstance();
        Subject subject = new Subject();
        subject.setCategory("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        Map<String, List<String>> attributeMap = Utils.generateAttributeMap(bean.getAttributes());
        for (String id : attributeMap.keySet()) {
            String attributeId = AttributeLoader.getInstance().getAttribute(id);
            this.logger.debug("Attribute id " + attributeId);
            Attribute attribute = new Attribute();
            attribute.setDataType("http://www.w3.org/2001/XMLSchema#string");
            attribute.setId(attributeId);
            List<String> values = attributeMap.get(id);
            for (String value : values) {
                this.logger.debug("Attribute value " + value);
                attribute.getValues().add(value);
            }
            subject.getAttributes().add(attribute);
        }
        Action action = profile.createActionId(bean.getAction());
        Resource resource = profile.createResourceId(bean.getResource());
        Request request = profile.createRequest(subject, resource, action);
        try {
            Response response = this.client.authorize(request);
            this.logger.debug("Argus Response " + response);
            List results = response.getResults();
            if (results.size() > 0) {
                Result result = (Result)results.get(0);
                int policyDecision = result.getDecision();
                this.logger.debug("Policy decision = " + policyDecision);
                decision = 1 == policyDecision || this.indeterminateDecision && 0 != policyDecision;
            } else {
                this.logger.error("No results!!!");
            }
        }
        catch (Exception e) {
            this.logger.debug("Policy query error", (Throwable)e);
        }
        this.logger.debug("Permit = " + decision);
        return decision;
    }
}

