/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.cms.elements.alternative;

import gr.uoa.di.madgik.cms.elements.DocumentProperty;
import gr.uoa.di.madgik.cms.elements.document.Document;
import gr.uoa.di.madgik.environment.exception.EnvironmentContentManagementSystemException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public abstract class DocumentAlternative {
    public String id;
    public String name;
    private InputStream inboundContentStream;
    public byte[] content;
    public String contentLocator;
    public String schemaName;
    public String schemaUri;
    public String creationTime;
    public String lastUpdate;
    public Document document;
    public String language;
    public long length;
    public String mimeType;
    public String type;
    public Map<String, DocumentProperty> properties;

    public abstract InputStream ResolveContent() throws Exception;

    public InputStream GetContentStream() throws EnvironmentContentManagementSystemException {
        try {
            if (this.inboundContentStream != null) {
                return this.inboundContentStream;
            }
            if (this.contentLocator != null) {
                return this.ResolveContent();
            }
            if (this.content != null) {
                ByteArrayInputStream ins = new ByteArrayInputStream(this.content);
                return ins;
            }
            return null;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not get content stream for document", e);
        }
    }

    public void SetInboundContentStream(InputStream is) {
        this.inboundContentStream = is;
    }
}

