/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.engine;

import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionCompletedStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStartedStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlanExecutor
extends Thread
implements Observer {
    private Logger logger = Logger.getLogger(PlanExecutor.class.getName());
    private ExecutionHandle Handle = null;

    public PlanExecutor(ExecutionHandle Handle) {
        this.Handle = Handle;
        this.RegisterForEvents();
        this.setName(PlanExecutor.class.getName());
        this.setDaemon(true);
    }

    public ExecutionHandle GetHandle() {
        return this.Handle;
    }

    private void RegisterForEvents() {
        ExecutionStateEvent ev = this.Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionCompleted);
        if (ev != null) {
            ev.addObserver(this);
        }
    }

    @Override
    public void run() {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "running executor");
            }
            this.Handle.PlanRunning();
            this.Handle.EmitEvent(new ExecutionStartedStateEvent());
            this.Handle.GetPlan().Root.Execute(this.Handle);
            this.Handle.SetIsCompleted(true);
            this.Handle.SetIsCompletedWithError(false);
            this.Handle.SetIsCompletedWithSuccess(true);
            this.Handle.SetCompletionError(null);
        }
        catch (ExecutionException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Could not complete successfully the plan execution", ex);
            }
            this.Handle.SetIsCompleted(true);
            this.Handle.SetIsCompletedWithError(true);
            this.Handle.SetIsCompletedWithSuccess(false);
            this.Handle.SetCompletionError(ex);
        }
        this.Handle.PlanCompleted();
        this.Handle.EmitEvent(new ExecutionCompletedStateEvent());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            return;
        }
        if (arg instanceof ExecutionCompletedStateEvent) {
            ExecutionEngine.RemoveExecutor(this);
        }
    }

    public void Dispose() {
        ExecutionStateEvent ev = this.Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionCompleted);
        if (ev != null) {
            ev.deleteObserver(this);
        }
        this.CleanUpFiles();
        this.Handle.Dispose();
    }

    private void CleanUpFiles() {
        for (String s : this.Handle.GetPlan().CleanUpLocalFiles) {
            try {
                String file = s;
                File f = new File(file);
                if (!f.exists() || !f.isFile() || f.delete()) continue;
                throw new Exception("Delete operation returned false. File prossibly not deleted");
            }
            catch (Exception ex) {
                if (!this.logger.isLoggable(Level.WARNING)) continue;
                this.logger.log(Level.WARNING, "Could not cleanup file of variable with location " + s);
            }
        }
    }
}

