/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.invocable.ws;

import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.invocable.ExecutionContextConfigBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.NozzleHandler;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSExecutionContextConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSSOAPCall;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSSOAPSimpleProxy;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSSOAPProxyWrapper {
    private static Logger logger = Logger.getLogger(WSSOAPProxyWrapper.class.getName());
    private URL ServiceEndPoint = null;
    private ExecutionHandle Handle;
    private boolean SupportsExecutionContext;
    private ExecutionContextConfigBase SuppliedContextProxy;
    private String ID = null;

    public WSSOAPProxyWrapper(ExecutionHandle Handle, String ID, URL ServiceEndPoint, boolean SupportsExecutionContext, ExecutionContextConfigBase SuppliedContextProxy) {
        this.ServiceEndPoint = ServiceEndPoint;
        this.Handle = Handle;
        this.SupportsExecutionContext = SupportsExecutionContext;
        this.SuppliedContextProxy = SuppliedContextProxy;
        this.ID = ID;
    }

    private boolean IsKeepContextAlive() {
        return this.SupportsExecutionContext && this.SuppliedContextProxy != null && this.SuppliedContextProxy.KeepContextAlive;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Invoke(WSSOAPCall methodCall, ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionValidationException, ExecutionInternalErrorException, ExecutionSerializationException {
        NozzleHandler handler;
        block15: {
            handler = null;
            boolean successfullyCompletedInvokation = false;
            try {
                methodCall.EvaluateArguments(Handle);
                WSSOAPSimpleProxy proxyWS = new WSSOAPSimpleProxy();
                IChannelLocator locator = null;
                WSExecutionContextConfig conf = null;
                boolean provideContext = false;
                if (this.SupportsExecutionContext && this.SuppliedContextProxy != null && this.SuppliedContextProxy instanceof WSExecutionContextConfig) {
                    provideContext = true;
                    if (((WSExecutionContextConfig)this.SuppliedContextProxy).NozzleConfig != null) {
                        handler = new NozzleHandler();
                        locator = handler.CreateInletNozzle(((WSExecutionContextConfig)this.SuppliedContextProxy).NozzleConfig, this.Handle);
                    }
                    conf = (WSExecutionContextConfig)this.SuppliedContextProxy;
                }
                Object ret = proxyWS.Invoke(this.ServiceEndPoint, methodCall, provideContext, locator, this.ID, conf, Handle);
                if (methodCall.OutputParameter != null) {
                    methodCall.OutputParameter.SetParameterValue(Handle, ret);
                }
                successfullyCompletedInvokation = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Cleaning up plugin with null handler (" + (handler == null) + ") and keep context alive (" + this.IsKeepContextAlive() + ")");
                }
                if (handler == null) return;
                if (!successfullyCompletedInvokation) break block15;
                if (this.IsKeepContextAlive()) {
                    this.Handle.AddContextHandler(handler);
                    return;
                }
            }
            catch (ExecutionRunTimeException ex) {
                try {
                    throw ex;
                    catch (ExecutionValidationException ex2) {
                        throw ex2;
                    }
                    catch (ExecutionInternalErrorException ex3) {
                        throw ex3;
                    }
                    catch (ExecutionSerializationException ex4) {
                        throw ex4;
                    }
                }
                catch (Throwable throwable) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Cleaning up plugin with null handler (" + (handler == null) + ") and keep context alive (" + this.IsKeepContextAlive() + ")");
                    }
                    if (handler == null) throw throwable;
                    if (!successfullyCompletedInvokation) {
                        handler.Dispose();
                        throw throwable;
                    }
                    if (this.IsKeepContextAlive()) {
                        this.Handle.AddContextHandler(handler);
                        throw throwable;
                    }
                    handler.Dispose();
                    throw throwable;
                }
            }
            handler.Dispose();
            return;
        }
        handler.Dispose();
    }
}

