/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.condition;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.condition.IConditionEnvironment;
import gr.uoa.di.madgik.execution.plan.element.condition.IPlanCondition;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputOutputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DecimalRangePlanCondition
implements IPlanCondition {
    private static Logger logger = Logger.getLogger(DecimalRangePlanCondition.class.getName());
    public static double DefaultEpsilon = 1.0E-5;
    public IInputParameter RangeStartParameter;
    public IInputParameter RangeEndParameter;
    public IInputOutputParameter CurrentValueParameter;
    public Boolean LeftBorderInclusive = false;
    public Boolean RightBorderInclusive = false;
    public double Epsilon = DefaultEpsilon;

    @Override
    public IPlanCondition.ConditionType GetCondtionType() {
        return IPlanCondition.ConditionType.DecimalRange;
    }

    @Override
    public void InitializeCondition() {
    }

    @Override
    public boolean EvaluateCondition(ExecutionHandle Handle, IConditionEnvironment Environment) throws ExecutionRunTimeException {
        Double start = this.GetStartValue(Handle);
        Double end = this.GetEndValue(Handle);
        Double current = this.GetCurrentValue(Handle);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Evaluating Range condition with start inclusive(" + this.LeftBorderInclusive + ") = " + start + " end inclusive(" + this.RightBorderInclusive + ") = " + end + " current = " + current);
        }
        if (this.FuzzyLess(current, start)) {
            return false;
        }
        if (this.FuzzyEqual(current, start) && !this.LeftBorderInclusive.booleanValue()) {
            return false;
        }
        if (this.FuzzyGreater(current, end)) {
            return false;
        }
        return !this.FuzzyEqual(current, end) || this.RightBorderInclusive != false;
    }

    private boolean FuzzyEqual(Double left, Double right) {
        return Math.abs(left - right) < this.Epsilon;
    }

    private boolean FuzzyLess(Double left, Double right) {
        double rightSignum;
        double leftSignum = Math.signum(left);
        if (leftSignum < (rightSignum = Math.signum(right))) {
            return true;
        }
        if (leftSignum > rightSignum) {
            return false;
        }
        if (this.FuzzyEqual(leftSignum, 0.0)) {
            return false;
        }
        if (leftSignum > 0.0) {
            Double diffSignum = Math.signum(left - right);
            if (this.FuzzyEqual(diffSignum, 0.0)) {
                return false;
            }
            if (this.FuzzyEqual(diffSignum, -1.0)) {
                return true;
            }
            if (this.FuzzyEqual(diffSignum, 1.0)) {
                return false;
            }
        } else if (leftSignum < 0.0) {
            Double diffSignum = Math.signum(Math.abs(left) - Math.abs(right));
            if (this.FuzzyEqual(diffSignum, 0.0)) {
                return false;
            }
            if (this.FuzzyEqual(diffSignum, -1.0)) {
                return false;
            }
            if (this.FuzzyEqual(diffSignum, 1.0)) {
                return true;
            }
        }
        return false;
    }

    private boolean FuzzyGreater(Double left, Double right) {
        double rightSignum;
        double leftSignum = Math.signum(left);
        if (leftSignum > (rightSignum = Math.signum(right))) {
            return true;
        }
        if (leftSignum < rightSignum) {
            return false;
        }
        if (this.FuzzyEqual(leftSignum, 0.0)) {
            return false;
        }
        if (leftSignum > 0.0) {
            Double diffSignum = Math.signum(left - right);
            if (this.FuzzyEqual(diffSignum, 0.0)) {
                return false;
            }
            if (this.FuzzyEqual(diffSignum, -1.0)) {
                return false;
            }
            if (this.FuzzyEqual(diffSignum, 1.0)) {
                return true;
            }
        } else if (leftSignum < 0.0) {
            Double diffSignum = Math.signum(Math.abs(left) - Math.abs(right));
            if (this.FuzzyEqual(diffSignum, 0.0)) {
                return false;
            }
            if (this.FuzzyEqual(diffSignum, -1.0)) {
                return true;
            }
            if (this.FuzzyEqual(diffSignum, 1.0)) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        Set<String> ExcludeAvailableConstraint = this.GetModifiedVariableNames();
        this.Validate();
        this.RangeEndParameter.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        this.RangeStartParameter.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        this.CurrentValueParameter.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
    }

    private Double GetStartValue(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            return DataTypeUtils.GetValueAsDouble(this.RangeStartParameter.GetParameterValue(Handle));
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve needed value", ex);
        }
    }

    private Double GetEndValue(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            return DataTypeUtils.GetValueAsDouble(this.RangeEndParameter.GetParameterValue(Handle));
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve needed value", ex);
        }
    }

    private Double GetCurrentValue(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            return DataTypeUtils.GetValueAsDouble(this.CurrentValueParameter.GetParameterValue(Handle));
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve needed value", ex);
        }
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided Range plan consition", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            if (!IPlanCondition.ConditionType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetCondtionType())) {
                throw new ExecutionSerializationException("not valid serialization of range plan condition");
            }
            Element tmpelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"start");
            if (tmpelem == null) {
                throw new ExecutionSerializationException("Provided serialization is not a valid one");
            }
            Element param = XMLUtils.GetChildElementWithName((Node)tmpelem, (String)"param");
            if (param == null) {
                throw new ExecutionSerializationException("Provided serialization is not a valid one");
            }
            this.RangeStartParameter = (IInputParameter)ParameterUtils.GetParameter(param);
            tmpelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"end");
            if (tmpelem == null) {
                throw new ExecutionSerializationException("Provided serialization is not a valid one");
            }
            param = XMLUtils.GetChildElementWithName((Node)tmpelem, (String)"param");
            if (param == null) {
                throw new ExecutionSerializationException("Provided serialization is not a valid one");
            }
            this.RangeEndParameter = (IInputParameter)ParameterUtils.GetParameter(param);
            tmpelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"current");
            if (tmpelem == null) {
                throw new ExecutionSerializationException("Provided serialization is not a valid one");
            }
            param = XMLUtils.GetChildElementWithName((Node)tmpelem, (String)"param");
            if (param == null) {
                throw new ExecutionSerializationException("Provided serialization is not a valid one");
            }
            this.CurrentValueParameter = (IInputOutputParameter)ParameterUtils.GetParameter(param);
            this.LeftBorderInclusive = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XMLUtils.GetChildElementWithName((Node)XML, (String)"leftinclusive"), (String)"value"));
            this.RightBorderInclusive = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XMLUtils.GetChildElementWithName((Node)XML, (String)"rightinclusive"), (String)"value"));
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize range plan condition", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<condition type=\"" + this.GetCondtionType().toString() + "\">");
        buf.append("<start>");
        buf.append(this.RangeStartParameter.ToXML());
        buf.append("</start>");
        buf.append("<end>");
        buf.append(this.RangeEndParameter.ToXML());
        buf.append("</end>");
        buf.append("<current>");
        buf.append(this.CurrentValueParameter.ToXML());
        buf.append("</current>");
        buf.append("<leftinclusive value=\"" + this.LeftBorderInclusive.toString() + "\"/>");
        buf.append("<rightinclusive value=\"" + this.RightBorderInclusive.toString() + "\"/>");
        buf.append("</condition>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.RangeStartParameter == null) {
            throw new ExecutionValidationException("Needed variable name has not been defined");
        }
        if (this.RangeEndParameter == null) {
            throw new ExecutionValidationException("Needed variable name has not been defined");
        }
        if (this.CurrentValueParameter == null) {
            throw new ExecutionValidationException("Needed variable name has not been defined");
        }
        this.RangeStartParameter.Validate();
        this.RangeEndParameter.Validate();
        this.CurrentValueParameter.Validate();
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> inputs = new HashSet<String>();
        inputs.addAll(this.RangeStartParameter.GetNeededVariableNames());
        inputs.addAll(this.RangeEndParameter.GetNeededVariableNames());
        inputs.addAll(this.CurrentValueParameter.GetNeededVariableNames());
        return inputs;
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> inputs = new HashSet<String>();
        inputs.addAll(this.RangeStartParameter.GetModifiedVariableNames());
        inputs.addAll(this.RangeEndParameter.GetModifiedVariableNames());
        inputs.addAll(this.CurrentValueParameter.GetModifiedVariableNames());
        return inputs;
    }
}

