/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterSerializationFilter
extends ParameterFilterBase {
    private static Logger logger = Logger.getLogger(ParameterSerializationFilter.class.getName());
    public String FilteredVariableName = null;
    public boolean StoreOutput = false;
    public String StoreOutputVariableName = null;
    public Set<String> TokenProvidingVariableNames = new HashSet<String>();

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.FilteredVariableName);
        vars.addAll(this.TokenProvidingVariableNames);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.StoreOutputVariableName);
        return vars;
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Starting filtering");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        String template = null;
        try {
            template = ndt.Value.GetStringValue();
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve filter rule", ex);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "filtering template is " + template);
        }
        try {
            for (NamedDataType entry : Handle.GetPlan().Variables) {
                if (entry.Token == null || entry.Token.trim().length() == 0 || !this.TokenProvidingVariableNames.contains(entry.Name)) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Checking if template contains token " + this.GetToken(entry.Token));
                }
                while (template.contains(this.GetToken(entry.Token))) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Using token " + this.GetToken(entry.Token) + " with value " + entry.Value.GetStringValue());
                    }
                    template = template.replace(this.GetToken(entry.Token), entry.Value.GetStringValue());
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "template now is " + template);
            }
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not evalute template rule", ex);
        }
        return template;
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        String template = null;
        try {
            template = DataTypeUtils.GetValueAsString(OnLineFilteredValue);
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve filter rule", ex);
        }
        try {
            for (NamedDataType entry : AdditionalValueProviders) {
                if (entry.Token == null || entry.Token.trim().length() == 0) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Checking if template contains token " + this.GetToken(entry.Token));
                }
                while (template.contains(this.GetToken(entry.Token))) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Using token " + this.GetToken(entry.Token) + " with value " + entry.Value.GetStringValue());
                    }
                    template = template.replace(this.GetToken(entry.Token), entry.Value.GetStringValue());
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "template now is " + template);
            }
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not evalute template rule", ex);
        }
        return template;
    }

    @Override
    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableName == null || this.FilteredVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.StoreOutput && (this.StoreOutputVariableName == null || this.StoreOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("No output variable name defined to store output");
        }
        if (this.TokenProvidingVariableNames == null) {
            throw new ExecutionValidationException("Token providing variables can be empty but cannot be null");
        }
        this.TokenMappingValidate();
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (this.StoreOutput) {
            for (String storeVarName : this.GetStoreOutputVariableName()) {
                if (Handle.GetPlan().Variables.Contains(storeVarName)) continue;
                throw new ExecutionValidationException("Needed parameter to store output not present");
            }
        }
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return true;
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        if (this.FilteredVariableName != null && this.FilteredVariableName.trim().length() != 0) {
            throw new ExecutionValidationException("No parameter name should be provided for online filtering");
        }
        if (this.StoreOutput) {
            throw new ExecutionValidationException("Online filtering cannot store intermediate results");
        }
        if (this.StoreOutputVariableName != null && this.StoreOutputVariableName.trim().length() != 0) {
            throw new ExecutionValidationException("No output variable name should be provided for online filtering");
        }
        if (this.TokenProvidingVariableNames == null) {
            throw new ExecutionValidationException("Token providing variables can be empty but cannot be null");
        }
        if (this.TokenProvidingVariableNames.size() != 0) {
            throw new ExecutionValidationException("No token providing set is expected");
        }
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.StoreOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if ((tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableName = XMLUtils.GetChildText((Node)tmp);
            Element tokenprovelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"tokenProviders");
            if (tokenprovelem == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            List varpovs = XMLUtils.GetChildElementsWithName((Node)tokenprovelem, (String)"var");
            this.TokenProvidingVariableNames.clear();
            for (Element varprov : varpovs) {
                if (!XMLUtils.AttributeExists((Element)varprov, (String)"name").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.TokenProvidingVariableNames.add(XMLUtils.GetAttribute((Element)varprov, (String)"name"));
            }
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        String outputvarString = "";
        if (this.StoreOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.StoreOutputVariableName + "\"";
        }
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        if (this.FilteredVariableName == null) {
            buf.append("<filteredVariable/>");
        } else {
            buf.append("<filteredVariable>" + this.FilteredVariableName + "</filteredVariable>");
        }
        buf.append("<tokenProviders>");
        for (String prov : this.TokenProvidingVariableNames) {
            buf.append("<var name=\"" + prov + "\"/>");
        }
        buf.append("</tokenProviders>");
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.Serialization;
    }
}

