/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.utils;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeArray;
import gr.uoa.di.madgik.execution.datatype.DataTypeReflectable;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.ReflectableItem;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.execution.utils.IExternalClassLoader;
import gr.uoa.di.madgik.execution.utils.ReflectableAnalyzerMemberInfo;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReflectableAnalyzer {
    private static Logger logger = Logger.getLogger(ReflectableAnalyzer.class.getName());
    public Class<?> Reflectable = null;
    public HashSet<String> UnderInvestigation = new HashSet();
    public IExternalClassLoader extLoader = null;

    public ReflectableAnalyzer() {
    }

    public ReflectableAnalyzer(Class<?> Reflectable, IExternalClassLoader extLoader) {
        this.Reflectable = Reflectable;
        this.UnderInvestigation.add(this.Reflectable.getName());
        this.extLoader = extLoader;
    }

    private ReflectableAnalyzer(Class<?> Reflectable, HashSet<String> UnderInvestigation, IExternalClassLoader extLoader) {
        this.Reflectable = Reflectable;
        this.UnderInvestigation = UnderInvestigation;
        this.UnderInvestigation.add(this.Reflectable.getName());
        this.extLoader = extLoader;
    }

    public boolean CanDescribeAsReflectable() {
        Class<?> originalReflectable = this.Reflectable;
        if (this.Reflectable.isArray()) {
            this.Reflectable = ReflectableAnalyzer.GetBaseComponentType(this.Reflectable, this.extLoader);
            this.UnderInvestigation.clear();
            this.UnderInvestigation.add(this.Reflectable.getName());
        }
        if (this.IsPrimitive(this.Reflectable) != null) {
            return false;
        }
        if (!this.GetterSettersExistForFields()) {
            return false;
        }
        this.Reflectable = originalReflectable;
        return true;
    }

    public boolean CanRepresentAsReflectable() {
        if (this.Reflectable.isArray()) {
            return false;
        }
        if (this.IsPrimitive(this.Reflectable) != null) {
            return false;
        }
        return this.GetterSettersExistForFields();
    }

    public String GetReflectableDescription() {
        try {
            this.UnderInvestigation.clear();
            this.UnderInvestigation.add(this.Reflectable.getName());
            StringBuilder buf = new StringBuilder();
            Class<?> currentType = this.Reflectable;
            if (this.Reflectable.isArray()) {
                int dims = DataTypeUtils.CountDimentionsOfObjectArrayCode(this.Reflectable.getName());
                String arrtype = "";
                for (int i = 0; i < dims; ++i) {
                    arrtype = arrtype + "[";
                }
                arrtype = arrtype + IDataType.DataTypes.Reflectable.toString();
                buf.append("<execprf:array type=\"" + arrtype + "\">");
                currentType = ReflectableAnalyzer.GetBaseComponentType(this.Reflectable, this.extLoader);
            }
            buf.append("<execprf:refl type=\"" + currentType.getName() + "\">");
            HashSet<ReflectableAnalyzerMemberInfo> infos = this.GetFirstLevelGettersSetters();
            for (ReflectableAnalyzerMemberInfo nfo : infos) {
                ReflectableAnalyzer anal;
                buf.append("<execprf:item>");
                buf.append("<execprf:name value=\"" + nfo.name + "\"/>");
                buf.append("<execprf:type value=\"" + nfo.type.getName() + "\"/>");
                IDataType.DataTypes dtype = this.IsDirectPrimitive(nfo.type);
                String engType = null;
                if (dtype == null) {
                    dtype = IDataType.DataTypes.Reflectable;
                }
                engType = dtype.toString();
                if (nfo.type.isArray()) {
                    int dims = DataTypeUtils.CountDimentionsOfObjectArrayCode(nfo.type.getName());
                    StringBuilder engTypeBuf = new StringBuilder();
                    engType = "";
                    for (int i = 0; i < dims; ++i) {
                        engTypeBuf.append("[");
                    }
                    engTypeBuf.append(dtype.toString());
                    engType = engType + engTypeBuf.toString();
                }
                buf.append("<execprf:engineType value=\"" + engType + "\">");
                if (dtype.equals((Object)IDataType.DataTypes.Reflectable) && (anal = new ReflectableAnalyzer(nfo.type, this.extLoader)).CanDescribeAsReflectable()) {
                    buf.append(anal.GetReflectableDescription());
                }
                buf.append("</execprf:engineType>");
                buf.append("</execprf:item>");
            }
            buf.append("</execprf:refl>");
            if (this.Reflectable.isArray()) {
                buf.append("</execprf:array>");
            }
            return buf.toString();
        }
        catch (ExecutionValidationException ex) {
            return null;
        }
    }

    public String PopulateTemplateFromReflectable(String Template, DataTypeReflectable refl, Map<String, String> TokenMapping) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Template is : " + Template);
        }
        StringBuilder buf = new StringBuilder();
        Document doc = XMLUtils.Deserialize((String)Template);
        List templateItems = XMLUtils.GetChildElementsWithName((Node)doc.getDocumentElement(), (String)"item");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Number of items in template is " + templateItems.size());
        }
        block0: for (Element templateElem : templateItems) {
            if (!XMLUtils.AttributeExists((Element)templateElem, (String)"type").booleanValue()) {
                throw new ExecutionValidationException("Invalid template provided");
            }
            if (XMLUtils.GetAttribute((Element)templateElem, (String)"type").equals("literal")) {
                String tokenSeparator = null;
                if (XMLUtils.AttributeExists((Element)templateElem, (String)"tokenSeparator").booleanValue()) {
                    tokenSeparator = XMLUtils.GetAttribute((Element)templateElem, (String)"tokenSeparator");
                }
                String[] tokens = new String[]{};
                if (XMLUtils.AttributeExists((Element)templateElem, (String)"tokens").booleanValue()) {
                    if (tokenSeparator == null) {
                        throw new ExecutionValidationException("Invalid template provided");
                    }
                    String tokenStrings = XMLUtils.GetAttribute((Element)templateElem, (String)"tokens");
                    tokens = tokenStrings.split(tokenSeparator);
                }
                boolean isXML = false;
                if (XMLUtils.AttributeExists((Element)templateElem, (String)"isxml").booleanValue() && DataTypeUtils.GetValueAsBoolean(XMLUtils.GetAttribute((Element)templateElem, (String)"isxml"))) {
                    isXML = true;
                }
                String payload = null;
                payload = !isXML ? XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)templateElem)) : XMLUtils.SerializeChild((Element)templateElem);
                if (payload == null || payload.trim().length() == 0) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Number of tokens to replace " + tokens.length);
                }
                for (String tok : tokens) {
                    if (tok == null || tok.trim().length() == 0) continue;
                    for (ReflectableItem it : refl) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Comparing '" + this.GetToken(TokenMapping, tok.trim()) + "' with '" + this.GetToken(TokenMapping, it.Token) + "'");
                        }
                        if (!this.GetToken(TokenMapping, it.Token).equalsIgnoreCase(this.GetToken(TokenMapping, tok.trim()))) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Found match for tokens " + this.GetToken(TokenMapping, tok.trim()) + " and inserting value " + it.Value.GetStringValue());
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Original message is " + payload);
                        }
                        while (payload.contains(this.GetToken(TokenMapping, tok.trim()))) {
                            payload = payload.replace(this.GetToken(TokenMapping, tok.trim()), it.Value.GetStringValue());
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "Replaced message is " + payload);
                    }
                }
                buf.append(payload);
                continue;
            }
            if (XMLUtils.GetAttribute((Element)templateElem, (String)"type").equals("refl")) {
                if (!XMLUtils.AttributeExists((Element)templateElem, (String)"token").booleanValue()) {
                    throw new ExecutionValidationException("Invalid template provided");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Processing template item with token " + this.GetToken(TokenMapping, XMLUtils.GetAttribute((Element)templateElem, (String)"token")));
                }
                for (ReflectableItem it : refl) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Matching it with " + this.GetToken(TokenMapping, it.Token));
                    }
                    if (!this.GetToken(TokenMapping, it.Token).equalsIgnoreCase(this.GetToken(TokenMapping, XMLUtils.GetAttribute((Element)templateElem, (String)"token")))) continue;
                    String subTemplate = XMLUtils.SerializeChild((Element)templateElem);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Matched and passing subtemplate " + subTemplate);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Matched reflection item is ");
                    }
                    if (!(it.Value instanceof DataTypeReflectable)) {
                        throw new ExecutionValidationException("Value not of required type for template");
                    }
                    ReflectableAnalyzer anal = new ReflectableAnalyzer();
                    buf.append(anal.PopulateTemplateFromReflectable(subTemplate, (DataTypeReflectable)it.Value, TokenMapping));
                    continue block0;
                }
                continue;
            }
            if (XMLUtils.GetAttribute((Element)templateElem, (String)"type").equals("array")) {
                if (!XMLUtils.AttributeExists((Element)templateElem, (String)"token").booleanValue()) {
                    throw new ExecutionValidationException("Invalid template provided");
                }
                for (ReflectableItem it : refl) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Matching it with " + this.GetToken(TokenMapping, it.Token));
                    }
                    if (!this.GetToken(TokenMapping, it.Token).equalsIgnoreCase(this.GetToken(TokenMapping, XMLUtils.GetAttribute((Element)templateElem, (String)"token")))) continue;
                    if (!(it.Value instanceof DataTypeArray)) {
                        throw new ExecutionValidationException("Value not of required type for template");
                    }
                    Element arrayElem = XMLUtils.GetChildElementWithName((Node)templateElem, (String)"item");
                    if (!XMLUtils.AttributeExists((Element)arrayElem, (String)"type").booleanValue()) {
                        throw new ExecutionValidationException("Invalid template provided");
                    }
                    if (XMLUtils.GetAttribute((Element)arrayElem, (String)"type").equals("array")) {
                        throw new ExecutionValidationException("Invalid template provided");
                    }
                    if (XMLUtils.GetAttribute((Element)arrayElem, (String)"type").equals("literal")) {
                        String tokenSeparator = null;
                        if (XMLUtils.AttributeExists((Element)arrayElem, (String)"tokenSeparator").booleanValue()) {
                            tokenSeparator = XMLUtils.GetAttribute((Element)arrayElem, (String)"tokenSeparator");
                        }
                        String[] tokens = new String[]{};
                        if (XMLUtils.AttributeExists((Element)arrayElem, (String)"tokens").booleanValue()) {
                            if (tokenSeparator == null) {
                                throw new ExecutionValidationException("Invalid template provided");
                            }
                            String tokenStrings = XMLUtils.GetAttribute((Element)arrayElem, (String)"tokens");
                            tokens = tokenStrings.split(tokenSeparator);
                        }
                        boolean isXML = false;
                        if (XMLUtils.AttributeExists((Element)arrayElem, (String)"isxml").booleanValue() && DataTypeUtils.GetValueAsBoolean(XMLUtils.GetAttribute((Element)arrayElem, (String)"isxml"))) {
                            isXML = true;
                        }
                        String originalPayload = null;
                        originalPayload = !isXML ? XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)arrayElem)) : XMLUtils.SerializeChild((Element)arrayElem);
                        if (originalPayload == null || originalPayload.trim().length() == 0) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Number of tokens to replace " + tokens.length);
                        }
                        for (IDataType dtArr : (DataTypeArray)it.Value) {
                            String payload = new String(originalPayload);
                            for (String tok : tokens) {
                                if (tok == null || tok.trim().length() == 0) continue;
                                while (payload.contains(this.GetToken(TokenMapping, tok.trim()))) {
                                    payload = payload.replace(this.GetToken(TokenMapping, tok.trim()), dtArr.GetStringValue());
                                }
                            }
                            buf.append(payload);
                        }
                        continue block0;
                    }
                    if (XMLUtils.GetAttribute((Element)arrayElem, (String)"type").equals("refl")) {
                        String subTemplate = XMLUtils.SerializeChild((Element)arrayElem);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Matched and passing subtemplate " + subTemplate);
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Matched reflection item is ");
                        }
                        for (IDataType dtArr : (DataTypeArray)it.Value) {
                            if (!(dtArr instanceof DataTypeReflectable)) {
                                throw new ExecutionValidationException("Invalid template provided");
                            }
                            ReflectableAnalyzer anal = new ReflectableAnalyzer();
                            buf.append(anal.PopulateTemplateFromReflectable(subTemplate, (DataTypeReflectable)dtArr, TokenMapping));
                        }
                        continue block0;
                    }
                    throw new ExecutionValidationException("invalid template provided");
                }
                continue;
            }
            throw new ExecutionValidationException("invalid template provided");
        }
        return buf.toString();
    }

    public DataTypeReflectable PopulateReflectableFromTemplate(String Template, String Value, int i, Map<String, String> TokenMapping) throws Exception {
        ReflectableItem newItem;
        String subElemValue;
        String subElemTemplate;
        ReflectableAnalyzer anal;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Template input is = " + Template);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Value input is = " + Value);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Array index is = " + i);
        }
        ArrayList<ReflectableItem> items = new ArrayList<ReflectableItem>();
        Document docValue = XMLUtils.Deserialize((String)Value);
        Document docTemplate = XMLUtils.Deserialize((String)Template);
        Element reflTemplateElement = docTemplate.getDocumentElement();
        if (reflTemplateElement == null) {
            throw new ExecutionValidationException("invalid template provided");
        }
        if (!reflTemplateElement.getNodeName().equals("refl")) {
            throw new ExecutionValidationException("invalid template provided");
        }
        if (!XMLUtils.AttributeExists((Element)reflTemplateElement, (String)"name").booleanValue()) {
            throw new ExecutionValidationException("invalid template provided");
        }
        if (!XMLUtils.AttributeExists((Element)reflTemplateElement, (String)"ns").booleanValue()) {
            throw new ExecutionValidationException("invalid template provided");
        }
        ArrayList<Element> reflValueElements = null;
        if (docValue.getDocumentElement().getLocalName().equals(XMLUtils.GetAttribute((Element)reflTemplateElement, (String)"name")) && docValue.getDocumentElement().getNamespaceURI().equals(XMLUtils.GetAttribute((Element)reflTemplateElement, (String)"ns"))) {
            reflValueElements = new ArrayList<Element>();
            reflValueElements.add(docValue.getDocumentElement());
        } else {
            reflValueElements = XMLUtils.GetChildElementsWithNameAndNamespace((Node)docValue.getDocumentElement(), (String)XMLUtils.GetAttribute((Element)reflTemplateElement, (String)"name"), (String)XMLUtils.GetAttribute((Element)reflTemplateElement, (String)"ns"));
        }
        if (reflValueElements == null || reflValueElements.size() == 0) {
            throw new ExecutionValidationException("invalid value for template provided");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "number of of values are " + reflValueElements.size());
        }
        List itemsTemplateLst = XMLUtils.GetChildElementsWithName((Node)reflTemplateElement, (String)"item");
        for (Element ittempl : itemsTemplateLst) {
            Element refValueItemToken;
            if (!(XMLUtils.AttributeExists((Element)ittempl, (String)"name").booleanValue() && XMLUtils.AttributeExists((Element)ittempl, (String)"token").booleanValue() && XMLUtils.AttributeExists((Element)ittempl, (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)ittempl, (String)"ns").booleanValue())) {
                throw new ExecutionValidationException("invalid template provided");
            }
            IDataType.DataTypes itemDataType = IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)ittempl, (String)"type"));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "item data type = " + itemDataType.toString());
            }
            if ((refValueItemToken = XMLUtils.GetChildElementWithNameAndNamespace((Node)((Node)reflValueElements.get(i)), (String)XMLUtils.GetAttribute((Element)ittempl, (String)"token"), (String)XMLUtils.GetAttribute((Element)ittempl, (String)"ns"))) == null) {
                throw new ExecutionValidationException("invalid Value for template provided");
            }
            IDataType dt = DataTypeUtils.GetDataType(itemDataType);
            switch (dt.GetDataTypeEnum()) {
                case Array: {
                    throw new ExecutionValidationException("Embedded arrays are not supported");
                }
                case Convertable: {
                    throw new ExecutionValidationException("Convertables are not supported");
                }
                case Reflectable: {
                    Element reflSubElement = XMLUtils.GetChildElementWithName((Node)ittempl, (String)"refl");
                    if (reflSubElement == null) {
                        throw new ExecutionValidationException("invalid template provided");
                    }
                    anal = new ReflectableAnalyzer();
                    subElemTemplate = XMLUtils.Serialize((Node)reflSubElement);
                    subElemValue = XMLUtils.Serialize((Node)refValueItemToken);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Passing to sub reflectable template " + subElemTemplate);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Passing to sub reflectable value " + subElemValue);
                    }
                    dt.SetValue(anal.PopulateReflectableFromTemplate(subElemTemplate, subElemValue, 0, TokenMapping));
                    if (!logger.isLoggable(Level.FINE)) break;
                    logger.log(Level.FINE, "Created sub element ");
                    break;
                }
                case BooleanClass: 
                case BooleanPrimitive: 
                case DoubleClass: 
                case DoublePrimitive: 
                case FloatClass: 
                case FloatPrimitive: 
                case IntegerClass: 
                case IntegerPrimitive: 
                case String: 
                case ResultSet: {
                    dt.SetStringValue(XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)refValueItemToken)));
                    break;
                }
                default: {
                    throw new ExecutionValidationException("Unrecognized data type");
                }
            }
            newItem = new ReflectableItem();
            newItem.Name = this.GetToken(TokenMapping, XMLUtils.GetAttribute((Element)ittempl, (String)"name"));
            newItem.Token = "[execprfBeginToken]" + newItem.Name + "[execprfEndToken]";
            newItem.Value = dt;
            items.add(newItem);
        }
        List arraysTemplateLst = XMLUtils.GetChildElementsWithName((Node)reflTemplateElement, (String)"array");
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Found " + arraysTemplateLst.size() + " arrays references in template ");
        }
        for (Element ittempl : arraysTemplateLst) {
            DataTypeArray dt = null;
            Element reflSubElement = XMLUtils.GetChildElementWithName((Node)ittempl, (String)"refl");
            if (reflSubElement != null) {
                dt = new DataTypeArray();
                dt.SetArrayClassCode("[" + (Object)((Object)IDataType.DataTypes.Reflectable));
                ArrayList<DataTypeReflectable> arritems = new ArrayList<DataTypeReflectable>();
                anal = new ReflectableAnalyzer();
                subElemTemplate = XMLUtils.Serialize((Node)reflSubElement);
                subElemValue = XMLUtils.Serialize((Node)((Node)reflValueElements.get(i)));
                List arritemselems = XMLUtils.GetChildElementsWithNameAndNamespace((Node)((Node)reflValueElements.get(i)), (String)XMLUtils.GetAttribute((Element)reflSubElement, (String)"name"), (String)XMLUtils.GetAttribute((Element)reflSubElement, (String)"ns"));
                for (int x = 0; x < arritemselems.size(); ++x) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Passing to sub reflectable template " + subElemTemplate);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Passing to sub reflectable value " + subElemValue);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Passing to sub reflectable index " + x);
                    }
                    arritems.add(anal.PopulateReflectableFromTemplate(subElemTemplate, subElemValue, x, TokenMapping));
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "Created sub element ");
                }
                dt.SetValue(arritems.toArray(new IDataType[0]));
            } else {
                Element primSubElement = XMLUtils.GetChildElementWithName((Node)ittempl, (String)"item");
                if (primSubElement == null) {
                    throw new ExecutionValidationException("invalid template provided");
                }
                if (!(XMLUtils.AttributeExists((Element)primSubElement, (String)"name").booleanValue() && XMLUtils.AttributeExists((Element)primSubElement, (String)"token").booleanValue() && XMLUtils.AttributeExists((Element)primSubElement, (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)primSubElement, (String)"ns").booleanValue())) {
                    throw new ExecutionValidationException("invalid template provided");
                }
                IDataType.DataTypes itemSubDataType = IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)primSubElement, (String)"type"));
                dt = new DataTypeArray();
                dt.SetArrayClassCode("[" + itemSubDataType.toString());
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Searching for elements with name " + XMLUtils.GetAttribute((Element)primSubElement, (String)"token") + " and ns " + XMLUtils.GetAttribute((Element)primSubElement, (String)"ns") + " under value element with name " + ((Element)reflValueElements.get(i)).getLocalName());
                }
                List refValueSubElements = XMLUtils.GetChildElementsWithNameAndNamespace((Node)((Node)reflValueElements.get(i)), (String)XMLUtils.GetAttribute((Element)primSubElement, (String)"token"), (String)XMLUtils.GetAttribute((Element)primSubElement, (String)"ns"));
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "found " + refValueSubElements.size() + " items");
                }
                if (refValueSubElements == null) {
                    throw new ExecutionValidationException("invalid values provided for template");
                }
                ArrayList<IDataType> arritems = new ArrayList<IDataType>();
                for (Element refValueSubitem : refValueSubElements) {
                    IDataType dtarritem = DataTypeUtils.GetDataType(itemSubDataType);
                    dtarritem.SetStringValue(XMLUtils.UndoReplaceSpecialCharachters((String)XMLUtils.GetChildText((Node)refValueSubitem)));
                    arritems.add(dtarritem);
                }
                dt.SetValue(arritems.toArray(new IDataType[0]));
            }
            newItem = new ReflectableItem();
            newItem.Name = this.GetToken(TokenMapping, XMLUtils.GetAttribute((Element)ittempl, (String)"name"));
            newItem.Token = "[execprfBeginToken]" + newItem.Name + "[execprfEndToken]";
            newItem.Value = dt;
            items.add(newItem);
        }
        DataTypeReflectable refl = new DataTypeReflectable();
        refl.SetValue(items.toArray(new ReflectableItem[0]));
        return refl;
    }

    private String GetToken(Map<String, String> TokenMapping, String Token) {
        if (TokenMapping == null) {
            return Token;
        }
        if (TokenMapping.containsKey(Token)) {
            return TokenMapping.get(Token);
        }
        return Token;
    }

    public Object PopulateTarget(DataTypeReflectable template, Map<String, String> TokenMapping) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ExecutionValidationException {
        if (this.Reflectable.isArray()) {
            return null;
        }
        this.UnderInvestigation.clear();
        this.UnderInvestigation.add(this.Reflectable.getName());
        Object target = this.Reflectable.newInstance();
        HashSet<ReflectableAnalyzerMemberInfo> firstLevel = this.GetFirstLevelGettersSetters();
        for (ReflectableItem item : template) {
            for (ReflectableAnalyzerMemberInfo nfo : firstLevel) {
                Class<?> compType;
                int dim;
                IDataType.DataTypes dtype = this.IsDirectPrimitive(nfo.type);
                if (dtype != null) {
                    int dim2;
                    if (!this.GetToken(TokenMapping, nfo.name).equals(this.GetToken(TokenMapping, item.Name)) || (!nfo.type.isArray() ? !dtype.equals((Object)item.Value.GetDataTypeEnum()) : !item.Value.GetDataTypeEnum().equals((Object)IDataType.DataTypes.Array) || !(item.Value instanceof DataTypeArray) || !dtype.equals((Object)DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)item.Value).GetArrayClassCode())) || (dim2 = DataTypeUtils.CountDimentionsOfObjectArrayCode(((DataTypeArray)item.Value).GetArrayClassCode())) != DataTypeUtils.CountDimentionsOfObjectArrayCode(nfo.type.getName()))) continue;
                    Object val = item.Value.GetValue();
                    nfo.setter.invoke(target, val);
                    continue;
                }
                if (!this.GetToken(TokenMapping, nfo.name).equals(this.GetToken(TokenMapping, item.Name))) continue;
                if (!nfo.type.isArray()) {
                    ReflectableAnalyzer anal = new ReflectableAnalyzer(nfo.type, this.extLoader);
                    if (!anal.CanRepresentAsReflectable() || !item.Value.GetDataTypeEnum().equals((Object)IDataType.DataTypes.Reflectable) || !(item.Value instanceof DataTypeReflectable)) continue;
                    Object subValue = anal.PopulateTarget((DataTypeReflectable)item.Value, TokenMapping);
                    nfo.setter.invoke(target, subValue);
                    continue;
                }
                if (!item.Value.GetDataTypeEnum().equals((Object)IDataType.DataTypes.Array) || !(item.Value instanceof DataTypeArray) || (dim = DataTypeUtils.CountDimentionsOfObjectArrayCode(((DataTypeArray)item.Value).GetArrayClassCode())) != DataTypeUtils.CountDimentionsOfObjectArrayCode(nfo.type.getName()) || !DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)item.Value).GetArrayClassCode()).equals((Object)IDataType.DataTypes.Reflectable) || (compType = ReflectableAnalyzer.GetBaseComponentType(nfo.type, this.extLoader)) == null) continue;
                Object arrTempl = ((DataTypeArray)item.Value).GetValue();
                int[] dims = new int[dim];
                dims[0] = Array.getLength(arrTempl);
                Object arrInst = this.CopyArray(arrTempl, compType, TokenMapping);
                if (arrInst == null) continue;
                nfo.setter.invoke(target, arrInst);
            }
        }
        return target;
    }

    private Object CopyArray(Object source, Class<?> compType, Map<String, String> TokenMapping) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, ExecutionValidationException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!source.getClass().isArray()) {
            return null;
        }
        Object arr = null;
        if (source.getClass().getComponentType().isArray()) {
            int[] dims = new int[DataTypeUtils.CountDimentionsOfObjectArrayCode(source.getClass().getName())];
            dims[0] = Array.getLength(source);
            arr = Array.newInstance(compType, dims);
            for (int i = 0; i < Array.getLength(source); ++i) {
                Array.set(arr, i, this.CopyArray(Array.get(source, i), compType, TokenMapping));
            }
        } else {
            arr = Array.newInstance(compType, Array.getLength(source));
            for (int i = 0; i < Array.getLength(source); ++i) {
                ReflectableAnalyzer anal;
                Object subValue = null;
                Object initValue = Array.get(source, i);
                if (initValue != null && initValue instanceof DataTypeReflectable && (anal = new ReflectableAnalyzer(compType, this.extLoader)).CanRepresentAsReflectable()) {
                    subValue = anal.PopulateTarget((DataTypeReflectable)initValue, TokenMapping);
                }
                Array.set(arr, i, subValue);
            }
        }
        return arr;
    }

    public DataTypeReflectable ProduceReflectable(Object Value) throws ExecutionValidationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!Value.getClass().getName().equals(this.Reflectable.getName())) {
            return null;
        }
        if (this.Reflectable.isArray()) {
            return null;
        }
        this.UnderInvestigation.clear();
        this.UnderInvestigation.add(this.Reflectable.getName());
        DataTypeReflectable dt = new DataTypeReflectable();
        HashSet<ReflectableAnalyzerMemberInfo> firstLevel = this.GetFirstLevelGettersSetters();
        ArrayList<ReflectableItem> items = new ArrayList<ReflectableItem>();
        for (ReflectableAnalyzerMemberInfo nfo : firstLevel) {
            Class<?> arrayBaseComponentType;
            String compdts;
            StringBuilder compdtsBuf;
            int dims;
            ReflectableItem item;
            IDataType.DataTypes nonArrayPrim = this.IsDirectPrimitive(nfo.type);
            if (nonArrayPrim != null) {
                item = new ReflectableItem();
                item.Name = nfo.name;
                item.Token = "[execprfBeginToken]" + nfo.name + "[execprfEndToken]";
                if (!nfo.type.isArray()) {
                    item.Value = DataTypeUtils.GetDataType(nonArrayPrim);
                } else {
                    dims = DataTypeUtils.CountDimentionsOfObjectArrayCode(nfo.type.getName());
                    compdtsBuf = new StringBuilder();
                    compdts = "";
                    for (int i = 0; i < dims; ++i) {
                        compdtsBuf.append("[");
                    }
                    compdtsBuf.append(nonArrayPrim.toString());
                    compdts = compdtsBuf.toString();
                    item.Value = DataTypeUtils.GetDataType(IDataType.DataTypes.Array);
                    arrayBaseComponentType = this.GetBasePrimitiveClassOfArray(nfo.type);
                    if (arrayBaseComponentType == null) {
                        throw new ExecutionValidationException("Expecting primitive type but found " + nfo.type);
                    }
                    ((DataTypeArray)item.Value).SetDefaultComponentType(arrayBaseComponentType.getName());
                    ((DataTypeArray)item.Value).SetArrayClassCode(compdts);
                }
                item.Value.SetValue(nfo.getter.invoke(Value, (Object[])null));
                items.add(item);
                continue;
            }
            item = new ReflectableItem();
            item.Name = nfo.name;
            item.Token = "[execprfBeginToken]" + nfo.name + "[execprfEndToken]";
            if (!nfo.type.isArray()) {
                item.Value = new DataTypeReflectable();
                ReflectableAnalyzer subanal = new ReflectableAnalyzer(nfo.type, this.extLoader);
                if (!subanal.CanRepresentAsReflectable()) {
                    throw new ExecutionValidationException("Expecting elememnt to be reflectable but got " + nfo.type);
                }
                item.Value.SetValue(subanal.ProduceReflectable(nfo.getter.invoke(Value, (Object[])null)));
            } else {
                dims = DataTypeUtils.CountDimentionsOfObjectArrayCode(nfo.type.getName());
                compdtsBuf = new StringBuilder();
                compdts = "";
                for (int i = 0; i < dims; ++i) {
                    compdtsBuf.append("[");
                }
                compdtsBuf.append(IDataType.DataTypes.Reflectable.toString());
                compdts = compdtsBuf.toString();
                item.Value = DataTypeUtils.GetDataType(IDataType.DataTypes.Array);
                arrayBaseComponentType = ReflectableAnalyzer.GetBaseComponentType(nfo.type, this.extLoader);
                if (arrayBaseComponentType == null) {
                    throw new ExecutionValidationException("Expecting non primitive type but found " + nfo.type);
                }
                ((DataTypeArray)item.Value).SetDefaultComponentType(arrayBaseComponentType.getName());
                ((DataTypeArray)item.Value).SetArrayClassCode(compdts);
                item.Value.SetValue(nfo.getter.invoke(Value, (Object[])null));
            }
            items.add(item);
        }
        ReflectableItem[] itemsArray = items.toArray(new ReflectableItem[0]);
        dt.SetValue(itemsArray);
        return dt;
    }

    private HashSet<ReflectableAnalyzerMemberInfo> GetFirstLevelGettersSetters() {
        Method[] methods;
        Hashtable<String, ReflectableAnalyzerMemberInfo> getters = new Hashtable<String, ReflectableAnalyzerMemberInfo>();
        Hashtable<String, ReflectableAnalyzerMemberInfo> setters = new Hashtable<String, ReflectableAnalyzerMemberInfo>();
        HashSet<ReflectableAnalyzerMemberInfo> paired = new HashSet<ReflectableAnalyzerMemberInfo>();
        for (Method m : methods = ReflectableAnalyzer.GetBaseComponentType(this.Reflectable, this.extLoader).getMethods()) {
            String name;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Checking method " + m.toString());
            }
            if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || Modifier.isAbstract(m.getModifiers())) continue;
            if (m.getName().toUpperCase().startsWith("get".toUpperCase())) {
                name = m.getName().substring("get".length());
                if (name.length() == 0 || m.getParameterTypes().length != 0 || m.getReturnType().getName().equals("void")) continue;
                getters.put(name, new ReflectableAnalyzerMemberInfo(name, m.getReturnType(), m, null));
            }
            if (!m.getName().toUpperCase().startsWith("set".toUpperCase()) || (name = m.getName().substring("set".length())).length() == 0 || m.getParameterTypes().length != 1 || !m.getReturnType().getName().equals("void")) continue;
            setters.put(name, new ReflectableAnalyzerMemberInfo(name, m.getParameterTypes()[0], null, m));
        }
        if (getters.size() == 0 || setters.size() == 0) {
            return paired;
        }
        for (Map.Entry entry : getters.entrySet()) {
            if (!setters.containsKey(entry.getKey()) || !((ReflectableAnalyzerMemberInfo)entry.getValue()).type.getName().equals(((ReflectableAnalyzerMemberInfo)setters.get(entry.getKey())).type.getName())) continue;
            paired.add(new ReflectableAnalyzerMemberInfo((String)entry.getKey(), ((ReflectableAnalyzerMemberInfo)entry.getValue()).type, ((ReflectableAnalyzerMemberInfo)entry.getValue()).getter, ((ReflectableAnalyzerMemberInfo)setters.get(entry.getKey())).setter));
        }
        if (paired.size() == 0) {
            return paired;
        }
        HashSet<ReflectableAnalyzerMemberInfo> toDel = new HashSet<ReflectableAnalyzerMemberInfo>();
        for (ReflectableAnalyzerMemberInfo entry : paired) {
            IDataType.DataTypes prim = this.IsPrimitive(ReflectableAnalyzer.GetBaseComponentType(entry.type, this.extLoader));
            if (prim != null) continue;
            Class<?> nonPrimCompType = ReflectableAnalyzer.GetBaseComponentType(entry.type, this.extLoader);
            if (this.UnderInvestigation.contains(nonPrimCompType.getName())) {
                toDel.add(entry);
                continue;
            }
            ReflectableAnalyzer suban = new ReflectableAnalyzer(nonPrimCompType, this.UnderInvestigation, this.extLoader);
            if (suban.CanRepresentAsReflectable()) {
                this.UnderInvestigation.remove(nonPrimCompType.getName());
                continue;
            }
            this.UnderInvestigation.remove(nonPrimCompType.getName());
            toDel.add(entry);
        }
        for (ReflectableAnalyzerMemberInfo entry : toDel) {
            paired.remove(entry);
        }
        return paired;
    }

    private boolean GetterSettersExistForFields() {
        Method[] methods;
        Hashtable getters = new Hashtable();
        Hashtable setters = new Hashtable();
        Hashtable paired = new Hashtable();
        for (Method m : methods = ReflectableAnalyzer.GetBaseComponentType(this.Reflectable, this.extLoader).getMethods()) {
            String name;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Checking method " + m.toString());
            }
            if (!Modifier.isPublic(m.getModifiers())) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Method is not public");
                continue;
            }
            if (Modifier.isStatic(m.getModifiers())) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Method is static");
                continue;
            }
            if (Modifier.isAbstract(m.getModifiers())) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Method is abstract");
                continue;
            }
            if (m.getName().toUpperCase().startsWith("get".toUpperCase())) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "method is getter");
                }
                if ((name = m.getName().substring("get".length())).length() == 0) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "no name could be retrieved");
                    continue;
                }
                if (m.getParameterTypes().length != 0) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "not empty parameter list");
                    continue;
                }
                if (m.getReturnType().getName().equals("void")) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "void return value");
                    continue;
                }
                getters.put(name, m.getReturnType());
            }
            if (!m.getName().toUpperCase().startsWith("set".toUpperCase())) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "method is setter");
            }
            if ((name = m.getName().substring("set".length())).length() == 0) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "no name could be retrieved");
                continue;
            }
            if (m.getParameterTypes().length != 1) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "not single parameter");
                continue;
            }
            if (!m.getReturnType().getName().equals("void")) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "non void return value");
                continue;
            }
            setters.put(name, m.getParameterTypes()[0]);
        }
        if (getters.size() == 0 || setters.size() == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "setters or getters are empty");
            }
            return false;
        }
        for (Map.Entry entry : getters.entrySet()) {
            if (!setters.containsKey(entry.getKey())) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "no respective setter for getter " + (String)entry.getKey() + " found");
                continue;
            }
            if (!((Class)entry.getValue()).getName().equals(((Class)setters.get(entry.getKey())).getName())) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "mathcing getter (" + ((Class)entry.getValue()).getName() + ") and setter (" + ((Class)setters.get(entry.getKey())).getName() + ") have incompatible types");
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "mathcing getter (" + ((Class)entry.getValue()).getName() + ") and setter (" + ((Class)setters.get(entry.getKey())).getName() + ") found");
            }
            paired.put(entry.getKey(), entry.getValue());
        }
        if (paired.size() == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No matched found");
            }
            return false;
        }
        HashSet toDel = new HashSet();
        for (Map.Entry entry : paired.entrySet()) {
            IDataType.DataTypes prim = this.IsPrimitive(ReflectableAnalyzer.GetBaseComponentType((Class)entry.getValue(), this.extLoader));
            if (prim != null) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "getter seter for " + (String)entry.getKey() + " has valid primitive component type " + prim.toString());
                continue;
            }
            Class<?> nonPrimCompType = ReflectableAnalyzer.GetBaseComponentType((Class)entry.getValue(), this.extLoader);
            if (this.UnderInvestigation.contains(nonPrimCompType.getName())) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "Possible self referencing in decleration. Not a reflectable");
                }
                toDel.add(entry.getKey());
                continue;
            }
            ReflectableAnalyzer suban = new ReflectableAnalyzer(nonPrimCompType, this.UnderInvestigation, this.extLoader);
            if (suban.CanRepresentAsReflectable()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "getter seter for " + (String)entry.getKey() + " has valid non primitive component type " + nonPrimCompType.getName());
                }
                this.UnderInvestigation.remove(nonPrimCompType.getName());
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "getter seter for " + (String)entry.getKey() + " has non valid component type " + nonPrimCompType.getName());
            }
            this.UnderInvestigation.remove(nonPrimCompType.getName());
            toDel.add(entry.getKey());
        }
        for (String entry : toDel) {
            paired.remove(entry);
        }
        if (paired.size() == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No getter setter left");
            }
            return false;
        }
        return true;
    }

    private Class<?> GetBasePrimitiveClassOfArray(Class<?> Array2) {
        Class<Object> ret = null;
        if (!Array2.isArray()) {
            ret = Array2;
        }
        int index = Array2.getName().lastIndexOf("[");
        String com = Array2.getName().substring(index + 1);
        if (com.startsWith("L")) {
            com = com.substring(1);
        }
        if (com.endsWith(";")) {
            com = com.substring(0, com.length() - 1);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "after string manipulation will check type of " + com);
        }
        if (com.equals("Z")) {
            ret = Boolean.TYPE;
        } else if (com.equals("I")) {
            ret = Integer.TYPE;
        } else if (com.equals("F")) {
            ret = Float.TYPE;
        } else if (com.equals("D")) {
            ret = Double.TYPE;
        } else if (com.equals(String.class.getName())) {
            ret = String.class;
        } else if (com.equals(Boolean.class.getName())) {
            ret = Boolean.class;
        } else if (com.equals(Double.class.getName())) {
            ret = Double.class;
        } else if (com.equals(Float.class.getName())) {
            ret = Float.class;
        } else if (com.equals(Integer.class.getName())) {
            ret = Integer.class;
        } else if (com.equals(URI.class.getName())) {
            ret = URI.class;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Base primitive Component of " + Array2.getName() + " is " + (ret == null ? "null" : ret.getName()));
        }
        return ret;
    }

    private IDataType.DataTypes IsDirectPrimitive(Class<?> componentType) {
        IDataType.DataTypes ret = null;
        if (componentType == null) {
            ret = null;
        } else if (componentType.getName().equals(Integer.TYPE.getName())) {
            ret = IDataType.DataTypes.IntegerPrimitive;
        } else if (componentType.getName().equals(Float.TYPE.getName())) {
            ret = IDataType.DataTypes.FloatPrimitive;
        } else if (componentType.getName().equals(Boolean.TYPE.getName())) {
            ret = IDataType.DataTypes.BooleanPrimitive;
        } else if (componentType.getName().equals(Double.TYPE.getName())) {
            ret = IDataType.DataTypes.DoublePrimitive;
        } else if (componentType.getName().equals(Integer.class.getName())) {
            ret = IDataType.DataTypes.IntegerClass;
        } else if (componentType.getName().equals(Float.class.getName())) {
            ret = IDataType.DataTypes.FloatClass;
        } else if (componentType.getName().equals(Boolean.class.getName())) {
            ret = IDataType.DataTypes.BooleanClass;
        } else if (componentType.getName().equals(Double.class.getName())) {
            ret = IDataType.DataTypes.DoubleClass;
        } else if (componentType.getName().equals(String.class.getName())) {
            ret = IDataType.DataTypes.String;
        } else if (componentType.getName().equals(URI.class.getName())) {
            ret = IDataType.DataTypes.ResultSet;
        } else if (componentType.isArray()) {
            ret = this.IsDirectPrimitive(componentType.getComponentType());
        }
        return ret;
    }

    private IDataType.DataTypes IsPrimitive(Class<?> componentType) {
        IDataType.DataTypes ret = null;
        if (componentType == null) {
            ret = null;
        } else if (componentType.getName().equals(Integer.TYPE.getName())) {
            ret = IDataType.DataTypes.IntegerPrimitive;
        } else if (componentType.getName().equals(Float.TYPE.getName())) {
            ret = IDataType.DataTypes.FloatPrimitive;
        } else if (componentType.getName().equals(Boolean.TYPE.getName())) {
            ret = IDataType.DataTypes.BooleanPrimitive;
        } else if (componentType.getName().equals(Double.TYPE.getName())) {
            ret = IDataType.DataTypes.DoublePrimitive;
        } else if (componentType.getName().equals(Integer.class.getName())) {
            ret = IDataType.DataTypes.IntegerClass;
        } else if (componentType.getName().equals(Float.class.getName())) {
            ret = IDataType.DataTypes.FloatClass;
        } else if (componentType.getName().equals(Boolean.class.getName())) {
            ret = IDataType.DataTypes.BooleanClass;
        } else if (componentType.getName().equals(Double.class.getName())) {
            ret = IDataType.DataTypes.DoubleClass;
        } else if (componentType.getName().equals(String.class.getName())) {
            ret = IDataType.DataTypes.String;
        } else if (componentType.getName().equals(URI.class.getName())) {
            ret = IDataType.DataTypes.ResultSet;
        } else if (componentType.isArray()) {
            ret = this.IsPrimitive(ReflectableAnalyzer.GetBaseComponentType(componentType, this.extLoader));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Base Component of " + componentType.getName() + " is " + (Object)((Object)ret));
        }
        return ret;
    }

    public static Class<?> GetBaseComponentType(Class<?> Array2, IExternalClassLoader extLoader) {
        Class<Object> ret = null;
        if (!Array2.isArray()) {
            ret = Array2;
        }
        int index = Array2.getName().lastIndexOf("[");
        String com = Array2.getName().substring(index + 1);
        if (com.startsWith("L")) {
            com = com.substring(1);
        }
        if (com.endsWith(";")) {
            com = com.substring(0, com.length() - 1);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "after string manipulation will check type of " + com);
        }
        if (com.equals("Z")) {
            ret = Boolean.TYPE;
        } else if (com.equals("I")) {
            ret = Integer.TYPE;
        } else if (com.equals("F")) {
            ret = Float.TYPE;
        } else if (com.equals("D")) {
            ret = Double.TYPE;
        } else if (com.equals(String.class.getName())) {
            ret = String.class;
        } else if (com.equals(Boolean.class.getName())) {
            ret = Boolean.class;
        } else if (com.equals(Double.class.getName())) {
            ret = Double.class;
        } else if (com.equals(Float.class.getName())) {
            ret = Float.class;
        } else if (com.equals(Integer.class.getName())) {
            ret = Integer.class;
        } else if (com.equals(URI.class.getName())) {
            ret = URI.class;
        }
        if (ret == null) {
            try {
                ret = Class.forName(com);
            }
            catch (Exception ex) {
                if (extLoader != null) {
                    try {
                        ret = extLoader.FindClass(com);
                    }
                    catch (Exception exx) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Error retrieving class " + com, exx);
                        }
                        ret = null;
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Error retrieving class " + com, ex);
                }
                ret = null;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Base Component of " + Array2.getName() + " is " + (ret == null ? "null" : ret.getName()));
        }
        return ret;
    }
}

