/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.invocable.ws;

import gr.uoa.di.madgik.commons.channel.nozzle.INozzleConfig;
import gr.uoa.di.madgik.commons.channel.nozzle.NozzleConfigUtils;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.plan.element.invocable.ExecutionContextConfigBase;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSExecutionContextConfig
extends ExecutionContextConfigBase {
    public INozzleConfig NozzleConfig = null;

    @Override
    public ExecutionContextConfigBase.ContextConfigType GetContextConfigType() {
        return ExecutionContextConfigBase.ContextConfigType.WS;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("<contextConfig type=\"" + this.GetContextConfigType().toString() + "\" proxytype=\"" + this.ProxyType.toString() + "\" keepAlive=\"" + this.KeepContextAlive + "\"/>");
            if (this.NozzleConfig != null) {
                buf.append(this.NozzleConfig.ToXML());
            }
            buf.append("</contextConfig>");
            return buf.toString();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize element", ex);
        }
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            if (!ExecutionContextConfigBase.ContextConfigType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetContextConfigType())) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            if (!XMLUtils.AttributeExists((Element)XML, (String)"proxytype").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            if (!XMLUtils.AttributeExists((Element)XML, (String)"keepAlive").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            this.ProxyType = ExecutionContextConfigBase.ContextProxyType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"proxytype"));
            this.KeepContextAlive = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)XML, (String)"keepAlive"));
            Element nozzleconfigElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"nozzleConfig");
            this.NozzleConfig = nozzleconfigElement == null ? null : NozzleConfigUtils.GetNozzleConfig((Element)nozzleconfigElement);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }
}

