package gr.uoa.di.madgik.execution.engine;

/**
 * Configuration class defining the operation of the {@link ExecutionEngine}
 * 
 * @author gpapanikos
 */
public class ExecutionEngineConfig
{
	
	/** A constant value indicating infinite plans acceptable by the engine. */
	public static final int InfinitePlans=0;
	
	/** The Maximum number of plans. */
	private int MaximumNumberOfPlans=ExecutionEngineConfig.InfinitePlans;
	
	/**
	 * Instantiates a new execution engine config.
	 * 
	 * @param MaximumNumberOfPlans the maximum number of plans
	 */
	public ExecutionEngineConfig( int MaximumNumberOfPlans)
	{
		if(MaximumNumberOfPlans<=0) this.MaximumNumberOfPlans=ExecutionEngineConfig.InfinitePlans;
		else this.MaximumNumberOfPlans=MaximumNumberOfPlans;
	}
	
	/**
	 * Gets the maximum number of plans.
	 * 
	 * @return the maximum number of plans.
	 */
	public int GetMaximumNumberOfPlans()
	{
		return this.MaximumNumberOfPlans;
	}
}
