/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.invocable.ws;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.invocable.ArgumentBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.CallBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSRESTArgument;
import gr.uoa.di.madgik.execution.plan.element.variable.IOutputParameter;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSRESTCall
extends CallBase {
    public String ExecutionContextToken = null;

    @Override
    public CallBase.CallType GetCallType() {
        return CallBase.CallType.WSREST;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        for (ArgumentBase arg : this.ArgumentList) {
            if (arg instanceof WSRESTArgument) continue;
            throw new ExecutionValidationException("Supplied argument type is not one of the supported ones");
        }
        super.Validate();
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        if (this.OutputParameter != null) {
            this.OutputParameter.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        }
        for (ArgumentBase arg : this.ArgumentList) {
            arg.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        }
        super.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<call type=\"" + this.GetCallType().toString() + "\" order=\"" + this.Order + "\">");
        if (this.ExecutionContextToken != null) {
            buf.append("<executionContextToken>" + this.ExecutionContextToken + "</executionContextToken>");
        }
        buf.append("<methodName value=\"" + this.MethodName + "\"/>");
        buf.append("<arguments>");
        for (ArgumentBase a : this.ArgumentList) {
            buf.append(a.ToXML());
        }
        buf.append("</arguments>");
        buf.append("<output>");
        if (this.OutputParameter != null) {
            buf.append(this.OutputParameter.ToXML());
        }
        buf.append("</output>");
        buf.append("</call>");
        return buf.toString();
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element modnode;
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            Element tokenelem = XMLUtils.GetChildElementWithName((Node)((Element)XML), (String)"executionContextToken");
            if (tokenelem != null) {
                this.ExecutionContextToken = XMLUtils.GetChildText((Node)tokenelem);
            }
            if ((modnode = XMLUtils.GetChildElementWithName((Node)((Element)XML), (String)"methodName")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!XMLUtils.AttributeExists((Element)modnode, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.MethodName = XMLUtils.GetAttribute((Element)modnode, (String)"value");
            Element argsnode = XMLUtils.GetChildElementWithName((Node)((Element)XML), (String)"arguments");
            if (argsnode == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.ArgumentList.clear();
            List args = XMLUtils.GetChildElementsWithName((Node)argsnode, (String)"argument");
            for (Element arg : args) {
                this.ArgumentList.add(PlanElementUtils.GetArgument(arg));
            }
            Element outputelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"output");
            if (outputelement == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element outparam = XMLUtils.GetChildElementWithName((Node)outputelement, (String)"param");
            this.OutputParameter = outparam == null ? null : (IOutputParameter)ParameterUtils.GetParameter(outparam);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }
}

