/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeArray;
import gr.uoa.di.madgik.execution.datatype.DataTypeReflectable;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.datatype.ReflectableItem;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterDecomposeFilter
extends ParameterFilterBase {
    public String FilteredVariableName = null;
    public List<String> OutputVariableNames = new ArrayList<String>();

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.Decompose;
    }

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.FilteredVariableName);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.OutputVariableNames);
        return vars;
    }

    @Override
    public boolean StoreOutput() {
        return false;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableName == null || this.FilteredVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.OutputVariableNames == null || this.OutputVariableNames.size() == 0) {
            throw new ExecutionValidationException("Output parameter names cannot be empty or null");
        }
        this.TokenMappingValidate();
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (ndt.Value.GetDataTypeEnum() != IDataType.DataTypes.Array && ndt.Value.GetDataTypeEnum() != IDataType.DataTypes.Reflectable || ndt.Value.GetDataTypeEnum() == IDataType.DataTypes.Array && DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)ndt.Value).GetArrayClassCode()) != IDataType.DataTypes.Reflectable) {
            throw new ExecutionValidationException("Filtered variable is not of type reflectable or array of reflectables");
        }
        for (String storeVarName : this.GetStoreOutputVariableName()) {
            if (Handle.GetPlan().Variables.Contains(storeVarName)) continue;
            throw new ExecutionValidationException("Needed parameter to store output not present");
        }
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return false;
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            HashSet<String> InterestingTokens = new HashSet<String>();
            for (String s : this.OutputVariableNames) {
                InterestingTokens.add(this.GetToken(Handle.GetPlan().Variables.Get((String)s).Token));
            }
            NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
            if (ndt.Value.GetDataTypeEnum() == IDataType.DataTypes.Reflectable) {
                Map<String, IDataType> extracted = this.Process((DataTypeReflectable)ndt.Value, InterestingTokens);
                for (String s : this.OutputVariableNames) {
                    NamedDataType ndtOut = Handle.GetPlan().Variables.Get(s);
                    if (!extracted.containsKey(this.GetToken(ndtOut.Token)) || !ndtOut.Value.GetDataTypeEnum().equals((Object)extracted.get(this.GetToken(ndtOut.Token)).GetDataTypeEnum())) continue;
                    Handle.GetPlan().Variables.Update(ndtOut.Name, extracted.get(this.GetToken(ndtOut.Token)).GetValue());
                }
            } else if (ndt.Value.GetDataTypeEnum() == IDataType.DataTypes.Array && DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)ndt.Value).GetArrayClassCode()) == IDataType.DataTypes.Reflectable) {
                HashMap tmpHolder = new HashMap();
                for (String s : this.OutputVariableNames) {
                    NamedDataType ndtOut = Handle.GetPlan().Variables.Get(s);
                    tmpHolder.put(this.GetToken(ndtOut.Token), new ArrayList());
                }
                for (IDataType arrItem : ((DataTypeArray)ndt.Value).GetItems()) {
                    if (arrItem.GetDataTypeEnum() != IDataType.DataTypes.Reflectable) {
                        throw new ExecutionRunTimeException("Filtered variable is not of the expected type");
                    }
                    Map<String, IDataType> extracted = this.Process((DataTypeReflectable)arrItem, InterestingTokens);
                    for (String s : this.OutputVariableNames) {
                        NamedDataType ndtOut = Handle.GetPlan().Variables.Get(s);
                        if (!extracted.containsKey(this.GetToken(ndtOut.Token))) continue;
                        IDataType extr = extracted.get(this.GetToken(ndtOut.Token));
                        if (!tmpHolder.containsKey(this.GetToken(ndtOut.Token))) continue;
                        ((List)tmpHolder.get(this.GetToken(ndtOut.Token))).add(extr);
                    }
                }
                for (String s : this.OutputVariableNames) {
                    NamedDataType ndtOut = Handle.GetPlan().Variables.Get(s);
                    List vals = (List)tmpHolder.get(this.GetToken(ndtOut.Token));
                    if (vals.size() == 0) continue;
                    if (ndtOut.Value.GetDataTypeEnum() != IDataType.DataTypes.Array && ndtOut.Value.GetDataTypeEnum().equals((Object)((IDataType)vals.get(0)).GetDataTypeEnum())) {
                        Handle.GetPlan().Variables.Update(ndtOut.Name, ((IDataType)vals.get(0)).GetValue());
                        continue;
                    }
                    if (ndtOut.Value.GetDataTypeEnum() != IDataType.DataTypes.Array || !DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)ndtOut.Value).GetArrayClassCode()).equals((Object)((IDataType)vals.get(0)).GetDataTypeEnum())) continue;
                    Handle.GetPlan().Variables.Update(ndtOut.Name, vals.toArray(new IDataType[0]));
                }
            } else {
                throw new ExecutionRunTimeException("Filtered variable is not of the expected type");
            }
            return null;
        }
        catch (ExecutionValidationException ex) {
            throw new ExecutionRunTimeException("Could not extract value", ex);
        }
    }

    private Map<String, IDataType> Process(DataTypeReflectable reflectable, Set<String> InterestingTokens) {
        HashMap<String, IDataType> extracted = new HashMap<String, IDataType>();
        for (ReflectableItem item : reflectable.GetItems()) {
            if (!InterestingTokens.contains(this.GetToken(item.Token))) continue;
            extracted.put(this.GetToken(item.Token), item.Value);
        }
        return extracted;
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\">");
        if (this.FilteredVariableName == null) {
            buf.append("<filteredVariable/>");
        } else {
            buf.append("<filteredVariable>" + this.FilteredVariableName + "</filteredVariable>");
        }
        buf.append("<outputList>");
        for (String s : this.OutputVariableNames) {
            buf.append("<outputVariable name=\"" + s + "\"/>");
        }
        buf.append("</outputList>");
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            Element tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable");
            if (tmp == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableName = XMLUtils.GetChildText((Node)tmp);
            tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"outputList");
            if (tmp == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            List outvars = XMLUtils.GetChildElementsWithName((Node)tmp, (String)"outputVariable");
            if (outvars == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.OutputVariableNames.clear();
            for (Element outvar : outvars) {
                if (!XMLUtils.AttributeExists((Element)outvar, (String)"name").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.OutputVariableNames.add(XMLUtils.GetAttribute((Element)outvar, (String)"name"));
            }
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }
}

