/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.invocable.ws;

import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.invocable.ExecutionContextConfigBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.NozzleHandler;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSExecutionContextConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSRESTCall;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSRESTSimpleProxy;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRESTProxyWrapper {
    private static Logger logger = LoggerFactory.getLogger(WSRESTProxyWrapper.class);
    private URL ServiceEndPoint = null;
    private ExecutionHandle Handle;
    private boolean SupportsExecutionContext;
    private ExecutionContextConfigBase SuppliedContextProxy;
    private String ID = null;

    public WSRESTProxyWrapper(ExecutionHandle Handle, String ID, URL ServiceEndPoint, boolean SupportsExecutionContext, ExecutionContextConfigBase SuppliedContextProxy) {
        this.ServiceEndPoint = ServiceEndPoint;
        this.Handle = Handle;
        this.SupportsExecutionContext = SupportsExecutionContext;
        this.SuppliedContextProxy = SuppliedContextProxy;
        this.ID = ID;
    }

    private boolean IsKeepContextAlive() {
        return this.SupportsExecutionContext && this.SuppliedContextProxy != null && this.SuppliedContextProxy.KeepContextAlive;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Invoke(WSRESTCall methodCall, ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionValidationException, ExecutionInternalErrorException, ExecutionSerializationException {
        boolean bl;
        StringBuilder stringBuilder;
        NozzleHandler handler = null;
        boolean successfullyCompletedInvokation = false;
        try {
            methodCall.EvaluateArguments(Handle);
            WSRESTSimpleProxy proxyWS = new WSRESTSimpleProxy();
            IChannelLocator locator = null;
            WSExecutionContextConfig conf = null;
            boolean provideContext = false;
            if (this.SupportsExecutionContext && this.SuppliedContextProxy != null && this.SuppliedContextProxy instanceof WSExecutionContextConfig) {
                provideContext = true;
                if (((WSExecutionContextConfig)this.SuppliedContextProxy).NozzleConfig != null) {
                    handler = new NozzleHandler();
                    locator = handler.CreateInletNozzle(((WSExecutionContextConfig)this.SuppliedContextProxy).NozzleConfig, this.Handle);
                }
                conf = (WSExecutionContextConfig)this.SuppliedContextProxy;
            }
            Object ret = proxyWS.Invoke(this.ServiceEndPoint, methodCall, provideContext, locator, this.ID, conf, Handle);
            if (methodCall.OutputParameter != null) {
                methodCall.OutputParameter.SetParameterValue(Handle, ret);
            }
            successfullyCompletedInvokation = true;
            stringBuilder = new StringBuilder().append("Cleaning up plugin with null handler (");
            bl = handler == null;
        }
        catch (ExecutionRunTimeException ex) {
            try {
                throw ex;
                catch (ExecutionValidationException ex2) {
                    throw ex2;
                }
                catch (ExecutionInternalErrorException ex3) {
                    throw ex3;
                }
                catch (ExecutionSerializationException ex4) {
                    throw ex4;
                }
            }
            catch (Throwable throwable) {
                logger.debug("Cleaning up plugin with null handler (" + (handler == null) + ") and keep context alive (" + this.IsKeepContextAlive() + ")");
                if (handler == null) throw throwable;
                if (!successfullyCompletedInvokation) {
                    handler.Dispose();
                    throw throwable;
                }
                if (this.IsKeepContextAlive()) {
                    this.Handle.AddContextHandler(handler);
                    throw throwable;
                }
                handler.Dispose();
                throw throwable;
            }
        }
        logger.debug(stringBuilder.append(bl).append(") and keep context alive (").append(this.IsKeepContextAlive()).append(")").toString());
        if (handler == null) return;
        if (!successfullyCompletedInvokation) {
            handler.Dispose();
            return;
        }
        if (this.IsKeepContextAlive()) {
            this.Handle.AddContextHandler(handler);
            return;
        }
        handler.Dispose();
    }
}

