/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.invocable.CheckpointConfig;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IOutputParameter;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import gr.uoa.di.madgik.grs.proxy.local.LocalStoreWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreWriterProxy;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CheckpointPlanElement
extends PlanElementBase {
    private static final Logger logger = LoggerFactory.getLogger(CheckpointPlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = CheckpointPlanElement.class.getSimpleName();
    public List<ContingencyTrigger> Triggers = new ArrayList<ContingencyTrigger>();
    public List<IInputParameter> Inputs = new ArrayList<IInputParameter>();
    public IOutputParameter Output = null;
    public CheckpointConfig Config = new CheckpointConfig();

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            Element outelement;
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element cont = XMLUtils.GetChildElementWithName((Node)XML, (String)"triggers");
            this.Triggers.clear();
            if (cont != null) {
                List trigs = XMLUtils.GetChildElementsWithName((Node)cont, (String)"contingency");
                for (Element trig : trigs) {
                    ContingencyTrigger t = new ContingencyTrigger();
                    t.FromXML(trig);
                    this.Triggers.add(t);
                }
            }
            if ((outelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"output")) == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            Element parelem = XMLUtils.GetChildElementWithName((Node)outelement, (String)"param");
            if (parelem == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            this.Output = (IOutputParameter)ParameterUtils.GetParameter(parelem);
            Element inselement = XMLUtils.GetChildElementWithName((Node)XML, (String)"inputs");
            if (inselement == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            List inputsparamselement = XMLUtils.GetChildElementsWithName((Node)inselement, (String)"param");
            for (Element inpar : inputsparamselement) {
                IInputParameter partmp = (IInputParameter)ParameterUtils.GetParameter(inpar);
                this.Inputs.add(partmp);
            }
            Element checkpointConfigElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"checkpointConfig");
            if (checkpointConfigElement == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Config = new CheckpointConfig();
            this.Config.FromXML(checkpointConfigElement);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Checkpoint;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<triggers>");
        for (ContingencyTrigger trig : this.Triggers) {
            buf.append(trig.ToXML());
        }
        buf.append("</triggers>");
        buf.append("<output>");
        buf.append(this.Output.ToXML());
        buf.append("</output>");
        buf.append("<inputs>");
        for (IInputParameter par : this.Inputs) {
            buf.append(par.ToXML());
        }
        buf.append("</inputs>");
        buf.append(this.Config.ToXML());
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Inputs == null || this.Inputs.size() == 0) {
            throw new ExecutionValidationException("Input list cannot be empty");
        }
        if (this.Output == null) {
            throw new ExecutionValidationException("Output parameter not defined");
        }
        for (IInputParameter par : this.Inputs) {
            par.Validate();
        }
        this.Output.Validate();
        this.Config.Validate();
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[]{IContingencyReaction.ReactionType.None, IContingencyReaction.ReactionType.Retry};
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return true;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return this.Triggers;
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Output.GetNeededVariableNames());
        for (IInputParameter par : this.Inputs) {
            vars.addAll(par.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Output.GetModifiedVariableNames());
        for (IInputParameter par : this.Inputs) {
            vars.addAll(par.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionCancelException, ExecutionInternalErrorException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int port = -1;
        String hostname = "Unknown";
        try {
            if (Handle.getHostingNodeInfo() != null) {
                String[] params = Handle.getHostingNodeInfo().split(":");
                hostname = params[0];
                if (params[1].compareTo("null") != 0) {
                    port = Integer.parseInt(params[1]);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error occurred!", (Throwable)e);
        }
        logger.debug("Starting");
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, 2, "Starting Execution of " + this.Name, this.Name, hostname, port));
        }
        try {
            List<URI> locators = this.RetrieveInputs(Handle);
            this.StopClock(PlanElementBase.ClockType.Init);
            this.StartClock(PlanElementBase.ClockType.Children);
            URI storeLocator = null;
            switch (this.Config.TypeOfProxy) {
                case LocalStore: {
                    storeLocator = LocalStoreWriterProxy.store((URI[])locators.toArray(new URI[0]), (IBufferStore.MultiplexType)this.Config.TypeOfMultiplex, (long)this.Config.TimeoutValue, (TimeUnit)this.Config.TimeoutUnit);
                    break;
                }
                case TCPStore: {
                    storeLocator = TCPStoreWriterProxy.store((URI[])locators.toArray(new URI[0]), (IBufferStore.MultiplexType)this.Config.TypeOfMultiplex, (long)this.Config.TimeoutValue, (TimeUnit)this.Config.TimeoutUnit);
                    break;
                }
                default: {
                    throw new ExecutionRunTimeException("Only Local and TCP Store proxies supported");
                }
            }
            this.StopClock(PlanElementBase.ClockType.Children);
            this.StartClock(PlanElementBase.ClockType.Finilization);
            logger.debug("Storing Output of checkpoint operation " + storeLocator);
            this.Output.SetParameterValue(Handle, storeLocator);
            this.StopClock(PlanElementBase.ClockType.Finilization);
        }
        catch (Exception ex) {
            ExceptionUtils.ThrowTransformedException(ex);
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 2, "Finishing Execution of " + this.Name, this.Name, hostname, port));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    private List<URI> RetrieveInputs(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionValidationException {
        ArrayList<URI> inputs = new ArrayList<URI>();
        for (IInputParameter input : this.Inputs) {
            Object in = input.GetParameterValue(Handle);
            if (!(in instanceof URI)) {
                throw new ExecutionValidationException("Provided input not instance of required locator interface");
            }
            inputs.add((URI)in);
        }
        return inputs;
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        Set<String> ExcludeAvailableConstraint = this.GetModifiedVariableNames();
        for (IInputParameter par : this.Inputs) {
            par.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        }
        this.Output.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
    }
}

