/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.invocable.CallBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.ExecutionContextConfigBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.simple.ClassReflectionWrapper;
import gr.uoa.di.madgik.execution.plan.element.invocable.simple.SimpleExecutionContextConfig;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PojoPlanElement
extends PlanElementBase {
    private static Logger logger = LoggerFactory.getLogger(PojoPlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = PojoPlanElement.class.getSimpleName();
    public List<ContingencyTrigger> Triggers = new ArrayList<ContingencyTrigger>();
    public List<CallBase> Calls = new ArrayList<CallBase>();
    public String ClassName = null;
    public boolean SupportsExecutionContext = false;
    public ExecutionContextConfigBase ExecutionContextConfig = null;

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            Element cname;
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element cont = XMLUtils.GetChildElementWithName((Node)XML, (String)"triggers");
            this.Triggers.clear();
            if (cont != null) {
                List trigs = XMLUtils.GetChildElementsWithName((Node)cont, (String)"contingency");
                for (Element trig : trigs) {
                    ContingencyTrigger t = new ContingencyTrigger();
                    t.FromXML(trig);
                    this.Triggers.add(t);
                }
            }
            if ((cname = XMLUtils.GetChildElementWithName((Node)XML, (String)"className")) == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            if (!XMLUtils.AttributeExists((Element)cname, (String)"value").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            this.ClassName = XMLUtils.GetAttribute((Element)cname, (String)"value");
            Element callselem = XMLUtils.GetChildElementWithName((Node)XML, (String)"calls");
            if (callselem == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            List calls = XMLUtils.GetChildElementsWithName((Node)callselem, (String)"call");
            this.Calls.clear();
            for (Element c : calls) {
                this.Calls.add(PlanElementUtils.GetCall(c));
            }
            Element supExecCntxtElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"context");
            if (supExecCntxtElement == null) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            if (!XMLUtils.AttributeExists((Element)supExecCntxtElement, (String)"supported").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization not valid");
            }
            this.SupportsExecutionContext = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)supExecCntxtElement, (String)"supported"));
            Element execProxyElement = XMLUtils.GetChildElementWithName((Node)supExecCntxtElement, (String)"contextConfig");
            this.ExecutionContextConfig = execProxyElement == null ? null : PlanElementUtils.GetExecutionContextConfig(execProxyElement);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.POJO;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        acts.add(this);
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<triggers>");
        for (ContingencyTrigger trig : this.Triggers) {
            buf.append(trig.ToXML());
        }
        buf.append("</triggers>");
        buf.append("<className value=\"" + this.ClassName + "\"/>");
        buf.append("<calls>");
        for (CallBase c : this.Calls) {
            buf.append(c.ToXML());
        }
        buf.append("</calls>");
        buf.append("<context supported=\"" + this.SupportsExecutionContext + "\">");
        if (this.ExecutionContextConfig != null) {
            buf.append(this.ExecutionContextConfig.ToXML());
        }
        buf.append("</context>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.ClassName == null || this.ClassName.trim().length() == 0) {
            throw new ExecutionValidationException("Class name not provided");
        }
        if (this.Calls == null || this.Calls.size() == 0) {
            throw new ExecutionValidationException("No calls specified");
        }
        for (CallBase c : this.Calls) {
            c.Validate();
        }
        if (this.SupportsExecutionContext && this.ExecutionContextConfig == null) {
            throw new ExecutionValidationException("Declare support for context but not config provided");
        }
        if (this.ExecutionContextConfig != null) {
            if (!(this.ExecutionContextConfig instanceof SimpleExecutionContextConfig)) {
                throw new ExecutionValidationException("Execution context supported by this element must be of type " + ExecutionContextConfigBase.ContextConfigType.Simple.toString());
            }
            this.ExecutionContextConfig.Validate();
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        Set<String> ExcludeAvailableConstraint = this.GetModifiedVariableNames();
        for (CallBase c : this.Calls) {
            c.ValidatePreExecution(Handle, ExcludeAvailableConstraint);
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[]{IContingencyReaction.ReactionType.None, IContingencyReaction.ReactionType.Retry};
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return true;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return this.Triggers;
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (CallBase c : this.Calls) {
            vars.addAll(c.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (CallBase c : this.Calls) {
            vars.addAll(c.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionCancelException, ExecutionInternalErrorException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int port = -1;
        String hostname = "Unknown";
        try {
            if (Handle.getHostingNodeInfo() != null) {
                String[] params = Handle.getHostingNodeInfo().split(":");
                hostname = params[0];
                if (params[1].compareTo("null") != 0) {
                    port = Integer.parseInt(params[1]);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error occurred!", (Throwable)e);
        }
        int TotalSteps = 0;
        try {
            this.RegisterToRunningActionElementsRestriction(Handle);
            int CurrentStep = 1;
            TotalSteps = 2 + this.Calls.size();
            logger.debug("Starting");
            this.CheckStatus(Handle);
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, TotalSteps, "Starting Execution of " + this.Name, this.Name, hostname, port));
            }
            ++CurrentStep;
            Collections.sort(this.Calls);
            ClassReflectionWrapper wrapper = new ClassReflectionWrapper(this.ClassName, Handle, this.GetID(), this.SupportsExecutionContext, this.ExecutionContextConfig);
            this.StopClock(PlanElementBase.ClockType.Init);
            this.StartClock(PlanElementBase.ClockType.Children);
            for (CallBase c : this.Calls) {
                this.StartClock(PlanElementBase.ClockType.Call);
                if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                    Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), CurrentStep, TotalSteps, "Invoking Method " + c.MethodName));
                }
                ++CurrentStep;
                if (c.MethodName.equals(this.ClassName)) {
                    wrapper.Instantiate(c);
                } else {
                    wrapper.Invoke(c);
                }
                this.StopClock(PlanElementBase.ClockType.Call);
            }
            this.StopClock(PlanElementBase.ClockType.Children);
        }
        catch (Exception ex) {
            ExceptionUtils.ThrowTransformedException(ex);
        }
        finally {
            this.StartClock(PlanElementBase.ClockType.Finilization);
            this.UnregisterToRunningActionElementsRestriction(Handle);
            this.StopClock(PlanElementBase.ClockType.Finilization);
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), TotalSteps, TotalSteps, "Finishing Execution of " + this.Name, this.Name, hostname, port));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }
}

