/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.DataTypeArray;
import gr.uoa.di.madgik.execution.datatype.DataTypeReflectable;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.datatype.ReflectableItem;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterComposeFilter
extends ParameterFilterBase {
    public boolean StoreOutput = false;
    public String StoreOutputVariableName = null;
    public List<String> FilteredVariableNames = new ArrayList<String>();
    public boolean PromoteArray = false;

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.Compose;
    }

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.FilteredVariableNames);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        if (this.StoreOutputVariableName != null) {
            vars.add(this.StoreOutputVariableName);
        }
        return vars;
    }

    @Override
    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableNames == null || this.FilteredVariableNames.size() == 0) {
            throw new ExecutionValidationException("Filtered parameter names cannot be empty or null");
        }
        if (this.StoreOutput && (this.StoreOutputVariableName == null || this.StoreOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("Needed parameter is not provided");
        }
        this.TokenMappingValidate();
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        NamedDataType ndt;
        this.Validate();
        for (String s : this.FilteredVariableNames) {
            if (!Handle.GetPlan().Variables.Contains(s)) {
                throw new ExecutionValidationException("Needed parameter not found");
            }
            ndt = Handle.GetPlan().Variables.Get(s);
            if (ndt.IsAvailable.booleanValue() || ExcludeAvailableConstraint.contains(s)) continue;
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (this.StoreOutput()) {
            for (String storeVarName : this.GetStoreOutputVariableName()) {
                if (!Handle.GetPlan().Variables.Contains(storeVarName)) {
                    throw new ExecutionValidationException("Needed parameter to store output not present");
                }
                ndt = Handle.GetPlan().Variables.Get(storeVarName);
                if ((ndt.Value.GetDataTypeEnum() == IDataType.DataTypes.Array || ndt.Value.GetDataTypeEnum() == IDataType.DataTypes.Reflectable) && (ndt.Value.GetDataTypeEnum() != IDataType.DataTypes.Array || DataTypeUtils.GetComponentDataTypeOfArrayInitializingCode(((DataTypeArray)ndt.Value).GetArrayClassCode()) == IDataType.DataTypes.Reflectable)) continue;
                throw new ExecutionValidationException("Output variable is not of type reflectable or array of reflectables");
            }
        }
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return false;
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            Iterable<IDataType> dtOut = null;
            if (this.ShouldConstructArray(Handle)) {
                dtOut = new DataTypeArray();
                ((DataTypeArray)dtOut).SetArrayClassCode("[" + (Object)((Object)IDataType.DataTypes.Reflectable));
                int length = this.GetConstructedArrayLength(Handle);
                ArrayList<DataTypeReflectable> items = new ArrayList<DataTypeReflectable>();
                for (int i = 0; i < length; ++i) {
                    items.add(this.GetReflectable(Handle, i));
                }
                dtOut.SetValue(items.toArray(new IDataType[0]));
            } else {
                dtOut = this.GetReflectable(Handle, -1);
            }
            return dtOut.GetValue();
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not extract value", ex);
        }
    }

    private DataTypeReflectable GetReflectable(ExecutionHandle Handle, int index) throws ExecutionRunTimeException, ExecutionValidationException {
        DataTypeReflectable dtOut = new DataTypeReflectable();
        Map<String, IDataType> extracted = this.GetDataTypesOfIndex(Handle, index);
        ArrayList<ReflectableItem> items = new ArrayList<ReflectableItem>();
        for (Map.Entry<String, IDataType> entry : extracted.entrySet()) {
            ReflectableItem it = new ReflectableItem();
            it.Name = UUID.randomUUID().toString();
            it.Token = this.GetToken(entry.getKey());
            it.Value = entry.getValue();
            items.add(it);
        }
        dtOut.SetValue(items.toArray(new ReflectableItem[0]));
        return dtOut;
    }

    private Map<String, IDataType> GetDataTypesOfIndex(ExecutionHandle Handle, int index) throws ExecutionRunTimeException {
        HashMap<String, IDataType> vals = new HashMap<String, IDataType>();
        for (String s : this.FilteredVariableNames) {
            NamedDataType ndtin = Handle.GetPlan().Variables.Get(s);
            if (index >= 0 && ndtin.Value.GetDataTypeEnum() == IDataType.DataTypes.Array) {
                if (((DataTypeArray)ndtin.Value).GetItems().length <= index) {
                    throw new ExecutionRunTimeException("Index out of range");
                }
                vals.put(ndtin.Token, ((DataTypeArray)ndtin.Value).GetItems()[index]);
                continue;
            }
            vals.put(ndtin.Token, ndtin.Value);
        }
        return vals;
    }

    private boolean ShouldConstructArray(ExecutionHandle Handle) {
        if (!this.PromoteArray) {
            return false;
        }
        for (String s : this.FilteredVariableNames) {
            if (Handle.GetPlan().Variables.Get((String)s).Value.GetDataTypeEnum() != IDataType.DataTypes.Array) continue;
            return true;
        }
        return false;
    }

    private int GetConstructedArrayLength(ExecutionHandle Handle) {
        int MinLength = Integer.MAX_VALUE;
        for (String s : this.FilteredVariableNames) {
            NamedDataType ndtin = Handle.GetPlan().Variables.Get(s);
            if (ndtin.Value.GetDataTypeEnum() != IDataType.DataTypes.Array || ((DataTypeArray)ndtin.Value).GetItems().length >= MinLength) continue;
            MinLength = ((DataTypeArray)ndtin.Value).GetItems().length;
        }
        return MinLength;
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        String outputvarString = "";
        if (this.StoreOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.StoreOutputVariableName + "\"";
        }
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + " promoteArray=\"" + this.PromoteArray + "\">");
        buf.append("<filteredList>");
        for (String s : this.FilteredVariableNames) {
            buf.append("<filteredVariable name=\"" + s + "\"/>");
        }
        buf.append("</filteredList>");
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"promoteArray").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            this.PromoteArray = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"promoteArray"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.StoreOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if ((tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredList")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            List filteredvars = XMLUtils.GetChildElementsWithName((Node)tmp, (String)"filteredVariable");
            if (filteredvars == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableNames.clear();
            for (Element filtervar : filteredvars) {
                if (!XMLUtils.AttributeExists((Element)filtervar, (String)"name").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.FilteredVariableNames.add(XMLUtils.GetAttribute((Element)filtervar, (String)"name"));
            }
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }
}

