/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionCancelStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionCompletedStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionPerformanceReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionResumeStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReactionHandler;
import gr.uoa.di.madgik.execution.report.accounting.TaskAccountingDispatcher;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;

public abstract class PlanElementBase
implements IPlanElement,
Observer {
    private static final long serialVersionUID = 1L;
    private final Boolean Resume = new Boolean(false);
    private long startInit = 0L;
    private long sumInit = 0L;
    private long startFinilize = 0L;
    private long sumFinilize = 0L;
    private long startChildren = 0L;
    private long sumChildren = 0L;
    private long startTotal = 0L;
    private long sumTotal = 0L;
    private long startCall = 0L;
    private long sumCall = 0L;
    private int callCount = 0;

    protected void ResetClocks() {
        this.sumInit = 0L;
        this.sumFinilize = 0L;
        this.sumChildren = 0L;
        this.sumTotal = 0L;
        this.sumCall = 0L;
        this.callCount = 0;
    }

    protected void StartClock(ClockType Type2) {
        switch (Type2) {
            case Children: {
                this.startChildren = Calendar.getInstance().getTimeInMillis();
                break;
            }
            case Finilization: {
                this.startFinilize = Calendar.getInstance().getTimeInMillis();
                break;
            }
            case Init: {
                this.startInit = Calendar.getInstance().getTimeInMillis();
                break;
            }
            case Total: {
                this.startTotal = Calendar.getInstance().getTimeInMillis();
                break;
            }
            case Call: {
                this.startCall = Calendar.getInstance().getTimeInMillis();
            }
        }
    }

    protected void StopClock(ClockType Type2) {
        switch (Type2) {
            case Children: {
                this.sumChildren += Calendar.getInstance().getTimeInMillis() - this.startChildren;
                break;
            }
            case Finilization: {
                this.sumFinilize += Calendar.getInstance().getTimeInMillis() - this.startFinilize;
                break;
            }
            case Init: {
                this.sumInit += Calendar.getInstance().getTimeInMillis() - this.startInit;
                break;
            }
            case Total: {
                this.sumTotal += Calendar.getInstance().getTimeInMillis() - this.startTotal;
                break;
            }
            case Call: {
                this.sumCall += Calendar.getInstance().getTimeInMillis() - this.startCall;
                ++this.callCount;
            }
        }
    }

    protected ExecutionPerformanceReportStateEvent GetPerformanceEvent() {
        return new ExecutionPerformanceReportStateEvent(this.GetID(), this.sumTotal, this.sumInit, this.sumFinilize, this.sumChildren, this.callCount, this.sumCall);
    }

    @Override
    public void Execute(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        block9: {
            try {
                this.GetExtenderLogger().debug("Validating Plan Element");
                this.ValidatePreExecution(Handle);
                TaskAccountingDispatcher accounter = null;
                accounter = new TaskAccountingDispatcher(Handle);
                this.GetExtenderLogger().debug("Executing Plan Element");
                this.ExecuteWithStateAwareness(Handle);
                try {
                    accounter.commit();
                }
                catch (Exception e) {}
            }
            catch (Exception ex) {
                String causeString = "";
                if (ex instanceof ExecutionRunTimeException) {
                    causeString = " and cause " + ((ExecutionRunTimeException)ex).GetCauseFullName();
                }
                if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                    Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "Execution of element " + this.GetName() + " failed with error " + ex.getClass().getName() + "(" + ex.getMessage() + ")" + causeString + ". Checking for contingency plans"));
                }
                this.GetExtenderLogger().debug("Checking if triggers are supported");
                if (!this.SupportsContingencyTriggers()) {
                    ExceptionUtils.ThrowTransformedException(ex);
                }
                this.GetExtenderLogger().debug("Checking if triggers are defined");
                if (this.GetContingencyTriggers() == null || this.GetContingencyTriggers().size() == 0) {
                    ExceptionUtils.ThrowTransformedException(ex);
                }
                Map<String, String> supportedTriggers = this.GetSupportedContingencyReactionTypes();
                boolean handled = false;
                for (ContingencyTrigger trig : this.GetContingencyTriggers()) {
                    this.GetExtenderLogger().debug("Examining trigger " + trig.Reaction.GetReactionType().toString());
                    if (!supportedTriggers.containsKey(trig.Reaction.GetReactionType().toString())) continue;
                    this.GetExtenderLogger().debug("Checking if trigger can handle error");
                    if (!trig.CanHandleError(ex)) continue;
                    this.GetExtenderLogger().debug("Passing error to handler");
                    IContingencyReactionHandler ReactionHandler = trig.Reaction.GetReactionHandler();
                    ReactionHandler.Handle(this.GetID(), ex, Handle, this);
                    handled = true;
                }
                if (handled) break block9;
                ExceptionUtils.ThrowTransformedException(ex);
            }
        }
    }

    public void ExecuteWithStateAwareness(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        try {
            this.InitExecution(Handle);
            this.ExecuteExtender(Handle);
        }
        catch (Exception ex) {
            this.FinilizeExecution(Handle);
            ExceptionUtils.ThrowTransformedException(ex);
        }
    }

    protected abstract Logger GetExtenderLogger();

    protected abstract void ExecuteExtender(ExecutionHandle var1) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException;

    protected void CheckStatus(ExecutionHandle Handle) throws ExecutionCancelException, ExecutionInternalErrorException {
        while (!this.CheckExecutionStatus(Handle)) {
            this.WaitToResume();
        }
    }

    private Map<String, String> GetSupportedContingencyReactionTypes() {
        IContingencyReaction.ReactionType[] supportedTypes;
        HashMap<String, String> supportedTriggers = new HashMap<String, String>();
        for (IContingencyReaction.ReactionType rt : supportedTypes = this.SupportedContingencyTriggers()) {
            supportedTriggers.put(rt.toString(), null);
        }
        return supportedTriggers;
    }

    private void InitExecution(ExecutionHandle Handle) {
        this.RegisterToHandle(Handle);
    }

    private void FinilizeExecution(ExecutionHandle Handle) {
        this.UnregisterFromHandle(Handle);
    }

    private void RegisterToHandle(ExecutionHandle Handle) {
        ExecutionStateEvent ev = Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionResume);
        if (ev != null) {
            ev.addObserver(this);
        }
        if ((ev = Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionCancel)) != null) {
            ev.addObserver(this);
        }
        if ((ev = Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionCompleted)) != null) {
            ev.addObserver(this);
        }
    }

    private void UnregisterFromHandle(ExecutionHandle Handle) {
        ExecutionStateEvent ev = Handle.GetEvent(ExecutionStateEvent.EventName.ExecutionResume);
        if (ev != null) {
            ev.deleteObserver(this);
        }
    }

    private boolean CheckExecutionStatus(ExecutionHandle Handle) throws ExecutionCancelException, ExecutionInternalErrorException {
        switch (Handle.GetHandleState()) {
            case Cancel: {
                this.GetExtenderLogger().debug("Execution canceled");
                throw new ExecutionCancelException("Execution canceled in element " + this.GetName());
            }
            case Completed: {
                this.GetExtenderLogger().debug("Execution completed while elements shill active");
                throw new ExecutionInternalErrorException("Execution completed while elements shill active " + this.GetName());
            }
            case Paused: {
                return false;
            }
            case Ready: {
                this.GetExtenderLogger().debug("Execution ready and not running while elements shill active");
                throw new ExecutionInternalErrorException("Execution ready and not running while elements shill active " + this.GetName());
            }
            case Running: {
                return true;
            }
        }
        this.GetExtenderLogger().debug("Unrecognized execution state " + Handle.GetHandleState().toString());
        throw new ExecutionInternalErrorException("Unrecognized execution state " + Handle.GetHandleState().toString() + " " + this.GetName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void WaitToResume() {
        Boolean bl = this.Resume;
        synchronized (bl) {
            try {
                this.Resume.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterToRunningActionElementsRestriction(ExecutionHandle Handle) {
        if (!Handle.GetPlan().Config.RestrictActionTypes.contains((Object)this.GetPlanElementType())) {
            return;
        }
        if (Handle.GetPlan().Config.ConcurrentActionsPerBoundary > 0) {
            Object object = Handle.GetSynchActionsRunning();
            synchronized (object) {
                while (Handle.GetHandleState() == ExecutionHandle.HandleState.Running) {
                    if (Handle.GetActionsRunning() <= Handle.GetPlan().Config.ConcurrentActionsPerBoundary - 1) {
                        this.GetExtenderLogger().debug("Granting execution with number of running elements before current is counted beeing " + Handle.GetActionsRunning() + " of " + Handle.GetPlan().Config.ConcurrentActionsPerBoundary);
                        Handle.IncreaseActionsRunning();
                        break;
                    }
                    this.GetExtenderLogger().debug("Blocking execution until some action element is completed");
                    try {
                        Handle.GetSynchActionsRunning().wait();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UnregisterToRunningActionElementsRestriction(ExecutionHandle Handle) {
        if (!Handle.GetPlan().Config.RestrictActionTypes.contains((Object)this.GetPlanElementType())) {
            return;
        }
        Object object = Handle.GetSynchActionsRunning();
        synchronized (object) {
            this.GetExtenderLogger().debug("Decreasing number of running action elements which are before decrease " + Handle.GetActionsRunning() + " of " + Handle.GetPlan().Config.ConcurrentActionsPerBoundary);
            Handle.DecreaseActionsRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        if (!o.getClass().getName().equals(arg.getClass().getName())) {
            return;
        }
        if (arg instanceof ExecutionResumeStateEvent || arg instanceof ExecutionCancelStateEvent || arg instanceof ExecutionCompletedStateEvent) {
            Boolean bl = this.Resume;
            synchronized (bl) {
                this.Resume.notify();
            }
        }
    }

    protected static enum ClockType {
        Init,
        Finilization,
        Children,
        Total,
        Call;

    }
}

