/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution;

import gr.uoa.di.madgik.commons.channel.proxy.tcp.ChannelTCPConnManagerEntry;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.accounting.AccountingSystem;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.environment.is.elements.ExtensionPair;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.engine.QueueableExecutionEngine;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngCallbackTCPConnManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngTCPConnManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.notificationhandling.NotificationHandling;
import gr.uoa.di.madgik.ss.StorageSystem;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.messaging.endpoints.BrokerEndpoints;
import org.gcube.common.messaging.endpoints.ScheduledRetriever;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceContext {
    private static Logger logger = LoggerFactory.getLogger(ServiceContext.class);
    public static final String PROPERTIES_FILE = "deploy.properties";
    public static final String ServiceClass = "Execution";
    public static final String ServiceName = "ExecutionEngineService";
    public static final String ENDPOINT_KEY = "resteasy-servlet";
    private String scope = null;

    public ServiceContext() throws Exception {
        this.initialize();
    }

    public String getScope() {
        return this.scope;
    }

    void initialize() throws Exception {
        Map map = this.readProperties();
        this.scope = (String)map.get("startScopes");
        EnvHintCollection Hints = new EnvHintCollection();
        Hints.AddHint(new NamedEnvHint("StorageSystemDeleteOnExit", new EnvHint(Boolean.TRUE.toString())));
        Hints.AddHint(new NamedEnvHint("StorageSystemLocalFileSystemBufferPath", new EnvHint(this.GetLocalFSBuffer(map))));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorCount", new EnvHint(Integer.toString(this.GetRetryOnErrorTimes(map)))));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorInterval", new EnvHint(Integer.toString(this.GetRetryOnErrorInterval(map)))));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass", new EnvHint("Execution")));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName", new EnvHint("ExecutionEngineService")));
        String jmshost = this.GetJMSHost();
        if (jmshost != null) {
            Hints.AddHint(new NamedEnvHint("JMSHost", new EnvHint(this.GetJMSHost())));
            String JMSPROVIDER = this.GetJMSProvider(map);
            try {
                NotificationHandling.Init((String)JMSPROVIDER, (EnvHintCollection)Hints);
            }
            catch (Exception e) {
                logger.warn("Notification Handler initialization failed", (Throwable)e);
            }
        }
        this.InitExecutionEngineEnvironment(Hints, map);
        ScopeProvider.instance.set(this.scope);
        if (!Boolean.valueOf((String)map.get("test")).booleanValue()) {
            List endpoints;
            ScopedPublisher sp = RegistryPublisherFactory.scopedPublisher();
            while (true) {
                if ((endpoints = ServiceContext.findEndpointResource((String)this.getHostName(map), (String)this.scope)).size() > 0) break;
                Thread.sleep(1000L);
                logger.trace("Could not find endpoint resource. trying again at scope: " + this.scope);
            }
            logger.trace("Found endpoint resource at scope: " + this.scope);
            String serialization = ServiceContext.createSerialization((String)this.getPe2ngPort(map), (String)this.getHostName(map));
            logger.info("endpoints num: " + endpoints.size());
            for (GCoreEndpoint endpoint : endpoints) {
                Element newBody = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(serialization.getBytes())).getDocumentElement();
                ServiceContext.removeAllChildren((Node)endpoint.profile().specificData());
                Node importedNode = endpoint.profile().specificData().getOwnerDocument().importNode(newBody, true);
                Document document = newBody.getOwnerDocument();
                DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
                LSSerializer serializer = domImplLS.createLSSerializer();
                String str = serializer.writeToString(newBody);
                logger.info("update resource: " + str);
                endpoint.profile().specificData().appendChild(importedNode);
                sp.update((Resource)endpoint);
                logger.info("update resource: " + endpoint.toString());
            }
        }
    }

    public static void removeAllChildren(Node node) {
        Node child;
        while ((child = node.getFirstChild()) != null) {
            node.removeChild(child);
        }
    }

    static String createSerialization(String pe2ngPort, String hostname) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<doc>");
        strBuf.append("<element id=\"" + UUID.randomUUID() + "\">");
        strBuf.append("<dynamic>");
        strBuf.append("<entry key=\"pe2ng.port\">" + pe2ngPort + "</entry>");
        strBuf.append("<entry key=\"hostname\">" + hostname + "</entry>");
        strBuf.append("</dynamic>");
        strBuf.append("</element>");
        strBuf.append("</doc>");
        return strBuf.toString();
    }

    static List<GCoreEndpoint> findEndpointResource(String hostname, String scope) {
        ArrayList<GCoreEndpoint> endpoints = new ArrayList<GCoreEndpoint>();
        ScopeProvider.instance.set(scope.toString());
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        String serviceName = "ExecutionEngineService";
        String serviceClass = "Execution";
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List insts = client.submit((Query)query);
        for (GCoreEndpoint inst : insts) {
            GCoreEndpoint.Profile.Endpoint epr;
            if (inst == null || inst.profile() == null || inst.profile().endpointMap() == null || (epr = (GCoreEndpoint.Profile.Endpoint)inst.profile().endpointMap().get("resteasy-servlet")) == null) continue;
            logger.info("scope: " + scope + " found epr at : " + epr.uri().toASCIIString() + " comparing to : " + hostname);
            if (!epr.uri().toASCIIString().contains(hostname)) continue;
            endpoints.add(inst);
            logger.info("scope: " + scope + " added: " + epr.uri().toASCIIString());
        }
        return endpoints;
    }

    private void InitExecutionEngineEnvironment(EnvHintCollection Hints, Map<String, String> map) throws Exception {
        logger.info("Initalizing Engine Environment");
        logger.info("Initalizing TCPManager");
        List range = this.GetPortRanges(map);
        for (PortRange r : range) {
            logger.info("port range : " + r.GetStart() + "-" + r.GetEnd());
        }
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(this.getHostName(map), range, this.GetUseRandomPort(map).booleanValue()));
        logger.info("Registering entries");
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngCallbackTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ChannelTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        logger.info("Initializing Execution Engine");
        try {
            String id = this.getHostName(map);
            QueueableExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0, this.getHostName(map), Integer.valueOf(this.getPe2ngPort(map)).intValue()), (String)id);
        }
        catch (NoClassDefFoundError e) {
            logger.warn("Queuing mechanism is not supported cause class not found " + e.getMessage());
        }
        ExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0));
        logger.info("Collecting Environment Hints");
        logger.info("Initializing Information System Provider");
        logger.info("Initializing Storage System Provider");
        StorageSystem.Init((String)this.GetStorageSystemProvider(map), (EnvHintCollection)Hints);
        logger.info("Initializing Accoutning System Provider");
        AccountingSystem.init((String)this.GetAccountingSystemProvider(map));
    }

    void getTomcatPort() {
    }

    private void RegisterInfo(EnvHintCollection Hints) throws Exception {
        logger.info("Registering Node");
        NodeInfo nfo = new NodeInfo();
        nfo.DynamicExtensions.put("pe2ng.port", new ExtensionPair("pe2ng.port", Integer.toString(TCPConnectionManager.GetConnectionManagerPort())));
        InformationSystem.RegisterNode((NodeInfo)nfo, (EnvHintCollection)Hints);
        logger.info("Registering boundary listener");
    }

    private String GetLocalFSBuffer(Map<String, String> map) {
        String tmpObj = map.get("localFSBuffer");
        if (tmpObj == null) {
            return "";
        }
        return tmpObj.toString();
    }

    private int GetRetryOnErrorInterval(Map<String, String> map) {
        String tmpObj = map.get("retryOnErrorInterval");
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private int GetRetryOnErrorTimes(Map<String, String> map) {
        String tmpObj = map.get("retryOnErrorTimes");
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String GetInformationSystemProvider(Map<String, String> map) {
        String informationProviderObj = map.get("providerInformationName");
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetStorageSystemProvider(Map<String, String> map) {
        String storageProviderObj = map.get("providerStorageName");
        if (storageProviderObj == null) {
            return null;
        }
        return storageProviderObj.toString();
    }

    private String GetAccountingSystemProvider(Map<String, String> map) {
        String accountingProviderObj = map.get("providerAccountingName");
        if (accountingProviderObj == null) {
            return null;
        }
        return accountingProviderObj.toString();
    }

    private String GetJMSProvider(Map<String, String> map) {
        String JMSProviderObj = map.get("JMSProviderName");
        if (JMSProviderObj == null) {
            return null;
        }
        return JMSProviderObj.toString();
    }

    private String GetJMSHost() {
        String JMSHost = null;
        ScopeProvider.instance.set(this.scope);
        ScheduledRetriever retriever = null;
        try {
            retriever = BrokerEndpoints.getRetriever((long)60L, (long)60L);
            JMSHost = retriever.getFailoverEndpoint();
        }
        catch (Exception e) {
            logger.warn("Could not find JMSHost for scope " + this.scope, (Throwable)e);
        }
        return JMSHost;
    }

    private List<PortRange> GetPortRanges(Map<String, String> map) {
        String portRangesObj = map.get("portRanges");
        logger.info("port ranges retrieved is " + portRangesObj);
        if (portRangesObj == null) {
            return new ArrayList<PortRange>();
        }
        String portRangesStr = portRangesObj.toString();
        String[] rangePairs = portRangesStr.trim().split("-");
        ArrayList<PortRange> ranges = new ArrayList<PortRange>();
        for (String pair : rangePairs) {
            String[] pairSplit = pair.trim().split(",");
            if (pairSplit.length != 2) {
                return new ArrayList<PortRange>();
            }
            String pairStart = pairSplit[0].trim();
            if (!pairStart.startsWith("{")) {
                return new ArrayList<PortRange>();
            }
            pairStart = pairStart.substring(1).trim();
            String pairEnd = pairSplit[1].trim();
            if (!pairEnd.endsWith("}")) {
                return new ArrayList<PortRange>();
            }
            pairEnd = pairEnd.substring(0, pairEnd.length() - 1).trim();
            int beginPair = 0;
            int endPair = 0;
            try {
                beginPair = Integer.parseInt(pairStart.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            try {
                endPair = Integer.parseInt(pairEnd.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            ranges.add(new PortRange(beginPair, endPair));
        }
        return ranges;
    }

    private Boolean GetUseRandomPort(Map<String, String> map) {
        String portRandomObj = map.get("useRandomPort");
        if (portRandomObj == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(portRandomObj.toString().trim());
        }
        catch (Exception ex) {
            return false;
        }
    }

    String getHostName(Map<String, String> map) {
        return map.get("hostname");
    }

    String getPe2ngPort(Map<String, String> map) {
        return map.get("pe2ng.port");
    }

    private Map<String, String> readProperties() throws FileNotFoundException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties prop = new Properties();
        InputStream is = ServiceContext.class.getResourceAsStream("/deploy.properties");
        prop.load(is);
        for (String key : prop.stringPropertyNames()) {
            String value = prop.getProperty(key);
            if (value == null) continue;
            map.put(key, value.trim());
        }
        logger.info("properties read : " + map);
        return map;
    }
}

