/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.ftp;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.infra.NodeInfo2HostingNodeAdapter;
import gr.uoa.di.madgik.environment.is.IInformationSystemProvider;
import gr.uoa.di.madgik.environment.is.Query;
import gr.uoa.di.madgik.environment.is.elements.InvocablePlotInfo;
import gr.uoa.di.madgik.environment.is.elements.InvocableProfileInfo;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import gr.uoa.di.madgik.environment.is.elements.matching.MatchParser;
import gr.uoa.di.madgik.is.InformationSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class FTPInformationSystemProvider
implements IInformationSystemProvider {
    private static final Object lockMe = new Object();
    private static Random randGen = new Random();
    public static final String FTPURLHintName = "InformationSystemFTPURL";
    public static final String NodeSelectorHintName = "NodeSelector";
    private static final String DefaultFTPURL = "ftp://ftpuser:za73ba97ra@dl13.di.uoa.gr/d5s/is/";
    private Hashtable<String, NodeInfo> Nodes = new Hashtable();
    private Hashtable<String, InvocableProfileInfo> Invocables = new Hashtable();
    private Hashtable<String, Set<String>> InvocablesInNode = new Hashtable();
    private Hashtable<String, Set<InvocablePlotInfo>> PlotsOfInvocable = new Hashtable();

    private URL GetFTPURL(String path, EnvHintCollection Hints) throws MalformedURLException {
        System.out.println("FTP url" + Hints);
        if (Hints == null || !Hints.HintExists(FTPURLHintName)) {
            return new URL(DefaultFTPURL + path + ".is.tmp");
        }
        String loc = Hints.GetHint((String)FTPURLHintName).Hint.Payload;
        if (loc == null || loc.trim().length() == 0) {
            return new URL(DefaultFTPURL + path + ".is.tmp");
        }
        if (!loc.endsWith("/")) {
            loc = loc + "/";
        }
        return new URL(loc + path + ".is.tmp");
    }

    private static NodeSelector GetNodeSelector(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        if (Hints == null) {
            return null;
        }
        if (!Hints.HintExists(NodeSelectorHintName)) {
            return InformationSystem.GetDefaultNodeSelector();
        }
        String nodeSelectorClassName = Hints.GetHint((String)NodeSelectorHintName).Hint.Payload;
        try {
            return (NodeSelector)Class.forName(nodeSelectorClassName).newInstance();
        }
        catch (Exception e) {
            throw new EnvironmentInformationSystemException("Could not construct node selector", (Throwable)e);
        }
    }

    private void PutRemote(String path, Object obj, EnvHintCollection Hints) throws MalformedURLException, IOException {
        System.out.println(this.GetFTPURL(path, Hints));
        URLConnection con = this.GetFTPURL(path, Hints).openConnection();
        ObjectOutputStream oout = new ObjectOutputStream(new BufferedOutputStream(con.getOutputStream()));
        oout.writeObject(obj);
        oout.flush();
        oout.close();
    }

    private Object GetRemote(String path, EnvHintCollection Hints) throws MalformedURLException, IOException, ClassNotFoundException {
        try {
            System.out.println(this.GetFTPURL(path, Hints));
            URLConnection con = this.GetFTPURL(path, Hints).openConnection();
            ObjectInputStream oin = new ObjectInputStream(new BufferedInputStream(con.getInputStream()));
            Object o = oin.readObject();
            if (o == null) {
                return null;
            }
            return o;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    private void FlushPlotsOfInvocable(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            this.PutRemote("PlotsOfInvocable", this.PlotsOfInvocable, Hints);
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    private void FlushInvocablesInNode(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            this.PutRemote("InvocablesInNode", this.InvocablesInNode, Hints);
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    private void FlushInvocables(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            this.PutRemote("Invocables", this.Invocables, Hints);
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    private void FlushNodes(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            this.PutRemote("Nodes", this.Nodes, Hints);
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    private void GetPlotsOfInvocable(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            Object objs = this.GetRemote("PlotsOfInvocable", Hints);
            if (objs == null) {
                this.PlotsOfInvocable.clear();
            } else {
                this.PlotsOfInvocable = (Hashtable)objs;
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    private void GetInvocablesInNode(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            Object objs = this.GetRemote("InvocablesInNode", Hints);
            if (objs == null) {
                this.InvocablesInNode.clear();
            } else {
                this.InvocablesInNode = (Hashtable)objs;
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    private void GetInvocables(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            Object objs = this.GetRemote("Invocables", Hints);
            if (objs == null) {
                this.Invocables.clear();
            } else {
                this.Invocables = (Hashtable)objs;
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    private void GetNodes(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        try {
            Object objs = this.GetRemote("Nodes", Hints);
            if (objs == null) {
                this.Nodes.clear();
            } else {
                this.Nodes = (Hashtable)objs;
            }
        }
        catch (Exception ex) {
            throw new EnvironmentInformationSystemException("Could not retrieve needed info", (Throwable)ex);
        }
    }

    public List<String> RetrieveByQualifier(String qualifier, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unsupported action");
    }

    public List<String> Query(Query query, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        return new ArrayList<String>();
    }

    public List<String> Query(String queryString, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        return new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String RegisterNode(NodeInfo info, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            if (info.ID == null) {
                throw new EnvironmentInformationSystemException("ID not provided");
            }
            this.GetNodes(Hints);
            this.Nodes.put(info.ID, info);
            this.FlushNodes(Hints);
            return info.ID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterInvocableInstance(String NodeID, String InvocableID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            if (NodeID == null || InvocableID == null) {
                throw new EnvironmentInformationSystemException("ID not provided");
            }
            this.GetNodes(Hints);
            this.GetInvocables(Hints);
            this.GetInvocablesInNode(Hints);
            if (!this.Nodes.containsKey(NodeID)) {
                throw new EnvironmentInformationSystemException("Node id " + NodeID + " referenced not porovided");
            }
            if (!this.Invocables.containsKey(InvocableID)) {
                throw new EnvironmentInformationSystemException("Invocable id " + InvocableID + " referenced not porovided");
            }
            if (!this.InvocablesInNode.contains(NodeID)) {
                this.InvocablesInNode.put(NodeID, new HashSet());
            }
            this.InvocablesInNode.get(NodeID).add(InvocableID);
            this.FlushInvocablesInNode(Hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String RegisterInvocable(InvocableProfileInfo info, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            if (info.ID == null) {
                throw new EnvironmentInformationSystemException("ID not provided");
            }
            this.GetInvocables(Hints);
            this.Invocables.put(info.ID, info);
            this.FlushInvocables(Hints);
            return info.ID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterPlotOfInvocable(String InvocableID, InvocablePlotInfo info, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            if (InvocableID == null) {
                throw new EnvironmentInformationSystemException("ID not provided");
            }
            this.GetInvocables(Hints);
            this.GetPlotsOfInvocable(Hints);
            if (!this.Invocables.containsKey(InvocableID)) {
                throw new EnvironmentInformationSystemException("Invocable id " + InvocableID + " referenced not porovided");
            }
            if (!this.PlotsOfInvocable.contains(InvocableID)) {
                this.PlotsOfInvocable.put(InvocableID, new HashSet());
            }
            this.PlotsOfInvocable.get(InvocableID).add(info);
            this.FlushPlotsOfInvocable(Hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeInfo GetNode(String NodeID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            if (NodeID == null) {
                throw new EnvironmentInformationSystemException("ID not provided");
            }
            this.GetNodes(Hints);
            if (!this.Nodes.containsKey(NodeID)) {
                return null;
            }
            return this.Nodes.get(NodeID);
        }
    }

    public List<NodeInfo> GetMatchingNodes(String RankingExpression, String RequirementsExpression, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            try {
                return this.CollectNodeInfo(Hints, RequirementsExpression, RankingExpression);
            }
            catch (Exception ex) {
                throw new EnvironmentInformationSystemException("Could not complete information system interaction", (Throwable)ex);
            }
        }
    }

    public NodeInfo GetMatchingNode(String RankingExpression, String RequirementsExpression, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        return this.GetMatchingNode(RankingExpression, RequirementsExpression, FTPInformationSystemProvider.GetNodeSelector(Hints), Hints);
    }

    public NodeInfo GetMatchingNode(String RankingExpression, String RequirementsExpression, NodeSelector selector, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        this.GetNodes(Hints);
        Object object = lockMe;
        synchronized (object) {
            try {
                List<NodeInfo> res = this.CollectNodeInfo(Hints, RequirementsExpression, RankingExpression);
                HostingNode hn = selector.selectNode(new NodeInfo2HostingNodeAdapter().adaptAll(res));
                for (NodeInfo ni : res) {
                    if (!ni.ID.equals(hn.getId())) continue;
                    return ni;
                }
                return null;
            }
            catch (Exception ex) {
                throw new EnvironmentInformationSystemException("Could not complete information system interaction", (Throwable)ex);
            }
        }
    }

    private List<NodeInfo> CollectNodeInfo(EnvHintCollection Hints, String Requirments, String Rank) throws Exception {
        ArrayList<NodeInfo> nodes = new ArrayList<NodeInfo>(this.Nodes.values());
        ArrayList<NodeInfo> pickedNodes = new ArrayList<NodeInfo>();
        MatchParser parser = new MatchParser(Requirments);
        for (NodeInfo nfo : nodes) {
            boolean match = true;
            for (Map.Entry entry : parser.requirments.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) break;
                String value = nfo.getExtension((String)entry.getKey());
                if (value != null && value.trim().equalsIgnoreCase(((String)entry.getValue()).trim())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            pickedNodes.add(nfo);
        }
        return pickedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocableProfileInfo GetInvocableProfile(String InvocableProfileID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            if (InvocableProfileID == null) {
                throw new EnvironmentInformationSystemException("ID not provided");
            }
            this.GetInvocables(Hints);
            if (!this.Invocables.containsKey(InvocableProfileID)) {
                return null;
            }
            return this.Invocables.get(InvocableProfileID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocablePlotInfo GetPlotWithName(String PlotName, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            this.GetPlotsOfInvocable(Hints);
            for (Set<InvocablePlotInfo> ps : this.PlotsOfInvocable.values()) {
                if (ps.size() == 0) continue;
                for (InvocablePlotInfo p : ps) {
                    if (!p.Name.equals(PlotName)) continue;
                    return p;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetNodeHostingInvocable(String InvocableID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        Object object = lockMe;
        synchronized (object) {
            this.GetInvocablesInNode(Hints);
            for (Map.Entry<String, Set<String>> invocs : this.InvocablesInNode.entrySet()) {
                for (String s : invocs.getValue()) {
                    if (!s.equals(InvocableID)) continue;
                    return invocs.getKey();
                }
            }
        }
        return null;
    }

    public String GetGenericByID(String ID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Method not supported");
    }

    public List<String> GetGenericByName(String Name, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Method not supported");
    }

    public String GetOpenSearchGenericByDescriptionDocumentURI(String URI2, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Method not supported");
    }

    public String CreateGenericResource(String genericContent, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Method not supported");
    }

    public void UnregisterNode(String NodeID, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }

    public NodeInfo GetNode(String Hostname, String Port, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }

    public void UpdateGenericResource(String id, String content, Query query, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }

    public String CreateGenericResource(String content, Query attributes, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }

    public void DeleteGenericResource(String id, EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }

    public String GetLocalNodeHostName() throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }

    public String GetLocalNodePort() throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }

    public String GetLocalNodePE2ngPort(EnvHintCollection Hints) throws EnvironmentInformationSystemException {
        throw new EnvironmentInformationSystemException("Unimplemented method");
    }
}

