/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.ftp;

import gr.uoa.di.madgik.environment.exception.EnvironmentStorageSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.ss.IStorageSystemProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FTPStorageSystemProvider
implements IStorageSystemProvider {
    public static final String FTPURLHintName = "StorageSystemFTPURL";
    public static final String DeleteOnExitHintName = "StorageSystemDeleteOnExit";
    public static final String LocalFileSystemBufferPathHintName = "StorageSystemLocalFileSystemBufferPath";
    public static final String UserNameHintName = "UserName";
    public static final String PasswordHintName = "Password";
    public static final String PortHintName = "Port";
    private static final String DefaultLocalFileSystemBufferPath = "/tmp/";
    private static final String DefaultFTPURL = "ftp://pe2ng:pe2ng2011@donald.di.uoa.gr/indexStorage/";
    private static final String DefaultUserName = "pe2ng";
    private static final String DefaultPassword = "pe2ng2011";
    private String host = null;
    private String path = null;
    private String userName = null;
    private String password = null;
    private Integer port = null;
    private static Logger logger = Logger.getLogger(FTPStorageSystemProvider.class.getName());
    private FTPClient ftpClient = new FTPClient();

    public void SessionInit(EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        String userName = FTPStorageSystemProvider.GetUserName(Hints);
        String password = FTPStorageSystemProvider.GetPassword(Hints);
        Integer port = FTPStorageSystemProvider.GetPort(Hints);
        String storeUrlLocation = null;
        storeUrlLocation = Hints == null || !Hints.HintExists(FTPURLHintName) ? DefaultFTPURL : Hints.GetHint((String)FTPURLHintName).Hint.Payload;
        if (storeUrlLocation == null) {
            storeUrlLocation = DefaultFTPURL;
        }
        URL url = null;
        try {
            url = new URL(storeUrlLocation);
        }
        catch (Exception e) {
            throw new EnvironmentStorageSystemException("Malformed FTP host");
        }
        if (url.getPort() > 0) {
            if (this.port <= 0) {
                this.port = url.getPort();
            } else if (url.getPort() != this.port.intValue()) {
                throw new EnvironmentStorageSystemException("URL/Configuration port mismatch");
            }
        }
        String afterProto = storeUrlLocation.substring(storeUrlLocation.indexOf("//") + 2);
        String afterHost = afterProto.substring(afterProto.indexOf("/") + 1);
        String embeddedAuthority = afterProto;
        if (afterProto.indexOf("@") != -1 && storeUrlLocation.indexOf("//") + 2 + afterProto.indexOf("@") < afterProto.indexOf("/") + 1) {
            embeddedAuthority = afterProto.substring(0, afterProto.indexOf("@"));
            String[] userPass = embeddedAuthority.split(":");
            if (userPass.length != 2) {
                throw new EnvironmentStorageSystemException("Malformed user/pass pair in URL");
            }
            if (userName != null) {
                if (!userName.equals(userPass[0])) {
                    throw new EnvironmentStorageSystemException("URL/Configuration user name mismatch");
                }
            } else {
                userName = userPass[0];
            }
            if (password != null) {
                if (!password.equals(userPass[1])) {
                    throw new EnvironmentStorageSystemException("URL/Configuration password mismatch");
                }
            } else {
                password = userPass[1];
            }
        }
        if (userName == null && password != null) {
            throw new EnvironmentStorageSystemException("Unspecified user name");
        }
        if (password == null && userName != null) {
            throw new EnvironmentStorageSystemException("Unspecified password");
        }
        this.host = url.getHost();
        this.path = afterHost;
        this.userName = userName != null ? userName : DefaultUserName;
        this.password = password != null ? password : DefaultPassword;
        if (port != null) {
            this.port = port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File Retrieve(String ID, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        try {
            String newID = UUID.randomUUID().toString();
            File newtmp = FTPStorageSystemProvider.GetLocalFileSystemBufferFile(newID, Hints);
            if (FTPStorageSystemProvider.ShouldDeleteOnExit(Hints)) {
                newtmp.deleteOnExit();
            }
            this.SessionInit(Hints);
            try {
                this.Connect(this.host);
                this.ChangeDirectory(this.path);
                this.RemoteCopyFile(ID, newtmp);
            }
            finally {
                if (this.ftpClient.isConnected()) {
                    this.ftpClient.logout();
                    this.ftpClient.disconnect();
                }
            }
            return newtmp;
        }
        catch (Exception ex) {
            throw new EnvironmentStorageSystemException("Could not retrieve requested content", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Delete(String ID, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        try {
            this.SessionInit(Hints);
            try {
                this.Connect(this.host);
                this.ChangeDirectory(this.path);
                this.ftpClient.deleteFile(this.getRemoteFileName(ID));
                int reply = this.ftpClient.getReplyCode();
                logger.log(Level.FINER, "Delete: Server response:" + this.ftpClient.getReplyString());
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    throw new EnvironmentStorageSystemException("Could not delete file from FTP server: " + reply + ": " + this.ftpClient.getReplyString());
                }
            }
            finally {
                if (this.ftpClient.isConnected()) {
                    this.ftpClient.logout();
                    this.ftpClient.disconnect();
                }
            }
        }
        catch (Exception ex) {
            throw new EnvironmentStorageSystemException("Could not retrieve requested content", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String Store(File file, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        try {
            String ID = UUID.randomUUID().toString();
            this.SessionInit(Hints);
            boolean loggedIn = false;
            try {
                this.Connect(this.host);
                this.ChangeDirectory(this.path);
                this.RemoteCopyFile(file, ID);
            }
            finally {
                if (loggedIn) {
                    this.ftpClient.logout();
                }
                if (this.ftpClient.isConnected()) {
                    this.ftpClient.disconnect();
                }
            }
            return ID;
        }
        catch (Exception ex) {
            throw new EnvironmentStorageSystemException("Could not store provided content", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String Store(URL location, EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        try {
            String newID = UUID.randomUUID().toString();
            File newtmp = FTPStorageSystemProvider.GetLocalFileSystemBufferFile(newID, Hints);
            newtmp.deleteOnExit();
            String ID = UUID.randomUUID().toString();
            this.SessionInit(Hints);
            boolean loggedIn = false;
            try {
                this.Connect(this.host);
                this.ChangeDirectory(this.path);
                FTPStorageSystemProvider.RemoteCopyFile(location, newtmp);
                this.RemoteCopyFile(newtmp, ID);
            }
            finally {
                if (loggedIn) {
                    this.ftpClient.logout();
                }
                if (this.ftpClient.isConnected()) {
                    this.ftpClient.disconnect();
                }
            }
            newtmp.delete();
            return ID;
        }
        catch (Exception ex) {
            throw new EnvironmentStorageSystemException("Could not store provided content", (Throwable)ex);
        }
    }

    public File GetLocalFSBufferLocation(EnvHintCollection Hints) throws EnvironmentStorageSystemException {
        if (Hints == null || !Hints.HintExists(LocalFileSystemBufferPathHintName)) {
            return new File(DefaultLocalFileSystemBufferPath);
        }
        String loc = Hints.GetHint((String)LocalFileSystemBufferPathHintName).Hint.Payload;
        if (loc == null || loc.trim().length() == 0) {
            return new File(DefaultLocalFileSystemBufferPath);
        }
        return new File(loc);
    }

    private void Connect(String host) throws EnvironmentStorageSystemException {
        try {
            this.ftpClient.connect(host, this.port != null ? this.port.intValue() : this.ftpClient.getDefaultPort());
            int reply = this.ftpClient.getReplyCode();
            logger.log(Level.FINER, "Connect: Server response: " + this.ftpClient.getReplyString());
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new EnvironmentStorageSystemException("Could not connect to FTP server: " + reply + ": " + this.ftpClient.getReplyString());
            }
            this.ftpClient.login(this.userName, this.password);
            reply = this.ftpClient.getReplyCode();
            logger.log(Level.FINER, "Login: Server response:" + this.ftpClient.getReplyString());
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new EnvironmentStorageSystemException("Could not login to FTP server: " + reply + ": " + this.ftpClient.getReplyString());
            }
            this.ftpClient.setFileType(2);
        }
        catch (Exception e) {
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (Exception ee) {
                    throw new EnvironmentStorageSystemException("Could not disconnect from server", (Throwable)ee);
                }
            }
            throw new EnvironmentStorageSystemException("Could not initiate FTP session", (Throwable)e);
        }
    }

    private void ChangeDirectory(String path) throws EnvironmentStorageSystemException {
        try {
            this.ftpClient.changeWorkingDirectory(path);
            int reply = this.ftpClient.getReplyCode();
            logger.log(Level.FINER, "Chdir: Server response: " + this.ftpClient.getReplyString());
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new EnvironmentStorageSystemException("Could not change working directory: " + reply + ": " + this.ftpClient.getReplyString());
            }
        }
        catch (Exception e) {
            throw new EnvironmentStorageSystemException("Could not change working directory", (Throwable)e);
        }
    }

    private static void RemoteCopyFile(File src, URL dest) throws IOException {
        byte[] b;
        int read;
        URLConnection con = dest.openConnection();
        BufferedOutputStream bout = new BufferedOutputStream(con.getOutputStream());
        BufferedInputStream din = new BufferedInputStream(new FileInputStream(src));
        while ((read = din.read(b = new byte[4096])) >= 0) {
            bout.write(b, 0, read);
        }
        din.close();
        bout.flush();
        bout.close();
    }

    private static void RemoteCopyFile(URL src, File dest) throws IOException {
        byte[] b;
        int read;
        URLConnection con = src.openConnection();
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(dest));
        BufferedInputStream din = new BufferedInputStream(con.getInputStream());
        while ((read = din.read(b = new byte[4096])) >= 0) {
            bout.write(b, 0, read);
        }
        din.close();
        bout.flush();
        bout.close();
    }

    private void RemoteCopyFile(String ID, File dest) throws Exception {
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(dest));
        this.ftpClient.retrieveFile(this.getRemoteFileName(ID), (OutputStream)bout);
        int reply = this.ftpClient.getReplyCode();
        logger.log(Level.FINER, "Retrieve: Server response: " + this.ftpClient.getReplyString());
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw new EnvironmentStorageSystemException("Could not retrieve file. " + reply + ": " + this.ftpClient.getReplyString());
        }
        bout.flush();
        bout.close();
    }

    private void RemoteCopyFile(File src, String ID) throws Exception {
        BufferedInputStream din = new BufferedInputStream(new FileInputStream(src));
        this.ftpClient.storeFile(this.getRemoteFileName(ID), (InputStream)din);
        int reply = this.ftpClient.getReplyCode();
        logger.log(Level.FINER, "Retrieve: Server response: " + this.ftpClient.getReplyString());
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            throw new EnvironmentStorageSystemException("Could not store file. " + reply + ": " + this.ftpClient.getReplyString());
        }
    }

    private static File GetLocalFileSystemBufferFile(String ID, EnvHintCollection Hints) {
        if (Hints == null || !Hints.HintExists(LocalFileSystemBufferPathHintName)) {
            return new File(DefaultLocalFileSystemBufferPath, ID + ".ss.tmp");
        }
        String loc = Hints.GetHint((String)LocalFileSystemBufferPathHintName).Hint.Payload;
        if (loc == null || loc.trim().length() == 0) {
            return new File(DefaultLocalFileSystemBufferPath, ID + ".ss.tmp");
        }
        return new File(loc, ID + ".ss.tmp");
    }

    private String getRemoteFileName(String ID) {
        return ID + ".ss.tmp";
    }

    private static String GetStringHint(EnvHintCollection Hints, String hintName) {
        if (Hints == null || !Hints.HintExists(hintName)) {
            return null;
        }
        String payload = Hints.GetHint((String)hintName).Hint.Payload;
        if (payload == null || payload.trim().length() == 0) {
            return null;
        }
        return payload;
    }

    private static String GetUserName(EnvHintCollection Hints) {
        return FTPStorageSystemProvider.GetStringHint(Hints, UserNameHintName);
    }

    private static String GetPassword(EnvHintCollection Hints) {
        return FTPStorageSystemProvider.GetStringHint(Hints, PasswordHintName);
    }

    private static Integer GetPort(EnvHintCollection Hints) {
        String p = FTPStorageSystemProvider.GetStringHint(Hints, PortHintName);
        Integer value = -1;
        if (p != null) {
            value = Integer.parseInt(p);
        }
        if (value > 0) {
            return value;
        }
        return null;
    }

    private static boolean ShouldDeleteOnExit(EnvHintCollection Hints) {
        if (Hints == null) {
            return true;
        }
        if (!Hints.HintExists(DeleteOnExitHintName)) {
            return true;
        }
        return Boolean.parseBoolean(Hints.GetHint((String)DeleteOnExitHintName).Hint.Payload);
    }
}

