/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.gcube;

import gr.uoa.di.madgik.environment.cms.IContentManagementSystemProvider;
import gr.uoa.di.madgik.environment.cms.elements.Collection;
import gr.uoa.di.madgik.environment.cms.elements.DocumentProperty;
import gr.uoa.di.madgik.environment.cms.elements.alternative.DocumentAlternative;
import gr.uoa.di.madgik.environment.cms.elements.annotation.DocumentAnnotation;
import gr.uoa.di.madgik.environment.cms.elements.document.Document;
import gr.uoa.di.madgik.environment.cms.elements.metadata.DocumentMetadata;
import gr.uoa.di.madgik.environment.cms.elements.part.DocumentPart;
import gr.uoa.di.madgik.environment.exception.EnvironmentContentManagementSystemException;
import gr.uoa.di.madgik.environment.gcube.cms.elements.GCubeOriginatingDocument;
import gr.uoa.di.madgik.environment.gcube.cms.elements.GCubeOriginatingDocumentAlternative;
import gr.uoa.di.madgik.environment.gcube.cms.elements.GCubeOriginatingDocumentAnnotation;
import gr.uoa.di.madgik.environment.gcube.cms.elements.GCubeOriginatingDocumentMetadata;
import gr.uoa.di.madgik.environment.gcube.cms.elements.GCubeOriginatingDocumentPart;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.GCubeCollections;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.ViewReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAnnotation;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElementProperty;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubePart;
import org.gcube.contentmanagement.gcubemodellibrary.elements.MetadataElements;

public class GCubeContentManagementSystemProvider
implements IContentManagementSystemProvider {
    private Map<String, ReaderWriterPair> accessors = new HashMap<String, ReaderWriterPair>();
    private Map<String, String> collectionNameToId = new HashMap<String, String>();
    public static final String GCubeActionScopeHintName = "GCubeActionScope";
    public static final String SynchronousCreationHintName = "SynchronousCreation";
    public static final String SynchronousDeletionHintName = "SynchronousDeletion";
    public static final String SynchronousPollingIntervalHintName = "SynchronousPollingInterval";
    public static final String SynchronousPollingIntervalUnitHintName = "SynchronousPollingIntervalUnit";
    public static final boolean SynchronousCreationDef = false;
    public static final boolean SynchronousDeletionDef = false;
    public static final long SynchronousPollingIntervalDef = 5L;
    public static final TimeUnit SynchronousPollingIntervalUnitDef = TimeUnit.SECONDS;

    public List<Collection> GetCollections(EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        ArrayList<Collection> cols = new ArrayList<Collection>();
        try {
            for (org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection gCubeCol : Collections.list((GCUBEScope)GCUBEScope.getScope((String)scope))) {
                Collection col = new Collection();
                col.id = gCubeCol.getId();
                col.name = gCubeCol.getName();
                if (gCubeCol.getDescription() != null) {
                    col.description = gCubeCol.getDescription();
                }
                if (gCubeCol.getCreationTime() != null) {
                    col.creationTime = new Long(gCubeCol.getCreationTime().getTimeInMillis()).toString();
                }
                col.isUserCollection = gCubeCol.isUserCollection();
                cols.add(col);
            }
            return cols;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not retrieve collections", (Throwable)e);
        }
    }

    public List<Collection> FindCollectionByName(String name, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        ArrayList<Collection> cols = new ArrayList<Collection>();
        long synchronousPollingInterval = GCubeContentManagementSystemProvider.GetSynchronousPollingInterval(Hints);
        TimeUnit synchronousPollingIntervalUnit = GCubeContentManagementSystemProvider.GetSynchronousPollingIntervalUnit(Hints);
        try {
            for (org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection gCubeCol : Collections.findByName((GCUBEScope)GCUBEScope.getScope((String)scope), (String)name)) {
                Collection col = new Collection();
                col.id = gCubeCol.getId();
                col.name = gCubeCol.getName();
                col.description = gCubeCol.getDescription();
                col.creationTime = new Long(gCubeCol.getCreationTime().getTimeInMillis()).toString();
                col.isUserCollection = gCubeCol.isUserCollection();
                cols.add(col);
            }
            return cols;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not find collection", (Throwable)e);
        }
    }

    public List<Collection> FindCollectionById(String id, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        ArrayList<Collection> cols = new ArrayList<Collection>();
        long synchronousPollingInterval = GCubeContentManagementSystemProvider.GetSynchronousPollingInterval(Hints);
        TimeUnit synchronousPollingIntervalUnit = GCubeContentManagementSystemProvider.GetSynchronousPollingIntervalUnit(Hints);
        try {
            List gCubeCols = null;
            gCubeCols = Collections.findById((GCUBEScope)GCUBEScope.getScope((String)scope), (String)id);
            for (org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection gCubeCol : gCubeCols) {
                Collection col = new Collection();
                col.id = gCubeCol.getId();
                col.name = gCubeCol.getName();
                col.description = gCubeCol.getDescription();
                col.creationTime = new Long(gCubeCol.getCreationTime().getTimeInMillis()).toString();
                col.isUserCollection = gCubeCol.isUserCollection();
                cols.add(col);
            }
            return cols;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not find collection", (Throwable)e);
        }
    }

    public String CreateCollection(Collection col, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        boolean synchronousCreation = GCubeContentManagementSystemProvider.GetSynchronousCreation(Hints);
        TimeUnit synchronousIntervalUnit = GCubeContentManagementSystemProvider.GetSynchronousPollingIntervalUnit(Hints);
        long synchronousInterval = GCubeContentManagementSystemProvider.GetSynchronousPollingInterval(Hints);
        boolean propagateRequest = false;
        boolean readable = true;
        boolean writable = true;
        try {
            GCUBEScope gCubeScope = GCUBEScope.getScope((String)scope);
            List collectionReferences = GCubeCollections.createGCubeCollection((boolean)propagateRequest, (String)col.name, (String)col.description, (boolean)col.isUserCollection, (boolean)readable, (boolean)writable, (GCUBEScope)gCubeScope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            if (collectionReferences.size() != 1) {
                throw new Exception("Not exactly one collection reference has been returned");
            }
            this.accessors.put(((CollectionReference)collectionReferences.get(0)).getCollectionID(), new ReaderWriterPair(new DocumentReader((CollectionReference)collectionReferences.get(0), gCubeScope), new DocumentWriter((CollectionReference)collectionReferences.get(0), gCubeScope)));
            this.collectionNameToId.put(col.name, ((CollectionReference)collectionReferences.get(0)).getCollectionID());
            if (synchronousCreation) {
                List gCubeCols = null;
                do {
                    if ((gCubeCols = Collections.findById((GCUBEScope)GCUBEScope.getScope((String)scope), (String)((CollectionReference)collectionReferences.get(0)).getCollectionID())).size() != 0) continue;
                    synchronousIntervalUnit.sleep(synchronousInterval);
                } while (gCubeCols.size() == 0);
            }
            return ((CollectionReference)collectionReferences.get(0)).getCollectionID();
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not create collection", (Throwable)e);
        }
    }

    public void DeleteCollection(String id, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        boolean synchronousDeletion = GCubeContentManagementSystemProvider.GetSynchronousDeletion(Hints);
        TimeUnit synchronousIntervalUnit = GCubeContentManagementSystemProvider.GetSynchronousPollingIntervalUnit(Hints);
        long synchronousInterval = GCubeContentManagementSystemProvider.GetSynchronousPollingInterval(Hints);
        boolean deleteProfile = true;
        try {
            List<Collection> foundCol = this.FindCollectionById(id, Hints);
            if (foundCol.size() != 1) {
                return;
            }
            List results = GCubeCollections.deleteGCubeCollection((String)id, (boolean)deleteProfile, (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            for (Future result : results) {
                RPDocument doc = (RPDocument)result.get();
            }
            this.accessors.remove(id);
            this.collectionNameToId.remove(foundCol.get((int)0).name);
            if (synchronousDeletion) {
                List gCubeCols = null;
                do {
                    if ((gCubeCols = Collections.findById((GCUBEScope)GCUBEScope.getScope((String)scope), (String)id)).size() == 0) continue;
                    synchronousIntervalUnit.sleep(synchronousInterval);
                } while (gCubeCols.size() != 0);
            }
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not delete collection", (Throwable)e);
        }
    }

    private Document translateDocument(GCubeDocument gCubeDoc, boolean includeParts, boolean includeAlternatives, boolean includeMetadata, boolean includeAnnotations) throws Exception {
        DocumentProperty prop;
        GCubeOriginatingDocument doc = new GCubeOriginatingDocument();
        doc.id = gCubeDoc.id();
        doc.name = gCubeDoc.name();
        doc.collectionId = gCubeDoc.collectionID();
        doc.language = gCubeDoc.language();
        doc.mimeType = gCubeDoc.mimeType();
        doc.schemaName = gCubeDoc.schemaName();
        if (gCubeDoc.schemaURI() != null) {
            doc.schemaURI = gCubeDoc.schemaURI().toString();
        }
        doc.content = gCubeDoc.bytestream();
        if (gCubeDoc.bytestreamURI() != null) {
            doc.contentLocator = gCubeDoc.bytestreamURI().toString();
        }
        if (includeParts && gCubeDoc.parts() != null && gCubeDoc.parts().size() != 0) {
            doc.parts = new ArrayList();
            for (GCubePart gCubePart : gCubeDoc.parts().toList()) {
                GCubeOriginatingDocumentPart part = new GCubeOriginatingDocumentPart();
                part.id = gCubePart.id();
                part.name = gCubePart.name();
                part.creationTime = new Long(gCubePart.creationTime().getTimeInMillis()).toString();
                part.document = doc;
                part.content = gCubePart.bytestream();
                part.contentLocator = gCubePart.bytestreamURI().toString();
                part.language = gCubePart.language();
                part.lastUpdate = new Long(gCubePart.lastUpdate().getTimeInMillis()).toString();
                part.length = gCubePart.length();
                part.mimeType = gCubePart.mimeType();
                part.order = gCubePart.order();
                part.schemaName = gCubePart.schemaName();
                part.schemaUri = gCubePart.schemaURI().toString();
                part.properties = new HashMap();
                for (Map.Entry entry : gCubePart.properties().entrySet()) {
                    prop = new DocumentProperty();
                    prop.key = ((GCubeElementProperty)entry.getValue()).key();
                    prop.type = ((GCubeElementProperty)entry.getValue()).type();
                    prop.value = ((GCubeElementProperty)entry.getValue()).value();
                    part.properties.put(entry.getKey(), prop);
                }
                doc.parts.add(part);
            }
            block2: for (GCubePart gCubePart : gCubeDoc.parts().toList()) {
                DocumentPart locatedPart = null;
                for (DocumentPart documentPart : doc.parts) {
                    if (!documentPart.id.equals(gCubePart.id())) continue;
                    locatedPart = documentPart;
                    break;
                }
                String prevGCubePartId = gCubePart.previous().id();
                for (DocumentPart previousPart : doc.parts) {
                    if (!previousPart.id.equals(prevGCubePartId)) continue;
                    locatedPart.previous = previousPart;
                    continue block2;
                }
            }
        }
        if (includeMetadata && gCubeDoc.metadata() != null && gCubeDoc.metadata().size() != 0) {
            doc.metadata = new ArrayList();
            for (GCubeMetadata gCubeMetadata : gCubeDoc.metadata().toList()) {
                GCubeOriginatingDocumentMetadata metadata = new GCubeOriginatingDocumentMetadata();
                metadata.id = gCubeMetadata.id();
                metadata.name = gCubeMetadata.name();
                metadata.content = gCubeMetadata.bytestream();
                if (gCubeMetadata.bytestreamURI() != null) {
                    metadata.contentLocator = gCubeMetadata.bytestreamURI().toString();
                }
                if (gCubeMetadata.creationTime() != null) {
                    metadata.creationTime = new Long(gCubeMetadata.creationTime().getTimeInMillis()).toString();
                }
                metadata.document = doc;
                metadata.language = gCubeMetadata.language();
                if (gCubeMetadata.lastUpdate() != null) {
                    metadata.lastUpdate = new Long(gCubeMetadata.lastUpdate().getTimeInMillis()).toString();
                }
                metadata.length = gCubeMetadata.length();
                metadata.mimeType = gCubeMetadata.mimeType();
                metadata.schemaName = gCubeMetadata.schemaName();
                if (gCubeMetadata.schemaURI() != null) {
                    metadata.schemaUri = gCubeMetadata.schemaURI().toString();
                }
                metadata.properties = new HashMap();
                if (gCubeMetadata.properties() != null) {
                    for (Map.Entry entry : gCubeMetadata.properties().entrySet()) {
                        prop = new DocumentProperty();
                        prop.key = ((GCubeElementProperty)entry.getValue()).key();
                        prop.type = ((GCubeElementProperty)entry.getValue()).type();
                        prop.value = ((GCubeElementProperty)entry.getValue()).value();
                        metadata.properties.put(entry.getKey(), prop);
                    }
                }
                doc.metadata.add(metadata);
            }
        }
        if (includeAlternatives && gCubeDoc.alternatives() != null && gCubeDoc.alternatives().size() != 0) {
            doc.alternatives = new ArrayList();
            for (GCubeAlternative gCubeAlternative : gCubeDoc.alternatives().toList()) {
                GCubeOriginatingDocumentAlternative alternative = new GCubeOriginatingDocumentAlternative();
                alternative.id = gCubeAlternative.id();
                alternative.name = gCubeAlternative.name();
                alternative.content = gCubeAlternative.bytestream();
                if (gCubeAlternative.bytestreamURI() != null) {
                    alternative.contentLocator = gCubeAlternative.bytestreamURI().toString();
                }
                if (gCubeAlternative.creationTime() != null) {
                    alternative.creationTime = new Long(gCubeAlternative.creationTime().getTimeInMillis()).toString();
                }
                alternative.document = doc;
                alternative.language = gCubeAlternative.language();
                if (gCubeAlternative.lastUpdate() != null) {
                    alternative.lastUpdate = new Long(gCubeAlternative.lastUpdate().getTimeInMillis()).toString();
                }
                alternative.length = gCubeAlternative.length();
                alternative.mimeType = gCubeAlternative.mimeType();
                alternative.schemaName = gCubeAlternative.schemaName();
                if (gCubeAlternative.schemaURI() != null) {
                    alternative.schemaUri = gCubeAlternative.schemaURI().toString();
                }
                alternative.properties = new HashMap();
                if (gCubeAlternative.properties() == null) continue;
                for (Map.Entry entry : gCubeAlternative.properties().entrySet()) {
                    prop = new DocumentProperty();
                    prop.key = ((GCubeElementProperty)entry.getValue()).key();
                    prop.type = ((GCubeElementProperty)entry.getValue()).type();
                    prop.value = ((GCubeElementProperty)entry.getValue()).value();
                    alternative.properties.put(entry.getKey(), prop);
                }
                doc.alternatives.add(alternative);
            }
        }
        if (includeAnnotations && gCubeDoc.annotations() != null && gCubeDoc.annotations().size() != 0) {
            doc.annotations = new ArrayList();
            for (GCubeAnnotation gCubeAnnotation : gCubeDoc.annotations().toList()) {
                GCubeOriginatingDocumentAnnotation annotation = new GCubeOriginatingDocumentAnnotation();
                annotation.id = gCubeAnnotation.id();
                annotation.name = gCubeAnnotation.name();
                if (gCubeAnnotation.uri() != null) {
                    annotation.uri = gCubeAnnotation.uri().toString();
                }
                annotation.content = gCubeAnnotation.bytestream();
                if (gCubeAnnotation.bytestreamURI() != null) {
                    annotation.contentLocator = gCubeAnnotation.bytestreamURI().toString();
                }
                if (gCubeAnnotation.creationTime() != null) {
                    annotation.creationTime = new Long(gCubeAnnotation.creationTime().getTimeInMillis()).toString();
                }
                annotation.document = doc;
                annotation.language = gCubeAnnotation.language();
                if (gCubeAnnotation.lastUpdate() != null) {
                    annotation.lastUpdate = new Long(gCubeAnnotation.lastUpdate().getTimeInMillis()).toString();
                }
                annotation.length = gCubeAnnotation.length();
                annotation.mimeType = gCubeAnnotation.mimeType();
                annotation.schemaName = gCubeAnnotation.schemaName();
                if (gCubeAnnotation.schemaURI() != null) {
                    annotation.schemaUri = gCubeAnnotation.schemaURI().toString();
                }
                annotation.properties = new HashMap();
                if (gCubeAnnotation.properties() == null) continue;
                for (Map.Entry entry : gCubeAnnotation.properties().entrySet()) {
                    prop = new DocumentProperty();
                    prop.key = ((GCubeElementProperty)entry.getValue()).key();
                    prop.type = ((GCubeElementProperty)entry.getValue()).type();
                    prop.value = ((GCubeElementProperty)entry.getValue()).value();
                    annotation.properties.put(entry.getKey(), prop);
                }
                doc.annotations.add(annotation);
            }
            block11: for (GCubeAnnotation gCubeAnnotation : gCubeDoc.annotations().toList()) {
                DocumentAnnotation locatedAnnotation = null;
                for (DocumentAnnotation documentAnnotation : doc.annotations) {
                    if (!documentAnnotation.id.equals(gCubeAnnotation.id())) continue;
                    locatedAnnotation = documentAnnotation;
                    break;
                }
                String prevGCubeAnnotationId = gCubeAnnotation.previous().id();
                for (DocumentAnnotation previousAnnotation : doc.annotations) {
                    if (!previousAnnotation.id.equals(prevGCubeAnnotationId)) continue;
                    locatedAnnotation.previous = previousAnnotation;
                    continue block11;
                }
            }
        }
        return doc;
    }

    public List<Document> GetDocuments(String collectionId, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            DocumentProjection dp = Projections.document();
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            RemoteIterator documentIterator = cmReader.get((Projection)dp);
            ArrayList<Document> docs = new ArrayList<Document>();
            while (documentIterator.hasNext()) {
                GCubeDocument gCubeDoc = (GCubeDocument)documentIterator.next();
                Document doc = this.translateDocument(gCubeDoc, true, true, true, true);
                docs.add(doc);
            }
            return docs;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not retrieve documents of collection", (Throwable)e);
        }
    }

    public InputStream ResolveContent(String locator) throws EnvironmentContentManagementSystemException {
        try {
            if (locator == null) {
                return null;
            }
            return new URI(locator).toURL().openStream();
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not resolve content locator", (Throwable)e);
        }
    }

    public void SessionInit(EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
    }

    public List<DocumentMetadata> GetMetadataDocuments(String collectionId, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        List<Document> documents = this.GetDocuments(collectionId, Hints);
        ArrayList<DocumentMetadata> allMetadata = new ArrayList<DocumentMetadata>();
        try {
            MetadataView tView = new MetadataView(GCUBEScope.getScope((String)scope));
            tView.setCollectionId(collectionId);
            List newView = tView.findSimilar();
            ViewReader reader = ((MetadataView)newView.get(0)).reader();
            MetadataProjection mp = Projections.metadata();
            RemoteIterator iterator = reader.get((Projection)mp);
            while (iterator.hasNext()) {
                GCubeDocument gCubeDoc = (GCubeDocument)iterator.next();
                MetadataElements elements = gCubeDoc.metadata();
                for (GCubeMetadata gCubeMetadata : elements) {
                    GCubeOriginatingDocumentMetadata metadata = new GCubeOriginatingDocumentMetadata();
                    metadata.id = gCubeMetadata.id();
                    metadata.name = gCubeMetadata.name();
                    metadata.content = gCubeMetadata.bytestream();
                    metadata.contentLocator = gCubeMetadata.bytestreamURI().toString();
                    metadata.creationTime = new Long(gCubeMetadata.creationTime().getTimeInMillis()).toString();
                    for (Document document : documents) {
                        if (!document.id.equals(gCubeMetadata.document().id())) continue;
                        metadata.document = document;
                        break;
                    }
                    metadata.language = gCubeMetadata.language();
                    metadata.lastUpdate = new Long(gCubeMetadata.lastUpdate().getTimeInMillis()).toString();
                    metadata.length = gCubeMetadata.length();
                    metadata.mimeType = gCubeMetadata.mimeType();
                    metadata.schemaName = gCubeMetadata.schemaName();
                    metadata.schemaUri = gCubeMetadata.schemaURI().toString();
                    metadata.properties = new HashMap();
                    for (Map.Entry entry : gCubeMetadata.properties().entrySet()) {
                        DocumentProperty prop = new DocumentProperty();
                        prop.key = ((GCubeElementProperty)entry.getValue()).key();
                        prop.type = ((GCubeElementProperty)entry.getValue()).type();
                        prop.value = ((GCubeElementProperty)entry.getValue()).value();
                        metadata.properties.put(entry.getKey(), prop);
                    }
                    allMetadata.add(metadata);
                }
            }
            return allMetadata;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not retrieve metadata documents of collection", (Throwable)e);
        }
    }

    public Document GetDocument(String collectionId, String documentId, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = Projections.document();
            GCubeDocument gCubeDoc = cmReader.get(documentId, (Projection)dp);
            return this.translateDocument(gCubeDoc, true, true, true, true);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not retrieve document", (Throwable)e);
        }
    }

    public Document GetMainDocument(String collectionId, String documentId, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.LENGTH, (Property[])new PropertyTypes.DocumentProperty[]{(PropertyTypes.DocumentProperty)Projections.opt((Property)Projections.BYTESTREAM_URI), Projections.NAME});
            GCubeDocument gCubeDoc = cmReader.get(documentId, (Projection)dp);
            return this.translateDocument(gCubeDoc, false, false, false, false);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not retrieve main document", (Throwable)e);
        }
    }

    public List<DocumentMetadata> GetDocumentMetadata(String collectionId, String documentId, String schemaName, String schemaUri, String language, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.LENGTH, (Property[])new PropertyTypes.DocumentProperty[]{(PropertyTypes.DocumentProperty)Projections.opt((Property)Projections.BYTESTREAM_URI), Projections.NAME});
            GCubeDocument gCubeDoc = cmReader.get(documentId, (Projection)dp);
            Document doc = this.translateDocument(gCubeDoc, false, false, true, false);
            return doc.metadata;
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not retrieve document metadata", (Throwable)e);
        }
    }

    public String AddDocument(Document document, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            InputStream contentStream;
            if (document.collectionId == null) {
                throw new Exception("Missing collection id");
            }
            if (document.name == null) {
                throw new Exception("Missing document name");
            }
            DocumentWriter cmWriter = this.accessors.get(document.collectionId) != null ? this.accessors.get((Object)document.collectionId).writer : new DocumentWriter(document.collectionId, GCUBEScope.getScope((String)scope));
            GCubeDocument newDocument = new GCubeDocument();
            newDocument.setMimeType(document.mimeType);
            if (document.language != null) {
                newDocument.setLanguage(new Locale(document.language));
            }
            if (document.schemaName != null) {
                newDocument.setSchemaName(document.schemaName);
            }
            if (document.schemaURI != null) {
                newDocument.setSchemaURI(new URI(document.schemaURI));
            }
            if (document.type != null) {
                newDocument.setType(document.type);
            }
            if ((contentStream = document.GetContentStream()) == null) {
                throw new Exception("Missing content");
            }
            newDocument.setBytestream(contentStream);
            newDocument.setName(document.name);
            return cmWriter.add(newDocument);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not add document", (Throwable)e);
        }
    }

    public void DeleteDocument(String collectionId, String documentId, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            DocumentWriter cmWriter = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).writer : new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            cmWriter.delete(document);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not delete document", (Throwable)e);
        }
    }

    public void AddAlternative(String collectionId, String documentId, DocumentAlternative alternative, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            if (alternative.mimeType == null) {
                throw new Exception("Missing mime type");
            }
            GCubeAlternative newgCubeAlternative = new GCubeAlternative(alternative.mimeType);
            newgCubeAlternative.setMimeType(alternative.mimeType);
            InputStream contentStream = alternative.GetContentStream();
            if (contentStream == null) {
                throw new Exception("Missing content");
            }
            newgCubeAlternative.setBytestream(contentStream);
            if (alternative.name != null) {
                newgCubeAlternative.setName(alternative.name);
            }
            if (alternative.language != null) {
                newgCubeAlternative.setLanguage(new Locale(alternative.language));
            }
            if (alternative.schemaName != null) {
                newgCubeAlternative.setSchemaName(alternative.schemaName);
            }
            if (alternative.schemaUri != null) {
                newgCubeAlternative.setSchemaURI(new URI(alternative.schemaUri));
            }
            if (alternative.type != null) {
                newgCubeAlternative.setType(alternative.type);
            }
            DocumentWriter cmWriter = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).writer : new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            document.alternatives().add((BaseInnerElement)newgCubeAlternative);
            cmWriter.update(document);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not add document alternative", (Throwable)e);
        }
    }

    public void DeleteAlternative(String collectionId, String documentId, DocumentAlternative alternative, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            GCubeAlternative alt = new GCubeAlternative();
            alt.setMimeType(alternative.mimeType);
            DocumentWriter cmWriter = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).writer : new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            document.alternatives().remove((BaseInnerElement)alt);
            cmWriter.update(document);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not delete document alternative", (Throwable)e);
        }
    }

    public void AddMetadata(String collectionId, String documentId, DocumentMetadata metadata, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            InputStream contentStream;
            if (metadata.schemaName == null) {
                throw new Exception("Missing schema name");
            }
            if (metadata.schemaUri == null) {
                throw new Exception("Missing schema uri");
            }
            if (metadata.language == null) {
                throw new Exception("Missing language");
            }
            GCubeMetadata newgCubeMetadata = new GCubeMetadata();
            newgCubeMetadata.setSchemaName(metadata.schemaName);
            newgCubeMetadata.setSchemaURI(new URI(metadata.schemaUri));
            newgCubeMetadata.setLanguage(new Locale(metadata.language));
            if (metadata.mimeType != null) {
                newgCubeMetadata.setMimeType(metadata.mimeType);
            }
            if (metadata.type != null) {
                newgCubeMetadata.setType(metadata.type);
            }
            if ((contentStream = metadata.GetContentStream()) == null) {
                throw new Exception("Missing content");
            }
            newgCubeMetadata.setBytestream(contentStream);
            DocumentWriter cmWriter = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).writer : new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            document.metadata().add((BaseInnerElement)newgCubeMetadata);
            cmWriter.update(document);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not add document metadata", (Throwable)e);
        }
    }

    public void AddAnnotation(String collectionId, String documentId, DocumentAnnotation annotation, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            InputStream contentStream;
            DocumentProjection dp;
            GCubeDocument doc;
            if (annotation.schemaName == null) {
                throw new Exception("Missing schema name");
            }
            if (annotation.schemaUri == null) {
                throw new Exception("Missing schema uri");
            }
            if (annotation.language == null) {
                throw new Exception("Missing language");
            }
            GCubeAnnotation newgCubeAnnotation = new GCubeAnnotation();
            if (annotation.schemaName != null) {
                newgCubeAnnotation.setSchemaName(annotation.schemaName);
            }
            if (annotation.schemaUri != null) {
                newgCubeAnnotation.setSchemaURI(new URI(annotation.schemaUri));
            }
            if (annotation.language != null) {
                newgCubeAnnotation.setLanguage(new Locale(annotation.language));
            }
            if (annotation.mimeType != null) {
                newgCubeAnnotation.setMimeType(annotation.mimeType);
            }
            if (annotation.type != null) {
                newgCubeAnnotation.setType(annotation.type);
            }
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            if (annotation.previous != null && (doc = cmReader.get(documentId, (Projection)(dp = Projections.document()))).annotations() != null) {
                for (GCubeAnnotation ann : doc.annotations().toList()) {
                    if (!ann.id().equals(annotation.previous.id)) continue;
                    newgCubeAnnotation.setPrevious(ann);
                    break;
                }
            }
            if ((contentStream = annotation.GetContentStream()) == null) {
                throw new Exception("Missing content");
            }
            newgCubeAnnotation.setBytestream(contentStream);
            DocumentWriter cmWriter = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).writer : new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp2 = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp2);
            document.annotations().add((BaseInnerElement)newgCubeAnnotation);
            cmWriter.update(document);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not add document metadata", (Throwable)e);
        }
    }

    public void DeleteMetadata(String collectionId, String documentId, DocumentMetadata metadata, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            GCubeMetadata meta = new GCubeMetadata();
            meta.setSchemaName(metadata.schemaName);
            meta.setSchemaURI(new URI(metadata.schemaUri));
            meta.setLanguage(new Locale(metadata.language));
            DocumentWriter cmWriter = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).writer : new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            document.metadata().remove((BaseInnerElement)meta);
            cmWriter.update(document);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not delete document metadata", (Throwable)e);
        }
    }

    public void AddPart(String collectionId, String documentId, DocumentPart part, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        String scope = GCubeContentManagementSystemProvider.GetActionScope(Hints);
        try {
            InputStream contentStream;
            if (part.mimeType == null) {
                throw new Exception("Missing part");
            }
            GCubePart newgCubePart = new GCubePart();
            newgCubePart.setMimeType(part.mimeType);
            if (part.language != null) {
                newgCubePart.setLanguage(new Locale(part.language));
            }
            if (part.name != null) {
                newgCubePart.setName(part.name);
            }
            if (part.order >= 0) {
                newgCubePart.setOrder(part.order);
            }
            if (part.schemaName != null) {
                newgCubePart.setSchemaName(part.schemaName);
            }
            if (part.schemaUri != null) {
                newgCubePart.setSchemaURI(new URI(part.schemaUri));
            }
            if (part.type != null) {
                newgCubePart.setType(part.type);
            }
            if ((contentStream = part.GetContentStream()) == null) {
                throw new Exception("Missing content");
            }
            newgCubePart.setBytestream(contentStream);
            DocumentWriter cmWriter = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).writer : new DocumentWriter(collectionId, GCUBEScope.getScope((String)scope));
            DocumentReader cmReader = this.accessors.get(collectionId) != null ? this.accessors.get((Object)collectionId).reader : new DocumentReader(collectionId, GCUBEScope.getScope((String)scope));
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            GCubeDocument document = cmReader.get(documentId, (Projection)dp);
            document.setMimeType("multipart/mixed");
            document.parts().add((BaseInnerElement)newgCubePart);
            cmWriter.update(document);
        }
        catch (Exception e) {
            throw new EnvironmentContentManagementSystemException("Could not add document part", (Throwable)e);
        }
    }

    private static String GetActionScope(EnvHintCollection Hints) {
        if (Hints == null) {
            return null;
        }
        if (!Hints.HintExists(GCubeActionScopeHintName)) {
            return null;
        }
        return Hints.GetHint((String)GCubeActionScopeHintName).Hint.Payload;
    }

    private static boolean GetSynchronousCreation(EnvHintCollection Hints) {
        if (Hints == null) {
            return false;
        }
        if (!Hints.HintExists(SynchronousCreationHintName)) {
            return false;
        }
        return Boolean.parseBoolean(Hints.GetHint((String)SynchronousCreationHintName).Hint.Payload);
    }

    private static boolean GetSynchronousDeletion(EnvHintCollection Hints) {
        if (Hints == null) {
            return false;
        }
        if (!Hints.HintExists(SynchronousDeletionHintName)) {
            return false;
        }
        return Boolean.parseBoolean(Hints.GetHint((String)SynchronousDeletionHintName).Hint.Payload);
    }

    private static long GetSynchronousPollingInterval(EnvHintCollection Hints) {
        if (Hints == null) {
            return 5L;
        }
        if (!Hints.HintExists(SynchronousPollingIntervalHintName)) {
            return 5L;
        }
        return Long.parseLong(Hints.GetHint((String)SynchronousPollingIntervalHintName).Hint.Payload);
    }

    private static TimeUnit GetSynchronousPollingIntervalUnit(EnvHintCollection Hints) {
        if (Hints == null) {
            return SynchronousPollingIntervalUnitDef;
        }
        if (!Hints.HintExists(SynchronousPollingIntervalUnitHintName)) {
            return SynchronousPollingIntervalUnitDef;
        }
        return TimeUnit.valueOf(Hints.GetHint((String)SynchronousPollingIntervalUnitHintName).Hint.Payload);
    }

    public Document NewDocument() throws EnvironmentContentManagementSystemException {
        return new GCubeOriginatingDocument();
    }

    public DocumentMetadata NewDocumentMetadata() throws EnvironmentContentManagementSystemException {
        return new GCubeOriginatingDocumentMetadata();
    }

    public DocumentPart NewDocumentPart() throws EnvironmentContentManagementSystemException {
        return new GCubeOriginatingDocumentPart();
    }

    public DocumentAlternative NewDocumentAlternative() throws EnvironmentContentManagementSystemException {
        return new GCubeOriginatingDocumentAlternative();
    }

    public DocumentAnnotation NewDocumentAnnotation() throws EnvironmentContentManagementSystemException {
        return new GCubeOriginatingDocumentAnnotation();
    }

    public List<Document> GetDocumentsWithProperties(String collectionId, HashMap<String, String> properties, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        return null;
    }

    public void updateDocumentContent(Document document, EnvHintCollection Hints) throws EnvironmentContentManagementSystemException {
        throw new EnvironmentContentManagementSystemException("", (Throwable)new UnsupportedOperationException("Operation not supported"));
    }

    private static class ReaderWriterPair {
        public DocumentReader reader;
        public DocumentWriter writer;

        public ReaderWriterPair(DocumentReader reader, DocumentWriter writer) {
            this.reader = reader;
            this.writer = writer;
        }
    }
}

