/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grsbroker;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.decorators.keepalive.KeepAliveReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FileField;
import gr.uoa.di.madgik.grs.record.field.ObjectField;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.URLField;
import gr.uoa.di.madgik.grs.test.SimplePumpable;
import gr.uoa.di.madgik.grsbroker.helpmanagers.FileManager;
import gr.uoa.di.madgik.grsbroker.helpmanagers.ReadersManager;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@WebServlet(value={"/Broker"})
public class Broker
extends HttpServlet {
    private static Logger logger = Logger.getLogger(HttpServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int BUFSIZE = 4096;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            try {
                logger.log(Level.FINE, "servlet got request");
                if (request.getParameter("locator") != null) {
                    String locatorStr = request.getParameter("locator") + "#" + request.getParameter("schema");
                    URI locator = null;
                    locator = new URI(locatorStr);
                    Integer max = -1;
                    if (request.getParameter("max") != null) {
                        max = Integer.valueOf(request.getParameter("max"));
                    }
                    logger.log(Level.FINE, "max read from request : " + max);
                    String key = (String)Broker.getQueryMap((String)request.getParameter("locator")).get("key");
                    GZIPOutputStream out = new GZIPOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
                    response.setHeader("Content-Encoding", "gzip");
                    long before = System.currentTimeMillis();
                    try {
                        KeepAliveReader reader = ReadersManager.getReader((String)key, (URI)locator);
                        logger.log(Level.FINE, "start reading from result set reader with key : " + key + " and locator : " + locator.toString());
                        int count = 0;
                        out.write("<?xml version=\"1.0\"?>".getBytes());
                        out.write("<Records>".getBytes());
                        while (count != max && reader.getStatus() != IBuffer.Status.Dispose && (reader.getStatus() != IBuffer.Status.Close || reader.availableRecords() != 0)) {
                            GenericRecord rec = (GenericRecord)reader.get(60L, TimeUnit.SECONDS);
                            if (rec == null) continue;
                            out.write(this.getRecordXML(rec, key).getBytes());
                            ++count;
                        }
                        out.write("</Records>".getBytes());
                        if (count == 0) {
                            logger.log(Level.FINE, "closing the reader at result set reader with key : " + key + " and locator : " + locator.toString());
                            ReadersManager.closeReader((String)key);
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "error reading records from result set", ex);
                        ReadersManager.closeReader((String)key);
                        response.setStatus(500);
                        response.getOutputStream().flush();
                        response.getOutputStream().close();
                    }
                    logger.log(Level.FINE, "total : " + (System.currentTimeMillis() - before) + " ms");
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "error closing response stream", e);
                    }
                    break block13;
                }
                if (request.getParameter("filename") != null) {
                    String filename = request.getParameter("filename");
                    String key = request.getParameter("key");
                    String path = FileManager.getFilePath((String)key, (String)filename);
                    String realFilename = FileManager.getFileRealName((String)key, (String)filename);
                    logger.log(Level.FINE, "read from request : " + filename + " and key : " + key);
                    logger.log(Level.FINE, "found path : " + path + " and realFilename : " + realFilename);
                    if (path == null) {
                        logger.log(Level.SEVERE, "path of file : " + filename + " and key : " + key + "not found");
                        response.setStatus(404);
                        response.getOutputStream().flush();
                        response.getOutputStream().close();
                    } else {
                        this.doDownload(request, response, path, realFilename);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "error parsing the request", e);
                response.setStatus(500);
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
    }

    private String getRecordXML(GenericRecord rec, String key) throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<Record id=\"" + rec.getID() + "\">");
        xml.append("<Fields>");
        for (Field f : rec.getFields()) {
            xml.append("<Field>");
            xml.append("<Name>");
            xml.append(StringEscapeUtils.escapeXml((String)f.getFieldDefinition().getName()));
            xml.append("</Name>");
            xml.append("<Value>");
            xml.append(StringEscapeUtils.escapeXml((String)this.getFieldXML(key, f)));
            xml.append("</Value>");
            xml.append("</Field>");
        }
        xml.append("</Fields>");
        xml.append("</Record>");
        return xml.toString();
    }

    private String getFieldXML(String key, Field f) throws Exception {
        StringBuffer xml = new StringBuffer();
        if (f.getClass().equals(SimplePumpable.class)) {
            xml.append(((ObjectField)f).getPayload());
        } else if (f.getClass().equals(FileField.class)) {
            String filename = ((FileField)f).getOriginalPayload().getName();
            String fname = FileManager.putFileInMap((File)((FileField)f).getPayload(), (String)filename, (String)key);
            xml.append("./Broker?key=" + key + "&filename=" + fname + "&realname=" + filename);
        } else if (f.getClass().equals(ObjectField.class)) {
            xml.append(((ObjectField)f).getPayload());
        } else if (f.getClass().equals(StringField.class)) {
            xml.append(((StringField)f).getPayload().toString());
        } else if (f.getClass().equals(URLField.class)) {
            xml.append(((URLField)f).getPayload().toString());
        } else {
            throw new Exception("Field : " + f.getClass() + " not of known class");
        }
        return xml.toString();
    }

    private String getRecordHTML(GenericRecord rec, String key) throws Exception {
        StringBuffer html = new StringBuffer();
        html.append("<div>");
        html.append("<div>");
        html.append(rec.getID());
        html.append("</div>");
        for (Field f : rec.getFields()) {
            html.append("<div>");
            html.append(this.getFieldString(key, f));
            html.append("</div>");
        }
        html.append("</div>");
        return html.toString();
    }

    private String getFieldString(String key, Field f) throws Exception {
        StringBuffer html = new StringBuffer();
        if (f.getClass().equals(SimplePumpable.class)) {
            html.append("<div>");
            html.append(((ObjectField)f).getPayload());
            html.append("</div>");
        } else if (f.getClass().equals(FileField.class)) {
            String filename = ((FileField)f).getOriginalPayload().getName();
            String fname = FileManager.putFileInMap((File)((FileField)f).getPayload(), (String)filename, (String)key);
            html.append("<a href=\"");
            html.append("./Broker?key=" + key + "&filename=" + fname);
            html.append("\">");
            html.append(filename);
            html.append("</a>");
        } else if (f.getClass().equals(ObjectField.class)) {
            html.append("<div>");
            html.append(((ObjectField)f).getPayload());
            html.append("</div>");
        } else if (f.getClass().equals(StringField.class)) {
            html.append("<div>");
            html.append(((StringField)f).getPayload().toString());
            html.append("</div>");
        } else if (f.getClass().equals(URLField.class)) {
            html.append("<a href=\"");
            html.append(((URLField)f).getPayload().toString());
            html.append("\">");
            html.append(((URLField)f).getPayload().toString());
            html.append("</a>");
        } else {
            throw new Exception("Field : " + f.getClass() + " not of known class");
        }
        return html.toString();
    }

    private static Map<String, String> getQueryMap(String url) {
        String[] parts = url.split("\\?");
        if (parts.length == 0) {
            return null;
        }
        String[] params = parts[1].split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private void doDownload(HttpServletRequest req, HttpServletResponse resp, String filename, String original_filename) throws IOException {
        File f = new File(filename);
        int length = 0;
        ServletOutputStream op = resp.getOutputStream();
        ServletContext context = this.getServletConfig().getServletContext();
        String mimetype = context.getMimeType(filename);
        resp.setContentType(mimetype != null ? mimetype : "application/octet-stream");
        resp.setContentLength((int)f.length());
        resp.setHeader("Content-Disposition", "attachment; filename=\"" + original_filename + "\"");
        byte[] bbuf = new byte[4096];
        DataInputStream in = new DataInputStream(new FileInputStream(f));
        while (in != null && (length = in.read(bbuf)) != -1) {
            op.write(bbuf, 0, length);
        }
        in.close();
        op.flush();
        op.close();
    }
}

