/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.events;

import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyValueEvent
extends BufferEvent {
    private String key = null;
    private String value = null;

    public KeyValueEvent() {
    }

    public KeyValueEvent(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void extendToXML(Document doc, Element element) throws GRS2RecordSerializationException {
        try {
            Element elm = null;
            if (this.key != null) {
                elm = doc.createElement("key");
                elm.setTextContent(String.valueOf(this.key));
                element.appendChild(elm);
            }
            if (this.value != null) {
                elm = doc.createElement("value");
                elm.setTextContent(String.valueOf(this.value));
                element.appendChild(elm);
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to create key value event xml", e);
        }
    }

    @Override
    public void extendFromXML(Element element) throws GRS2RecordSerializationException {
        try {
            if (element.getElementsByTagName("key") != null && element.getElementsByTagName("key").getLength() > 0) {
                this.key = element.getElementsByTagName("key").item(0).getTextContent();
            }
            if (element.getElementsByTagName("value") != null && element.getElementsByTagName("value").getLength() > 0) {
                this.value = element.getElementsByTagName("value").item(0).getTextContent();
            }
        }
        catch (Exception e) {
            throw new GRS2RecordSerializationException("unable to get key value event from xml", e);
        }
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            if (this.key == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.key);
            }
            if (this.value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(this.value);
            }
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("Could not deflate event", e);
        }
    }

    @Override
    public void extendInflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            if (in.readBoolean()) {
                this.key = in.readUTF();
            }
            if (in.readBoolean()) {
                this.value = in.readUTF();
            }
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("Could not inflate event", e);
        }
    }
}

