package gr.uoa.di.madgik.grs.bridge;

import gr.uoa.di.madgik.grs.bridge.exceptions.GCubeBridgeException;
import gr.uoa.di.madgik.grs.record.Record;

/**
 * Base record that is manageable by the upgrade / downgrade facilities
 * 
 * @author gpapanikos
 *
 */
public abstract class GCubeRecord extends Record
{
	/**
	 * Downgrade the record to a string serialization that is compatible to the serialization
	 * of an "old style" ResultSet record
	 * 
	 * @return the serialization
	 * @throws GCubeBridgeException the downgrade could not be performed
	 */
	public abstract String downgrade() throws GCubeBridgeException;
	
	/**
	 * Upgrade from the provided "old style" ResultSet record serialization to the provided record
	 * 
	 * @param record the ResultSet record serialization
	 * @throws GCubeBridgeException the upgrade could not be performed
	 */
	public abstract void upgrade(String record) throws GCubeBridgeException;
}
