package gr.uoa.di.madgik.grs.bridge.xml;

import java.net.URI;
import java.util.logging.Logger;

import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.bridge.BridgeUpgrade;
import gr.uoa.di.madgik.grs.bridge.exceptions.GCubeBridgeException;
import gr.uoa.di.madgik.grs.buffer.IBuffer.Status;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;

/**
 * Implementation of the {@link BridgeUpgrade} base class specialized for XML containing payload ResultSet 
 * 
 * @author gpapanikos
 *
 */
public class XMLUpgrade extends BridgeUpgrade
{
	private static Logger logger=Logger.getLogger(XMLUpgrade.class.getName());
	private RecordWriter<Record> writer=null;
	private RSXMLIterator iterator=null;
	private boolean compress=GCubeXMLRecordDefinition.DefaultCompress;
	private IWriterProxy proxy=null;
	
	public XMLUpgrade(){}
	
	public XMLUpgrade(RSLocator locator)
	{
		this.locator=locator;
	}
	
	/**
	 * Set compress at transport
	 * 
	 * @param compress compress at transport or not
	 */
	public void setCompress(boolean compress)
	{
		this.compress=compress;
	}
	
	/**
	 * Sets the {@link IWriterProxy} to be used for the locaotr URI to be created for the output
	 * 
	 * @param proxy the proxy to use
	 */
	public void setProxy(IWriterProxy proxy)
	{
		this.proxy=proxy;
	}
	
	/**
	 * {@inheritDoc}
	 * 
	 * @see gr.uoa.di.madgik.grs.bridge.BridgeUpgrade#initialize()
	 */
	@Override
	public void initialize() throws GCubeBridgeException
	{
		try
		{
			this.writer=new RecordWriter<Record>(this.proxy, new RecordDefinition[]{new GCubeXMLRecordDefinition(this.compress)});
		} catch (GRS2Exception e)
		{
			throw new GCubeBridgeException("Could not initialize Record Writer", e);
		}
		try
		{
			this.iterator=RSXMLReader.getRSXMLReader(this.locator).makeLocal(new RSResourceLocalType()).getRSIterator();
		} catch (Exception e)
		{
			throw new GCubeBridgeException("Could not initialize RS Reader Iterator", e);
		}
	}	

	/**
	 * {@inheritDoc}
	 * 
	 * @see gr.uoa.di.madgik.grs.bridge.BridgeUpgrade#getLocator()
	 */
	@Override
	public URI getLocator() throws GCubeBridgeException
	{
		try
		{
			return this.writer.getLocator();
		} catch (GRS2WriterException e)
		{
			throw new GCubeBridgeException("Could not retrieve locator", e);
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see gr.uoa.di.madgik.grs.bridge.BridgeUpgrade#doUpgrade()
	 */
	@Override
	public void doUpgrade() throws GCubeBridgeException
	{
		try
		{
			while(this.iterator.hasNext() && this.writer.getStatus()==Status.Open)
			{
				ResultElementBase rec=this.iterator.next(this.recordInputClass);
				if(rec==null) continue;
				this.writer.put(this.getRecord(rec), RecordWriter.DefaultInactivityTimeout, RecordWriter.DefaultInactivityTimeUnit);
			}
		}
		catch(Exception ex)
		{
			throw new GCubeBridgeException("Could not add the downgraded record", ex);
		}finally
		{
			try{this.writer.close();}catch(Exception ex){}
		}
	}
	
	/**
	 * {@inheritDoc}
	 * 
	 * @see gr.uoa.di.madgik.grs.bridge.BridgeUpgrade#getLogger()
	 */
	@Override
	public Logger getLogger()
	{
		return XMLUpgrade.logger;
	}
}
