/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.madgik.environment.notifications.handlers;

import gr.uoa.di.madgik.environment.notifications.NotificationMessageListenerI;
import gr.uoa.di.madgik.environment.notifications.SubscriberToTopic;
import gr.uoa.madgik.environment.jms.JMSConnectionHandler;
import gr.uoa.madgik.environment.notifications.exceptions.FailedToCommunicateWithNotificationService;
import gr.uoa.madgik.environment.notifications.exceptions.FailedToRegisterToTopicException;
import gr.uoa.madgik.environment.notifications.exceptions.FailedToUnregisterFromTopicException;
import gr.uoa.madgik.environment.notifications.exceptions.TopicCreationException;
import gr.uoa.madgik.environment.notifications.model.TopicData;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandler {
    static NotificationHandler nh;
    String jmsLocation;

    public static NotificationHandler getInstance() {
        if (nh == null) {
            nh = new NotificationHandler();
        }
        return nh;
    }

    public void configureHandler(String jmsLocation) {
        NotificationHandler.nh.jmsLocation = jmsLocation;
    }

    public boolean[] isTopicRegistered(List<TopicData> topics) throws FailedToCommunicateWithNotificationService {
        return JMSConnectionHandler.getInstance(NotificationHandler.nh.jmsLocation).isTopicRegistered(topics);
    }

    public String registerNotificationTopics(TopicData topic) throws TopicCreationException {
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        Logger logger = LoggerFactory.getLogger((String)NotificationHandler.class.getName());
        logger.info("NotificationHandler: Registering Topic! ProducerId: " + topic.getProducerId() + "- TopicName: " + topic.getTopicName());
        Topic theTopic = JMSConnectionHandler.getInstance(NotificationHandler.nh.jmsLocation).createTopic(topic);
        try {
            String topicId = theTopic.getTopicName();
            logger.info("NotificationHandler: TopicId of created topic: " + topicId);
            return topicId;
        }
        catch (JMSException e) {
            throw new TopicCreationException(e);
        }
    }

    public SubscriberToTopic registerToNotificationTopic(TopicData topic, String listenerId, String subscriptionName, String selector, SubscriberToTopic subscriberToTopic, NotificationMessageListenerI listener) throws FailedToRegisterToTopicException {
        Logger logger = LoggerFactory.getLogger((String)NotificationHandler.class.getName());
        logger.info("NotificationHandler: Registering to NotificationTopic - ProducerId" + topic.getProducerId() + " - topicName: " + topic.getTopicName() + " listenerId: listenerId - subscriptionName: " + subscriptionName);
        return JMSConnectionHandler.getInstance(NotificationHandler.nh.jmsLocation).listenToMessagesOfTopic(topic, listenerId, subscriptionName, selector, subscriberToTopic, listener);
    }

    public void unregisterNotificationTopic(TopicData topic) throws FailedToCommunicateWithNotificationService {
        JMSConnectionHandler.getInstance(NotificationHandler.nh.jmsLocation).deleteTopic(topic);
    }

    public void unregisterFromNotificationTopic(TopicData topic, String listenerId, SubscriberToTopic subscriberToTopic) throws FailedToUnregisterFromTopicException {
        JMSConnectionHandler.getInstance(NotificationHandler.nh.jmsLocation).unsubscribeFromTopic(topic, listenerId, subscriberToTopic);
    }

    public void sendNotificationToTopic(TopicData topicData, String textMessage, HashMap<String, String> propertiesNameValueMap) {
        Logger logger = LoggerFactory.getLogger(NotificationHandler.class);
        logger.info("NotificationHandler: Sending Notification To Topic, TopicName: " + topicData.getTopicName() + " - producerId: " + topicData.getProducerId());
        JMSConnectionHandler.getInstance(NotificationHandler.nh.jmsLocation).sendNotificationToTopic(topicData, textMessage, propertiesNameValueMap);
    }
}

