package org.gcube.execution.refextractservice.tests;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.execution.refextractservice.stubs.*;
import org.gcube.execution.refextractservice.stubs.service.RefextractServiceAddressingLocator;
import org.gcube.execution.refextractservice.stubs.service.RefextractServiceFactoryServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;



public class TestRefextractService {

	private enum	SubmissionType { jdlAdaptor, gridAdaptor };
	private static  boolean 		destroyWSResources 		= true;							// whether you want the WS resource of the job to be destroyed in the end
	private static  long			pollPeriodMilliSeconds	= 10000;						// milliseconds between polling status of indexer job		
	private static 	SubmissionType	subType					= SubmissionType.jdlAdaptor;	// type of submission, jdl or grid
	private static  String 			proxyPath				= "/tmp/proxy";					// location of proxy in local filesystem
	private static  String 			owner 					= "TestRefextractServiceClient";
	
	public static void main(String[] args)  {

		final String usage = "Usage: 	java org.gcube.execution.refextractservice.tests.TestRefextractService <ocr factory address> <gcube scope> <resource key> <resource access> <value> <optional jobName in >=1 words>\n" + 
				"\n" + 
				"Example 1:\n" + 
				"	java org.gcube.execution.refextractservice.tests.TestRefextractService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/refextractservice/RefextractServiceFactory /gcube/devNext example_doc.text Reference 		http://dl.dropbox.com/u/19792897/refextract_job_files/example_doc.text A refextract job submitted Friday night by Peter\n" + 
				"\n" + 
				"Example 2:\n" + 
				"	java org.gcube.execution.refextractservice.tests.TestRefextractService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/refextractservice/RefextractServiceFactory /gcube/devNext example_doc.text CMSReference     	cmsreference  A refextract job submitted Friday night by Peter\n" + 
				"\n" + 
				"Example 3a:\n" + 
				"	java org.gcube.execution.refextractservice.tests.TestRefextractService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/refextractservice/RefextractServiceFactory /gcube/devNext example_doc.text InMessageString  	/home/stefanos/inspire/refextract/example_doc.text A refextract job submitted Friday night by Peter\n" + 
				"\n" + 
				"Example 3b:\n" + 
				"	java org.gcube.execution.refextractservice.tests.TestRefextractService http://jazzman.di.uoa.gr:8080/wsrf/services/gcube/execution/refextractservice/RefextractServiceFactory /gcube/devNext example_doc.text InMessageBytes   	/home/stefanos/inspire/refextract/example_doc.text A refextract job submitted Friday night by Peter\n" + 
				"";
		
		try {

			//Client needs >=5 arguments
			if(args.length<5){
				System.err.println(usage);
				System.exit(1);
			}
			
			String jobName="";
			if(args.length>=5){
				for(int i=0; i<args.length-5; i++)
					jobName+= args[5+i] + " ";
			}
			jobName= jobName.trim();
			
			System.out.println("TestRefextractService client started with arguments: ");
			System.out.println("Refextract Factory Service: "+ args[0] );
			System.out.println("Scope:                      "+ args[1] );
			System.out.println("Key:                        "+ args[2] );
			System.out.println("Access:                     "+ args[3] );
			System.out.println("Value:                      "+ args[4] );
			System.out.println("Adaptor:                    "+ subType.toString() );
			
			EndpointReferenceType factoryEPR = new EndpointReferenceType(new AttributedURI(args[0]));
			System.out.println("\nGetting factory stub...");
			RefextractServiceFactoryPortType stub1 = new RefextractServiceFactoryServiceAddressingLocator().getRefextractServiceFactoryPortTypePort(factoryEPR);
			stub1 = GCUBERemotePortTypeContext.getProxy(stub1,GCUBEScope.getScope(args[1].trim()));

			System.out.println("Preparing input of Refextract job...");
			Submit sub=new Submit();
			InputResource input=new InputResource();

			//Case 1: give input as FTP reference
			if(args[3].equals("Reference")){
				input.setResourceKey(args[2]);
				input.setResourceAccess("Reference");
				input.setResourceReference(args[4]);
			}
			//Case 2: give input as CMS reference
			else if(args[3].equals("CMSReference")){
				input.setResourceKey(args[2]);
				input.setResourceAccess("CMSReference");
				input.setResourceReference(args[4]);
			}
			//Case 3a: send input's payload in string form
			else if(args[3].equals("InMessageString")){
				input.setResourceKey(args[2]);
				input.setResourceAccess("InMessageString");
				input.setInMessageStringPayload( TestRefextractService.getStringFilePayload(args[4]));
			}
			//Case 3b: send input's payload in byte form
			else if(args[3].equals("InMessageBytes")){
				input.setResourceKey(args[2]);
				input.setResourceAccess("InMessageBytes");
				input.setInMessageBytePayload( TestRefextractService.getByteFilePayload(args[4]));
			}
			else{
				System.err.println(usage);
				System.exit(1);
			}
			
			//in case of grid adaptor, give proxy
			if( subType ==  SubmissionType.gridAdaptor ){
				try{
					sub.setGridProxy( getByteFilePayload(proxyPath));
				}catch(Exception ex){
					throw new Exception("To submit refextract job with grid adaptor, put proxy in " + proxyPath);
				}
			}
			
			///---> Submit Refectract job
			sub.setInputResource(input);
			sub.setJobName(jobName);
			sub.setOwner(owner);
			System.out.println("Submitting Refextract job...");
			EndpointReferenceType resourceEpr; 
			if( subType == SubmissionType.jdlAdaptor)
				resourceEpr =  stub1.submitJDL(sub).getEndpointReference();
			else 
				resourceEpr = stub1.submitGrid(sub).getEndpointReference();
			
			RefextractServicePortType stub2 = new  RefextractServiceAddressingLocator().getRefextractServicePortTypePort(resourceEpr);
			stub2=GCUBERemotePortTypeContext.getProxy(stub2,GCUBEScope.getScope(args[1]));
			System.out.println("Refextract job was submitted");
			
			//---> poll status every 5 seconds until completion
			System.out.println("Calling status() until completion\n");
			
			StatusResponseType status=null;
			do{
				
				status= stub2.status( new VOID() );
				System.out.println("Description:    " + status.getStatusDescription());
				System.out.println("Last poll date: " + status.getLastPollDate() );
				System.out.println("");
				Thread.sleep(pollPeriodMilliSeconds);

			}while (status.isCompleted()==false);

			//delete WS-resource
			if(destroyWSResources==true)
				stub2.destroy( new Destroy() );
			
			System.out.println("");
			System.out.println("Refextract Job has finished:");
			System.out.println("-----------------------------------------------------");
			System.out.println("Name:            " +     status.getJobName());
			System.out.println("Description:     " +     status.getStatusDescription());
			System.out.println("Submited:        " +	 status.getSubmitDate());
			System.out.println("Last Poll:       " +	 status.getLastPollDate());
			System.out.println("Error:           " +	 status.getError());
			System.out.println("ErrorDetails:    " + 	 status.getErrorDetails());
			System.out.println("out    ssid: 	 " + 	 status.getOutputSSID());
			System.out.println("stdout ssid: 	 " + 	 status.getJoboutSSID());
			System.out.println("stderr ssid: 	 " + 	 status.getJoberrSSID());
			
		}catch(Exception ex){
			ex.printStackTrace();
		}

	}
	
	
	
	public static String getStringFilePayload(String path) throws IOException
	{
		BufferedReader reader=new BufferedReader(new FileReader(new File(path)));
		StringBuilder buf=new StringBuilder();
		while(true)
		{
			String line = reader.readLine();
			if(line==null) break;
			buf.append(line);
			buf.append("\n");
		}
		reader.close();
		return buf.toString();
	}

	public static byte[] getByteFilePayload(String path) throws IOException
	{
		ByteArrayOutputStream bout=new ByteArrayOutputStream();
		BufferedInputStream bin=new BufferedInputStream(new FileInputStream(new File(path)));
		byte []b=new byte[4*1024];
		while(true)
		{
			int read=bin.read(b);
			if(read<0) break;
			bout.write(b, 0, read);
		}
		bin.close();
		bout.flush();
		bout.close();
		return bout.toByteArray();
	}
	

	
}
