package org.gcube.execution.rr.bridge;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;
import gr.uoa.di.madgik.commons.utils.XMLUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FieldModel 
{
	private static Logger logger = Logger.getLogger(FieldModel.class.getName());
	
	private static GenericResource mainResource;
	private static Map<String, GenericResource> fieldResources = new HashMap<String, GenericResource>();
	private static GenericResource metadataResource;
	private static GenericResource staticConfigResource;
	
	private static Set<String> fieldIds = new HashSet<String>();

	private static GenericResource getMostRecentResource(List<GenericResource> resources) throws Exception
	{
		long mostRecentTime=-1;
		GenericResource mostRecentResource=null;
		for(GenericResource resource : resources)
		{
			long updateTime=0;
			try{updateTime = Long.parseLong(resource.profile().description());}catch(Exception ex){continue;}
			if(updateTime> mostRecentTime) mostRecentResource=resource;
		}
		return mostRecentResource;
	}
	
	private static void processResources(Map<String, Map<String, GenericResource>> resources) throws Exception
	{
		Set<String> fieldResourceIds = new HashSet<String>();
		Set<String> fieldIdsInDirectory = new HashSet<String>();
		
		List<GenericResource> mainResources = new ArrayList<GenericResource>();
		for(Map<String, GenericResource> resourcesInScope : resources.values())
		{
			GenericResource mainResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName);
			if(mainResource!=null) mainResources.add(mainResource);
		}
		mainResource = getMostRecentResource(mainResources);

		boolean foundDirectory = false;
		Document fieldsDOM=null;
		if(mainResource != null && 
			getStringOfElement(mainResource.profile().body())!=null && 
			getStringOfElement(mainResource.profile().body()).trim().length()!=0)
		{
			fieldsDOM = XMLUtils.Deserialize(getStringOfElement(mainResource.profile().body()));
			foundDirectory = true;
		}
		
		if(foundDirectory == true)
		{
			boolean flatModel = false;
			List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields") , "field");
			if(xmlObjs.size()!=0)
				flatModel = true;
			else
				xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
				
			for(Element elem : xmlObjs)
			{
				if(!flatModel)
					fieldIdsInDirectory.add(elem.getFirstChild().getNodeValue());
				else
					fieldIdsInDirectory.add(XMLUtils.GetChildElementWithName(elem, "id").getFirstChild().getNodeValue());
			}
			FieldModel.fieldIds.addAll(fieldIdsInDirectory);
		}
		
		List<GenericResource> metadataResources = new ArrayList<GenericResource>();
		for(Map<String, GenericResource> resourcesInScope : resources.values())
		{
			GenericResource metadataResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName+".Metadata");
			if(metadataResource!=null) metadataResources.add(metadataResource);
		}
		metadataResource = getMostRecentResource(metadataResources);
		
		List<GenericResource> staticConfigResources = new ArrayList<GenericResource>();
		for(Map<String, GenericResource> resourcesInScope : resources.values())
		{
			GenericResource staticConfigResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName+".StaticConfig");
			if(staticConfigResource!=null) staticConfigResources.add(staticConfigResource);
		}
		staticConfigResource = getMostRecentResource(staticConfigResources);
		
		if(foundDirectory)
		{
			for(Map<String, GenericResource> resourcesInScope : resources.values())
			{
				for(Map.Entry<String, GenericResource> r : resourcesInScope.entrySet())
				{
					if(r.getKey().startsWith(GCubeRepositoryProvider.RRModelGenericResourceName+".")) fieldResourceIds.add(r.getValue().profile().name().substring(r.getValue().profile().name().indexOf(".")+1));
				}
			}
			
			for(String fieldResourceId : fieldResourceIds)
			{
				if(!fieldIdsInDirectory.contains(fieldResourceId)) continue;
				List<GenericResource> fieldResources = new ArrayList<GenericResource>();
				for(Map<String, GenericResource> resourcesInScope : resources.values())
				{
					GenericResource fieldResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName+"."+fieldResourceId);
					if(fieldResource!=null) fieldResources.add(fieldResource);
				}
				GenericResource fr = getMostRecentResource(fieldResources);
				if(fr!=null) FieldModel.fieldResources.put(fieldResourceId, fr);
			}
		}
		
	}
	
	public static void retrieve() throws Exception
	{
		mainResource = null;
		fieldResources = new HashMap<String, GenericResource>();
		metadataResource = null;
		staticConfigResource = null;
		fieldIds = new HashSet<String>();
			
		List<String> scopes = BridgeHelper.getFieldModelScopes();
		
		Map<String, Map<String, GenericResource>> resources=new HashMap<String, Map<String, GenericResource>>();
		for(String scope : scopes)
		{
			logger.info("Retrieving field model generic resources in scope " + scope.toString());
			
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(GenericResource.class);
			query.addCondition("$resource/Profile/SecondaryType/text() eq '" + GCubeRepositoryProvider.RRModelGenericResourceName + "'");
			DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
			
			List<GenericResource> res = client.submit(query);
			if(!resources.containsKey(scope.toString())) resources.put(scope.toString(), new HashMap<String, GenericResource>());
			for(GenericResource r : res)
				resources.get(scope.toString()).put(r.profile().name(), r);
		}
		processResources(resources);
		logger.info("Processed field model generic resources: " + (mainResource != null ? "1" : "0") + " field directory resources containing " + fieldIds.size() + " field references, " + 
				fieldResources.keySet().size() + " field resources, " + (metadataResource != null ? "1" : "0") + " element metadata resources, " + 
				(staticConfigResource != null ? "1" : "0") + " static configuration resources.");
	}
	
	public static String getMainResource()
	{
		if(mainResource == null || 
				getStringOfElement(mainResource.profile().body())==null ||
				getStringOfElement(mainResource.profile().body()).trim().length()==0) return null;
		 return getStringOfElement(mainResource.profile().body());
	}
	
	public static String getMetadataResource()
	{
		if(metadataResource == null || 
				getStringOfElement(metadataResource.profile().body())==null ||
				getStringOfElement(metadataResource.profile().body()).trim().length()==0) return null;
		 return getStringOfElement(metadataResource.profile().body());
	}
	
	public static String getStaticConfigResource()
	{
		if(staticConfigResource == null ||
				getStringOfElement(staticConfigResource.profile().body()) == null ||
				getStringOfElement(staticConfigResource.profile().body()).trim().length()==0) return null;
		return getStringOfElement(staticConfigResource.profile().body());
	}
	
	public static Set<String> getFieldIds()
	{
		return fieldIds;
	}
	
	public static String getFieldResource(String id)
	{
		GenericResource fieldResource = fieldResources.get(id);
		if(fieldResource == null || 
				getStringOfElement(fieldResource.profile().body())==null ||
				getStringOfElement(fieldResource.profile().body()).trim().length()==0) return null;
		 return getStringOfElement(fieldResource.profile().body());
	}
	
	public static String getStringOfElement(Element el){
		XPathHelper xpath = new XPathHelper(el);
		String text = xpath.evaluate("/").get(0);
		text = text.substring("<doc>".length());
		text = text.substring(0, text.length() - "</doc>".length());
		
		return text;
	}
	
}
