package org.gcube.execution.rr.configuration;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationProviderLoader {
	
	private static Logger logger=Logger.getLogger(ConfigurationProviderLoader.class.getName());
	private static ConfigurationProvider configurationProvider =  null;

	public static synchronized ConfigurationProvider getProvider(){
		if (configurationProvider != null)
			return configurationProvider;
		
		ServiceLoader<ConfigurationProvider> loader = ServiceLoader.load(ConfigurationProvider.class, Thread.currentThread().getContextClassLoader());
		
		
		for (ConfigurationProvider cp : ServiceLoader.load(ConfigurationProvider.class, Thread.currentThread().getContextClassLoader())){
			logger.log(Level.INFO, "found " + ConfigurationProvider.class.getName() + " impl " + cp.getClass());
		}
		
		for (ConfigurationProvider cp : loader){
			logger.log(Level.INFO, "got " + ConfigurationProvider.class.getName() + " impl " + cp.getClass());
			configurationProvider = cp;
			break;
		}
		if (configurationProvider == null){
			logger.log(Level.WARNING, "No " + ConfigurationProvider.class.getName() + " no implementations found");
			throw new Error("No " + ConfigurationProvider.class.getName() + " no implementations found");
		}
		return configurationProvider;
	}
	
	public static void main(String[] args) {
		getProvider();
	}
}
