/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataCollectionDao;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServerDao;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServiceDao;
import gr.uoa.di.madgik.rr.element.execution.SearchServiceDao;
import gr.uoa.di.madgik.rr.element.execution.WorkflowServiceDao;
import gr.uoa.di.madgik.rr.element.functionality.Functionality;
import gr.uoa.di.madgik.rr.element.functionality.FunctionalityDao;
import gr.uoa.di.madgik.rr.element.infra.HostingNode;
import gr.uoa.di.madgik.rr.element.infra.HostingNodeDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndex;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FWIndex;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndex;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexService;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSource;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceServiceDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.execution.rr.bridge.DataSourceDescription;
import org.gcube.execution.rr.bridge.FieldModel;
import org.gcube.execution.rr.bridge.GCubeRepositoryProvider;
import org.gcube.execution.rr.configuration.ConfigurationProviderLoader;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BridgeHelper {
    private static Logger logger = Logger.getLogger(BridgeHelper.class.getName());
    private static List<String> scopes = null;
    private static List<String> searchSystemScopes = null;
    private static Set<IDaoElement> searchSystemServices = null;
    public static final String ENDPOINT_KEY = "resteasy-servlet";
    private static final String JNDI_NAME = "gcube/data/tm";
    private static final String TREADER_NAME = "gcube/data/tm/reader";
    private static final String SOURCENAME_RPNAME = "Name";
    private static final String SOURCEID_RPNAME = "SourceId";
    private static final String CARDINALITY_RPNAME = "Cardinality";

    public static void initializeIndexTypes() {
        DataSource.clearSubTypes();
        DataSource.addSubType((DataSource.Type)DataSource.Type.FullTextIndex, FTIndex.class, FTIndexDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.ForwardIndex, FWIndex.class, FWIndexDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.GeoIndex, GeoIndex.class, GeoIndexDao.class);
        DataSource.addSubType((DataSource.Type)DataSource.Type.OpenSearch, OpenSearchDataSource.class, OpenSearchDataSourceDao.class);
        DataSourceService.clearSubTypes();
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.GeoIndex, GeoIndexService.class, GeoIndexServiceDao.class);
        DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.OpenSearch, OpenSearchDataSourceService.class, OpenSearchDataSourceServiceDao.class);
    }

    public static void initializeIndexTypes(Properties config) throws ResourceRegistryException {
        try {
            String value;
            String key;
            String type;
            int i;
            HashSet res;
            int count = Integer.parseInt(config.getProperty("dataSourceSubTypesCount", "0"));
            if (count != 0) {
                DataSource.clearSubTypes();
                res = new HashSet(count);
                for (i = 0; i < count; ++i) {
                    type = config.getProperty("dataSourceSubTypesType." + i);
                    if (type == null) {
                        throw new ResourceRegistryException("Could not read datasource type #" + i);
                    }
                    key = config.getProperty("dataSourceSubTypesKey." + i);
                    if (key == null) {
                        throw new ResourceRegistryException("Could not read datasource class name #" + i);
                    }
                    value = config.getProperty("dataSourceSubTypesValue." + i);
                    if (value == null) {
                        throw new ResourceRegistryException("Could not read datasource dao class name #" + i);
                    }
                    DataSource.addSubType((DataSource.Type)DataSource.Type.valueOf((String)type), Class.forName(key), Class.forName(value));
                    logger.log(Level.INFO, "Adding DataSource type: " + type + "-" + key + "-" + value);
                }
            }
            if ((count = Integer.parseInt(config.getProperty("dataSourceServiceSubTypesCount", "0"))) != 0) {
                DataSourceService.clearSubTypes();
                res = new HashSet(count);
                for (i = 0; i < count; ++i) {
                    type = config.getProperty("dataSourceServiceSubTypesType." + i);
                    if (type == null) {
                        throw new ResourceRegistryException("Could not read datasource service type #" + i);
                    }
                    key = config.getProperty("dataSourceServiceSubTypesKey." + i);
                    if (key == null) {
                        throw new ResourceRegistryException("Could not read datasource service class name #" + i);
                    }
                    value = config.getProperty("dataSourceServiceSubTypesValue." + i);
                    if (value == null) {
                        throw new ResourceRegistryException("Could not read datasource service dao class name #" + i);
                    }
                    DataSourceService.addSubType((DataSourceService.Type)DataSourceService.Type.valueOf((String)type), Class.forName(key), Class.forName(value));
                    logger.log(Level.INFO, "Adding DataSource service type: " + type + "-" + key + "-" + value);
                }
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while initializing datasource types", (Throwable)e);
        }
    }

    public static void retrieveScopes() throws Exception {
        if (BridgeHelper.isClientMode()) {
            BridgeHelper.retrieveScopesOffline();
        } else {
            BridgeHelper.retrieveScopesOnline();
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuilder logScopes = new StringBuilder();
            for (String scope : scopes) {
                logScopes.append(scope.toString());
                logScopes.append(" ");
            }
            logger.log(Level.INFO, "Scopes: " + logScopes.toString());
        }
        searchSystemServices = BridgeHelper.retrieveSearchService();
        HashSet searchSystemScopeSet = new HashSet();
        for (IDaoElement searchSystemService : searchSystemServices) {
            searchSystemScopeSet.addAll(((SearchServiceDao)searchSystemService).scopes);
        }
        searchSystemScopes = new ArrayList<String>();
        boolean i = false;
        logger.log(Level.INFO, "searchSystemScopeSet contains : " + searchSystemScopeSet);
        for (String s : searchSystemScopeSet) {
            searchSystemScopes.add(s);
        }
    }

    public static List<String> getFieldModelScopes() throws Exception {
        HashSet<String> fieldScopes = new HashSet<String>();
        for (String scope : searchSystemScopes) {
            ScopeBean bean = new ScopeBean(scope);
            if (bean.is(ScopeBean.Type.INFRASTRUCTURE)) {
                logger.log(Level.INFO, scope + " is infra scope");
                continue;
            }
            if (bean.is(ScopeBean.Type.VO)) {
                logger.log(Level.INFO, scope + " is a VO scope");
            } else if (bean.is(ScopeBean.Type.VRE)) {
                logger.log(Level.INFO, scope + " is a VRE scope. Will add : " + bean.enclosingScope().toString());
            }
            if (bean.is(ScopeBean.Type.VO)) {
                fieldScopes.add(scope);
                continue;
            }
            if (!bean.is(ScopeBean.Type.VRE)) continue;
            fieldScopes.add(bean.enclosingScope().toString());
        }
        ArrayList<String> gCubeScopes = new ArrayList<String>();
        logger.log(Level.FINE, "#### searchSystemScopes : " + searchSystemScopes);
        logger.log(Level.FINE, "#### FieldModelScopes   : " + fieldScopes);
        for (String scope : fieldScopes) {
            gCubeScopes.add(scope);
        }
        return gCubeScopes;
    }

    private static void retrieveScopesOnline() throws Exception {
        List<String> tmpScopes = BridgeHelper.getGHNContextScopes();
        logger.log(Level.INFO, "retrieveScopesOnline : " + tmpScopes);
        ArrayList<String> toKeepScopes = new ArrayList<String>();
        for (String scope : tmpScopes) {
            ScopeBean bean = new ScopeBean(scope);
            if (bean.is(ScopeBean.Type.INFRASTRUCTURE)) continue;
            toKeepScopes.add(scope);
        }
        logger.log(Level.INFO, "retrieveScopesOnline after additions : " + toKeepScopes);
        scopes = new ArrayList<String>(toKeepScopes);
    }

    private static void retrieveScopesOffline() throws Exception {
        List<String> scopes = BridgeHelper.getGHNContextStartScopes();
        logger.log(Level.INFO, "retrieveScopesOffline : " + scopes);
        List<GenericResource> resources = BridgeHelper.getPublishedVREResources();
        for (GenericResource resource : resources) {
            String retrievedScope = BridgeHelper.getVREScope(resource);
            if (retrievedScope == null) continue;
            scopes.add(retrievedScope);
        }
        logger.log(Level.INFO, "retrieveScopesOffline after additions : " + scopes);
        BridgeHelper.scopes = new ArrayList<String>(scopes);
    }

    private static List<GenericResource> getPublishedVREResources() throws Exception {
        logger.log(Level.INFO, "Searching for publised VRE resouces");
        ArrayList<GenericResource> resources = new ArrayList<GenericResource>();
        List<String> scopes = BridgeHelper.getGHNContextStartScopes();
        logger.log(Level.INFO, "getPublishedVREResources : " + scopes);
        Set<String> voScopes = BridgeHelper.getVOScopes(scopes);
        for (String scope : voScopes) {
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType/text() eq 'VRE'");
            logger.log(Level.INFO, "query      : " + query.toString());
            logger.log(Level.INFO, "query expr : " + query.expression());
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            resources.addAll(client.submit((Query)query));
        }
        return resources;
    }

    private static String getVREScope(GenericResource resource) throws Exception {
        if (resource != null && resource.scopes() != null && resource.scopes().size() > 0) {
            return (String)resource.scopes().toArray()[0];
        }
        return null;
    }

    public static Set<IDaoElement> getElement(Class<?> type) throws Exception {
        if (type.equals(FieldDao.class)) {
            return BridgeHelper.getFields();
        }
        if (type.equals(PresentableDao.class)) {
            return BridgeHelper.getPresentables();
        }
        if (type.equals(SearchableDao.class)) {
            return BridgeHelper.getSearchables();
        }
        if (type.equals(DataCollectionDao.class)) {
            return BridgeHelper.getAllCollections();
        }
        if (type.equals(HostingNodeDao.class)) {
            return BridgeHelper.getHostingNodes();
        }
        if (type.equals(FunctionalityDao.class)) {
            return BridgeHelper.getFunctionality();
        }
        if (type.equals(ExecutionServerDao.class)) {
            return BridgeHelper.getExecutionServer();
        }
        if (type.equals(ExecutionServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(WorkflowServiceDao.class)) {
            return BridgeHelper.getWorkflowService();
        }
        if (type.equals(FieldIndexContainerDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(FTIndexDao.class)) {
            return BridgeHelper.getFTIndex();
        }
        if (type.equals(FWIndexDao.class)) {
            return BridgeHelper.getFWIndex();
        }
        if (type.equals(GeoIndexDao.class)) {
            return BridgeHelper.getGeoIndex();
        }
        if (type.equals(OpenSearchDataSourceDao.class)) {
            return BridgeHelper.getOpenSearchDataSource();
        }
        if (type.equals(FTIndexServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(FWIndexServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(GeoIndexServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(OpenSearchDataSourceServiceDao.class)) {
            return new HashSet<IDaoElement>();
        }
        if (type.equals(ElementMetadataDao.class)) {
            return BridgeHelper.getElementMetadata();
        }
        if (type.equals(StaticConfigurationDao.class)) {
            return BridgeHelper.getStaticConfiguration();
        }
        throw new ResourceRegistryException("unrecognized element type " + type);
    }

    private static Set<IDaoElement> getDataSource(String className, String serviceClassName, String serviceClass, String serviceName, String functionality, DataSource.Type type, String description) throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        logger.log(Level.WARNING, "### getting datasources from scopes : " + scopes);
        HashMap<String, DataSourceDao> datasourceItems = new HashMap<String, DataSourceDao>();
        HashMap<String, DataSourceServiceDao> datasourceServiceItems = new HashMap<String, DataSourceServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        for (String scope : scopes) {
            logger.log(Level.INFO, "Searching for " + description + " indexes in scope " + scope.toString());
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(ServiceInstance.class);
            query.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'");
            logger.log(Level.INFO, "query      : " + query.toString());
            logger.log(Level.INFO, "query expr : " + query.expression());
            DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
            List resources = client.submit((Query)query);
            logger.log(Level.INFO, "found  " + resources.size() + " " + description + "  in scope " + scope.toString());
            for (ServiceInstance r : resources) {
                logger.log(Level.INFO, "resource key : " + r.key() + " datasourcetimes : " + datasourceItems + " scope : " + scope);
                if (r.key() == null) continue;
                String key = r.key();
                if (datasourceItems.containsKey(key)) {
                    for (String datasourceScope : r.properties().scopes()) {
                        logger.log(Level.FINE, "adding scope : " + datasourceScope);
                        ((DataSourceDao)datasourceItems.get(key)).getScopes().add(datasourceScope);
                        ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(datasourceScope);
                    }
                    ((DataSourceDao)datasourceItems.get(key)).getScopes().add(scope.toString());
                    ((DataSourceServiceDao)datasourceServiceItems.get(key)).getScopes().add(scope.toString());
                    continue;
                }
                DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
                ss.setID(key);
                ss.setType(type.toString());
                ss.getDataSources().add(key);
                logger.log(Level.FINE, "------- endpoint : " + r.endpoint().toString());
                ss.setEndpoint(r.endpoint().toString());
                ss.setFunctionality(functionality);
                ss.setHostingNode(r.properties().nodeId());
                ss.getScopes().addAll(r.properties().scopes());
                ss.getScopes().add(scope);
                ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
                datasourceServiceItems.put(ss.getID(), ss);
                DataSourceDao s = (DataSourceDao)Class.forName(className).newInstance();
                s.setID(key);
                s.setType(type.toString());
                s.setFunctionality(functionality);
                if (s.getBoundDataSourceServices() == null) {
                    s.setBoundDataSourceServices(new HashSet());
                }
                s.getBoundDataSourceServices().add(key);
                s.setTimestamp(Calendar.getInstance().getTimeInMillis());
                s.getCapabilities().clear();
                XPathHelper xpath = new XPathHelper((Node)r.properties().customProperties());
                for (String capability : xpath.evaluate("/doc/*[local-name()='SupportedRelations']/text()")) {
                    s.getCapabilities().add(capability);
                }
                s.getScopes().addAll(r.properties().scopes());
                s.getScopes().add(scope);
                HashSet<String> checkDups = new HashSet<String>();
                xpath = new XPathHelper((Node)r.properties().customProperties());
                for (String f : xpath.evaluate("/doc/*[local-name()='Fields']/text()")) {
                    logger.log(Level.FINE, "Custom properties f : " + f);
                    String[] fparts = f.split(":");
                    if (fparts.length == 6 && fparts[2].equals("s")) {
                        fparts[4] = fparts[4] + ":" + fparts[5];
                    }
                    if (fparts.length < 4 || fparts.length > 6 || fparts.length == 6 && !fparts[2].equals("s")) continue;
                    FieldIndexContainerDao fc = new FieldIndexContainerDao();
                    fc.setID(s.getID() + ":" + f);
                    if (checkDups.contains(fc.getID())) {
                        logger.log(Level.WARNING, "Duplicate field detected: " + fc.getID());
                        continue;
                    }
                    checkDups.add(fc.getID());
                    fc.setCollection(fparts[0]);
                    fc.setLanguage(fparts[1]);
                    fc.setFieldType(fparts[2]);
                    fc.setField(fparts[3]);
                    if (fparts.length >= 5) {
                        fc.setExpression(fparts[4]);
                    }
                    s.getFields().add(fc.getID());
                    fieldItems.add(fc);
                }
                logger.log(Level.INFO, "datasource : " + s.getID());
                logger.log(Level.INFO, "datasource fields : " + s.getFields());
                logger.log(Level.INFO, "datasource scopes : " + s.getScopes());
                datasourceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(datasourceServiceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getFTIndex() throws Exception {
        return BridgeHelper.getDataSource(FTIndexDao.class.getName(), FTIndexServiceDao.class.getName(), "Index", "FullTextIndexNode", "search.index.ft", DataSource.Type.FullTextIndex, "full text");
    }

    private static Set<IDaoElement> getFakeFTIndex() throws Exception {
        FieldIndexContainerDao fc;
        String[] fparts;
        HashMap<String, FTIndexDao> datasourceItems = new HashMap<String, FTIndexDao>();
        HashMap<String, FTIndexServiceDao> serviceItems = new HashMap<String, FTIndexServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        FTIndexServiceDao ss = new FTIndexServiceDao();
        ss.setID("1283-5c96-f869-172b");
        ss.setFunctionality("search.index.ft");
        ss.setHostingNode("FTIndexGHNOne");
        ss.setEndpoint("http://nowhere1.com/wsrf/index/fulltext");
        ss.getScopes().add("/no/scope/");
        ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
        ss.setType(DataSource.Type.FullTextIndex.toString());
        serviceItems.put(ss.getID(), ss);
        FTIndexDao s = new FTIndexDao();
        s.setID("1283-5c96-f869-172b");
        s.setType(DataSource.Type.FullTextIndex.toString());
        s.setFunctionality("search.index.ft");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ArrayList<String> ff = new ArrayList<String>();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:title");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:title");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:source");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:source");
        for (String f : ff) {
            fparts = f.split(":");
            if (fparts.length != 4) continue;
            fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        ss = new FTIndexServiceDao();
        ss.setID("768a-8ab8-1281-9812");
        ss.setType(DataSource.Type.FullTextIndex.toString());
        ss.setHostingNode("FTIndexGHNTwo");
        ss.setEndpoint("http://nowhere2.com/wsrf/index/fulltext");
        serviceItems.put(ss.getID(), ss);
        s = new FTIndexDao();
        s.setID("768a-8ab8-1281-9812");
        s.setType(DataSource.Type.FullTextIndex.toString());
        s.setFunctionality("search.index.ft");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ff = new ArrayList();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:type");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:type");
        for (String f : ff) {
            fparts = f.split(":");
            if (fparts.length != 4) continue;
            fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(serviceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getFWIndex() throws Exception {
        return BridgeHelper.getDataSource(FWIndexDao.class.getName(), FWIndexServiceDao.class.getName(), "Index", "ForwardIndexNode", "search.index.fw", DataSource.Type.ForwardIndex, "forward index");
    }

    private static Set<IDaoElement> getGeoIndex() throws Exception {
        return BridgeHelper.getDataSource(GeoIndexDao.class.getName(), GeoIndexServiceDao.class.getName(), "Index", "GeoIndexLookup", "search.index.geo", DataSource.Type.GeoIndex, "geo");
    }

    private static Set<IDaoElement> getOpenSearchDataSource() throws Exception {
        return BridgeHelper.getDataSource(OpenSearchDataSourceDao.class.getName(), OpenSearchDataSourceServiceDao.class.getName(), "OpenSearch", "OpenSearchDataSource", "search.index.opensearch", DataSource.Type.OpenSearch, "opensearch");
    }

    private static Set<IDaoElement> getFakeFWIndex() throws Exception {
        HashMap<String, FWIndexDao> datasourceItems = new HashMap<String, FWIndexDao>();
        HashMap<String, FWIndexServiceDao> serviceItems = new HashMap<String, FWIndexServiceDao>();
        HashSet<FieldIndexContainerDao> fieldItems = new HashSet<FieldIndexContainerDao>();
        FWIndexServiceDao ss = new FWIndexServiceDao();
        ss.setID("8b77-1111-89b1-c128");
        ss.setType(DataSource.Type.ForwardIndex.toString());
        ss.setFunctionality("search.index.fw");
        ss.setHostingNode("FWIndexGHNOne");
        ss.setEndpoint("http://nowhere3.com/wsrf/index/forward");
        ss.getScopes().add("/no/scope/");
        serviceItems.put(ss.getID(), ss);
        FWIndexDao s = new FWIndexDao();
        s.setID("8b77-1111-89b1-c128");
        s.setType(DataSource.Type.ForwardIndex.toString());
        s.setFunctionality("search.index.fw");
        s.getCapabilities().clear();
        s.getCapabilities().add("any");
        s.getFields().clear();
        s.getScopes().add("/no/scope/");
        ArrayList<String> ff = new ArrayList<String>();
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:identifier");
        ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:identifier");
        for (String f : ff) {
            String[] fparts = f.split(":");
            if (fparts.length != 4) continue;
            FieldIndexContainerDao fc = new FieldIndexContainerDao();
            fc.setID(s.getID() + ":" + f);
            fc.setCollection(fparts[0]);
            fc.setLanguage(fparts[1]);
            fc.setFieldType(fparts[2]);
            fc.setField(fparts[3]);
            s.getFields().add(fc.getID());
            fieldItems.add(fc);
        }
        datasourceItems.put(s.getID(), s);
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(datasourceItems.values());
        retValue.addAll(fieldItems);
        return retValue;
    }

    private static Set<IDaoElement> getWorkflowService() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, WorkflowServiceDao> serviceItems = new HashMap<String, WorkflowServiceDao>();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            String serviceName = "WorkflowEngineService";
            String serviceClass = "Execution";
            query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List insts = client.submit((Query)query);
            logger.log(Level.INFO, "Found " + insts.size() + " workflow services in scope");
            for (GCoreEndpoint inst : insts) {
                Group eprs = inst.profile().endpoints();
                if (eprs.size() != 1) continue;
                HashSet<String> instScopes = new HashSet<String>();
                for (Object instSc : inst.scopes().toArray()) {
                    instScopes.add((String)instSc);
                }
                if (serviceItems.containsKey(inst.id())) {
                    ((WorkflowServiceDao)serviceItems.get(inst.id())).getScopes().addAll(instScopes);
                    continue;
                }
                WorkflowServiceDao s = new WorkflowServiceDao();
                GCoreEndpoint.Profile.Endpoint epr = (GCoreEndpoint.Profile.Endpoint)eprs.toArray()[0];
                logger.log(Level.FINE, "---- WorkflowService uri    : " + epr.uri().toString());
                logger.log(Level.FINE, "---- WorkflowService name   : " + epr.name());
                logger.log(Level.FINE, "---- WorkflowService string : " + epr.toString());
                s.setEndpoint(epr.uri().toString());
                s.setFunctionality("execution.workflow");
                s.setID(inst.id());
                s.setHostingNode(inst.profile().ghnId());
                s.getScopes().addAll(new HashSet(instScopes));
                serviceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        return retValue;
    }

    private static Set<IDaoElement> getSearchService() {
        return searchSystemServices;
    }

    private static Set<IDaoElement> retrieveSearchService() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, SearchServiceDao> serviceItems = new HashMap<String, SearchServiceDao>();
        for (String scope : scopes) {
            logger.log(Level.INFO, "Searching for search system services in scope " + scope.toString());
            ScopeProvider.instance.set(scope.toString());
            logger.log(Level.INFO, " scope set : " + ScopeProvider.instance.get());
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            logger.log(Level.INFO, " query : " + query);
            String serviceName = "SearchSystemService";
            String serviceClass = "Search";
            query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
            logger.log(Level.INFO, " query : " + query);
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List insts = client.submit((Query)query);
            logger.log(Level.INFO, "Found " + insts.size() + " search services in scope");
            for (GCoreEndpoint inst : insts) {
                Group eprs = inst.profile().endpoints();
                if (inst == null || inst.profile() == null || inst.profile().endpointMap() == null) continue;
                GCoreEndpoint.Profile.Endpoint epr = (GCoreEndpoint.Profile.Endpoint)inst.profile().endpointMap().get(ENDPOINT_KEY);
                if (epr == null) {
                    logger.log(Level.INFO, "running instance : " + inst.id() + " has no searchsystemservice epr");
                    continue;
                }
                String riStatus = inst.profile().deploymentData().status();
                if (!riStatus.equalsIgnoreCase("ready")) {
                    logger.log(Level.INFO, "running instance : " + inst.id() + " is NOT ready");
                    continue;
                }
                HashSet<String> instScopes = new HashSet<String>();
                for (Object instSc : inst.scopes().toArray()) {
                    instScopes.add((String)instSc);
                }
                logger.log(Level.INFO, "Scopes of " + inst.id() + " : " + instScopes);
                if (serviceItems.containsKey(inst.id())) {
                    ((SearchServiceDao)serviceItems.get(inst.id())).getScopes().addAll(instScopes);
                    continue;
                }
                SearchServiceDao s = new SearchServiceDao();
                s.setEndpoint(epr.uri().toString());
                s.setFunctionality("search.orchestrator");
                s.setID(inst.id());
                s.setHostingNode(inst.profile().ghnId());
                s.getScopes().addAll(new HashSet(instScopes));
                serviceItems.put(s.getID(), s);
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        return retValue;
    }

    private static Set<IDaoElement> getExecutionServer() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, ExecutionServerDao> serverItems = new HashMap<String, ExecutionServerDao>();
        HashMap<String, ExecutionServiceDao> serviceItems = new HashMap<String, ExecutionServiceDao>();
        for (String scope : scopes) {
            logger.log(Level.INFO, "Searching for execution engine services in scope " + scope.toString());
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            String serviceName = "ExecutionEngineService";
            String serviceClass = "Execution";
            query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List insts = client.submit((Query)query);
            logger.log(Level.INFO, "Found " + insts.size() + " execution services in scope");
            for (GCoreEndpoint inst : insts) {
                try {
                    if (inst == null || inst.profile() == null || inst.profile().endpointMap() == null) continue;
                    String riStatus = inst.profile().deploymentData().status();
                    if (!riStatus.equalsIgnoreCase("ready")) {
                        logger.log(Level.INFO, "running instance : " + inst.id() + " is NOT ready");
                        continue;
                    }
                    GCoreEndpoint.Profile.Endpoint epr = (GCoreEndpoint.Profile.Endpoint)inst.profile().endpointMap().get(ENDPOINT_KEY);
                    if (epr == null) {
                        logger.log(Level.INFO, "running instance : " + inst.id() + " has no execution engine service epr");
                        continue;
                    }
                    HashSet<String> instScopes = new HashSet<String>();
                    for (Object instSc : inst.scopes().toArray()) {
                        instScopes.add((String)instSc);
                    }
                    logger.log(Level.INFO, "Scopes of execution engine service with id : " + inst.id() + " : " + instScopes);
                    if (serviceItems.containsKey(inst.id())) {
                        ((ExecutionServiceDao)serviceItems.get(inst.id())).getScopes().addAll(instScopes);
                    } else {
                        ExecutionServiceDao s = new ExecutionServiceDao();
                        s.setEndpoint(epr.uri().toString());
                        s.setFunctionality("execution.execute");
                        s.setID(inst.id());
                        s.setHostingNode(inst.profile().ghnId());
                        s.getScopes().addAll(new HashSet(instScopes));
                        serviceItems.put(s.getID(), s);
                    }
                    String sd = null;
                    XPathHelper xpath = new XPathHelper((Node)inst.profile().specificData());
                    Iterator i$ = xpath.evaluate("/").iterator();
                    while (i$.hasNext()) {
                        String val;
                        sd = val = (String)i$.next();
                    }
                    if (sd == null || sd.trim().length() == 0) continue;
                    sd = sd.substring("<doc>".length());
                    sd = sd.substring(0, sd.length() - "</doc>".length());
                    System.out.println(sd);
                    Document doc = XMLUtils.Deserialize((String)sd);
                    List elems = XMLUtils.GetChildElementsWithName((Node)doc.getDocumentElement(), (String)"element");
                    String hostname = null;
                    String port = null;
                    String elemId = null;
                    for (Element el : elems) {
                        elemId = XMLUtils.GetAttribute((Element)el, (String)"id");
                        Element dynElem = XMLUtils.GetChildElementWithName((Node)el, (String)"dynamic");
                        List dynPairs = XMLUtils.GetChildElementsWithName((Node)dynElem, (String)"entry");
                        for (Element pair : dynPairs) {
                            String attrVal;
                            if (!XMLUtils.AttributeExists((Element)pair, (String)"pe2ng.port").booleanValue()) {
                                if (!XMLUtils.AttributeExists((Element)pair, (String)"key").booleanValue()) continue;
                                attrVal = XMLUtils.GetAttribute((Element)pair, (String)"key");
                                if (attrVal != null && attrVal.equals("pe2ng.port")) {
                                    port = XMLUtils.GetChildText((Node)pair);
                                }
                            } else {
                                port = XMLUtils.GetAttribute((Element)pair, (String)"pe2ng.port");
                            }
                            if (!XMLUtils.AttributeExists((Element)pair, (String)"hostname").booleanValue()) {
                                if (!XMLUtils.AttributeExists((Element)pair, (String)"key").booleanValue() || (attrVal = XMLUtils.GetAttribute((Element)pair, (String)"key")) == null || !attrVal.equals("hostname")) continue;
                                hostname = XMLUtils.GetChildText((Node)pair);
                                break;
                            }
                            hostname = XMLUtils.GetAttribute((Element)pair, (String)"hostname");
                            break;
                        }
                        if (port == null || hostname == null) continue;
                        break;
                    }
                    if (port != null) {
                        if (serverItems.containsKey(elemId)) {
                            ((ExecutionServerDao)serverItems.get(elemId)).getScopes().addAll(instScopes);
                        } else {
                            ExecutionServerDao ss = new ExecutionServerDao();
                            ss.setFunctionality("execution.execute");
                            ss.setHostingNode(inst.profile().ghnId());
                            ss.setID(elemId);
                            ss.setHostname(hostname);
                            ss.setPort(port);
                            ss.getScopes().addAll(instScopes);
                            serverItems.put(ss.getID(), ss);
                        }
                    }
                    System.out.println("found execution server at : " + hostname + " : " + port);
                    logger.log(Level.INFO, "found execution server at : " + hostname + " : " + port);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error parsing the running instance : " + inst.id(), e);
                }
            }
        }
        HashSet<IDaoElement> retValue = new HashSet<IDaoElement>();
        retValue.addAll(serviceItems.values());
        retValue.addAll(serverItems.values());
        logger.log(Level.INFO, "Found " + serverItems.values().size() + " execution servers");
        return retValue;
    }

    private static Set<IDaoElement> getFunctionality() throws Exception {
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        FunctionalityDao f = new FunctionalityDao();
        f.setName("execution.execute");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("execution.workflow");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.ft");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.fw");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.geo");
        items.add((IDaoElement)f);
        f = new FunctionalityDao();
        f.setName("search.index.opensearch");
        items.add((IDaoElement)f);
        return items;
    }

    private static Set<IDaoElement> getHostingNodes() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, HostingNodeDao> items = new HashMap<String, HostingNodeDao>();
        for (String scope : scopes) {
            logger.log(Level.INFO, "Searching for hosting nodes in scope " + scope.toString());
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(org.gcube.common.resources.gcore.HostingNode.class);
            String serviceName = "WorkflowEngineService";
            String serviceClass = "Execution";
            DiscoveryClient client = ICFactory.clientFor(org.gcube.common.resources.gcore.HostingNode.class);
            List insts = client.submit((Query)query);
            logger.log(Level.INFO, "Found " + insts.size() + " nodes in scope");
            for (org.gcube.common.resources.gcore.HostingNode node : insts) {
                HashSet<String> nodeScopes = new HashSet<String>();
                for (Object instSc : node.scopes().toArray()) {
                    nodeScopes.add((String)instSc);
                }
                if (items.containsKey(node.id())) {
                    ((HostingNodeDao)items.get(node.id())).getScopes().addAll(nodeScopes);
                    continue;
                }
                HostingNodeDao item = new HostingNodeDao();
                item.setID(node.id());
                item.setScopes(new HashSet(nodeScopes));
                try {
                    item.getPairKeys().add("hn.infrastructure");
                    item.getPairValues().add("hn.infrastructure##delim##" + node.profile().infrastructure());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.country");
                    item.getPairValues().add("hn.country##delim##" + node.profile().site().country());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.domain");
                    item.getPairValues().add("hn.domain##delim##" + node.profile().site().domain());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.latitude");
                    item.getPairValues().add("hn.latitude##delim##" + node.profile().site().latitude());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.longitude");
                    item.getPairValues().add("hn.longitude##delim##" + node.profile().site().longitude());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.location");
                    item.getPairValues().add("hn.location##delim##" + node.profile().site().location());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.platform");
                    item.getPairValues().add("hn.architecture.platform##delim##" + node.profile().description().architecture().platformType());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.smp");
                    item.getPairValues().add("hn.architecture.smp##delim##" + Long.toString(node.profile().description().architecture().smpSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.architecture.smt");
                    item.getPairValues().add("hn.architecture.smt##delim##" + Long.toString(node.profile().description().architecture().smtSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.benchmark.sf00");
                    item.getPairValues().add("hn.benchmark.sf00##delim##" + Long.toString(node.profile().description().benchmark().sf00()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.benchmark.si00");
                    item.getPairValues().add("hn.benchmark.si00##delim##" + Long.toString(node.profile().description().benchmark().si00()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_day");
                    item.getPairValues().add("hn.load.one_day##delim##" + Double.toString(node.profile().description().historicalLoad().lastDay()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_hour");
                    item.getPairValues().add("hn.load.one_hour##delim##" + Double.toString(node.profile().description().historicalLoad().lastHour()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_week");
                    item.getPairValues().add("hn.load.one_week##delim##" + Double.toString(node.profile().description().historicalLoad().lastWeek()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.one_min");
                    item.getPairValues().add("hn.load.one_min##delim##" + Double.toString(node.profile().description().load().lastMin()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.five_min");
                    item.getPairValues().add("hn.load.five_min##delim##" + Double.toString(node.profile().description().load().last5Mins()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.load.fifteen_min");
                    item.getPairValues().add("hn.load.fifteen_min##delim##" + Double.toString(node.profile().description().load().last15Mins()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.disk.size");
                    item.getPairValues().add("hn.disk.size##delim##" + Long.toString(node.profile().description().localAvailableStorage().intValue()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.physical.available");
                    item.getPairValues().add("hn.memory.physical.available##delim##" + Long.toString(node.profile().description().mainMemory().ramAvailable()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.physical.size");
                    item.getPairValues().add("hn.memory.physical.size##delim##" + Long.toString(node.profile().description().mainMemory().ramSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.virtual.size");
                    item.getPairValues().add("hn.memory.virtual.size##delim##" + Long.toString(node.profile().description().mainMemory().virtualSize()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.memory.virtual.available");
                    item.getPairValues().add("hn.memory.virtual.available##delim##" + Long.toString(node.profile().description().mainMemory().virtualAvailable()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hostname");
                    item.getPairValues().add("hostname##delim##" + node.profile().description().name().substring(0, node.profile().description().name().lastIndexOf(58)));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.port");
                    item.getPairValues().add("hn.port##delim##" + node.profile().description().name().substring(node.profile().description().name().lastIndexOf(58) + 1));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.hostname");
                    item.getPairValues().add("hn.hostname##delim##" + node.profile().description().name());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                int count = 0;
                try {
                    for (HostingNode.Profile.NodeDescription.NetworkAdapter nadp : node.profile().description().networkAdapters()) {
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".inbound.ip");
                            item.getPairValues().add("hn.network.adapter." + count + ".inbound.ip" + "##delim##" + nadp.inboundIP());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".ip.address");
                            item.getPairValues().add("hn.network.adapter." + count + ".ip.address" + "##delim##" + nadp.ipAddress());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".mtu");
                            item.getPairValues().add("hn.network.adapter." + count + ".mtu" + "##delim##" + Long.toString(nadp.mtu()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".name");
                            item.getPairValues().add("hn.network.adapter." + count + ".name" + "##delim##" + nadp.name());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.network.adapter." + count + ".outbound.ip");
                            item.getPairValues().add("hn.network.adapter." + count + ".outbound.ip" + "##delim##" + nadp.outboundIP());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++count;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.name");
                    item.getPairValues().add("hn.os.name##delim##" + node.profile().description().operatingSystem().name());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.release");
                    item.getPairValues().add("hn.os.release##delim##" + node.profile().description().operatingSystem().release());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.os.version");
                    item.getPairValues().add("hn.os.version##delim##" + node.profile().description().operatingSystem().version());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                count = 0;
                try {
                    long totalBogoMips = 0L;
                    long totalClockSpeed = 0L;
                    for (HostingNode.Profile.NodeDescription.Processor pr : node.profile().description().processors()) {
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".bogomips");
                            item.getPairValues().add("hn.processor." + count + ".bogomips" + "##delim##" + Double.toString(pr.bogomips().longValue()));
                            totalBogoMips += pr.bogomips().longValue();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1" + "##delim##" + Long.toString(pr.cacheL1()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1d");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1d" + "##delim##" + Long.toString(pr.cacheL1D()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l1i");
                            item.getPairValues().add("hn.processor." + count + ".cache.l1i" + "##delim##" + Long.toString(pr.cacheL1I()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".cache.l2");
                            item.getPairValues().add("hn.processor." + count + ".cache.l2" + "##delim##" + Long.toString(pr.cacheL2()));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".clockspeed");
                            item.getPairValues().add("hn.processor." + count + ".clockspeed" + "##delim##" + Double.toString(pr.clockSpeedMhz().longValue()));
                            totalClockSpeed += pr.clockSpeedMhz().longValue();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".family");
                            item.getPairValues().add("hn.processor." + count + ".clockspeed" + "##delim##" + pr.family());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".model");
                            item.getPairValues().add("hn.processor." + count + ".model" + "##delim##" + pr.model());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".model_name");
                            item.getPairValues().add("hn.processor." + count + ".model_name" + "##delim##" + pr.modelName());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("hn.processor." + count + ".vendor");
                            item.getPairValues().add("hn.processor." + count + ".vendor" + "##delim##" + pr.vendor());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ++count;
                    }
                    item.getPairKeys().add("hn.processor.count");
                    item.getPairValues().add("hn.processor.count##delim##" + Integer.toString(count));
                    item.getPairKeys().add("hn.processor.total_bogomips");
                    item.getPairValues().add("hn.processor.total_bogomips##delim##" + Long.toString(totalBogoMips));
                    item.getPairKeys().add("hn.processor.total_clockspeed");
                    item.getPairValues().add("hn.processor.total_clockspeed##delim##" + Long.toString(totalClockSpeed));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    item.getPairKeys().add("hn.status");
                    item.getPairValues().add("hn.status##delim##" + node.profile().description().status().toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                count = 0;
                try {
                    item.getPairKeys().add("hn.uptime");
                    item.getPairValues().add("hn.uptime##delim##" + node.profile().description().uptime());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    for (HostingNode.Profile.DeployedPackage pkg : node.profile().packages()) {
                        String identifier = pkg.serviceClass() + "." + pkg.serviceName() + "." + pkg.name();
                        try {
                            item.getPairKeys().add("software." + identifier + ".deployed");
                            item.getPairValues().add("software." + identifier + ".deployed" + "##delim##" + "true");
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("software." + identifier + ".service_version");
                            item.getPairValues().add("software." + identifier + ".service_version" + "##delim##" + pkg.serviceVersion());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        try {
                            item.getPairKeys().add("software." + identifier + ".package_version");
                            item.getPairValues().add("software." + identifier + ".package_version" + "##delim##" + pkg.packageVersion());
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    for (HostingNode.Profile.NodeDescription.Variable var : node.profile().description().environmentVariables()) {
                        try {
                            item.getPairKeys().add(var.key());
                            item.getPairValues().add(var.key() + "##delim##" + var.value());
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                items.put(item.getID(), item);
            }
        }
        return new HashSet<IDaoElement>(items.values());
    }

    private static Set<IDaoElement> getAllCollections() throws Exception {
        HashSet<IDaoElement> dataCollections = new HashSet<IDaoElement>();
        dataCollections.addAll(BridgeHelper.getDataCollections());
        dataCollections.addAll(BridgeHelper.getTreeCollections());
        return dataCollections;
    }

    private static Set<IDaoElement> getDataCollections() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, DataCollectionDao> hcols = new HashMap<String, DataCollectionDao>();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType/text() eq 'DataSource'");
            logger.log(Level.INFO, "query      : " + query.toString());
            logger.log(Level.INFO, "query expr : " + query.expression());
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            List resources = client.submit((Query)query);
            for (GenericResource resource : resources) {
                String id = resource.id();
                logger.log(Level.INFO, "Found collection with id : " + id);
                if (hcols.containsKey(id)) {
                    ((DataCollectionDao)hcols.get(id)).getScopes().add(scope.toString());
                    continue;
                }
                try {
                    String name = resource.profile().name();
                    logger.log(Level.INFO, "collection with id : " + id + " has name : " + name);
                    String description = resource.profile().description();
                    DataSourceDescription datasourceDescription = DataSourceDescription.getCollection(resource);
                    Boolean isUserCollection = datasourceDescription.isUser();
                    Calendar creationTime = datasourceDescription.getCreationTime();
                    String type = datasourceDescription.getType();
                    if (!type.equalsIgnoreCase("opensearch")) {
                        logger.log(Level.INFO, "collection with id : " + id + " name : " + name + " is not of type : opensearch. Skipping");
                        continue;
                    }
                    logger.log(Level.INFO, "collection with id : " + id + " name : " + name + " is of type : " + type);
                    if (!isUserCollection.booleanValue()) continue;
                    DataCollectionDao d = new DataCollectionDao();
                    d.setID(id);
                    d.setDescription(description);
                    d.setCollectionType(type);
                    if (creationTime != null) {
                        d.setCreationTime(Long.toString(creationTime.getTimeInMillis()));
                    }
                    d.setName(name);
                    d.getScopes().add(scope.toString());
                    hcols.put(d.getID(), d);
                    if (d.getDescription() == null || d.getDescription().trim().length() == 0) {
                        d.setDescription(null);
                    }
                    if (d.getName().trim().length() == 0) {
                        d.setName(null);
                    }
                    HashSet<String> toDel = new HashSet<String>();
                    for (String s : d.getScopes()) {
                        if (s.trim().length() != 0) continue;
                        toDel.add(s);
                    }
                    d.getScopes().removeAll(toDel);
                    logger.log(Level.INFO, "collection with id : " + id + " has name : " + name + " type : " + type);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "problem getting the resource of : " + resource.id());
                }
            }
        }
        return new HashSet<IDaoElement>(hcols.values());
    }

    public static Set<IDaoElement> getTreeCollections() throws Exception {
        List<String> scopes = BridgeHelper.scopes;
        HashMap<String, DataCollectionDao> hcols = new HashMap<String, DataCollectionDao>();
        logger.log(Level.INFO, " will search for TREE COLLECTIONS in the following scopes");
        for (String scope : scopes) {
            logger.log(Level.INFO, "### " + scope.toString());
        }
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(ServiceInstance.class);
            logger.log(Level.INFO, " searching for TREE COLLECTIONS in scope : " + scope);
            String serviceName = "tree-manager-service";
            String serviceClass = "DataAccess";
            query.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'");
            logger.log(Level.INFO, "query      : " + query.toString());
            logger.log(Level.INFO, "query expr : " + query.expression());
            DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
            List resources = client.submit((Query)query);
            logger.log(Level.INFO, " found " + resources.size() + " TREE COLLECTIONS in scope : " + scope);
            for (ServiceInstance r : resources) {
                try {
                    String endpoint = r.endpoint().getPath();
                    if (!endpoint.endsWith(TREADER_NAME)) continue;
                    logger.log(Level.INFO, "Parsing tree...");
                    XPathHelper xpath = new XPathHelper((Node)r.properties().customProperties());
                    String name = (String)xpath.evaluate("//*[local-name()='Name']/text()").get(0);
                    logger.log(Level.INFO, "\t name : " + name);
                    xpath = new XPathHelper((Node)r.properties().customProperties());
                    String id = (String)xpath.evaluate("//*[local-name()='SourceId']/text()").get(0);
                    logger.log(Level.INFO, "\t id : " + id);
                    logger.log(Level.INFO, "Parsing tree...OK");
                    String description = null;
                    String creationTime = null;
                    logger.log(Level.INFO, "Parsed elements from xml : [id = " + id + ", name = " + name + " ] ");
                    if (hcols.containsKey(id)) {
                        ((DataCollectionDao)hcols.get(id)).getScopes().add(scope.toString());
                        logger.log(Level.INFO, "updated collection of : \n" + ((DataCollectionDao)hcols.get(id)).deepToString());
                        logger.log(Level.INFO, "+ added collection : " + name + " " + description + " scope : " + scope + " all scopes : " + ((DataCollectionDao)hcols.get(id)).getScopes());
                        continue;
                    }
                    DataCollectionDao d = new DataCollectionDao();
                    d.setID(id);
                    d.setName(name);
                    d.setDescription(description);
                    d.setCreationTime(creationTime);
                    if (d.getDescription() == null || d.getDescription().trim().length() == 0) {
                        d.setDescription(null);
                    }
                    if (d.getName().trim().length() == 0) {
                        d.setName(null);
                    }
                    if (creationTime == null || creationTime.trim().length() == 0) {
                        d.setCreationTime(null);
                    }
                    d.getScopes().add(scope.toString());
                    hcols.put(d.getID(), d);
                    HashSet<String> toDel = new HashSet<String>();
                    for (String s : d.getScopes()) {
                        if (s.trim().length() != 0) continue;
                        toDel.add(s);
                    }
                    d.getScopes().removeAll(toDel);
                    logger.log(Level.INFO, "added collection : \n" + ((DataCollectionDao)hcols.get(id)).deepToString());
                    logger.log(Level.INFO, "+ added collection : " + name + " " + description + " scope : " + scope + " all scopes : " + d.getScopes());
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error while retrieving-parsing the tree manager collection");
                }
            }
        }
        return new HashSet<IDaoElement>(hcols.values());
    }

    private static Set<IDaoElement> getFields() throws Exception {
        logger.info("Searching for fields");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        logger.log(Level.INFO, "fieldsResource : " + fieldsResource);
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"field");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                FieldDao f = new FieldDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                logger.log(Level.FINE, "Field read from resource");
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fieldInfo"), (String)"field");
                logger.log(Level.FINE, "field has elements : " + xmlObjs.size());
                for (Element elem : xmlObjs) {
                    FieldDao f = new FieldDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " fields");
        return items;
    }

    private static Set<IDaoElement> getSearchables() throws Exception {
        logger.info("Searching for searchables");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"searchables"), (String)"searchable");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                SearchableDao f = new SearchableDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"searchables"), (String)"searchable");
                for (Element elem : xmlObjs) {
                    SearchableDao f = new SearchableDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " searchables");
        return items;
    }

    private static Set<IDaoElement> getPresentables() throws Exception {
        logger.info("Searching for presentables");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String fieldsResource = FieldModel.getMainResource();
        if (fieldsResource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)fieldsResource);
        boolean flatModel = false;
        List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"presentables"), (String)"presentable");
        if (xmlObjs.size() != 0) {
            flatModel = true;
        } else {
            xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
        }
        if (flatModel) {
            for (Element elem : xmlObjs) {
                PresentableDao f = new PresentableDao();
                f.fromXML(elem);
                items.add((IDaoElement)f);
            }
        } else {
            Set<String> fieldIds = FieldModel.getFieldIds();
            for (String fieldId : fieldIds) {
                String fieldResource = FieldModel.getFieldResource(fieldId);
                if (fieldResource == null) continue;
                fieldsDOM = XMLUtils.Deserialize((String)fieldResource);
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"presentables"), (String)"presentable");
                for (Element elem : xmlObjs) {
                    PresentableDao f = new PresentableDao();
                    f.fromXML(elem);
                    items.add((IDaoElement)f);
                }
            }
        }
        logger.info("Found " + items.size() + " presentables");
        return items;
    }

    private static Set<IDaoElement> getElementMetadata() throws Exception {
        logger.info("Searching for element metadata");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document fieldsDOM = null;
        String resource = null;
        String fieldsResource = null;
        String metadataResource = FieldModel.getMetadataResource();
        resource = metadataResource == null ? (fieldsResource = FieldModel.getMainResource()) : metadataResource;
        if (resource == null) {
            return items;
        }
        fieldsDOM = XMLUtils.Deserialize((String)resource);
        List xmlObjs = null;
        Element metadataElement = XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"metadata");
        if (metadataElement == null) {
            return items;
        }
        xmlObjs = XMLUtils.GetChildElementsWithName((Node)metadataElement, (String)"elementMetadata");
        for (Element elem : xmlObjs) {
            ElementMetadataDao s = new ElementMetadataDao();
            s.fromXML(elem);
            items.add((IDaoElement)s);
        }
        logger.info("Found " + items.size() + " element metadata");
        return items;
    }

    private static Set<IDaoElement> getStaticConfiguration() throws Exception {
        logger.info("Searching for static configuration");
        HashSet<IDaoElement> items = new HashSet<IDaoElement>();
        Document staticConfigDOM = null;
        String staticConfigResource = FieldModel.getStaticConfigResource();
        if (staticConfigResource == null) {
            return items;
        }
        staticConfigDOM = XMLUtils.Deserialize((String)staticConfigResource);
        StaticConfigurationDao item = new StaticConfigurationDao();
        item.fromXML(staticConfigDOM.getDocumentElement());
        items.add((IDaoElement)item);
        logger.info("Found " + items.size() + " static configuration");
        return items;
    }

    private static GenericResource getMostRecentResource(List<GenericResource> resources) throws Exception {
        long mostRecentTime = -1L;
        GenericResource mostRecentResource = null;
        for (GenericResource resource : resources) {
            long updateTime = 0L;
            try {
                updateTime = Long.parseLong(resource.profile().description());
            }
            catch (Exception ex) {
                continue;
            }
            if (updateTime <= mostRecentTime) continue;
            mostRecentResource = resource;
        }
        return mostRecentResource;
    }

    public static List<GenericResource> getPublishedFieldResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName);
    }

    public static List<GenericResource> getPublishedMetadataResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "Metadata");
    }

    public static List<GenericResource> getPublishedStaticConfigResources() throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "StaticConfig");
    }

    public static List<GenericResource> getPublishedFieldResourcesForField(String fieldId) throws Exception {
        return BridgeHelper.getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + fieldId);
    }

    public static List<GenericResource> getPublishedFieldResources(String resourceName) throws Exception {
        logger.log(Level.INFO, "Searching for publised field resources in scopes : " + scopes);
        Set<String> scopes = BridgeHelper.getVOScopes(BridgeHelper.scopes);
        logger.log(Level.INFO, "VO scopes of : " + BridgeHelper.scopes + " are : " + scopes);
        ArrayList<GenericResource> resources = new ArrayList<GenericResource>();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType/text() eq '" + GCubeRepositoryProvider.RRModelGenericResourceName + "'").addCondition("$resource/Profile/Name/text() eq '" + resourceName + "'");
            logger.log(Level.INFO, "query      : " + query.toString());
            logger.log(Level.INFO, "query expr : " + query.expression());
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            resources.addAll(client.submit((Query)query));
        }
        return resources;
    }

    public static String getVOScope(String scope) {
        ScopeBean bean = new ScopeBean(scope);
        if (bean.is(ScopeBean.Type.VO)) {
            return scope;
        }
        if (bean.is(ScopeBean.Type.VRE)) {
            return bean.enclosingScope().toString();
        }
        return null;
    }

    public static Set<String> getVOScopes(Collection<String> vreScopes) {
        HashSet<String> voScopes = new HashSet<String>();
        if (vreScopes != null) {
            for (String scope : vreScopes) {
                String voScope = BridgeHelper.getVOScope(scope);
                if (voScope == null) continue;
                voScopes.add(voScope);
            }
        }
        return voScopes;
    }

    public static void publishFieldResource(GenericResource resource, boolean isNew, Set<String> nonUpdateVOScopes) throws Exception {
        logger.log(Level.INFO, "publishing information on IS");
        logger.log(Level.INFO, "nonUpdateVOScopes : " + nonUpdateVOScopes);
        for (String gcubeScope : BridgeHelper.getFieldModelScopes()) {
            logger.log(Level.INFO, "will check scope  : " + gcubeScope.toString());
        }
        Set<String> voScopes = BridgeHelper.getVOScopes(BridgeHelper.getFieldModelScopes());
        for (String gcubeScope : voScopes) {
            logger.log(Level.INFO, "VOScope scope : " + gcubeScope);
            if (nonUpdateVOScopes.contains(gcubeScope)) {
                logger.log(Level.INFO, "VOScope of scope : " + gcubeScope + " is in nonUpdateVOScopes");
                continue;
            }
            logger.log(Level.INFO, "trying to use scope : " + gcubeScope.toString());
            ScopeProvider.instance.set(gcubeScope);
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add(gcubeScope);
            logger.log(Level.INFO, "scope added : " + scopes);
            ScopedPublisher publish = RegistryPublisherFactory.scopedPublisher();
            Resource r = null;
            if (isNew) {
                logger.log(Level.INFO, "creating resource with id : " + resource.id() + " . is new : " + isNew);
                r = publish.create((Resource)resource, scopes);
            } else {
                logger.log(Level.INFO, "updating resource with id : " + resource.id() + " is new : " + isNew);
                if (resource.scopes().contains((Object)gcubeScope)) {
                    logger.log(Level.INFO, "scope in resource. updating with id : " + resource.id() + " is new : " + isNew);
                    r = publish.update((Resource)resource);
                } else {
                    logger.log(Level.INFO, "scope not in resource. creating resource with id : " + resource.id() + ". is new : " + isNew);
                    r = publish.create((Resource)resource, scopes);
                }
                if (r != null) {
                    logger.log(Level.INFO, "published resource id : " + r.id());
                    logger.log(Level.INFO, "published resource id equals to previous : " + r.id().equalsIgnoreCase(resource.id()));
                }
            }
            logger.log(Level.INFO, "is new : " + isNew);
            logger.log(Level.INFO, "id : " + r.id());
        }
        logger.log(Level.INFO, "done publishing information on IS");
    }

    public static void deleteFieldResource(GenericResource resource, Set<String> nonUpdateVOScopes) throws Exception {
        logger.log(Level.INFO, "Deleting information from IS");
        for (String gcubeScope : BridgeHelper.getFieldModelScopes()) {
            logger.log(Level.INFO, "trying to use scope : " + gcubeScope.toString());
            ScopeProvider.instance.set(gcubeScope);
            String VOScope1 = BridgeHelper.getVOScope(gcubeScope);
            if (nonUpdateVOScopes.contains(gcubeScope) || nonUpdateVOScopes.contains(VOScope1)) {
                logger.log(Level.INFO, "VOScope of scope : " + gcubeScope + " is in nonUpdateVOScopes");
                continue;
            }
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add(gcubeScope);
            logger.log(Level.INFO, "scope added : " + scopes);
            ScopedPublisher sp = RegistryPublisherFactory.scopedPublisher();
            Resource r = null;
            r = sp.remove((Resource)resource, scopes);
        }
        logger.log(Level.INFO, "done deleting information from IS");
    }

    public static String buildFieldDirectorySerialization(Set<IDaoElement> fields) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<fields>\n");
        for (IDaoElement elem : fields) {
            buf.append("<fieldId>");
            buf.append(((FieldDao)elem).getID());
            buf.append("</fieldId>");
        }
        buf.append("</fields>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildFieldSerialization(IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables, Set<String> deletedSearchables, Set<String> deletedPresentables) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<fieldInfo>\n");
        buf.append(field.toXML());
        buf.append("</fieldInfo>\n");
        buf.append("<searchables>\n");
        for (String searchableId : ((FieldDao)field).getSearchables()) {
            for (IDaoElement elem : searchables) {
                if (!elem.getID().equals(searchableId) || deletedSearchables.contains(searchableId)) continue;
                buf.append(elem.toXML());
            }
        }
        buf.append("</searchables>\n");
        buf.append("<presentables>\n");
        for (String presentableId : ((FieldDao)field).getPresentables()) {
            for (IDaoElement elem : presentables) {
                if (!elem.getID().equals(presentableId) || deletedPresentables.contains(presentableId)) continue;
                buf.append(elem.toXML());
            }
        }
        buf.append("</presentables>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static Set<IDaoElement> updateFieldList(Set<IDaoElement> fields, Set<IDaoElement> searchables, Set<IDaoElement> presentables, List<String> emptyScopedSearchables, List<String> emptyScoperdPresentables) throws ResourceRegistryException {
        HashSet<IDaoElement> updatedFields = new HashSet<IDaoElement>();
        for (IDaoElement field : fields) {
            if (!BridgeHelper.shouldUpdateField(field, searchables, presentables, emptyScopedSearchables, emptyScoperdPresentables)) continue;
            updatedFields.add(field);
        }
        return updatedFields;
    }

    public static boolean shouldUpdateField(IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables, List<String> emptyScopedSearchables, List<String> emptyScoperdPresentables) throws ResourceRegistryException {
        for (String searchableId : ((FieldDao)field).getSearchables()) {
            for (IDaoElement elem : searchables) {
                if (!elem.getID().equals(searchableId) || emptyScopedSearchables.contains(searchableId)) continue;
                return true;
            }
        }
        for (String presentableId : ((FieldDao)field).getPresentables()) {
            for (IDaoElement elem : presentables) {
                if (!elem.getID().equals(presentableId) || emptyScoperdPresentables.contains(presentableId)) continue;
                return true;
            }
        }
        return false;
    }

    public static String updateFieldSerialization(String originalSerialization, IDaoElement field, Set<IDaoElement> searchables, Set<IDaoElement> presentables, boolean updateFields, boolean updateSearchables, boolean updatePresentables, Set<String> deletedSearchables, Set<String> deletedPresentables) throws Exception {
        Document original = null;
        try {
            original = XMLUtils.Deserialize((String)originalSerialization);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error in deserializing : " + originalSerialization);
            throw e;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        if (updateFields) {
            if (updateSearchables && updatePresentables) {
                buf.append("<fieldInfo>\n");
                buf.append(field.toXML());
                buf.append("</fieldInfo>\n");
            } else {
                Element originalField = (Element)XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"fieldInfo"), (String)"field").get(0);
                buf.append("<fieldInfo>\n");
                FieldDao updatedDao = new FieldDao();
                Document dbField = XMLUtils.Deserialize((String)field.toXML());
                updatedDao.setID(((FieldDao)field).getID());
                updatedDao.setName(((FieldDao)field).getName());
                updatedDao.setDescription(((FieldDao)field).getDescription());
                HashSet<String> updatedSearchables = new HashSet<String>();
                if (updateSearchables) {
                    List dbSearchables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)dbField.getDocumentElement(), (String)"searchables"), (String)"searchable");
                    for (Element dbSearchable : dbSearchables) {
                        updatedSearchables.add(dbSearchable.getFirstChild().getNodeValue());
                    }
                } else {
                    List originalSearchables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)originalField, (String)"searchables"), (String)"searchable");
                    for (Element originalSearchable : originalSearchables) {
                        updatedSearchables.add(originalSearchable.getFirstChild().getNodeValue());
                    }
                }
                HashSet<String> updatedPresentables = new HashSet<String>();
                if (updatePresentables) {
                    List dbPresentables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)dbField.getDocumentElement(), (String)"presentables"), (String)"presentable");
                    for (Element dbPresentable : dbPresentables) {
                        updatedPresentables.add(dbPresentable.getFirstChild().getNodeValue());
                    }
                } else {
                    List originalPresentables = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)originalField, (String)"presentables"), (String)"presentable");
                    for (Element originalPresentable : originalPresentables) {
                        updatedPresentables.add(originalPresentable.getFirstChild().getNodeValue());
                    }
                }
                updatedDao.setSearchables(updatedSearchables);
                updatedDao.setPresentables(updatedPresentables);
                buf.append(updatedDao.toXML());
                buf.append("</fieldInfo>\n");
            }
        } else {
            Element originalFields = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"fieldInfo");
            buf.append(XMLUtils.Serialize((Node)originalFields, (boolean)true));
        }
        if (updateSearchables) {
            buf.append("<searchables>\n");
            for (String searchableId : ((FieldDao)field).getSearchables()) {
                for (IDaoElement elem : searchables) {
                    if (!elem.getID().equals(searchableId) || deletedSearchables.contains(searchableId)) continue;
                    buf.append(elem.toXML());
                }
            }
            buf.append("</searchables>\n");
        } else {
            Element originalSearchables = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"searchables");
            buf.append(XMLUtils.Serialize((Node)originalSearchables, (boolean)true));
        }
        if (updatePresentables) {
            buf.append("<presentables>\n");
            for (String presentableId : ((FieldDao)field).getPresentables()) {
                for (IDaoElement elem : presentables) {
                    if (!elem.getID().equals(presentableId) || deletedPresentables.contains(presentableId)) continue;
                    buf.append(elem.toXML());
                }
            }
            buf.append("</presentables>\n");
        } else {
            Element originalPresentables = XMLUtils.GetChildElementWithName((Node)original.getDocumentElement(), (String)"presentables");
            buf.append(XMLUtils.Serialize((Node)originalPresentables, (boolean)true));
        }
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildElementMetadataSerialization(Set<IDaoElement> metadata) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append("<root>\n");
        buf.append("<metadata>\n");
        for (IDaoElement elem : metadata) {
            buf.append(elem.toXML());
        }
        buf.append("</metadata>\n");
        buf.append("</root>\n");
        return buf.toString();
    }

    public static String buildStaticConfigSerialization(IDaoElement staticConfig) throws ResourceRegistryException {
        StringBuilder buf = new StringBuilder();
        buf.append(staticConfig.toXML());
        return buf.toString();
    }

    public static void prefetchInMemoryItems(Set<Class<?>> itemTypes) throws ResourceRegistryException {
        InMemoryStore.clear();
        HashMap<String, ElementMetadataDao> metadata = new HashMap<String, ElementMetadataDao>();
        Set metadataSet = null;
        try {
            metadataSet = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, ElementMetadataDao.class);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not retrieve element metadata", (Throwable)e);
        }
        for (IDaoElement m : metadataSet) {
            metadata.put(m.getID(), (ElementMetadataDao)m);
        }
        boolean baseDatasource = false;
        for (Class<?> itemType : itemTypes) {
            if (!itemType.getName().equals(DataSource.class.getName())) continue;
            baseDatasource = true;
            break;
        }
        boolean baseDatasourceService = false;
        for (Class<?> itemType : itemTypes) {
            if (!itemType.getName().equals(DataSourceService.class.getName())) continue;
            baseDatasourceService = true;
            break;
        }
        for (Class<?> itemType : itemTypes) {
            List ds;
            Searchable loaded;
            Set items;
            logger.log(Level.INFO, "Prefetching element " + itemType.getName());
            if (itemType.getName().equals(DataCollection.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(DataCollection.getAllCollections((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(DataLanguage.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(DataLanguage.getLanguages()));
                continue;
            }
            if (itemType.getName().equals(Functionality.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(Functionality.getAllFunctionalities((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(HostingNode.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(HostingNode.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(Field.class.getName())) {
                InMemoryStore.setItems(itemType, new HashSet(Field.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(Searchable.class.getName())) {
                items = null;
                try {
                    items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, SearchableDao.class);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Could not prefetch searchables", (Throwable)e);
                }
                for (IDaoElement item : items) {
                    loaded = new Searchable();
                    loaded.setID(((SearchableDao)item).getID());
                    loaded.load(false);
                    if (metadata.containsKey(loaded.getField()) && ((ElementMetadataDao)metadata.get(loaded.getField())).getType().equals(ElementMetadata.Type.DeletedField.toString())) continue;
                    if (metadata.get(loaded.getField()) != null) {
                        logger.info("loaded searchable for field : " + loaded.getField() + " id : " + item.getID() + " type " + ((ElementMetadataDao)metadata.get(loaded.getField())).getType());
                    } else {
                        logger.info("loaded searchable for field : " + loaded.getField() + " id : " + item.getID() + " is not in metadata");
                    }
                    InMemoryStore.setItem(Searchable.class, (IRRElement)loaded);
                }
                continue;
            }
            if (itemType.getName().equals(Presentable.class.getName())) {
                items = null;
                try {
                    items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, PresentableDao.class);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Could not prefetch presentables", (Throwable)e);
                }
                for (IDaoElement item : items) {
                    loaded = new Presentable();
                    loaded.setID(((PresentableDao)item).getID());
                    loaded.load(false);
                    if (metadata.containsKey(loaded.getField()) && ((ElementMetadataDao)metadata.get(loaded.getField())).getType().equals(ElementMetadata.Type.DeletedField.toString())) continue;
                    if (metadata.get(loaded.getField()) != null) {
                        logger.info("loaded presentable for field : " + loaded.getField() + " id : " + item.getID() + " type " + ((ElementMetadataDao)metadata.get(loaded.getField())).getType());
                    } else {
                        logger.info("loaded presentable for field : " + loaded.getField() + " id : " + item.getID() + " is not in metadata");
                    }
                    InMemoryStore.setItem(Presentable.class, (IRRElement)loaded);
                }
                continue;
            }
            if (itemType.getName().equals(DataSource.class.getName())) {
                ds = DataSource.getAll((boolean)false);
                for (DataSource d : ds) {
                    InMemoryStore.setItem(d.getClass(), (IRRElement)d);
                }
                continue;
            }
            if (itemType.getName().equals(DataSourceService.class.getName())) {
                ds = DataSourceService.getAll((boolean)false);
                for (DataSource d : ds) {
                    InMemoryStore.setItem(d.getClass(), (IRRElement)d);
                }
                continue;
            }
            if (itemType.getName().equals(FTIndex.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(FTIndex.class, new HashSet(FTIndex.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(FTIndexService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(FTIndexService.class, new HashSet(FTIndexService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(FWIndex.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(FWIndex.class, new HashSet(FWIndex.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(FWIndexService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(FWIndexService.class, new HashSet(FWIndexService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(GeoIndex.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(GeoIndex.class, new HashSet(GeoIndex.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(GeoIndexService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(GeoIndexService.class, new HashSet(GeoIndexService.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(OpenSearchDataSource.class.getName())) {
                if (baseDatasource) continue;
                InMemoryStore.setItems(OpenSearchDataSource.class, new HashSet(OpenSearchDataSource.getAll((boolean)false)));
                continue;
            }
            if (itemType.getName().equals(OpenSearchDataSourceService.class.getName())) {
                if (baseDatasourceService) continue;
                InMemoryStore.setItems(OpenSearchDataSourceService.class, new HashSet(OpenSearchDataSourceService.getAll((boolean)false)));
                continue;
            }
            if (!itemType.getName().equals(FieldIndexContainer.class.getName())) continue;
            items = null;
            try {
                items = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, FieldIndexContainerDao.class);
            }
            catch (Exception e) {
                throw new ResourceRegistryException("Could not prefetch datasource field info", (Throwable)e);
            }
            for (IDaoElement item : items) {
                loaded = new FieldIndexContainer();
                loaded.setID(((FieldIndexContainerDao)item).getID());
                loaded.load(false);
                InMemoryStore.setItem(FieldIndexContainer.class, (IRRElement)loaded);
            }
        }
    }

    public static List<String> getGHNContextStartScopes() {
        List<String> scopes = ConfigurationProviderLoader.getProvider().getGHNContextStartScopes();
        logger.log(Level.INFO, "gHNContextStartScopes : " + scopes);
        return scopes;
    }

    public static List<String> getGHNContextScopes() {
        List<String> scopes = ConfigurationProviderLoader.getProvider().getGHNContextScopes();
        logger.log(Level.INFO, "gHNContextScopes : " + scopes);
        return scopes;
    }

    public static boolean isClientMode() {
        boolean isClientMode = ConfigurationProviderLoader.getProvider().isClientMode();
        logger.log(Level.INFO, "isClientMode : " + isClientMode);
        return isClientMode;
    }

    public static void main(String[] args) throws Exception {
        scopes = new ArrayList<String>();
        scopes.add("/gcube/devNext/NextNext");
        scopes.add("/gcube/devNext");
        BridgeHelper.getExecutionServer();
        BridgeHelper.getSearchables();
        BridgeHelper.getPresentables();
    }
}

