/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.configuration;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.gcube.execution.rr.configuration.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProviderLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationProviderLoader.class);
    private static ConfigurationProvider configurationProvider = null;

    public static synchronized ConfigurationProvider getProvider() {
        if (configurationProvider != null) {
            return configurationProvider;
        }
        ServiceLoader<ConfigurationProvider> loader = ServiceLoader.load(ConfigurationProvider.class, Thread.currentThread().getContextClassLoader());
        for (ConfigurationProvider cp : ServiceLoader.load(ConfigurationProvider.class, Thread.currentThread().getContextClassLoader())) {
            logger.info("found " + ConfigurationProvider.class.getName() + " impl " + cp.getClass());
        }
        Iterator<ConfigurationProvider> i$ = loader.iterator();
        if (i$.hasNext()) {
            ConfigurationProvider cp;
            cp = i$.next();
            logger.info("got " + ConfigurationProvider.class.getName() + " impl " + cp.getClass());
            configurationProvider = cp;
        }
        if (configurationProvider == null) {
            logger.warn("No " + ConfigurationProvider.class.getName() + " no implementations found");
            throw new Error("No " + ConfigurationProvider.class.getName() + " no implementations found");
        }
        return configurationProvider;
    }

    public static void main(String[] args) {
        ConfigurationProviderLoader.getProvider();
    }
}

