package gr.uoa.di.madgik.rr.plugins.impl.gcube;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.plugins.Plugin;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.gcube.common.core.contexts.GHNContext;

public class GCubeHostFinderPlugin extends Plugin 
{
	private static Logger logger = Logger.getLogger(GCubeHostFinderPlugin.class.getName());
	
	private Properties properties = null;
	private synchronized Properties getPropertyFile() throws IOException {
		if (properties != null)
			return properties;
		
		String filename = "/deploy.properties";

		properties = new Properties();
		properties.load(ClassLoader.class.getResourceAsStream(filename));

		return properties;
	}
	
	private String getHostname(){
		return properties.getProperty("hostname");
	}
	
	private String getPort(){
		return properties.getProperty("port");
	}
	
	public GCubeHostFinderPlugin()
	{
		this.type = Type.ONE_OFF;
	}
	
	@Override
	public void setup() throws ResourceRegistryException {
		try {
			getPropertyFile();
		} catch (IOException e) {
			throw new ResourceRegistryException("could not open properties file");
		}
	}
	
	@Override
	protected void execute(Set<Class<?>> targets)throws ResourceRegistryException 
	{
		try 
		{
			String host = this.getHostname();
			String port = this.getPort();
			
			logger.log(Level.INFO, "hostname : " + host);
			logger.log(Level.INFO, "port     : " + port);
			
			System.out.println("hostname : " + host);
			System.out.println("port     : " + port);
			
			ResourceRegistry.getContext().setLocalNodeHostname(host);
			ResourceRegistry.getContext().setLocalNodePort(port);
			
		}catch(Exception e)
		{
			throw new ResourceRegistryException("could not resolve local node hostname or port", e);
		}	
	}
	
}
