/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins.impl.gcube;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeHostFinderPlugin
extends Plugin {
    private static final Logger logger = LoggerFactory.getLogger(GCubeHostFinderPlugin.class);
    private Properties properties = null;

    private synchronized Properties getPropertyFile() throws IOException {
        if (this.properties != null) {
            return this.properties;
        }
        String filename = "/deploy.properties";
        this.properties = new Properties();
        this.properties.load(ClassLoader.class.getResourceAsStream(filename));
        return this.properties;
    }

    private String getHostname() {
        return this.properties.getProperty("hostname");
    }

    private String getPort() {
        return this.properties.getProperty("port");
    }

    public GCubeHostFinderPlugin() {
        this.type = Plugin.Type.ONE_OFF;
    }

    public void setup() throws ResourceRegistryException {
        try {
            this.getPropertyFile();
        }
        catch (IOException e) {
            throw new ResourceRegistryException("could not open properties file");
        }
    }

    protected void execute(Set<Class<?>> targets) throws ResourceRegistryException {
        try {
            String host = this.getHostname();
            String port = this.getPort();
            logger.info("hostname : " + host);
            logger.info("port     : " + port);
            ResourceRegistry.getContext().setLocalNodeHostname(host);
            ResourceRegistry.getContext().setLocalNodePort(port);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("could not resolve local node hostname or port", (Throwable)e);
        }
    }
}

