/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceService;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenSearchDataSource
extends DataSource {
    public static Logger logger = Logger.getLogger(OpenSearchDataSource.class.getName());

    public OpenSearchDataSource() throws ResourceRegistryException {
        super(OpenSearchDataSourceDao.class, OpenSearchDataSourceService.class);
        super.setType(DataSource.Type.OpenSearch);
    }

    @Override
    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("OpenSearchDataSource - ID : " + this.getID() + "\n");
        buf.append("OpenSearchDataSource - Functionality : " + this.getFunctionality() + "\n");
        buf.append("OpenSearchDataSource - Scopes : ");
        for (String string : this.getScopes()) {
            buf.append(string + " ");
        }
        buf.append("\nOpenSearchDataSource - Capabilities : ");
        for (String string : this.getCapabilities()) {
            buf.append(string + " ");
        }
        buf.append("\nOpenSearchDataSource - Fields : \n");
        for (FieldIndexContainer fieldIndexContainer : this.getFieldInfo()) {
            buf.append(fieldIndexContainer.deepToString() + "\n");
        }
        return buf.toString();
    }

    @Override
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.exists(OpenSearchDataSourceDao.class, persistencyType);
    }

    public static List<DataSource> getAll(boolean loadDetails) throws ResourceRegistryException {
        return DataSource.getAll(OpenSearchDataSourceDao.class, RRContext.DatastoreType.LOCAL, loadDetails);
    }

    public static List<DataSource> getAll(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return DataSource.getAll(OpenSearchDataSourceDao.class, persistencyType, loadDetails);
    }

    @Override
    public List<DataSourceService> getDataSourceServices() throws ResourceRegistryException {
        if (this.boundDataSourceServices == null) {
            if (this.item.getBoundDataSourceServices() != null) {
                ArrayList<DataSourceService> ret = new ArrayList<DataSourceService>();
                for (String ds : this.item.getBoundDataSourceServices()) {
                    DataSourceService s = OpenSearchDataSourceService.getById(true, ds);
                    if (s != null) {
                        ret.add(s);
                        continue;
                    }
                    logger.log(Level.WARNING, "Could not find bound open search datasource service with id " + ds);
                }
                this.boundDataSourceServices = ret;
                return ret;
            }
            return OpenSearchDataSourceService.getAll(true);
        }
        return this.boundDataSourceServices;
    }

    public static DataSource getById(boolean loadDetails, String id) throws ResourceRegistryException {
        OpenSearchDataSource f = new OpenSearchDataSource();
        f.setID(id);
        return f.load(loadDetails) ? f : null;
    }
}

