/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FWIndex
extends DataSource {
    public static Logger logger = Logger.getLogger(FWIndex.class.getName());

    public FWIndex() throws ResourceRegistryException {
        super(FWIndexDao.class, FWIndexService.class);
        super.setType(DataSource.Type.ForwardIndex);
    }

    @Override
    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("FWIndex - ID : " + this.getID() + "\n");
        buf.append("FWIndex - Functionality : " + this.getFunctionality() + "\n");
        buf.append("FWIndex - Scopes : ");
        for (String string : this.getScopes()) {
            buf.append(string + " ");
        }
        buf.append("\nFWIndex - Capabilities : ");
        for (String string : this.getCapabilities()) {
            buf.append(string + " ");
        }
        buf.append("\nFWIndex - Fields : \n");
        for (FieldIndexContainer fieldIndexContainer : this.getFieldInfo()) {
            buf.append(fieldIndexContainer.deepToString() + "\n");
        }
        return buf.toString();
    }

    @Override
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.exists(FWIndexDao.class, persistencyType);
    }

    public static List<DataSource> getAll(boolean loadDetails) throws ResourceRegistryException {
        return DataSource.getAll(FWIndexDao.class, RRContext.DatastoreType.LOCAL, loadDetails);
    }

    public static List<DataSource> getAll(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return DataSource.getAll(FWIndexDao.class, persistencyType, loadDetails);
    }

    @Override
    public List<DataSourceService> getDataSourceServices() throws ResourceRegistryException {
        if (this.boundDataSourceServices == null) {
            if (this.item.getBoundDataSourceServices() != null) {
                ArrayList<DataSourceService> ret = new ArrayList<DataSourceService>();
                for (String ds : this.item.getBoundDataSourceServices()) {
                    DataSourceService s = FWIndexService.getById(true, ds);
                    if (s != null) {
                        ret.add(s);
                        continue;
                    }
                    logger.log(Level.WARNING, "Could not find bound forward index service with id " + ds);
                }
                this.boundDataSourceServices = ret;
                return ret;
            }
            return FWIndexService.getAll(true);
        }
        return this.boundDataSourceServices;
    }

    public static DataSource getById(boolean loadDetails, String id) throws ResourceRegistryException {
        FWIndex f = new FWIndex();
        f.setID(id);
        return f.load(loadDetails) ? f : null;
    }
}

