/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.search;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.RRElement;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import gr.uoa.di.madgik.rr.element.query.SourceHelper;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class Field
extends RRElement {
    private FieldDao item = new FieldDao();
    private Set<Searchable> searchables = new HashSet<Searchable>();
    private Set<Presentable> presentables = new HashSet<Presentable>();
    private RRContext context = null;
    private static Behavior behavior = new Behavior();
    private static Logger logger = Logger.getLogger(Field.class.getName());

    public RRContext getISContext() {
        return this.context;
    }

    public static Behavior getBehavior() {
        return behavior;
    }

    public Field() throws ResourceRegistryException {
        this.item.setID(UUID.randomUUID().toString());
        this.context = ResourceRegistry.getContext();
    }

    public Field(FieldDao item) throws ResourceRegistryException {
        this.item = item;
        this.context = ResourceRegistry.getContext();
    }

    public String getID() {
        return this.item.getID();
    }

    public void setID(String id) {
        this.item.setID(id);
    }

    public String getName() {
        return this.item.getName();
    }

    public void setName(String name) {
        this.item.setName(name);
    }

    public String getDescription() {
        return this.item.getDescription();
    }

    public void setDescription(String description) {
        this.item.setDescription(description);
    }

    public Set<Searchable> getSearchables() {
        return this.searchables;
    }

    public Set<Presentable> getPresentables() {
        return this.presentables;
    }

    public FieldDao getItem() {
        return this.item;
    }

    public void setDirty() {
        this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
    }

    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.load(loadDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType, boolean overridePrefetched) throws ResourceRegistryException {
        RRElement w;
        if (!this.exists(persistencyType)) {
            return false;
        }
        boolean memLoaded = false;
        PersistenceManager pm = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        try {
            if (!overridePrefetched && persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    Field retrieved = (Field)InMemoryStore.getItem(((Object)((Object)this)).getClass(), (String)this.getID());
                    this.apply((IRRElement)retrieved, true, persistencyType, false);
                    memLoaded = true;
                }
                sharedLock.unlock();
                locked = false;
            }
            if (!memLoaded) {
                pm = this.getISContext().getManagerForRead(persistencyType);
                sharedLock.lock();
                locked = true;
                pm.currentTransaction().begin();
                this.item = (FieldDao)pm.detachCopy(pm.getObjectById(FieldDao.class, (Object)this.item.getID()));
                pm.currentTransaction().commit();
                sharedLock.unlock();
                locked = false;
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (pm != null && pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            if (pm != null) {
                pm.close();
            }
        }
        this.searchables.clear();
        for (String item : this.item.getSearchables()) {
            w = new Searchable();
            w.setID(item);
            if (!w.exists(persistencyType)) continue;
            if (loadDetails) {
                w.load(loadDetails, persistencyType, overridePrefetched);
            }
            this.searchables.add((Searchable)w);
        }
        this.presentables.clear();
        for (String item : this.item.getPresentables()) {
            w = new Presentable();
            w.setID(item);
            if (!w.exists(persistencyType)) continue;
            if (loadDetails) {
                w.load(loadDetails, persistencyType, overridePrefetched);
            }
            this.presentables.add((Presentable)w);
        }
        return true;
    }

    public boolean load(boolean loadDetails, String scope) throws ResourceRegistryException {
        if (ResourceRegistry.isReadPolicySupported((RRContext.ReadPolicy)RRContext.ReadPolicy.REFRESH_AHEAD)) {
            return this.load(loadDetails, scope, RRContext.DatastoreType.LOCAL);
        }
        if (ResourceRegistry.isReadPolicySupported((RRContext.ReadPolicy)RRContext.ReadPolicy.READ_THROUGH) && ResourceRegistry.isReadPolicySupported((RRContext.ReadPolicy)RRContext.ReadPolicy.READ_LOCAL)) {
            if (this.load(loadDetails, scope, RRContext.ReadPolicy.READ_LOCAL)) {
                return true;
            }
            return this.load(loadDetails, scope, RRContext.ReadPolicy.READ_THROUGH);
        }
        throw new ResourceRegistryException("Failed to find supported read policy");
    }

    public boolean load(boolean loadDetails, String scope, RRContext.ReadPolicy policy) throws ResourceRegistryException {
        if (!ResourceRegistry.isReadPolicySupported((RRContext.ReadPolicy)policy)) {
            throw new ResourceRegistryException("Read policy not supported");
        }
        if (policy == RRContext.ReadPolicy.READ_LOCAL || policy == RRContext.ReadPolicy.REFRESH_AHEAD) {
            return this.load(loadDetails, scope, RRContext.DatastoreType.LOCAL);
        }
        if (policy == RRContext.ReadPolicy.READ_THROUGH) {
            boolean result = false;
            if (ResourceRegistry.getContext().isDatastoreSupportedForRead(RRContext.DatastoreType.REMOTE)) {
                result = this.load(loadDetails, scope, RRContext.DatastoreType.REMOTE);
                if (result) {
                    this.store(loadDetails, scope, RRContext.DatastoreType.LOCAL);
                }
                return result;
            }
            ResourceRegistry.retrieveDirect(((Object)((Object)this)).getClass(), (String)this.getID());
            return this.load(loadDetails, scope, RRContext.DatastoreType.LOCAL);
        }
        throw new ResourceRegistryException("Unsupported read policy");
    }

    public boolean load(boolean loadDetails, String scope, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        if (!this.load(loadDetails, persistencyType)) {
            return false;
        }
        if (loadDetails) {
            HashSet<Searchable> filteredSearchables = new HashSet<Searchable>();
            for (Searchable s : this.searchables) {
                DataSource source = QueryHelper.GetSourceById(s.getLocator());
                if (source != null) {
                    if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                    filteredSearchables.add(s);
                    continue;
                }
                logger.log(Level.WARNING, "DataSource with id " + s.getLocator() + " not found");
            }
            HashSet<Presentable> filteredPresentables = new HashSet<Presentable>();
            for (Presentable p : this.presentables) {
                DataSource source = QueryHelper.GetSourceById(p.getLocator());
                if (source != null) {
                    if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                    filteredPresentables.add(p);
                    continue;
                }
                logger.log(Level.WARNING, "DataSource with id " + p.getLocator() + " not found");
            }
            this.searchables = filteredSearchables;
            this.presentables = filteredPresentables;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean deleteDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        if (!this.exists(persistencyType)) {
            return;
        }
        if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
            InMemoryStore.removeItem(((Object)((Object)this)).getClass(), (String)this.getID());
        }
        Field f = new Field();
        f.setID(this.getID());
        f.load(deleteDetails, persistencyType, true);
        PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
        try {
            ElementMetadata metadata = new ElementMetadata();
            metadata.setID(f.getName());
            metadata.setType(ElementMetadata.Type.DeletedField);
            metadata.store(true);
            if (behavior.isMarkDeletion()) {
                ElementMetadata elementMetadata = new ElementMetadata();
                elementMetadata.setID(this.getID() + (Object)((Object)ElementMetadata.Type.FieldRecentDeletion));
                elementMetadata.setType(ElementMetadata.Type.FieldRecentDeletion);
                elementMetadata.getProperties().put("id", f.getID());
                elementMetadata.store(true);
            }
            pm.currentTransaction().begin();
            pm.deletePersistent((Object)f.item);
            pm.currentTransaction().commit();
            pm.flush();
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
        if (deleteDetails) {
            for (Searchable searchable : f.searchables) {
                searchable.delete(deleteDetails, persistencyType);
            }
            for (Presentable presentable : f.presentables) {
                presentable.delete(deleteDetails, persistencyType);
            }
        }
    }

    public void delete(boolean deleteDetails, String scope) throws ResourceRegistryException {
        if (ResourceRegistry.isWritePolicySupported((RRContext.WritePolicy)RRContext.WritePolicy.WRITE_BEHIND)) {
            this.delete(deleteDetails, scope, RRContext.DatastoreType.LOCAL);
        } else if (ResourceRegistry.isWritePolicySupported((RRContext.WritePolicy)RRContext.WritePolicy.WRITE_THROUGH)) {
            this.delete(deleteDetails, scope, RRContext.WritePolicy.WRITE_THROUGH);
        } else {
            throw new ResourceRegistryException("Failed to find supported write policy");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(boolean deleteDetails, String scope, RRContext.WritePolicy policy) throws ResourceRegistryException {
        if (!ResourceRegistry.isWritePolicySupported((RRContext.WritePolicy)policy)) {
            throw new ResourceRegistryException("Write policy not supported");
        }
        if (policy == RRContext.WritePolicy.WRITE_LOCAL || policy == RRContext.WritePolicy.WRITE_BEHIND) {
            this.delete(deleteDetails, scope, RRContext.DatastoreType.LOCAL);
            return;
        } else {
            if (policy != RRContext.WritePolicy.WRITE_THROUGH) throw new ResourceRegistryException("Unsupported write policy");
            if (!ResourceRegistry.getContext().isDatastoreSupportedForWrite(RRContext.DatastoreType.REMOTE)) throw new ResourceRegistryException("This element does not support deletion");
            this.delete(deleteDetails, scope, RRContext.DatastoreType.REMOTE);
            this.delete(deleteDetails, scope, RRContext.DatastoreType.LOCAL);
        }
    }

    public void delete(boolean deleteDetails, String scope, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        if (!this.exists(persistencyType)) {
            return;
        }
        Field f = new Field();
        f.setID(this.getID());
        f.load(deleteDetails, persistencyType, true);
        HashSet<Searchable> filteredSearchables = new HashSet<Searchable>();
        boolean shouldDelete = true;
        for (Searchable item : f.searchables) {
            DataSource source = QueryHelper.GetSourceById(item.getLocator());
            if (source == null) {
                ElementMetadata metadata = null;
                metadata = ElementMetadata.getById(true, item.getLocator());
                if (metadata == null || Arrays.asList(metadata.getProperties().get("scopes").split(" ")).contains(scope)) continue;
                shouldDelete = false;
                filteredSearchables.add(item);
                continue;
            }
            if (SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
            shouldDelete = false;
            filteredSearchables.add(item);
        }
        HashSet<Presentable> filteredPresentables = new HashSet<Presentable>();
        for (Presentable item : f.presentables) {
            DataSource source = QueryHelper.GetSourceById(item.getLocator());
            if (source == null) {
                ElementMetadata metadata = null;
                metadata = ElementMetadata.getById(true, item.getLocator());
                if (metadata == null || Arrays.asList(metadata.getProperties().get("scopes").split(" ")).contains(scope)) continue;
                shouldDelete = false;
                filteredPresentables.add(item);
                continue;
            }
            if (SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
            shouldDelete = false;
            filteredPresentables.add(item);
        }
        if (shouldDelete) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Field " + this.getID() + " was left without searchables and presentables after scoped deletion. Deleting field...");
            }
            this.delete(deleteDetails, persistencyType);
        } else {
            this.store(deleteDetails, scope);
        }
    }

    public void store(boolean storeDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        this.store(storeDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(boolean storeDetails, RRContext.DatastoreType persistencyType, boolean writeThrough) throws ResourceRegistryException {
        if (this.exists(persistencyType) && !writeThrough) {
            Field item = new Field();
            item.setID(this.getID());
            item.load(storeDetails, persistencyType, true);
            item.apply((IRRElement)this, storeDetails, persistencyType, true);
        } else {
            this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                InMemoryStore.setItem(((Object)((Object)this)).getClass(), (IRRElement)this);
            }
            PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
            try {
                ElementMetadata updateMetadata;
                HashSet<String> sid = new HashSet<String>();
                HashSet<String> hashSet = new HashSet<String>();
                for (Searchable searchable : this.searchables) {
                    sid.add(searchable.getID());
                }
                for (Presentable presentable : this.presentables) {
                    hashSet.add(presentable.getID());
                }
                this.item.setSearchables(sid);
                this.item.setPresentables(hashSet);
                logger.log(Level.INFO, "Field id=" + this.getID() + " name=" + this.getName() + " searchables=" + sid);
                logger.log(Level.INFO, "Field id=" + this.getID() + " name=" + this.getName() + " presentables=" + hashSet);
                if (behavior.isMarkUpdate() && (updateMetadata = ElementMetadata.getById(true, this.getID() + (Object)((Object)ElementMetadata.Type.FieldRecentUpdate))) == null) {
                    updateMetadata = new ElementMetadata();
                    updateMetadata.setID(this.getID() + (Object)((Object)ElementMetadata.Type.FieldRecentUpdate));
                    updateMetadata.setType(ElementMetadata.Type.FieldRecentUpdate);
                    updateMetadata.getProperties().put("id", this.getID());
                    updateMetadata.store(true, persistencyType);
                }
                pm.currentTransaction().begin();
                this.item = (FieldDao)pm.detachCopy(pm.makePersistent((Object)this.item));
                pm.currentTransaction().commit();
                pm.flush();
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
            if (storeDetails) {
                for (Searchable searchable : this.searchables) {
                    searchable.setField(this.getID());
                    searchable.store(storeDetails, persistencyType);
                }
                for (Presentable presentable : this.presentables) {
                    presentable.setField(this.getID());
                    presentable.store(storeDetails, persistencyType);
                }
            }
        }
    }

    public void store(boolean storeDetails, String scope) throws ResourceRegistryException {
        if (ResourceRegistry.isWritePolicySupported((RRContext.WritePolicy)RRContext.WritePolicy.WRITE_BEHIND)) {
            logger.log(Level.INFO, "Field store with write behind");
            this.store(storeDetails, scope, RRContext.DatastoreType.LOCAL);
        } else if (ResourceRegistry.isWritePolicySupported((RRContext.WritePolicy)RRContext.WritePolicy.WRITE_THROUGH)) {
            logger.log(Level.INFO, "Field store with write through");
            this.store(storeDetails, scope, RRContext.WritePolicy.WRITE_THROUGH);
        } else {
            throw new ResourceRegistryException("Failed to find supported write policy");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store(boolean storeDetails, String scope, RRContext.WritePolicy policy) throws ResourceRegistryException {
        if (!ResourceRegistry.isWritePolicySupported((RRContext.WritePolicy)policy)) {
            throw new ResourceRegistryException("Write policy not supported");
        }
        if (policy == RRContext.WritePolicy.WRITE_LOCAL || policy == RRContext.WritePolicy.WRITE_BEHIND) {
            this.store(storeDetails, scope, RRContext.DatastoreType.LOCAL);
            return;
        } else {
            if (policy != RRContext.WritePolicy.WRITE_THROUGH) throw new ResourceRegistryException("Unsupported read policy");
            if (!ResourceRegistry.getContext().isDatastoreSupportedForWrite(RRContext.DatastoreType.REMOTE)) throw new ResourceRegistryException("This element does not support storing");
            this.store(storeDetails, scope, RRContext.DatastoreType.REMOTE);
            this.store(storeDetails, scope, RRContext.DatastoreType.LOCAL);
        }
    }

    public void store(boolean storeDetails, String scope, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        this.store(storeDetails, scope, persistencyType, false);
    }

    private void store(boolean storeDetails, String scope, RRContext.DatastoreType persistencyType, boolean writeThrough) throws ResourceRegistryException {
        if (this.exists(persistencyType) && !writeThrough) {
            logger.log(Level.INFO, "Field store and apply");
            Field item = new Field();
            item.setID(this.getID());
            item.load(storeDetails, persistencyType, true);
            item.apply((IRRElement)this, storeDetails, scope, persistencyType, true);
        } else {
            logger.log(Level.INFO, "Field store not apply");
            this.store(storeDetails, persistencyType, true);
        }
    }

    protected void apply(IRRElement target, boolean applyDetails, RRContext.DatastoreType persistencyType, boolean doStore) throws ResourceRegistryException {
        if (!(target instanceof Field)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.isEqual(target, applyDetails)) {
            return;
        }
        this.item.setDescription(((Field)target).item.getDescription());
        this.item.setName(((Field)target).item.getName());
        this.item.setPresentables(((Field)target).item.getPresentables());
        this.item.setSearchables(((Field)target).item.getSearchables());
        if (applyDetails) {
            HashSet<Searchable> toDelSearchable = new HashSet<Searchable>();
            HashSet<Searchable> toAddSearchable = new HashSet<Searchable>();
            for (Searchable item : this.searchables) {
                Searchable s = ((Field)target).getSearchable(item.getID());
                if (s == null) {
                    toDelSearchable.add(item);
                    continue;
                }
                item.apply((IRRElement)s, applyDetails, persistencyType, false);
            }
            for (Searchable item : ((Field)target).searchables) {
                if (this.getSearchable(item.getID()) != null) continue;
                toAddSearchable.add(item);
            }
            for (Searchable item : toDelSearchable) {
                item.delete(true);
                this.searchables.remove((Object)item);
            }
            for (Searchable item : toAddSearchable) {
                this.searchables.add(item);
            }
            HashSet<Presentable> toDelPresentable = new HashSet<Presentable>();
            HashSet<Presentable> toAddPresentable = new HashSet<Presentable>();
            for (Presentable item : this.presentables) {
                Presentable s = ((Field)target).getPresentable(item.getID());
                if (s == null) {
                    toDelPresentable.add(item);
                    continue;
                }
                item.apply((IRRElement)s, applyDetails, persistencyType, false);
            }
            for (Presentable item : ((Field)target).presentables) {
                if (this.getPresentable(item.getID()) != null) continue;
                toAddPresentable.add(item);
            }
            for (Presentable item : toDelPresentable) {
                item.delete(true);
                this.presentables.remove((Object)item);
            }
            for (Presentable item : toAddPresentable) {
                this.presentables.add(item);
            }
            logger.log(Level.FINE, "Field id=" + this.getID() + " name=" + this.getName() + " To add searchables=" + toAddSearchable.size());
            logger.log(Level.FINE, "Field id=" + this.getID() + " name=" + this.getName() + " To del searchables=" + toDelSearchable.size());
            logger.log(Level.FINE, "Field id=" + this.getID() + " name=" + this.getName() + " To add presentables=" + toAddPresentable.size());
            logger.log(Level.FINE, "Field id=" + this.getID() + " name=" + this.getName() + " To del presentables=" + toDelPresentable.size());
        }
        if (doStore) {
            this.store(applyDetails, persistencyType, true);
        }
    }

    protected void apply(IRRElement target, boolean applyDetails, String scope, RRContext.DatastoreType persistencyType, boolean doStore) throws ResourceRegistryException {
        if (!(target instanceof Field)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.isEqual(target, applyDetails)) {
            return;
        }
        this.item.setDescription(((Field)target).item.getDescription());
        this.item.setName(((Field)target).item.getName());
        this.item.setPresentables(((Field)target).item.getPresentables());
        this.item.setSearchables(((Field)target).item.getSearchables());
        if (applyDetails) {
            HashSet<Searchable> toDelSearchable = new HashSet<Searchable>();
            HashSet<Searchable> toAddSearchable = new HashSet<Searchable>();
            for (Searchable item : this.searchables) {
                DataSource source;
                Searchable s = ((Field)target).getSearchable(item.getID());
                if (s == null) {
                    source = QueryHelper.GetSourceById(item.getLocator());
                    if (source == null) {
                        logger.log(Level.WARNING, "No source with the provided id (" + item.getLocator() + ") exists");
                        continue;
                    }
                    if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                    toDelSearchable.add(item);
                    continue;
                }
                source = QueryHelper.GetSourceById(s.getLocator());
                if (source == null) {
                    throw new ResourceRegistryException("No source with the provided id (" + s.getLocator() + ") exists");
                }
                if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                item.apply((IRRElement)s, applyDetails, persistencyType, false);
            }
            for (Searchable item : ((Field)target).searchables) {
                if (this.getSearchable(item.getID()) != null) continue;
                DataSource source = QueryHelper.GetSourceById(item.getLocator());
                if (source == null) {
                    throw new ResourceRegistryException("No source with the provided id (" + item.getLocator() + ") exists");
                }
                if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                toAddSearchable.add(item);
            }
            logger.log(Level.INFO, "toDelSearchable : " + toDelSearchable);
            logger.log(Level.INFO, "toAddSearchable : " + toAddSearchable);
            for (Searchable item : toDelSearchable) {
                item.delete(true);
                this.searchables.remove((Object)item);
            }
            for (Searchable item : toAddSearchable) {
                this.searchables.add(item);
            }
            HashSet<Presentable> toDelPresentable = new HashSet<Presentable>();
            HashSet<Presentable> toAddPresentable = new HashSet<Presentable>();
            for (Presentable item : this.presentables) {
                DataSource source;
                Presentable s = ((Field)target).getPresentable(item.getID());
                if (s == null) {
                    source = QueryHelper.GetSourceById(item.getLocator());
                    if (source == null) {
                        logger.log(Level.WARNING, "No source with the provided id (" + item.getLocator() + ") exists");
                        continue;
                    }
                    if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                    toDelPresentable.add(item);
                    continue;
                }
                source = QueryHelper.GetSourceById(s.getLocator());
                if (source == null) {
                    throw new ResourceRegistryException("No source with the provided id (" + s.getLocator() + ") exists");
                }
                if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                item.apply((IRRElement)s, applyDetails, persistencyType, false);
            }
            for (Presentable item : ((Field)target).presentables) {
                if (this.getPresentable(item.getID()) != null) continue;
                DataSource source = QueryHelper.GetSourceById(item.getLocator());
                if (source == null) {
                    throw new ResourceRegistryException("No source with the provided id (" + item.getLocator() + ") exists");
                }
                if (!SourceHelper.getScopesOfSource((IRRElement)source).contains(scope)) continue;
                toAddPresentable.add(item);
            }
            for (Presentable item : toDelPresentable) {
                item.delete(true);
                this.presentables.remove((Object)item);
            }
            for (Presentable item : toAddPresentable) {
                this.presentables.add(item);
            }
        }
        if (doStore) {
            this.store(applyDetails, scope, persistencyType, true);
        }
    }

    public boolean isEqual(IRRElement target, boolean includeDetails) throws ResourceRegistryException {
        if (!(target instanceof Field)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.item.getID() == null && ((Field)target).item.getID() != null) {
            return false;
        }
        if (this.item.getID() != null && ((Field)target).item.getID() == null) {
            return false;
        }
        if (this.item.getID() != null && ((Field)target).item.getID() != null && !this.item.getID().equals(((Field)target).item.getID())) {
            return false;
        }
        if (this.item.getDescription() == null && ((Field)target).item.getDescription() != null) {
            return false;
        }
        if (this.item.getDescription() != null && ((Field)target).item.getDescription() == null) {
            return false;
        }
        if (this.item.getDescription() != null && ((Field)target).item.getDescription() != null && !this.item.getDescription().equals(((Field)target).item.getDescription())) {
            return false;
        }
        if (this.item.getName() == null && ((Field)target).item.getName() != null) {
            return false;
        }
        if (this.item.getName() != null && ((Field)target).item.getName() == null) {
            return false;
        }
        if (this.item.getName() != null && ((Field)target).item.getName() != null && !this.item.getName().equals(((Field)target).item.getName())) {
            return false;
        }
        if (this.item.getPresentables().size() != ((Field)target).getPresentables().size() && this.getPresentables().size() != ((Field)target).getPresentables().size()) {
            return false;
        }
        if (!((Field)target).getPresentables().containsAll(this.item.getPresentables())) {
            HashSet<String> thisPresentables = new HashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            for (Presentable p : this.getPresentables()) {
                thisPresentables.add(p.getID());
            }
            for (Presentable p : ((Field)target).getPresentables()) {
                hashSet.add(p.getID());
            }
            if (!hashSet.containsAll(thisPresentables)) {
                return false;
            }
        }
        if (this.item.getSearchables().size() != ((Field)target).getSearchables().size()) {
            return false;
        }
        if (!((Field)target).getSearchables().containsAll(this.item.getSearchables())) {
            HashSet<String> thisSearchables = new HashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            for (Searchable s : this.getSearchables()) {
                thisSearchables.add(s.getID());
            }
            for (Searchable s : ((Field)target).getSearchables()) {
                hashSet.add(s.getID());
            }
            if (!hashSet.containsAll(thisSearchables)) {
                return false;
            }
        }
        if (includeDetails) {
            RRElement tmp;
            if (this.searchables.size() != ((Field)target).searchables.size()) {
                return false;
            }
            for (Searchable searchable : ((Field)target).searchables) {
                tmp = this.getSearchable(searchable.getID());
                if (tmp == null) {
                    return false;
                }
                if (tmp.isEqual((IRRElement)searchable, includeDetails)) continue;
                return false;
            }
            if (this.presentables.size() != ((Field)target).presentables.size()) {
                return false;
            }
            for (Presentable presentable : ((Field)target).presentables) {
                tmp = this.getPresentable(presentable.getID());
                if (tmp == null) {
                    return false;
                }
                if (tmp.isEqual((IRRElement)presentable, includeDetails)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Field)) {
            return false;
        }
        return this.item.getID().equals(((Field)((Object)other)).getID());
    }

    public Searchable getSearchable(String id) {
        for (Searchable item : this.searchables) {
            if (!item.getID().equals(id)) continue;
            return item;
        }
        return null;
    }

    public Presentable getPresentable(String id) {
        for (Presentable item : this.presentables) {
            if (!item.getID().equals(id)) continue;
            return item;
        }
        return null;
    }

    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.item.deepToString());
        for (Searchable searchable : this.searchables) {
            buf.append(searchable.deepToString());
        }
        for (Presentable presentable : this.presentables) {
            buf.append(presentable.deepToString());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(FieldDao.class, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", this.getID());
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getAll(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        ArrayList<Field> col = new ArrayList<Field>();
        boolean memLoaded = false;
        try {
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && ResourceRegistry.getContext().isTargetInMemory(Field.class.getName())) {
                sharedLock.lock();
                locked = true;
                Set retrieved = InMemoryStore.getItems(Field.class);
                sharedLock.unlock();
                locked = false;
                if (retrieved != null) {
                    for (Object item : retrieved) {
                        col.add((Field)((Object)item));
                    }
                    memLoaded = true;
                }
            }
            if (!memLoaded) {
                pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
                query = pm.newNamedQuery(FieldDao.class, "allFields");
                query.compile();
                sharedLock.lock();
                locked = true;
                Collection res = (Collection)query.execute();
                sharedLock.unlock();
                locked = false;
                for (Object item : res) {
                    Field f = new Field();
                    f.setID((String)item);
                    f.load(loadDetails, persistencyType);
                    col.add(f);
                }
            } else if (loadDetails) {
                for (Field f : col) {
                    for (Searchable s : f.getSearchables()) {
                        s.load(true);
                    }
                    for (Presentable p : f.getPresentables()) {
                        p.load(true);
                    }
                }
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    public static List<Field> getAll(boolean loadDetails) throws ResourceRegistryException {
        return Field.getAll(loadDetails, RRContext.DatastoreType.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getAll(boolean loadDetails, String scope) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        ArrayList<Field> col = new ArrayList<Field>();
        PersistenceManager pm = null;
        Query query = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            query = pm.newNamedQuery(FieldDao.class, "allFields");
            query.compile();
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.execute();
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                Field f = new Field();
                f.setID(item);
                f.load(loadDetails, scope);
                col.add(f);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    public static Field getById(boolean loadDetails, String id) throws ResourceRegistryException {
        Field f = new Field();
        f.setID(id);
        return f.load(loadDetails) ? f : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFieldNameById(String id) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            query = pm.newNamedQuery(FieldDao.class, "fieldName");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", id);
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            sharedLock.unlock();
            locked = false;
            if (res.size() == 0) {
                String string = null;
                return string;
            }
            String string = (String)res.iterator().next();
            return string;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getFieldsWithName(boolean loadDetails, String name) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        ArrayList<Field> col = new ArrayList<Field>();
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            query = pm.newNamedQuery(FieldDao.class, "fieldsWithName");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("name", name);
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                Field f = new Field();
                f.setID(item);
                f.load(loadDetails);
                col.add(f);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getSearchableFieldsOfCollection(boolean loadDetails, String collection) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        ArrayList<Field> col = new ArrayList<Field>();
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            query = pm.newNamedQuery(FieldDao.class, "searchableFieldsOfCollection");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("collection", collection);
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                Field f = new Field();
                f.setID(item);
                f.load(loadDetails);
                col.add(f);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getSearchableFieldsOfCollections(boolean loadDetails, boolean filter, Set<String> collections) throws ResourceRegistryException {
        PersistenceManager pm = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        Query query = null;
        ArrayList<Field> col = new ArrayList<Field>();
        Set allDatasources = null;
        if (loadDetails && filter) {
            try {
                allDatasources = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
            }
            catch (Exception e) {
                throw new ResourceRegistryException("Could not load data source info", (Throwable)e);
            }
        }
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            Set<String> fieldIDs = Searchable.getFieldsOfCollections(collections);
            query = pm.newNamedQuery(FieldDao.class, "fields");
            query.compile();
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.execute(fieldIDs);
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                Field f = new Field();
                f.setID(item);
                f.load(loadDetails);
                if (loadDetails && filter) {
                    HashSet<Searchable> filterOut = new HashSet<Searchable>();
                    for (Searchable s : f.searchables) {
                        if (!collections.contains(s.getCollection())) {
                            filterOut.add(s);
                        }
                        DataSourceDao ds = null;
                        for (IDaoElement d : allDatasources) {
                            if (!((DataSourceDao)d).getID().equals(s.getLocator())) continue;
                            ds = (DataSourceDao)d;
                            break;
                        }
                        if (ds != null) continue;
                        filterOut.add(s);
                    }
                    f.searchables.removeAll(filterOut);
                }
                col.add(f);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    public static List<Field> getBrowsableFieldsOfCollection(boolean loadDetails, String collection) throws ResourceRegistryException {
        ArrayList<Field> filteredCol = new ArrayList<Field>();
        List<Field> col = Field.getSearchableFieldsOfCollection(loadDetails, collection);
        logger.log(Level.INFO, "getting browsable fields of collection : " + collection);
        Set allDatasources = null;
        try {
            allDatasources = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not load data source info", e);
            throw new ResourceRegistryException("Could not load data source info", (Throwable)e);
        }
        block2: for (Field f : col) {
            logger.log(Level.WARNING, "checking if field : " + f.getID() + " : " + f.getName());
            for (Searchable s : f.getSearchables()) {
                logger.log(Level.WARNING, "s  : " + s.getID() + " : " + s.getField() + " is searchable of field : " + f.getID() + " : " + f.getName() + " and belongs to collection : " + s.getCollection());
                if (!s.getCollection().equals(collection)) continue;
                DataSourceDao ds = null;
                for (IDaoElement d : allDatasources) {
                    if (!((DataSourceDao)d).getID().equals(s.getLocator())) continue;
                    ds = (DataSourceDao)d;
                    break;
                }
                if (ds == null) {
                    logger.log(Level.WARNING, "Could not find datasource " + s.getLocator() + " of searchable " + s.getID());
                    continue;
                }
                logger.log(Level.WARNING, "found datasource for searchable  : " + s.getID() + " : " + s.getField() + " with type : " + ds.getType());
                if (!ds.getType().equals(DataSource.Type.FullTextIndex.toString())) continue;
                filteredCol.add(f);
                continue block2;
            }
        }
        String foundFields = new String();
        for (Field f : filteredCol) {
            String val = f.getID() + " : " + f.getName();
            foundFields = foundFields + val + ", ";
        }
        logger.log(Level.INFO, "browsable fields of collection : " + collection + " : " + foundFields);
        return filteredCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getBrowsableFieldsOfCollections(boolean loadDetails, boolean filter, Set<String> collections) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        ArrayList<Field> col = new ArrayList<Field>();
        PersistenceManager pm = null;
        Query query = null;
        Set allDatasources = null;
        try {
            allDatasources = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not load data source info", (Throwable)e);
        }
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            Set<String> fieldIDs = Searchable.getFieldsOfCollections(collections);
            query = pm.newNamedQuery(FieldDao.class, "fields");
            query.compile();
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.execute(fieldIDs);
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                Field f = new Field();
                f.setID(item);
                f.load(loadDetails);
                boolean omit = false;
                for (Searchable s : f.getSearchables()) {
                    DataSourceDao ds = null;
                    for (IDaoElement d : allDatasources) {
                        if (!((DataSourceDao)d).getID().equals(s.getLocator())) continue;
                        ds = (DataSourceDao)d;
                        break;
                    }
                    if (ds == null || ds.getType().equals(DataSource.Type.ForwardIndex.toString())) continue;
                    omit = true;
                    break;
                }
                if (omit) continue;
                if (loadDetails && filter) {
                    HashSet<Searchable> filterOut = new HashSet<Searchable>();
                    for (Searchable s : f.searchables) {
                        if (collections.contains(s.getCollection())) continue;
                        filterOut.add(s);
                    }
                    f.searchables.removeAll(filterOut);
                }
                col.add(f);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getPresentableFieldsOfCollection(boolean loadDetails, String collection) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        ArrayList<Field> col = new ArrayList<Field>();
        Set allDatasources = null;
        try {
            allDatasources = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not load data source info", (Throwable)e);
        }
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            query = pm.newNamedQuery(FieldDao.class, "presentableFieldsOfCollection");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("collection", collection);
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                Field f = new Field();
                f.setID(item);
                f.load(loadDetails);
                HashSet<Presentable> filterOut = new HashSet<Presentable>();
                for (Presentable s : f.presentables) {
                    DataSourceDao ds = null;
                    for (IDaoElement d : allDatasources) {
                        if (!((DataSourceDao)d).getID().equals(s.getLocator())) continue;
                        ds = (DataSourceDao)d;
                    }
                    if (ds != null) continue;
                    filterOut.add(s);
                }
                f.presentables.removeAll(filterOut);
                if (f.presentables.isEmpty()) continue;
                col.add(f);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getPresentableFieldsOfCollections(boolean loadDetails, boolean filter, Set<String> collections) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        ArrayList<Field> col = new ArrayList<Field>();
        Set allDatasources = null;
        if (loadDetails && filter) {
            try {
                allDatasources = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
            }
            catch (Exception e) {
                throw new ResourceRegistryException("Could not load data source info", (Throwable)e);
            }
        }
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(RRContext.DatastoreType.LOCAL);
            Set<String> fieldIDs = Searchable.getFieldsOfCollections(collections);
            query = pm.newNamedQuery(FieldDao.class, "fields");
            query.compile();
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.execute(fieldIDs);
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                Field f = new Field();
                f.setID(item);
                f.load(loadDetails);
                if (loadDetails && filter) {
                    HashSet<Presentable> filterOut = new HashSet<Presentable>();
                    for (Presentable s : f.presentables) {
                        if (!collections.contains(s.getCollection())) {
                            filterOut.add(s);
                        }
                        DataSourceDao ds = null;
                        for (IDaoElement d : allDatasources) {
                            if (!((DataSourceDao)d).getID().equals(s.getLocator())) continue;
                            ds = (DataSourceDao)d;
                            break;
                        }
                        if (ds != null) continue;
                        filterOut.add(s);
                    }
                    f.presentables.removeAll(filterOut);
                }
                if (f.presentables.isEmpty()) continue;
                col.add(f);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    public static List<Field> getSearchableFieldsOfCollectionByCapabilities(boolean loadDetails, String collection, Set<String> capabilities) throws ResourceRegistryException {
        List<Field> allSearchableFields = Field.getSearchableFieldsOfCollection(loadDetails, collection);
        Set allDatasources = null;
        try {
            allDatasources = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not load data source info", (Throwable)e);
        }
        ArrayList<Field> filteredSearchableFields = new ArrayList<Field>();
        block2: for (Field f : allSearchableFields) {
            boolean found = false;
            for (Searchable s : f.getSearchables()) {
                if (s.getCollection().equals(collection)) {
                    DataSourceDao ds = null;
                    for (IDaoElement d : allDatasources) {
                        if (!((DataSourceDao)d).getID().equals(s.getLocator())) continue;
                        ds = (DataSourceDao)d;
                        break;
                    }
                    if (ds == null) continue;
                    for (String capability : capabilities) {
                        if (!ds.getCapabilities().contains(capability)) continue;
                        filteredSearchableFields.add(f);
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                continue block2;
            }
        }
        return filteredSearchableFields;
    }

    public static class Behavior {
        private boolean markUpdate = true;
        private boolean markDeletion = true;

        public boolean isMarkUpdate() {
            return this.markUpdate;
        }

        public void setMarkUpdate(boolean markUpdate) {
            this.markUpdate = markUpdate;
        }

        public boolean isMarkDeletion() {
            return this.markDeletion;
        }

        public void setMarkDeletion(boolean markDeletion) {
            this.markDeletion = markDeletion;
        }
    }
}

