/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.RRElement;
import gr.uoa.di.madgik.rr.element.infra.HostingNode;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceServiceDao;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public abstract class DataSourceService
extends RRElement {
    private static Logger logger = Logger.getLogger(DataSourceService.class.getName());
    private static Map<Class<? extends DataSourceService>, Class<? extends DataSourceServiceDao>> SubTypes = new HashMap<Class<? extends DataSourceService>, Class<? extends DataSourceServiceDao>>();
    private static Map<Class<? extends DataSourceServiceDao>, Class<? extends DataSourceService>> ReverseSubTypes = new HashMap<Class<? extends DataSourceServiceDao>, Class<? extends DataSourceService>>();
    private static Map<Type, Class<? extends DataSourceService>> SubTypesMap = new HashMap<Type, Class<? extends DataSourceService>>();
    protected DataSourceServiceDao item = null;
    protected Set<DataSource> datasources = null;
    protected HostingNode hostingNode = null;
    protected RRContext context = null;
    private Class<? extends DataSourceServiceDao> daoType = null;

    public static void clearSubTypes() {
        SubTypesMap.clear();
        SubTypes.clear();
        ReverseSubTypes.clear();
    }

    public static void addSubType(Type type, Class<? extends DataSourceService> service, Class<? extends DataSourceServiceDao> serviceDao) {
        SubTypesMap.put(type, service);
        SubTypes.put(service, serviceDao);
        ReverseSubTypes.put(serviceDao, service);
    }

    public static Set<Class<? extends DataSourceService>> subTypes() {
        return SubTypes.keySet();
    }

    public static Set<Class<? extends DataSourceServiceDao>> subTypeItems() {
        return new HashSet<Class<? extends DataSourceServiceDao>>(SubTypes.values());
    }

    public RRContext getISContext() {
        return this.context;
    }

    protected DataSourceService(Class<? extends DataSourceServiceDao> type) throws ResourceRegistryException {
        try {
            this.item = type.newInstance();
            this.daoType = type;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Unknown dao type: " + type.getName(), (Throwable)e);
        }
        this.item.setID(UUID.randomUUID().toString());
        this.context = ResourceRegistry.getContext();
    }

    public String getID() {
        return this.item.getID();
    }

    public void setID(String id) {
        this.item.setID(id);
    }

    public Type getType() {
        return Type.valueOf(this.item.getType());
    }

    protected void setType(Type type) {
        this.item.setType(type.toString());
    }

    public Set<String> getScopes() {
        return this.item.getScopes();
    }

    public String getHostingNode() {
        return this.item.getHostingNode();
    }

    public void setHostingNode(String hostingNode) {
        this.item.setHostingNode(hostingNode);
    }

    public String getEndpoint() {
        return this.item.getEndpoint();
    }

    public void setEndpoint(String endpoint) {
        this.item.setEndpoint(endpoint);
    }

    public Set<DataSource> getDataSources() {
        return this.datasources;
    }

    public String getFunctionality() {
        return this.item.getFunctionality();
    }

    public void setFunctionality(String functionality) {
        this.item.setFunctionality(functionality);
    }

    public DataSourceServiceDao getItem() {
        return this.item;
    }

    public void setDirty() {
        this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
    }

    private void apply(IRRElement target, boolean applyDetails, RRContext.DatastoreType persistencyType, boolean doStore) throws ResourceRegistryException {
        if (!(target instanceof DataSourceService)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.isEqual(target, applyDetails)) {
            return;
        }
        this.item.setID(((DataSourceService)target).item.getID());
        this.item.setEndpoint(((DataSourceService)target).item.getEndpoint());
        this.item.setHostingNode(((DataSourceService)target).item.getHostingNode());
        this.item.setType(((DataSourceService)target).item.getType());
        this.item.setFunctionality(((DataSourceService)target).item.getFunctionality());
        this.item.getDataSources().addAll(((DataSourceService)target).item.getDataSources());
        this.item.setScopes(((DataSourceService)target).item.getScopes());
        if (doStore) {
            this.store(applyDetails, persistencyType, true);
        }
    }

    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.load(loadDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType, boolean overridePrefetched) throws ResourceRegistryException {
        long existEnd;
        long existStart = Calendar.getInstance().getTimeInMillis();
        if (!this.exists(persistencyType)) {
            return false;
        }
        long lookupStart = existEnd = Calendar.getInstance().getTimeInMillis();
        boolean memLoaded = false;
        PersistenceManager pm = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        try {
            if (!overridePrefetched && persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    DataSourceService retrieved = (DataSourceService)InMemoryStore.getItem(((Object)((Object)this)).getClass(), (String)this.getID());
                    this.apply((IRRElement)retrieved, loadDetails, persistencyType, false);
                    memLoaded = true;
                }
                sharedLock.unlock();
                locked = false;
            }
            if (!memLoaded) {
                pm = this.getISContext().getManagerForRead(persistencyType);
                sharedLock.lock();
                locked = true;
                pm.currentTransaction().begin();
                this.item = (DataSourceServiceDao)pm.detachCopy(pm.getObjectById(this.daoType, (Object)this.item.getID()));
                pm.currentTransaction().commit();
                sharedLock.unlock();
                locked = false;
            }
            HostingNode hn = new HostingNode();
            hn.setID(this.item.getHostingNode());
            if (loadDetails) {
                if (hn.exists(persistencyType)) {
                    hn.load(loadDetails, persistencyType);
                } else {
                    logger.log(Level.WARNING, "Hosting node " + hn.getID() + " does not exist!");
                }
                this.hostingNode = hn;
                this.datasources = new HashSet<DataSource>();
                for (String dsId : this.item.getDataSources()) {
                    DataSource d = DataSource.getById(loadDetails, dsId);
                    if (d != null) {
                        this.datasources.add(d);
                        continue;
                    }
                    logger.log(Level.WARNING, "Datasource " + dsId + " does not exist!");
                }
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (pm != null && pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            if (pm != null) {
                pm.close();
            }
        }
        long lookupEnd = Calendar.getInstance().getTimeInMillis();
        return true;
    }

    public void store(boolean storeDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        this.store(storeDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(boolean storeDetails, RRContext.DatastoreType persistencyType, boolean writeThrough) throws ResourceRegistryException {
        if (this.exists(persistencyType) && !writeThrough) {
            DataSourceService item = null;
            try {
                item = (DataSourceService)((Object)((Object)((Object)this)).getClass().newInstance());
            }
            catch (Exception e) {
                throw new ResourceRegistryException("Could not store data source service", (Throwable)e);
            }
            item.setID(this.getID());
            item.load(storeDetails, persistencyType, true);
            item.apply((IRRElement)this, false, persistencyType, true);
        } else {
            this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                InMemoryStore.setItem(((Object)((Object)this)).getClass(), (IRRElement)this);
            }
            PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
            try {
                HashSet<String> did = new HashSet<String>();
                if (this.getDataSources() != null) {
                    for (DataSource item : this.getDataSources()) {
                        did.add(item.getID());
                    }
                    this.item.setDataSources(did);
                }
                pm.currentTransaction().begin();
                this.item = (DataSourceServiceDao)pm.detachCopy(pm.makePersistent((Object)this.item));
                pm.currentTransaction().commit();
                pm.flush();
                if (storeDetails) {
                    for (DataSource d : this.datasources) {
                        d.store(storeDetails, persistencyType);
                    }
                    this.hostingNode.store(storeDetails, persistencyType);
                }
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
        }
    }

    public void delete(boolean deleteDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        if (deleteDetails) {
            throw new ResourceRegistryException("Unsupported operation");
        }
        if (!this.exists(persistencyType)) {
            return;
        }
        if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
            InMemoryStore.removeItem(((Object)((Object)this)).getClass(), (String)this.getID());
        }
        PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
        try {
            DataSourceService d = (DataSourceService)((Object)((Object)((Object)this)).getClass().newInstance());
            d.setID(this.getID());
            d.load(deleteDetails, persistencyType, true);
            pm.currentTransaction().begin();
            pm.deletePersistent((Object)d.item);
            pm.currentTransaction().commit();
            pm.flush();
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not delete data source", (Throwable)e);
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    public boolean isEqual(IRRElement target, boolean includeDetails) throws ResourceRegistryException {
        if (!(target instanceof DataSourceService)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.item.getID() == null && ((DataSourceService)target).item.getID() != null) {
            return false;
        }
        if (this.item.getID() != null && ((DataSourceService)target).item.getID() == null) {
            return false;
        }
        if (this.item.getID() != null && ((DataSourceService)target).item.getID() != null && !this.item.getID().equals(((DataSourceService)target).item.getID())) {
            return false;
        }
        if (this.item.getFunctionality() == null && ((DataSourceService)target).item.getFunctionality() != null) {
            return false;
        }
        if (this.item.getFunctionality() != null && ((DataSourceService)target).item.getFunctionality() == null) {
            return false;
        }
        if (this.item.getFunctionality() != null && ((DataSourceService)target).item.getFunctionality() != null && !this.item.getFunctionality().equals(((DataSourceService)target).item.getFunctionality())) {
            return false;
        }
        if (this.item.getEndpoint() == null && ((DataSourceService)target).item.getEndpoint() != null) {
            return false;
        }
        if (this.item.getEndpoint() != null && ((DataSourceService)target).item.getEndpoint() == null) {
            return false;
        }
        if (this.item.getEndpoint() != null && ((DataSourceService)target).item.getEndpoint() != null && !this.item.getEndpoint().equals(((DataSourceService)target).item.getEndpoint())) {
            return false;
        }
        if (this.item.getHostingNode() == null && ((DataSourceService)target).item.getHostingNode() != null) {
            return false;
        }
        if (this.item.getHostingNode() != null && ((DataSourceService)target).item.getHostingNode() == null) {
            return false;
        }
        if (this.item.getHostingNode() != null && ((DataSourceService)target).item.getHostingNode() != null && !this.item.getHostingNode().equals(((DataSourceService)target).item.getHostingNode())) {
            return false;
        }
        if (((DataSourceService)target).getDataSources() != null) {
            if (this.item.getDataSources().size() != ((DataSourceService)target).getDataSources().size()) {
                return false;
            }
            if (!((DataSourceService)target).getDataSources().containsAll(this.item.getDataSources())) {
                return false;
            }
        }
        if (this.item.getScopes().size() != ((DataSourceService)target).getScopes().size()) {
            return false;
        }
        if (!((DataSourceService)target).getScopes().containsAll(this.item.getScopes())) {
            return false;
        }
        if (includeDetails) {
            if (this.datasources.size() != ((DataSourceService)target).datasources.size()) {
                return false;
            }
            for (DataSource item : ((DataSourceService)target).datasources) {
                DataSource tmp = this.getDataSource(item.getID());
                if (tmp == null) {
                    return false;
                }
                if (tmp.isEqual((IRRElement)item, includeDetails)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!other.getClass().isInstance(((Object)((Object)this)).getClass())) {
            return false;
        }
        return this.item.getID().equals(((DataSource)((Object)other)).getID());
    }

    public DataSource getDataSource(String id) {
        for (DataSource item : this.datasources) {
            if (!item.getID().equals(id)) continue;
            return item;
        }
        return null;
    }

    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DataSourceService - ID : " + this.getID() + "\n");
        buf.append("DataSourceService - Type : " + (Object)((Object)this.getType()) + "\n");
        buf.append("DataSourceService - EndPoint : " + this.getEndpoint() + "\n");
        buf.append("DataSourceService - Functionality : " + this.getFunctionality() + "\n");
        buf.append("DataSourceService - Hosting Node : " + this.getHostingNode() + "\n");
        buf.append("DataSourceService - Scopes : ");
        for (String scope : this.getScopes()) {
            buf.append(scope + " ");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(Class<? extends DataSourceServiceDao> type, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(type, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", this.getID());
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.exists(DataSourceServiceDao.class, persistencyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<DataSourceService> getAll(Class<? extends DataSourceServiceDao> type, RRContext.DatastoreType persistencyType, boolean loadDetails) throws ResourceRegistryException {
        ArrayList<DataSourceService> col = new ArrayList<DataSourceService>();
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        Query typeQuery = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(type, "all");
            query.compile();
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.execute();
            sharedLock.unlock();
            locked = false;
            Class<? extends DataSourceServiceDao> targetType = null;
            boolean base = false;
            if (type.getName().equals(DataSourceServiceDao.class.getName())) {
                base = true;
            } else {
                targetType = type;
            }
            HashMap<String, String> typeQueryArgs = new HashMap<String, String>();
            if (base) {
                typeQuery = pm.newNamedQuery(type, "getType");
                typeQuery.compile();
            }
            try {
                for (String item : res) {
                    Class<? extends DataSourceService> typeToInstantiate;
                    if (base) {
                        typeQueryArgs.put("id", item);
                        sharedLock.lock();
                        locked = true;
                        Collection t = (Collection)typeQuery.executeWithMap(typeQueryArgs);
                        sharedLock.unlock();
                        locked = false;
                        targetType = SubTypes.get(SubTypesMap.get((Object)Type.valueOf((String)t.iterator().next())));
                        if (targetType == null) continue;
                    }
                    if ((typeToInstantiate = ReverseSubTypes.get(targetType)) == null) continue;
                    DataSourceService f = typeToInstantiate.newInstance();
                    f.setID(item);
                    f.load(loadDetails, persistencyType);
                    col.add(f);
                }
            }
            catch (IllegalAccessException e) {
                throw new ResourceRegistryException("Could not instantiate type: " + type.getName(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ResourceRegistryException("Could not instantiate type: " + type.getName(), (Throwable)e);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (typeQuery != null) {
                typeQuery.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    public static List<DataSourceService> getAll(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return DataSourceService.getAll(DataSourceServiceDao.class, persistencyType, loadDetails);
    }

    public static List<DataSourceService> getAll(boolean loadDetails) throws ResourceRegistryException {
        return DataSourceService.getAll(loadDetails, RRContext.DatastoreType.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String id, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(DataSourceServiceDao.class, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", id);
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAllIds(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        Collection res = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(DataSourceServiceDao.class, "all");
            query.compile();
            sharedLock.lock();
            locked = true;
            res = (Collection)query.execute();
            sharedLock.unlock();
            locked = false;
            HashSet<String> hashSet = new HashSet<String>(res);
            return hashSet;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public static Set<String> getAllIds() throws ResourceRegistryException {
        return DataSourceService.getAllIds(RRContext.DatastoreType.LOCAL);
    }

    public static boolean exists(String id) throws ResourceRegistryException {
        return DataSourceService.exists(id, RRContext.DatastoreType.LOCAL);
    }

    public static DataSourceService getById(boolean loadDetails, RRContext.DatastoreType persistencyType, String id) throws ResourceRegistryException {
        PersistenceManager pm = null;
        Query typeQuery = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        Class<? extends DataSourceService> typeToInstantiate = null;
        try {
            long instantiateEnd;
            boolean memLoaded = false;
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL)) {
                boolean inMemory = false;
                for (Class<? extends DataSourceService> type : DataSourceService.subTypes()) {
                    if (!ResourceRegistry.getContext().isTargetInMemory(type.getName())) continue;
                    inMemory = true;
                }
                if (inMemory) {
                    sharedLock.lock();
                    locked = true;
                    for (Class<? extends DataSourceService> type : DataSourceService.subTypes()) {
                        if (!InMemoryStore.hasItem(type, (String)id)) continue;
                        typeToInstantiate = type;
                        memLoaded = true;
                        break;
                    }
                    sharedLock.unlock();
                    locked = false;
                }
            }
            if (!memLoaded) {
                long retrieveTypeEnd;
                long retrieveTypeStart = Calendar.getInstance().getTimeInMillis();
                pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
                typeQuery = pm.newNamedQuery(DataSourceServiceDao.class, "getType");
                typeQuery.compile();
                HashMap<String, String> typeQueryArgs = new HashMap<String, String>();
                typeQueryArgs.put("id", id);
                sharedLock.lock();
                locked = true;
                Collection t = (Collection)typeQuery.executeWithMap(typeQueryArgs);
                if (t.isEmpty()) {
                    DataSourceService dataSourceService = null;
                    return dataSourceService;
                }
                sharedLock.unlock();
                locked = false;
                long instantiateStart = retrieveTypeEnd = Calendar.getInstance().getTimeInMillis();
                Class<? extends DataSourceServiceDao> targetType = SubTypes.get(SubTypesMap.get((Object)Type.valueOf((String)t.iterator().next())));
                if (targetType == null) {
                    DataSourceService dataSourceService = null;
                    return dataSourceService;
                }
                typeToInstantiate = ReverseSubTypes.get(targetType);
            }
            if (typeToInstantiate == null) {
                DataSourceService retrieveTypeStart = null;
                return retrieveTypeStart;
            }
            DataSourceService f = (DataSourceService)((Object)typeToInstantiate.newInstance());
            long loadStart = instantiateEnd = Calendar.getInstance().getTimeInMillis();
            f.setID(id);
            if (!f.load(loadDetails)) {
                DataSourceService dataSourceService = null;
                return dataSourceService;
            }
            long loadEnd = Calendar.getInstance().getTimeInMillis();
            DataSourceService dataSourceService = f;
            return dataSourceService;
        }
        catch (IllegalAccessException e) {
            throw new ResourceRegistryException("Could not instantiate type: " + typeToInstantiate.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ResourceRegistryException("Could not instantiate type: " + typeToInstantiate.getName(), (Throwable)e);
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (typeQuery != null) {
                typeQuery.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public static DataSourceService getById(boolean loadDetails, String id) throws ResourceRegistryException {
        return DataSourceService.getById(loadDetails, RRContext.DatastoreType.LOCAL, id);
    }

    public static enum Type {
        FullTextIndex,
        ForwardIndex,
        GeoIndex,
        OpenSearch;


        public boolean isExternal() {
            return this.equals((Object)OpenSearch);
        }
    }
}

