package gr.uoa.di.madgik.rr.plugins.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

import gr.uoa.di.madgik.rr.RRContext.DatastoreType;
import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;

public class FieldUpdaterPlugin extends Plugin
{

	private static Logger logger = Logger.getLogger(FieldUpdaterPlugin.class.getName());
	
	public FieldUpdaterPlugin()
	{
		this.type = Type.POST_RETRIEVE;
		this.processedItems.add(new ProcessedItemType(Field.class, DatastoreType.LOCALBUFFER));
		this.processedItems.add(new ProcessedItemType(DataSource.class, DatastoreType.LOCALBUFFER));
		this.processedItems.add(new ProcessedItemType(ElementMetadataDao.class, DatastoreType.LOCALBUFFER));
		this.processedItems.add(new ProcessedItemType(FieldIndexContainerDao.class, DatastoreType.LOCALBUFFER));
	}

	@Override
	public void setup() throws ResourceRegistryException {
		Field.getBehavior().setMarkDeletion(true);
		Field.getBehavior().setMarkUpdate(true);
	}
	
	private List<Field> getFields() throws ResourceRegistryException
	{
		@SuppressWarnings("unchecked")
		Set<Field> fields = (Set<Field>)this.items.get(new ProcessedItemType(Field.class, DatastoreType.LOCALBUFFER));
		if(fields == null) return Field.getAll(true, DatastoreType.LOCALBUFFER);
		return new ArrayList<Field>(fields);
	}
	
	private List<DataSource> getDataSources() throws ResourceRegistryException
	{
		@SuppressWarnings("unchecked")
		Set<DataSource> datasources = (Set<DataSource>)this.items.get(new ProcessedItemType(DataSource.class, DatastoreType.LOCALBUFFER));
		if(datasources == null) return DataSource.getAll(false, DatastoreType.LOCALBUFFER);
		return new ArrayList<DataSource>(datasources);
	}
	
	private Set<IDaoElement> getElementMetadata() throws ResourceRegistryException
	{
		@SuppressWarnings("unchecked")
		Set<IDaoElement> elMetadata = (Set<IDaoElement>)this.itemDaos.get(new ProcessedItemType(ElementMetadataDao.class, DatastoreType.LOCALBUFFER));
		try
		{ 
			if(elMetadata == null) return DatastoreHelper.getItems(DatastoreType.LOCALBUFFER, ElementMetadataDao.class); 
		}catch(Exception e) { throw new ResourceRegistryException("",e); }
		return elMetadata;
	}
	
	private Set<IDaoElement> getFieldIndexContainer() throws ResourceRegistryException
	{
		@SuppressWarnings("unchecked")
		Set<IDaoElement> fic = (Set<IDaoElement>)this.itemDaos.get(new ProcessedItemType(FieldIndexContainerDao.class, DatastoreType.LOCALBUFFER));
		try
		{ 
			if(fic == null) return DatastoreHelper.getItems(DatastoreType.LOCALBUFFER, FieldIndexContainerDao.class); 
		}catch(Exception e) { throw new ResourceRegistryException("",e); }
		return fic;
	}
	
	@Override
	protected void execute(Set<Class<?>> targets) throws ResourceRegistryException
	{
		
		logger.log(Level.INFO, "Executing " + this.type + " plugin: " + this.getClass().getName());
		boolean locked = false;
		Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
		try
		{
			boolean updateMode = !(targets.contains(FieldDao.class) &&
			targets.contains(SearchableDao.class) && targets.contains(PresentableDao.class));
			RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() && updateMode ? RRContext.DatastoreType.LOCAL : RRContext.DatastoreType.LOCALBUFFER;
			List<Field> allFields = getFields();
			List<DataSource> allDataSources = getDataSources();
			Set<IDaoElement> allMetadata = getElementMetadata();
			
			
			//Replace field names in FieldIndexContainer with field ids, for all published fields
			if(targets.contains(FieldIndexContainerDao.class))
			{
				Set<IDaoElement> elems = getFieldIndexContainer();
				HashSet<Class<?>> purge=new HashSet<Class<?>>();
				purge.add(FieldIndexContainerDao.class);
				DatastoreHelper.clear(RRContext.DatastoreType.LOCALBUFFER, purge);
				for(IDaoElement el : elems)
				{
					if(!(el instanceof FieldIndexContainerDao)) continue;
				//	List<Field> fs = Field.getFieldsWithName(false, ((FieldIndexContainerDao)el).getField());
					Field f = null;
					for(Field field: allFields)
					{
						if(field.getID().equals(((FieldIndexContainerDao)el).getField()))
						{
							f = field;
							break;
						}
					}
					
					if(f == null) //if the field is not found by searching by its id, it might be a newly created field so search also by name
					{
						for(Field field : allFields)
						{
							if(field.getName().equals(((FieldIndexContainerDao)el).getField()))
							{
								f = field;
								break;
							}
						}
					}
	
					Field updatedField = null;
					//if(updateMode) 
					//{
						updatedField = updateField(f, (FieldIndexContainerDao)el, allFields, allDataSources, allMetadata, datastoreType);
						if(f==null && updatedField != null) 
						{
							for(IDaoElement fic : elems)
							{
								if(((FieldIndexContainerDao)fic).getField().equals(updatedField.getName()))
										((FieldIndexContainerDao)fic).setField(updatedField.getID());
							}
						}
					//}
				}
				DatastoreHelper.bufferItems(elems);
			}
			
		}catch(Exception ex)
		{
			throw new ResourceRegistryException("could not align incoming elements", ex);
		}finally
		{
			if(locked) writeLock.unlock();
		}
	}
	
	private Field updateField(Field f, FieldIndexContainerDao el, List<Field> allFields, List<DataSource> allDatasources, Set<IDaoElement> allMetadata, DatastoreType datastoreType) throws ResourceRegistryException
	{
	//	RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() ? RRContext.DatastoreType.DERBY : RRContext.DatastoreType.BUFFER;
		String locator = el.getID().split(":")[0];
	
		Field updatedField = new Field();
		if(f == null) 
		{
			for(IDaoElement metadata: allMetadata)
			{
				ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
				if(elMetadata.getType().equals(ElementMetadata.Type.DeletedField) && elMetadata.getID().equals(el.getField()))
					return null;
			}
			updatedField.setName(el.getField());
			allFields.add(updatedField);
			updatedField.store(true, datastoreType);
			logger.log(Level.INFO, "Created new field: " + el.getField());
			f = updatedField;
		}else
		{
			updatedField = new Field();
			updatedField.setID(f.getID());
			updatedField.setDescription(f.getDescription());
			updatedField.setName(f.getName());
			updatedField.getSearchables().addAll(f.getSearchables());
			updatedField.getPresentables().addAll(f.getPresentables());
		}
		
		boolean found = false;
		boolean update = false;
		if(el.getFieldType().equals("s"))
		{
			outer:for(Searchable s : updatedField.getSearchables())
			{
				for(IDaoElement metadata : allMetadata)
				{
					ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
					if(elMetadata.getType().equals(ElementMetadata.Type.DeletedSearchable) && elMetadata.getID().equals(el.getField()))
						continue outer;
				}
				if(s.getCollection().equals(el.getCollection()) && s.getLocator().equals(locator))
				{
					found = true;
					break;
				}
			}
			if(found == false)
			{
				DataSource ds = null;
				for(DataSource d : allDatasources)
				{
					if(d.getID().equals(locator))
					{
						ds = d;
						break;
					}
				}
				Searchable s = new Searchable();
				s.setCollection(el.getCollection());
				s.setField(f.getID());
				s.setLocator(locator);
				s.setExpression(el.getExpression());
				s.getCapabilities().addAll(ds.getCapabilities());
				s.setDatasourceScopes(ds.getScopes());
				s.store(true, datastoreType);
				f.getSearchables().add(s);
				logger.log(Level.INFO, "Added new searchable to field " + f.getName() + " (" + f.getID() + ") for collection " + 
						s.getCollection() + " and data source " + s.getLocator());
				update = true;
			}
		}else
		{
			outer:for(Presentable p : updatedField.getPresentables())
			{
				for(IDaoElement metadata : allMetadata)
				{
					ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
					if(elMetadata.getType().equals(ElementMetadata.Type.DeletedPresentable) && elMetadata.getID().equals(el.getField()))
						continue outer;
				}
				if(p.getCollection().equals(el.getCollection()) && p.getLocator().equals(locator))
				{
					found = true;
					break;
				}
			}
			if(found == false)
			{
				DataSource ds = null;
				for(DataSource d : allDatasources)
				{
					if(d.getID().equals(locator))
					{
						ds = d;
						break;
					}
				}
				
				Presentable p = new Presentable();
				p.setCollection(el.getCollection());
				p.setField(f.getID());
				p.setLocator(locator);
				p.setDatasourceScopes(ds.getScopes());
				p.store(true, datastoreType);
				f.getPresentables().add(p);
				logger.log(Level.INFO, "Added new presentable to field " + f.getName() + " (" + f.getID() + ") for collection " + 
						p.getCollection() + " and data source " + p.getLocator());
				update = true;
			}
		}
		
		//if(f == null || found == true)
		if(update)
			updatedField.store(true, datastoreType);
		return updatedField;
	}
	
}
