/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins.impl;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldUpdaterPlugin
extends Plugin {
    private static Logger logger = Logger.getLogger(FieldUpdaterPlugin.class.getName());

    public FieldUpdaterPlugin() {
        this.type = Plugin.Type.POST_RETRIEVE;
        this.processedItems.add(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCALBUFFER));
        this.processedItems.add(new Plugin.ProcessedItemType(DataSource.class, RRContext.DatastoreType.LOCALBUFFER));
        this.processedItems.add(new Plugin.ProcessedItemType(ElementMetadataDao.class, RRContext.DatastoreType.LOCALBUFFER));
        this.processedItems.add(new Plugin.ProcessedItemType(FieldIndexContainerDao.class, RRContext.DatastoreType.LOCALBUFFER));
    }

    public void setup() throws ResourceRegistryException {
        Field.getBehavior().setMarkDeletion(true);
        Field.getBehavior().setMarkUpdate(true);
    }

    private List<Field> getFields() throws ResourceRegistryException {
        Set fields = (Set)this.items.get(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCALBUFFER));
        if (fields == null) {
            return Field.getAll((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
        }
        return new ArrayList<Field>(fields);
    }

    private List<DataSource> getDataSources() throws ResourceRegistryException {
        Set datasources = (Set)this.items.get(new Plugin.ProcessedItemType(DataSource.class, RRContext.DatastoreType.LOCALBUFFER));
        if (datasources == null) {
            return DataSource.getAll((boolean)false, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
        }
        return new ArrayList<DataSource>(datasources);
    }

    private Set<IDaoElement> getElementMetadata() throws ResourceRegistryException {
        Set elMetadata = (Set)this.itemDaos.get(new Plugin.ProcessedItemType(ElementMetadataDao.class, RRContext.DatastoreType.LOCALBUFFER));
        try {
            if (elMetadata == null) {
                return DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, ElementMetadataDao.class);
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("", (Throwable)e);
        }
        return elMetadata;
    }

    private Set<IDaoElement> getFieldIndexContainer() throws ResourceRegistryException {
        Set fic = (Set)this.itemDaos.get(new Plugin.ProcessedItemType(FieldIndexContainerDao.class, RRContext.DatastoreType.LOCALBUFFER));
        try {
            if (fic == null) {
                return DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, FieldIndexContainerDao.class);
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("", (Throwable)e);
        }
        return fic;
    }

    protected void execute(Set<Class<?>> targets) throws ResourceRegistryException {
        logger.log(Level.INFO, "Executing " + this.type + " plugin: " + ((Object)((Object)this)).getClass().getName());
        boolean locked = false;
        Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
        try {
            boolean updateMode = !targets.contains(FieldDao.class) || !targets.contains(SearchableDao.class) || !targets.contains(PresentableDao.class);
            RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() && updateMode ? RRContext.DatastoreType.LOCAL : RRContext.DatastoreType.LOCALBUFFER;
            List<Field> allFields = this.getFields();
            List<DataSource> allDataSources = this.getDataSources();
            Set<IDaoElement> allMetadata = this.getElementMetadata();
            if (targets.contains(FieldIndexContainerDao.class)) {
                Set<IDaoElement> elems = this.getFieldIndexContainer();
                HashSet<Class<FieldIndexContainerDao>> purge = new HashSet<Class<FieldIndexContainerDao>>();
                purge.add(FieldIndexContainerDao.class);
                DatastoreHelper.clear((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, purge);
                for (IDaoElement el : elems) {
                    if (!(el instanceof FieldIndexContainerDao)) continue;
                    Field f = null;
                    for (Field field : allFields) {
                        if (!field.getID().equals(((FieldIndexContainerDao)el).getField())) continue;
                        f = field;
                        break;
                    }
                    if (f == null) {
                        for (Field field : allFields) {
                            if (!field.getName().equals(((FieldIndexContainerDao)el).getField())) continue;
                            f = field;
                            break;
                        }
                    }
                    Field updatedField = null;
                    updatedField = this.updateField(f, (FieldIndexContainerDao)el, allFields, allDataSources, allMetadata, datastoreType);
                    if (f != null || updatedField == null) continue;
                    for (IDaoElement fic : elems) {
                        if (!((FieldIndexContainerDao)fic).getField().equals(updatedField.getName())) continue;
                        ((FieldIndexContainerDao)fic).setField(updatedField.getID());
                    }
                }
                DatastoreHelper.bufferItems(elems);
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not align incoming elements", (Throwable)ex);
        }
        finally {
            if (locked) {
                writeLock.unlock();
            }
        }
    }

    private Field updateField(Field f, FieldIndexContainerDao el, List<Field> allFields, List<DataSource> allDatasources, Set<IDaoElement> allMetadata, RRContext.DatastoreType datastoreType) throws ResourceRegistryException {
        DataSource ds;
        String locator = el.getID().split(":")[0];
        Field updatedField = new Field();
        if (f == null) {
            for (IDaoElement metadata : allMetadata) {
                ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
                if (!elMetadata.getType().equals(ElementMetadata.Type.DeletedField) || !elMetadata.getID().equals(el.getField())) continue;
                return null;
            }
            updatedField.setName(el.getField());
            allFields.add(updatedField);
            updatedField.store(true, datastoreType);
            logger.log(Level.INFO, "Created new field: " + el.getField());
            f = updatedField;
        } else {
            updatedField = new Field();
            updatedField.setID(f.getID());
            updatedField.setDescription(f.getDescription());
            updatedField.setName(f.getName());
            updatedField.getSearchables().addAll(f.getSearchables());
            updatedField.getPresentables().addAll(f.getPresentables());
        }
        boolean found = false;
        boolean update = false;
        if (el.getFieldType().equals("s")) {
            block1: for (Searchable s : updatedField.getSearchables()) {
                for (IDaoElement metadata : allMetadata) {
                    ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
                    if (!elMetadata.getType().equals(ElementMetadata.Type.DeletedSearchable) || !elMetadata.getID().equals(el.getField())) continue;
                    continue block1;
                }
                if (!s.getCollection().equals(el.getCollection()) || !s.getLocator().equals(locator)) continue;
                found = true;
                break;
            }
            if (!found) {
                Searchable s;
                ds = null;
                for (DataSource d : allDatasources) {
                    if (!d.getID().equals(locator)) continue;
                    ds = d;
                    break;
                }
                s = new Searchable();
                s.setCollection(el.getCollection());
                s.setField(f.getID());
                s.setLocator(locator);
                s.setExpression(el.getExpression());
                s.getCapabilities().addAll(ds.getCapabilities());
                s.setDatasourceScopes(ds.getScopes());
                s.store(true, datastoreType);
                f.getSearchables().add(s);
                updatedField.getSearchables().add(s);
                logger.log(Level.INFO, "Added new searchable to field " + f.getName() + " (" + f.getID() + ") for collection " + s.getCollection() + " and data source " + s.getLocator());
                update = true;
            }
        } else {
            block4: for (Presentable p : updatedField.getPresentables()) {
                for (IDaoElement metadata : allMetadata) {
                    ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
                    if (!elMetadata.getType().equals(ElementMetadata.Type.DeletedPresentable) || !elMetadata.getID().equals(el.getField())) continue;
                    continue block4;
                }
                if (!p.getCollection().equals(el.getCollection()) || !p.getLocator().equals(locator)) continue;
                found = true;
                break;
            }
            if (!found) {
                Presentable p;
                ds = null;
                for (DataSource d : allDatasources) {
                    if (!d.getID().equals(locator)) continue;
                    ds = d;
                    break;
                }
                p = new Presentable();
                p.setCollection(el.getCollection());
                p.setField(f.getID());
                p.setLocator(locator);
                p.setDatasourceScopes(ds.getScopes());
                p.store(true, datastoreType);
                f.getPresentables().add(p);
                updatedField.getPresentables().add(p);
                logger.log(Level.INFO, "Added new presentable to field " + f.getName() + " (" + f.getID() + ") for collection " + p.getCollection() + " and data source " + p.getLocator());
                update = true;
            }
        }
        logger.log(Level.WARNING, "After Field Update : ");
        logger.log(Level.WARNING, f.getSearchables().toString());
        logger.log(Level.WARNING, f.getPresentables().toString());
        if (update) {
            updatedField.store(true, datastoreType);
        }
        return updatedField;
    }
}

