/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins.impl;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostFinderPlugin
extends Plugin {
    private static final Logger logger = LoggerFactory.getLogger(HostFinderPlugin.class);
    public static final String PROPERTIES_FILE = "deploy.properties";
    private Properties properties = null;

    private synchronized Properties getPropertyFile() throws IOException {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = new Properties();
        InputStream is = HostFinderPlugin.class.getResourceAsStream("/deploy.properties");
        this.properties.load(is);
        return this.properties;
    }

    private String getHostname() throws IOException {
        return this.getPropertyFile().getProperty("hostname");
    }

    private String getPort() throws IOException {
        return this.getPropertyFile().getProperty("port");
    }

    public HostFinderPlugin() {
        this.type = Plugin.Type.ONE_OFF;
    }

    public void setup() throws ResourceRegistryException {
    }

    protected void execute(Set<Class<?>> targets) throws ResourceRegistryException {
        try {
            String host = this.getHostname();
            String port = this.getPort();
            logger.info("hostname : " + host);
            logger.info("port     : " + port);
            ResourceRegistry.getContext().setLocalNodeHostname(host);
            ResourceRegistry.getContext().setLocalNodePort(port);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("could not resolve local node hostname or port", (Throwable)e);
        }
    }
}

