/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.condor;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.IExternalFilter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JobSubmitExternalFilter
implements IExternalFilter {
    private static Logger logger = Logger.getLogger(JobSubmitExternalFilter.class.getName());
    public boolean StoreOutput = false;
    public String JobIdentifierVariableName = null;
    public String JobIdentifierOutputVariableName = null;

    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobIdentifierVariableName);
        return vars;
    }

    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobIdentifierOutputVariableName);
        return vars;
    }

    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    public void Validate() throws ExecutionValidationException {
        if (this.JobIdentifierVariableName == null || this.JobIdentifierVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Filtered parameter names cannot be empty or null");
        }
        if (this.StoreOutput && (this.JobIdentifierOutputVariableName == null || this.JobIdentifierOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("Needed parameter is not provided");
        }
    }

    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.JobIdentifierVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.JobIdentifierVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.JobIdentifierVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (!Handle.GetPlan().Variables.Contains(this.JobIdentifierOutputVariableName)) {
            throw new ExecutionValidationException("Needed parameter to store output not present");
        }
    }

    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    public boolean SupportsOnLineFiltering() {
        return false;
    }

    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            String output = DataTypeUtils.GetValueAsString((Object)Handle.GetPlan().Variables.Get((String)this.JobIdentifierVariableName).Value.GetValue());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Retrieved submission output is : \n" + output);
            }
            BufferedReader r = new BufferedReader(new StringReader(output));
            String line = r.readLine();
            line = r.readLine();
            line = r.readLine();
            Pattern pattern = Pattern.compile("(\\d*) job\\(s\\) submitted to cluster (\\d*)\\.");
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) {
                throw new ExecutionRunTimeException("faied to parse the cluster number.");
            }
            int noJobs = Integer.parseInt(matcher.group(1));
            String[] clusters = matcher.group(2).split(",");
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Retrieved " + clusters.length + " number of clusters with " + noJobs + " jobs associated");
            }
            return clusters;
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve job status", (Throwable)ex);
        }
    }

    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    public String ToXML() throws ExecutionSerializationException {
        String outputvarString = "";
        if (this.JobIdentifierOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.JobIdentifierOutputVariableName + "\"";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<external type=\"" + this.getClass().getName() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        buf.append("<filteredVariable name=\"" + this.JobIdentifierVariableName + "\"/>");
        buf.append("</external>");
        return buf.toString();
    }

    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.JobIdentifierOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if (!XMLUtils.AttributeExists((Element)(tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")), (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.JobIdentifierVariableName = XMLUtils.GetAttribute((Element)tmp, (String)"name");
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", (Throwable)ex);
        }
    }
}

