/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.jdl;

import gr.uoa.di.madgik.execution.utils.EnvironmentKeyValue;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.ParsedJDLInfo;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JDLParsingUtils {
    public static boolean IsSandboxNameReference(String SandboxName) {
        return SandboxName.startsWith("root.nodes.") && SandboxName.contains(".description.OutputSandbox[") && SandboxName.endsWith("]");
    }

    public static String Trim(String val) {
        if (val == null) {
            return "";
        }
        return val.trim();
    }

    public static List<String> ParseSandbox(String val) {
        String[] items;
        ArrayList<String> vals = new ArrayList<String>();
        if (val == null) {
            return vals;
        }
        for (String it : items = val.split(",")) {
            vals.add(JDLParsingUtils.StripQuotes(it));
        }
        return vals;
    }

    public static List<EnvironmentKeyValue> ParseEnvironment(String val) {
        String[] items;
        ArrayList<EnvironmentKeyValue> vals = new ArrayList<EnvironmentKeyValue>();
        if (val == null) {
            return vals;
        }
        for (String it : items = JDLParsingUtils.StripBrackets(val).split(",")) {
            String[] pair = JDLParsingUtils.StripQuotes(it.trim()).split("=");
            if (pair.length != 2 || pair[0] == null || pair[0].trim().length() == 0 || pair[1] == null || pair[1].trim().length() == 0) continue;
            vals.add(new EnvironmentKeyValue(pair[0].trim(), pair[1].trim()));
        }
        return vals;
    }

    public static String StripBrackets(String val) {
        if (val == null) {
            return val;
        }
        String payload = val.trim();
        if (payload.startsWith("{") && payload.endsWith("}")) {
            payload = payload.substring(1, payload.length() - 1);
        }
        return payload.trim();
    }

    public static String StripQuotes(String val) {
        if (val == null) {
            return val;
        }
        String payload = val.trim();
        if (payload.startsWith("\"") && payload.endsWith("\"")) {
            payload = payload.substring(1, payload.length() - 1);
        }
        return payload;
    }

    public static String StripComments(String val) {
        StringBuilder buf = new StringBuilder();
        boolean lineComment = false;
        boolean multilineComment = false;
        for (int i = 0; i < val.length(); ++i) {
            if (lineComment) {
                if (val.charAt(i) != '\n') continue;
                lineComment = false;
                continue;
            }
            if (multilineComment) {
                if (val.charAt(i) != '*' || val.charAt(i + 1) != '/') continue;
                multilineComment = false;
                ++i;
                continue;
            }
            if (Character.isWhitespace(val.charAt(i))) {
                buf.append(val.charAt(i));
                continue;
            }
            if (val.charAt(i) == '#') {
                lineComment = true;
                continue;
            }
            if (val.charAt(i) == '/' && val.charAt(i + 1) == '/') {
                lineComment = true;
                continue;
            }
            if (val.charAt(i) == '/' && val.charAt(i + 1) == '*') {
                multilineComment = true;
                continue;
            }
            buf.append(val.charAt(i));
        }
        return buf.toString();
    }

    public static String GetDefinitionBlock(String val) {
        String block = null;
        int startingOffset = JDLParsingUtils.NextNonEmptyChar(val);
        if (startingOffset < 0 || startingOffset >= val.length()) {
            return null;
        }
        int innerBlock = 0;
        if (val.charAt(startingOffset) != '[') {
            return null;
        }
        for (int i = startingOffset; i < val.length(); ++i) {
            if (val.charAt(i) == '[') {
                ++innerBlock;
            } else if (val.charAt(i) == ']') {
                --innerBlock;
            }
            if (innerBlock != 0) continue;
            block = val.substring(startingOffset + 1, i);
            break;
        }
        return block;
    }

    private static int NextNonEmptyChar(String val) {
        for (int i = 0; i < val.length(); ++i) {
            if (Character.isWhitespace(val.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static Map<String, List<String>> GetDependencies(String dependencies) {
        HashMap<String, List<String>> keyVals = new HashMap<String, List<String>>();
        String deps = JDLParsingUtils.Trim(JDLParsingUtils.StripBrackets(JDLParsingUtils.Trim(dependencies)));
        int offset = 0;
        while (offset < deps.length()) {
            int openingBracket = deps.indexOf(123, offset);
            int closingBracket = deps.indexOf(125, offset);
            if (openingBracket < 0 || closingBracket < 0) break;
            offset = closingBracket + 1;
            String block = JDLParsingUtils.StripBrackets(deps.substring(openingBracket, closingBracket + 1));
            String[] elems = block.split(",");
            if (elems.length != 2 || elems[0].trim().length() == 0 || elems[1].trim().length() == 0) continue;
            if (!keyVals.containsKey(elems[1].trim())) {
                keyVals.put(elems[1].trim(), new ArrayList());
            }
            ((List)keyVals.get(elems[1].trim())).add(elems[0].trim());
        }
        return keyVals;
    }

    public static Map<String, String> GetKeyValues(String block) {
        HashMap<String, String> keyVals = new HashMap<String, String>();
        String Key = null;
        String Value = null;
        boolean StartingValueParsing = true;
        StringBuilder wordBuf = new StringBuilder();
        for (int i = 0; i < block.length(); ++i) {
            if (Key == null) {
                if (block.charAt(i) == '=') {
                    Key = wordBuf.toString();
                    wordBuf = new StringBuilder();
                    continue;
                }
                wordBuf.append(block.charAt(i));
                continue;
            }
            if (StartingValueParsing) {
                if (!Character.isWhitespace(block.charAt(i))) {
                    StartingValueParsing = false;
                }
                if (block.charAt(i) == '[') {
                    int nextNonEmpty;
                    if ((nextNonEmpty = JDLParsingUtils.NextNonEmptyChar(block.substring(i += (Value = '[' + JDLParsingUtils.GetDefinitionBlock(block.substring(i)) + ']').length()))) >= 0) {
                        i += nextNonEmpty + 1;
                    }
                    StartingValueParsing = true;
                    keyVals.put(Key.trim(), Value.trim());
                    wordBuf = new StringBuilder();
                    Key = null;
                    Value = null;
                    continue;
                }
            }
            if (block.charAt(i) == ';') {
                Value = wordBuf.toString();
                keyVals.put(Key.trim(), Value.trim());
                wordBuf = new StringBuilder();
                StartingValueParsing = true;
                Key = null;
                Value = null;
                continue;
            }
            wordBuf.append(block.charAt(i));
        }
        return keyVals;
    }

    public static String GetKeyValue(Map<String, String> KeyValues, ParsedJDLInfo.KnownKeys Key, boolean mandatory) throws WorkflowValidationException {
        if (!KeyValues.containsKey(Key.toString())) {
            if (mandatory) {
                throw new WorkflowValidationException("Needed key " + (Object)((Object)Key) + " not found");
            }
            return null;
        }
        String val = KeyValues.get(Key.toString());
        if (val == null || val.trim().length() == 0) {
            if (mandatory) {
                throw new WorkflowValidationException("Value of key " + (Object)((Object)Key) + " not found");
            }
            return null;
        }
        return val.trim();
    }
}

