/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.workflowengine.service;

import gr.uoa.di.madgik.execution.event.ExecutionExternalProgressReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionPerformanceReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.workflow.adaptor.utils.IOutputResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.condor.AdaptorCondorResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.condor.AttachedCondorResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.condor.OutputCondorResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.AdaptorGridResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.AttachedGridResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.OutputSandboxGridResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.hadoop.AdaptorHadoopResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.hadoop.AttachedHadoopResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.hadoop.OutputHadoopResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.AdaptorJDLResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.AttachedJDLResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.OutputSandboxJDLResource;
import gr.uoa.di.madgik.workflow.directory.ExecutionObserver;
import gr.uoa.di.madgik.workflow.exception.WorkflowEnvironmentException;
import gr.uoa.di.madgik.workflow.exception.WorkflowException;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gcube.execution.workflowengine.service.ServiceContext;
import org.gcube.execution.workflowengine.service.WorkflowEngineService;
import org.gcube.execution.workflowengine.service.stubs.CONDORParams;
import org.gcube.execution.workflowengine.service.stubs.CONDORResource;
import org.gcube.execution.workflowengine.service.stubs.ExecutionEvent;
import org.gcube.execution.workflowengine.service.stubs.ExecutionExternalProgressEvent;
import org.gcube.execution.workflowengine.service.stubs.ExecutionPerformanceEvent;
import org.gcube.execution.workflowengine.service.stubs.ExecutionProgressEvent;
import org.gcube.execution.workflowengine.service.stubs.GRIDParams;
import org.gcube.execution.workflowengine.service.stubs.GRIDResource;
import org.gcube.execution.workflowengine.service.stubs.HADOOPArchiveResource;
import org.gcube.execution.workflowengine.service.stubs.HADOOPParams;
import org.gcube.execution.workflowengine.service.stubs.JDLParams;
import org.gcube.execution.workflowengine.service.stubs.JDLResource;
import org.gcube.execution.workflowengine.service.stubs.JobOutput;

public class ServiceUtils {
    private static final Logger logger = Logger.getLogger(ServiceUtils.class.getName());

    public static JobOutput GetJobOutput(ExecutionObserver obs, IOutputResource res) throws ExecutionException, WorkflowException {
        JobOutput jo = new JobOutput();
        switch (obs.GetWorkflowType()) {
            case JDL: {
                if (!(res instanceof OutputSandboxJDLResource)) {
                    throw new WorkflowValidationException("Different type of output found");
                }
                String OutputSSID = ServiceUtils.GetStoredFileID(((OutputSandboxJDLResource)res).VariableID, obs);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Execution with id " + obs.GetExecutionID() + " Output file of node " + ((OutputSandboxJDLResource)res).NodeName + " with jdl name : " + ((OutputSandboxJDLResource)res).SandboxName + " is stored at StorageSystem id " + OutputSSID);
                }
                jo.setKey(((OutputSandboxJDLResource)res).SandboxName);
                jo.setSubKey(((OutputSandboxJDLResource)res).NodeName);
                jo.setStorageSystemID(OutputSSID);
                break;
            }
            case Grid: {
                if (!(res instanceof OutputSandboxGridResource)) {
                    throw new WorkflowValidationException("Different type of output found");
                }
                String OutputSSID = ServiceUtils.GetStoredFileID(((OutputSandboxGridResource)res).VariableID, obs);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Execution with id " + obs.GetExecutionID() + " Output file " + ((OutputSandboxGridResource)res).Key + " is stored at StorageSystem id " + OutputSSID);
                }
                jo.setKey(((OutputSandboxGridResource)res).Key);
                jo.setStorageSystemID(OutputSSID);
                break;
            }
            case Hadoop: {
                if (!(res instanceof OutputHadoopResource)) {
                    throw new WorkflowValidationException("Different type of output found");
                }
                String OutputSSID = ServiceUtils.GetStoredFileID(((OutputHadoopResource)res).VariableID, obs);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Execution with id " + obs.GetExecutionID() + " Output file " + ((OutputHadoopResource)res).Key + " of type " + ((OutputHadoopResource)res).TypeOfOutput + " is stored at StorageSystem id " + OutputSSID);
                }
                jo.setKey(((OutputHadoopResource)res).Key);
                jo.setSubKey(((OutputHadoopResource)res).TypeOfOutput.toString());
                jo.setStorageSystemID(OutputSSID);
                break;
            }
            case Condor: {
                if (!(res instanceof OutputCondorResource)) {
                    throw new WorkflowValidationException("Different type of output found");
                }
                String OutputSSID = ServiceUtils.GetStoredFileID(((OutputCondorResource)res).VariableID, obs);
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Execution with id " + obs.GetExecutionID() + " Output file " + ((OutputCondorResource)res).Key + " of type " + ((OutputCondorResource)res).TypeOfOutput + " is stored at StorageSystem id " + OutputSSID);
                }
                jo.setKey(((OutputCondorResource)res).Key);
                jo.setSubKey(((OutputCondorResource)res).TypeOfOutput.toString());
                jo.setStorageSystemID(OutputSSID);
                break;
            }
            default: {
                throw new WorkflowValidationException("Unrecognized workflow type " + obs.GetWorkflowType().toString());
            }
        }
        return jo;
    }

    public static String GetExecutionErrorMessage(ExecutionObserver obs) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (obs.GetExecutionHandle().GetCompletionError() instanceof ExecutionRunTimeException) {
            buf.append("Error Cause was " + ((ExecutionRunTimeException)obs.GetExecutionHandle().GetCompletionError()).GetCauseFullName());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        obs.GetExecutionHandle().GetCompletionError().printStackTrace(pw);
        pw.flush();
        pw.close();
        sw.flush();
        sw.close();
        sw.toString();
        buf.append(sw.toString());
        return buf.toString();
    }

    public static List<ExecutionEvent> GetExecutionEvents(ExecutionObserver obs) {
        List events = obs.GetEvents();
        ArrayList<ExecutionEvent> reportEvents = new ArrayList<ExecutionEvent>();
        for (ExecutionStateEvent event : events) {
            ExecutionProgressEvent nfo;
            ExecutionEvent ev = new ExecutionEvent();
            ev.setEventTimestamp(event.GetEmitTimestamp());
            ev.setEventType(event.GetEventName().toString());
            if (event instanceof ExecutionProgressReportStateEvent) {
                nfo = new ExecutionProgressEvent();
                nfo.setCurrentStep(((ExecutionProgressReportStateEvent)event).GetCurrentStep());
                nfo.setEmiterID(((ExecutionProgressReportStateEvent)event).GetID());
                nfo.setMessage(((ExecutionProgressReportStateEvent)event).GetMessage());
                nfo.setNodeName(((ExecutionProgressReportStateEvent)event).GetNodeName());
                nfo.setNodeHostName(((ExecutionProgressReportStateEvent)event).GetNodeHostName());
                nfo.setNodePort(((ExecutionProgressReportStateEvent)event).GetNodePort());
                nfo.setReportProgress(((ExecutionProgressReportStateEvent)event).DoesReportProgress());
                nfo.setReportNodeProgress(((ExecutionProgressReportStateEvent)event).DoesReportNodeProgress());
                nfo.setReportNodeStatus(((ExecutionProgressReportStateEvent)event).DoesReportNodeStatus());
                nfo.setTotalStep(((ExecutionProgressReportStateEvent)event).GetTotalSteps());
                ev.setProgressEventInfo(nfo);
            } else if (event instanceof ExecutionExternalProgressReportStateEvent) {
                nfo = new ExecutionExternalProgressEvent();
                nfo.setCurrentStep(((ExecutionExternalProgressReportStateEvent)event).GetCurrentStep());
                nfo.setEmiterID(((ExecutionExternalProgressReportStateEvent)event).GetID());
                nfo.setMessage(((ExecutionExternalProgressReportStateEvent)event).GetMessage());
                nfo.setReportProgress(((ExecutionExternalProgressReportStateEvent)event).DoesReportProgress());
                nfo.setTotalStep(((ExecutionExternalProgressReportStateEvent)event).GetTotalSteps());
                nfo.setExternalEmiterName(((ExecutionExternalProgressReportStateEvent)event).GetExternalSender());
                ev.setProgressExternalEventInfo((ExecutionExternalProgressEvent)nfo);
            } else if (event instanceof ExecutionPerformanceReportStateEvent) {
                nfo = new ExecutionPerformanceEvent();
                nfo.setEmiterID(((ExecutionPerformanceReportStateEvent)event).GetID());
                nfo.setTotalTime(((ExecutionPerformanceReportStateEvent)event).GetTotalTime());
                nfo.setInitializationTime(((ExecutionPerformanceReportStateEvent)event).GetInitializationTime());
                nfo.setFinalizationTime(((ExecutionPerformanceReportStateEvent)event).GetFinilizationTime());
                nfo.setChildrenTotalTime(((ExecutionPerformanceReportStateEvent)event).GetChildrenTotalTime());
                nfo.setNumberOfSubcalls(((ExecutionPerformanceReportStateEvent)event).GetSubCalls());
                nfo.setSubcallsTotalTime(((ExecutionPerformanceReportStateEvent)event).GetSubCallTotalTime());
                ev.setPerformanceEventInfo((ExecutionPerformanceEvent)nfo);
            }
            reportEvents.add(ev);
        }
        return reportEvents;
    }

    public static String GetStoredFileID(String varID, ExecutionObserver obs) throws ExecutionValidationException {
        if (obs.GetExecutionHandle().GetPlan().Variables.Get(varID) == null) {
            logger.log(Level.INFO, "Variable " + varID + " is null");
            return "not available";
        }
        if (!obs.GetExecutionHandle().GetPlan().Variables.Get((String)varID).IsAvailable.booleanValue()) {
            logger.log(Level.INFO, "Variable " + varID + " is not available");
            return "not available";
        }
        return DataTypeUtils.GetValueAsString((Object)obs.GetExecutionHandle().GetPlan().Variables.Get((String)varID).Value.GetValue());
    }

    public static boolean EvaluateResult(ExecutionObserver obs) {
        if (!obs.GetExecutionHandle().IsCompleted()) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.INFO, "Execution " + obs.GetExecutionID() + " Not completed! Why am I here?");
            }
            return false;
        }
        if (obs.GetExecutionHandle().IsCompletedWithSuccess()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Execution " + obs.GetExecutionID() + " successfully completed");
            }
            return false;
        }
        if (obs.GetExecutionHandle().IsCompletedWithError()) {
            String errorString = "unsuccessfully completed with error";
            if (obs.GetExecutionHandle().GetCompletionError() instanceof ExecutionRunTimeException) {
                errorString = errorString + " of cause " + ((ExecutionRunTimeException)obs.GetExecutionHandle().GetCompletionError()).GetCauseFullName();
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Execution " + obs.GetExecutionID() + " " + errorString, obs.GetExecutionHandle().GetCompletionError());
            }
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.INFO, "Execution " + obs.GetExecutionID() + " Completed but neither with success or failure!");
        }
        return false;
    }

    public static void EnrichHadoopResource(AttachedHadoopResource att, WorkflowEngineService.ResourceAccessType rat, AttachedHadoopResource.AccessInfo ai, String reference, byte[] bytePayload, String stringPayload) throws WorkflowEnvironmentException, WorkflowValidationException {
        switch (rat) {
            case Reference: {
                att.Value = reference;
                att.ResourceLocationType = AttachedHadoopResource.AttachedResourceType.Reference;
                if (ai == null) break;
                if (ai.userId != null) {
                    att.accessInfo.userId = ai.userId;
                    att.accessInfo.password = ai.password;
                }
                att.accessInfo.port = ai.port;
                break;
            }
            case CMSReference: {
                att.Value = reference;
                att.ResourceLocationType = AttachedHadoopResource.AttachedResourceType.CMSReference;
                break;
            }
            case InMessageBytes: {
                try {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(tmp));
                    bout.write(bytePayload);
                    bout.flush();
                    bout.close();
                    att.Value = tmp.toString();
                    att.ResourceLocationType = AttachedHadoopResource.AttachedResourceType.LocalFile;
                    break;
                }
                catch (Exception ex) {
                    throw new WorkflowEnvironmentException("Could not store attached payload");
                }
            }
            case InMessageString: {
                try {
                    File tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                    BufferedWriter bout = new BufferedWriter(new FileWriter(tmp));
                    bout.write(stringPayload);
                    bout.flush();
                    bout.close();
                    att.Value = tmp.toString();
                    att.ResourceLocationType = AttachedHadoopResource.AttachedResourceType.LocalFile;
                    break;
                }
                catch (Exception ex) {
                    throw new WorkflowEnvironmentException("Could not store attached payload");
                }
            }
            default: {
                throw new WorkflowValidationException("Value of resource access invalid");
            }
        }
    }

    public static AdaptorHadoopResources GetAdaptorHADOOPResources(HADOOPParams params) throws WorkflowValidationException, WorkflowEnvironmentException {
        AttachedHadoopResource att;
        AttachedHadoopResource att2;
        WorkflowEngineService.ResourceAccessType rat;
        AdaptorHadoopResources resources = new AdaptorHadoopResources();
        resources.Resources.add(new AttachedHadoopResource(ServiceContext.GetServiceContext().getScope().toString(), ServiceContext.GetServiceContext().getScope().toString(), AttachedHadoopResource.ResourceType.Scope));
        if (params.getHadoopResources().getArchives() != null) {
            for (HADOOPArchiveResource hADOOPArchiveResource : params.getHadoopResources().getArchives()) {
                AttachedHadoopResource att22 = new AttachedHadoopResource();
                att22.TypeOfResource = AttachedHadoopResource.ResourceType.Archive;
                att22.Key = hADOOPArchiveResource.getResourceKey();
                att22.IsHDFSPresent = hADOOPArchiveResource.isHdfsPresent();
                rat = WorkflowEngineService.ResourceAccessType.InMessageBytes;
                try {
                    rat = WorkflowEngineService.ResourceAccessType.valueOf(hADOOPArchiveResource.getResourceAccess());
                }
                catch (Exception ex) {
                    throw new WorkflowValidationException("Value of resource access invalid");
                }
                ServiceUtils.EnrichHadoopResource(att22, rat, null, hADOOPArchiveResource.getResourceReference(), hADOOPArchiveResource.getInMessageBytePayload(), hADOOPArchiveResource.getInMessageStringPayload());
                resources.Resources.add(att22);
            }
        }
        if (params.getHadoopResources().getArguments() != null) {
            for (HADOOPArchiveResource hADOOPArchiveResource : params.getHadoopResources().getArguments()) {
                att2 = new AttachedHadoopResource();
                att2.TypeOfResource = AttachedHadoopResource.ResourceType.Argument;
                att2.Key = hADOOPArchiveResource.getResourceValue();
                att2.Order = hADOOPArchiveResource.getOrder();
                att2.Value = hADOOPArchiveResource.getResourceValue();
                resources.Resources.add(att2);
            }
        }
        if (params.getHadoopResources().getConfiguration() != null) {
            att = new AttachedHadoopResource();
            att.TypeOfResource = AttachedHadoopResource.ResourceType.Configuration;
            att.Key = params.getHadoopResources().getConfiguration().getResourceKey();
            att.IsHDFSPresent = params.getHadoopResources().getConfiguration().isHdfsPresent();
            WorkflowEngineService.ResourceAccessType rat2 = WorkflowEngineService.ResourceAccessType.InMessageBytes;
            try {
                rat2 = WorkflowEngineService.ResourceAccessType.valueOf(params.getHadoopResources().getConfiguration().getResourceAccess());
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Value of resource access invalid");
            }
            ServiceUtils.EnrichHadoopResource(att, rat2, null, params.getHadoopResources().getConfiguration().getResourceReference(), params.getHadoopResources().getConfiguration().getInMessageBytePayload(), params.getHadoopResources().getConfiguration().getInMessageStringPayload());
            resources.Resources.add(att);
        }
        if (params.getHadoopResources().getFiles() != null) {
            for (HADOOPArchiveResource hADOOPArchiveResource : params.getHadoopResources().getFiles()) {
                att2 = new AttachedHadoopResource();
                att2.TypeOfResource = AttachedHadoopResource.ResourceType.File;
                att2.Key = hADOOPArchiveResource.getResourceKey();
                att2.IsHDFSPresent = hADOOPArchiveResource.isHdfsPresent();
                rat = WorkflowEngineService.ResourceAccessType.InMessageBytes;
                try {
                    rat = WorkflowEngineService.ResourceAccessType.valueOf(hADOOPArchiveResource.getResourceAccess());
                }
                catch (Exception ex) {
                    throw new WorkflowValidationException("Value of resource access invalid");
                }
                ServiceUtils.EnrichHadoopResource(att2, rat, null, hADOOPArchiveResource.getResourceReference(), hADOOPArchiveResource.getInMessageBytePayload(), hADOOPArchiveResource.getInMessageStringPayload());
                resources.Resources.add(att2);
            }
        }
        if (params.getHadoopResources().getInputs() != null) {
            for (HADOOPArchiveResource hADOOPArchiveResource : params.getHadoopResources().getInputs()) {
                att2 = new AttachedHadoopResource();
                att2.TypeOfResource = AttachedHadoopResource.ResourceType.Input;
                att2.Key = hADOOPArchiveResource.getResourceKey();
                att2.CleanUp = hADOOPArchiveResource.isCleanup();
                rat = WorkflowEngineService.ResourceAccessType.InMessageBytes;
                try {
                    rat = WorkflowEngineService.ResourceAccessType.valueOf(hADOOPArchiveResource.getResourceAccess());
                }
                catch (Exception ex) {
                    throw new WorkflowValidationException("Value of resource access invalid");
                }
                ServiceUtils.EnrichHadoopResource(att2, rat, null, hADOOPArchiveResource.getResourceReference(), hADOOPArchiveResource.getInMessageBytePayload(), hADOOPArchiveResource.getInMessageStringPayload());
                resources.Resources.add(att2);
            }
        }
        if (params.getHadoopResources().getJar() != null) {
            att = new AttachedHadoopResource();
            att.TypeOfResource = AttachedHadoopResource.ResourceType.Jar;
            att.Key = params.getHadoopResources().getJar().getResourceKey();
            att.IsHDFSPresent = params.getHadoopResources().getJar().isHdfsPresent();
            WorkflowEngineService.ResourceAccessType rat3 = WorkflowEngineService.ResourceAccessType.InMessageBytes;
            try {
                rat3 = WorkflowEngineService.ResourceAccessType.valueOf(params.getHadoopResources().getJar().getResourceAccess());
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Value of resource access invalid");
            }
            ServiceUtils.EnrichHadoopResource(att, rat3, null, params.getHadoopResources().getJar().getResourceReference(), params.getHadoopResources().getJar().getInMessageBytePayload(), params.getHadoopResources().getJar().getInMessageStringPayload());
            resources.Resources.add(att);
        }
        if (params.getHadoopResources().getLibs() != null) {
            for (HADOOPArchiveResource hADOOPArchiveResource : params.getHadoopResources().getLibs()) {
                att2 = new AttachedHadoopResource();
                att2.TypeOfResource = AttachedHadoopResource.ResourceType.Lib;
                att2.Key = hADOOPArchiveResource.getResourceKey();
                att2.IsHDFSPresent = hADOOPArchiveResource.isHdfsPresent();
                rat = WorkflowEngineService.ResourceAccessType.InMessageBytes;
                try {
                    rat = WorkflowEngineService.ResourceAccessType.valueOf(hADOOPArchiveResource.getResourceAccess());
                }
                catch (Exception ex) {
                    throw new WorkflowValidationException("Value of resource access invalid");
                }
                ServiceUtils.EnrichHadoopResource(att2, rat, null, hADOOPArchiveResource.getResourceReference(), hADOOPArchiveResource.getInMessageBytePayload(), hADOOPArchiveResource.getInMessageStringPayload());
                resources.Resources.add(att2);
            }
        }
        if (params.getHadoopResources().getMain() != null) {
            att = new AttachedHadoopResource();
            att.TypeOfResource = AttachedHadoopResource.ResourceType.MainClass;
            att.Key = params.getHadoopResources().getMain().getResourceValue();
            att.Value = params.getHadoopResources().getMain().getResourceValue();
            resources.Resources.add(att);
        }
        if (params.getHadoopResources().getOutputs() != null) {
            for (HADOOPArchiveResource hADOOPArchiveResource : params.getHadoopResources().getOutputs()) {
                att2 = new AttachedHadoopResource();
                att2.TypeOfResource = AttachedHadoopResource.ResourceType.Output;
                att2.Key = hADOOPArchiveResource.getResourceKey();
                att2.CleanUp = hADOOPArchiveResource.isCleanup();
                rat = WorkflowEngineService.ResourceAccessType.CMSReference;
                if (hADOOPArchiveResource.getResourceAccess() != null) {
                    try {
                        if (hADOOPArchiveResource.getResourceAccess() != null) {
                            rat = WorkflowEngineService.ResourceAccessType.valueOf(hADOOPArchiveResource.getResourceAccess());
                        }
                    }
                    catch (Exception ex) {
                        throw new WorkflowValidationException("Value of resource access invalid");
                    }
                }
                AttachedHadoopResource.AccessInfo ai = new AttachedHadoopResource.AccessInfo();
                if (hADOOPArchiveResource.getResourceAccessInfo() != null) {
                    if (hADOOPArchiveResource.getResourceAccessInfo().getUserId() != null) {
                        ai.userId = hADOOPArchiveResource.getResourceAccessInfo().getUserId();
                        ai.password = hADOOPArchiveResource.getResourceAccessInfo().getPassword();
                    }
                    if (hADOOPArchiveResource.getResourceAccessInfo().getPort() != null) {
                        ai.port = Integer.parseInt(hADOOPArchiveResource.getResourceAccessInfo().getPort());
                    }
                }
                ServiceUtils.EnrichHadoopResource(att2, rat, ai, hADOOPArchiveResource.getResourceReference(), null, null);
                resources.Resources.add(att2);
            }
        }
        if (params.getHadoopResources().getProperties() != null) {
            for (HADOOPArchiveResource hADOOPArchiveResource : params.getHadoopResources().getProperties()) {
                att2 = new AttachedHadoopResource();
                att2.TypeOfResource = AttachedHadoopResource.ResourceType.Property;
                att2.Key = hADOOPArchiveResource.getResourceValue();
                att2.Value = hADOOPArchiveResource.getResourceValue();
                resources.Resources.add(att2);
            }
        }
        return resources;
    }

    public static AdaptorGridResources GetAdaptorGRIDResources(GRIDParams params) throws WorkflowValidationException, WorkflowEnvironmentException {
        AdaptorGridResources resources = new AdaptorGridResources();
        resources.Resources.add(new AttachedGridResource(ServiceContext.GetServiceContext().getScope().toString(), ServiceContext.GetServiceContext().getScope().toString(), AttachedGridResource.ResourceType.Scope));
        for (GRIDResource res : params.getGridResources()) {
            AttachedGridResource.ResourceType rt = AttachedGridResource.ResourceType.InData;
            try {
                rt = AttachedGridResource.ResourceType.valueOf((String)res.getResourceType());
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Value of resource type invalid");
            }
            WorkflowEngineService.ResourceAccessType rat = WorkflowEngineService.ResourceAccessType.InMessageBytes;
            try {
                rat = WorkflowEngineService.ResourceAccessType.valueOf(res.getResourceAccess());
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Value of resource access invalid");
            }
            AttachedGridResource att = null;
            switch (rat) {
                case Reference: {
                    att = new AttachedGridResource(res.getResourceKey(), res.getResourceReference(), rt, AttachedGridResource.AttachedResourceType.Reference);
                    if (res.getResourceAccessInfo() == null) break;
                    if (res.getResourceAccessInfo().getUserId() != null) {
                        att.accessInfo.userId = res.getResourceAccessInfo().getUserId();
                        att.accessInfo.password = res.getResourceAccessInfo().getPassword();
                    }
                    if (res.getResourceAccessInfo().getPort() == null) break;
                    att.accessInfo.port = Integer.parseInt(res.getResourceAccessInfo().getPort());
                    break;
                }
                case CMSReference: {
                    att = new AttachedGridResource(res.getResourceKey(), res.getResourceReference(), rt, AttachedGridResource.AttachedResourceType.CMSReference);
                    break;
                }
                case InMessageBytes: {
                    Closeable bout;
                    File tmp;
                    try {
                        tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                        bout = new BufferedOutputStream(new FileOutputStream(tmp));
                        ((FilterOutputStream)bout).write(res.getInMessageBytePayload());
                        ((BufferedOutputStream)bout).flush();
                        ((FilterOutputStream)bout).close();
                        att = new AttachedGridResource(res.getResourceKey(), tmp.toString(), rt, AttachedGridResource.AttachedResourceType.LocalFile);
                        break;
                    }
                    catch (Exception ex) {
                        throw new WorkflowEnvironmentException("Could not store attached payload");
                    }
                }
                case InMessageString: {
                    Closeable bout;
                    File tmp;
                    try {
                        tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                        bout = new BufferedWriter(new FileWriter(tmp));
                        ((Writer)bout).write(res.getInMessageStringPayload());
                        ((BufferedWriter)bout).flush();
                        ((BufferedWriter)bout).close();
                        att = new AttachedGridResource(res.getResourceKey(), tmp.toString(), rt, AttachedGridResource.AttachedResourceType.LocalFile);
                        break;
                    }
                    catch (Exception ex) {
                        throw new WorkflowEnvironmentException("Could not store attached payload");
                    }
                }
                default: {
                    throw new WorkflowValidationException("Value of resource access invalid");
                }
            }
            resources.Resources.add(att);
        }
        return resources;
    }

    public static AdaptorCondorResources GetAdaptorCONDORResources(CONDORParams params) throws WorkflowValidationException, WorkflowEnvironmentException {
        AdaptorCondorResources resources = new AdaptorCondorResources();
        resources.Resources.add(new AttachedCondorResource(ServiceContext.GetServiceContext().getScope().toString(), ServiceContext.GetServiceContext().getScope().toString(), AttachedCondorResource.ResourceType.Scope));
        for (CONDORResource res : params.getCondorResources()) {
            AttachedCondorResource.ResourceType rt = AttachedCondorResource.ResourceType.InData;
            try {
                rt = AttachedCondorResource.ResourceType.valueOf((String)res.getResourceType());
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Value of resource type invalid");
            }
            WorkflowEngineService.ResourceAccessType rat = WorkflowEngineService.ResourceAccessType.InMessageBytes;
            try {
                rat = WorkflowEngineService.ResourceAccessType.valueOf(res.getResourceAccess());
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Value of resource access invalid");
            }
            AttachedCondorResource att = null;
            switch (rat) {
                case Reference: {
                    att = new AttachedCondorResource(res.getResourceKey(), res.getResourceReference(), rt, AttachedCondorResource.AttachedResourceType.Reference);
                    break;
                }
                case CMSReference: {
                    att = new AttachedCondorResource(res.getResourceKey(), res.getResourceReference(), rt, AttachedCondorResource.AttachedResourceType.CMSReference);
                    break;
                }
                case InMessageBytes: {
                    Closeable bout;
                    File tmp;
                    try {
                        tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                        bout = new BufferedOutputStream(new FileOutputStream(tmp));
                        ((FilterOutputStream)bout).write(res.getInMessageBytePayload());
                        ((BufferedOutputStream)bout).flush();
                        ((FilterOutputStream)bout).close();
                        att = new AttachedCondorResource(res.getResourceKey(), tmp.toString(), rt, AttachedCondorResource.AttachedResourceType.LocalFile);
                        break;
                    }
                    catch (Exception ex) {
                        throw new WorkflowEnvironmentException("Could not store attached payload");
                    }
                }
                case InMessageString: {
                    Closeable bout;
                    File tmp;
                    try {
                        tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                        bout = new BufferedWriter(new FileWriter(tmp));
                        ((Writer)bout).write(res.getInMessageStringPayload());
                        ((BufferedWriter)bout).flush();
                        ((BufferedWriter)bout).close();
                        att = new AttachedCondorResource(res.getResourceKey(), tmp.toString(), rt, AttachedCondorResource.AttachedResourceType.LocalFile);
                        break;
                    }
                    catch (Exception ex) {
                        throw new WorkflowEnvironmentException("Could not store attached payload");
                    }
                }
                default: {
                    throw new WorkflowValidationException("Value of resource access invalid");
                }
            }
            resources.Resources.add(att);
        }
        return resources;
    }

    public static AdaptorJDLResources GetAdaptorJDLResources(JDLParams params) throws WorkflowValidationException, WorkflowEnvironmentException {
        AdaptorJDLResources resources = new AdaptorJDLResources();
        for (JDLResource res : params.getJdlResources()) {
            WorkflowEngineService.ResourceAccessType rat = WorkflowEngineService.ResourceAccessType.InMessageBytes;
            if (res.getResourceType() != null && AttachedJDLResource.ResourceType.valueOf((String)res.getResourceType()).equals((Object)AttachedJDLResource.ResourceType.OutData)) {
                rat = WorkflowEngineService.ResourceAccessType.CMSReference;
            }
            try {
                rat = WorkflowEngineService.ResourceAccessType.valueOf(res.getResourceAccess());
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Value of resource access invalid");
            }
            AttachedJDLResource att = null;
            switch (rat) {
                case Reference: {
                    AttachedJDLResource.ResourceType rType = null;
                    if (res.getResourceType() != null) {
                        rType = AttachedJDLResource.ResourceType.valueOf((String)res.getResourceType());
                    }
                    att = new AttachedJDLResource(res.getResourceKey(), rType, res.getResourceReference(), AttachedJDLResource.AttachedResourceType.Reference);
                    logger.log(Level.INFO, "Created attached jdl resource: key=" + res.getResourceKey() + " type=" + res.getResourceType() + " ref=" + res.getResourceReference() + " access=Reference");
                    if (res.getResourceAccessInfo() == null) break;
                    if (res.getResourceAccessInfo().getUserId() != null) {
                        att.accessInfo.userId = res.getResourceAccessInfo().getUserId();
                        att.accessInfo.password = res.getResourceAccessInfo().getPassword();
                    }
                    if (res.getResourceAccessInfo().getPort() == null) break;
                    att.accessInfo.port = Integer.parseInt(res.getResourceAccessInfo().getPort());
                    break;
                }
                case CMSReference: {
                    AttachedJDLResource.ResourceType rType = null;
                    if (res.getResourceType() != null) {
                        rType = AttachedJDLResource.ResourceType.valueOf((String)res.getResourceType());
                    }
                    att = new AttachedJDLResource(res.getResourceKey(), rType, res.getResourceReference(), AttachedJDLResource.AttachedResourceType.CMSReference);
                    logger.log(Level.INFO, "Create attached jdl resource: key=" + res.getResourceKey() + " type=" + res.getResourceType() + " ref=" + res.getResourceReference() + " access=CMSReference");
                    break;
                }
                case InMessageBytes: {
                    AttachedJDLResource.ResourceType rType;
                    Closeable bout;
                    File tmp;
                    try {
                        tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                        bout = new BufferedOutputStream(new FileOutputStream(tmp));
                        ((FilterOutputStream)bout).write(res.getInMessageBytePayload());
                        ((BufferedOutputStream)bout).flush();
                        ((FilterOutputStream)bout).close();
                        rType = null;
                        if (res.getResourceType() != null) {
                            rType = AttachedJDLResource.ResourceType.valueOf((String)res.getResourceType());
                        }
                        att = new AttachedJDLResource(res.getResourceKey(), rType, tmp.toString(), AttachedJDLResource.AttachedResourceType.LocalFile);
                        logger.log(Level.INFO, "Create attached jdl resource: key=" + res.getResourceKey() + " type=" + res.getResourceType() + " ref=" + res.getResourceReference() + " access=InMessageBytes(Local)");
                        break;
                    }
                    catch (Exception ex) {
                        throw new WorkflowEnvironmentException("Could not store attached payload", (Throwable)ex);
                    }
                }
                case InMessageString: {
                    AttachedJDLResource.ResourceType rType;
                    Closeable bout;
                    File tmp;
                    try {
                        tmp = File.createTempFile(UUID.randomUUID().toString(), "attached.tmp");
                        bout = new BufferedWriter(new FileWriter(tmp));
                        ((Writer)bout).write(res.getInMessageStringPayload());
                        ((BufferedWriter)bout).flush();
                        ((BufferedWriter)bout).close();
                        rType = null;
                        if (res.getResourceType() != null) {
                            rType = AttachedJDLResource.ResourceType.valueOf((String)res.getResourceType());
                        }
                        att = new AttachedJDLResource(res.getResourceKey(), rType, tmp.toString(), AttachedJDLResource.AttachedResourceType.LocalFile);
                        logger.log(Level.INFO, "Create attached jdl resource: key=" + res.getResourceKey() + " type=" + res.getResourceType() + " ref=" + res.getResourceReference() + " access=InMessageString(Local)");
                        break;
                    }
                    catch (Exception ex) {
                        throw new WorkflowEnvironmentException("Could not store attached payload", (Throwable)ex);
                    }
                }
                default: {
                    throw new WorkflowValidationException("Value of resource access invalid");
                }
            }
            resources.Resources.add(att);
        }
        return resources;
    }
}

